/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesTask;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.MessageNotifier;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class FeaturesPanel
extends JPanel {
    private JCheckBox notifier;
    private JLabel intervalLabel;
    private final JosmTextField notifierInterval = new JosmTextField(4);
    private final JosmTextField notesDaysClosed = new JosmTextField(4);

    public FeaturesPanel() {
        this.build();
        this.initFromPreferences();
        this.updateEnabledState();
    }

    private void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.notifier = new JCheckBox(I18n.tr("Periodically check for new messages", new Object[0]));
        this.add((Component)this.notifier, GBC.std(0, 0).span(2).fill(2));
        this.notifier.addChangeListener(e -> this.updateEnabledState());
        this.intervalLabel = new JLabel(I18n.tr("Check interval (minutes):", new Object[0]));
        this.intervalLabel.setLabelFor(this.notifierInterval);
        this.add((Component)this.intervalLabel, GBC.std(0, 1));
        this.notifierInterval.setToolTipText(I18n.tr("Default value: {0}", MessageNotifier.PROP_INTERVAL.getDefaultValue()));
        this.notifierInterval.setMinimumSize(this.notifierInterval.getPreferredSize());
        this.add((Component)this.notifierInterval, GBC.std(1, 1).insets(5, 0, 0, 0));
        JLabel notesDaysClosedLabel = new JLabel(I18n.tr("Max age for closed notes (days):", new Object[0]));
        notesDaysClosedLabel.setLabelFor(this.notesDaysClosed);
        notesDaysClosedLabel.setToolTipText(I18n.tr("Specifies the number of days a note needs to be closed to no longer be downloaded", new Object[0]));
        this.add((Component)notesDaysClosedLabel, GBC.std(0, 2).insets(0, 20, 0, 0));
        this.notesDaysClosed.setToolTipText(I18n.tr("Default value: {0}", DownloadNotesTask.DAYS_CLOSED.getDefaultValue()));
        this.notesDaysClosed.setMinimumSize(this.notesDaysClosed.getPreferredSize());
        this.add((Component)this.notesDaysClosed, GBC.std(1, 2).insets(5, 20, 0, 0));
    }

    private void updateEnabledState() {
        boolean enabled = this.notifier.isSelected();
        this.intervalLabel.setEnabled(enabled);
        this.notifierInterval.setEnabled(enabled);
        this.notifierInterval.setEditable(enabled);
    }

    public final void initFromPreferences() {
        this.notifier.setSelected(MessageNotifier.PROP_NOTIFIER_ENABLED.get());
        this.notifierInterval.setText(Integer.toString(MessageNotifier.PROP_INTERVAL.get()));
        this.notesDaysClosed.setText(Integer.toString(DownloadNotesTask.DAYS_CLOSED.get()));
    }

    public void saveToPreferences() {
        boolean enabled = this.notifier.isSelected();
        boolean changed = MessageNotifier.PROP_NOTIFIER_ENABLED.put(enabled);
        changed |= MessageNotifier.PROP_INTERVAL.parseAndPut(this.notifierInterval.getText());
        if (changed |= DownloadNotesTask.DAYS_CLOSED.parseAndPut(this.notesDaysClosed.getText())) {
            MessageNotifier.stop();
            if (enabled) {
                MessageNotifier.start();
            }
        } else if (!MessageNotifier.isUserEnoughIdentified()) {
            MessageNotifier.stop();
        } else if (enabled && !MessageNotifier.isRunning()) {
            MessageNotifier.start();
        }
    }
}

