/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.HasPrefixedName;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.Namespaces;

public enum PROVVocabulary implements HasShortForm,
HasIRI,
HasPrefixedName
{
    ACTIVITY_CLASS(Namespaces.PROV, "Activity", EntityType.CLASS),
    AGENT_CLASS(Namespaces.PROV, "Agent", EntityType.CLASS),
    ORGANIZATION(Namespaces.PROV, "Organization", EntityType.CLASS),
    PERSON(Namespaces.PROV, "Person", EntityType.CLASS),
    SOFTWARE_AGENT(Namespaces.PROV, "SoftwareAgent", EntityType.CLASS),
    ENTITY_CLASS(Namespaces.PROV, "Entity", EntityType.CLASS),
    BUNDLE(Namespaces.PROV, "Bundle", EntityType.CLASS),
    COLLECTION(Namespaces.PROV, "Collection", EntityType.CLASS),
    EMPTY_COLLECTION(Namespaces.PROV, "EmptyCollection", EntityType.CLASS),
    PLAN(Namespaces.PROV, "Plan", EntityType.CLASS),
    INFLUENCE(Namespaces.PROV, "Influence", EntityType.CLASS),
    ACTIVITY_INFLUENCE(Namespaces.PROV, "ActivityInfluence", EntityType.CLASS),
    COMMUNICATION(Namespaces.PROV, "Communication", EntityType.CLASS),
    GENERATION(Namespaces.PROV, "Generation", EntityType.CLASS),
    INVALIDATION(Namespaces.PROV, "Invalidation", EntityType.CLASS),
    AGENT_INFLUENCE(Namespaces.PROV, "AgentInfluence", EntityType.CLASS),
    ASSOCIATION(Namespaces.PROV, "Association", EntityType.CLASS),
    ATTRIBUTION(Namespaces.PROV, "Attribution", EntityType.CLASS),
    DELEGATION(Namespaces.PROV, "Delegation", EntityType.CLASS),
    ENTITY_INFLUENCE(Namespaces.PROV, "EntityInfluence", EntityType.CLASS),
    DERIVATION(Namespaces.PROV, "Derivation", EntityType.CLASS),
    PRIMARY_SOURCE(Namespaces.PROV, "PrimarySource", EntityType.CLASS),
    QUOTATION(Namespaces.PROV, "Quotation", EntityType.CLASS),
    REVISION(Namespaces.PROV, "Revision", EntityType.CLASS),
    END(Namespaces.PROV, "End", EntityType.CLASS),
    START(Namespaces.PROV, "Start", EntityType.CLASS),
    USAGE(Namespaces.PROV, "Usage", EntityType.CLASS),
    INSTANTANEOUS_EVENT(Namespaces.PROV, "InstantaneousEvent", EntityType.CLASS),
    LOCATION(Namespaces.PROV, "Location", EntityType.CLASS),
    ROLE(Namespaces.PROV, "Role", EntityType.CLASS),
    ALTERNATE_OF(Namespaces.PROV, "alternateOf", EntityType.OBJECT_PROPERTY),
    AT_LOCATION(Namespaces.PROV, "atLocation", EntityType.OBJECT_PROPERTY),
    HAD_ACTIVITY(Namespaces.PROV, "hadActivity", EntityType.OBJECT_PROPERTY),
    HAD_GENERATION(Namespaces.PROV, "hadGeneration", EntityType.OBJECT_PROPERTY),
    HAD_PLAN(Namespaces.PROV, "hadPlan", EntityType.OBJECT_PROPERTY),
    HAD_ROLE(Namespaces.PROV, "hadRole", EntityType.OBJECT_PROPERTY),
    HAD_USAGE(Namespaces.PROV, "hadUsage", EntityType.OBJECT_PROPERTY),
    INFLUENCED(Namespaces.PROV, "influenced", EntityType.OBJECT_PROPERTY),
    GENERATED(Namespaces.PROV, "generated", EntityType.OBJECT_PROPERTY),
    INVALIDATED(Namespaces.PROV, "invalidated", EntityType.OBJECT_PROPERTY),
    INFLUENCER(Namespaces.PROV, "influencer", EntityType.OBJECT_PROPERTY),
    ACTIVITY_PROPERTY(Namespaces.PROV, "activity", EntityType.OBJECT_PROPERTY),
    AGENT_PROPERTY(Namespaces.PROV, "agent", EntityType.OBJECT_PROPERTY),
    ENTITY_PROPERTY(Namespaces.PROV, "entity", EntityType.OBJECT_PROPERTY),
    QUALIFIED_INFLUENCE(Namespaces.PROV, "qualifiedInfluence", EntityType.OBJECT_PROPERTY),
    QUALIFIED_ASSOCIATION(Namespaces.PROV, "qualifiedAssociation", EntityType.OBJECT_PROPERTY),
    QUALIFIED_ATTRIBUTION(Namespaces.PROV, "qualifiedAttribution", EntityType.OBJECT_PROPERTY),
    QUALIFIED_COMMUNICATION(Namespaces.PROV, "qualifiedCommunication", EntityType.OBJECT_PROPERTY),
    QUALIFIED_DELEGATION(Namespaces.PROV, "qualifiedDelegation", EntityType.OBJECT_PROPERTY),
    QUALIFIED_DERIVATION(Namespaces.PROV, "qualifiedDerivation", EntityType.OBJECT_PROPERTY),
    QUALIFIED_END(Namespaces.PROV, "qualifiedEnd", EntityType.OBJECT_PROPERTY),
    QUALIFIED_GENERATION(Namespaces.PROV, "qualifiedGeneration", EntityType.OBJECT_PROPERTY),
    QUALIFIED_INVALIDATION(Namespaces.PROV, "qualifiedInvalidation", EntityType.OBJECT_PROPERTY),
    QUALIFIED_PRIMARY_SOURCE(Namespaces.PROV, "qualifiedPrimarySource", EntityType.OBJECT_PROPERTY),
    QUALIFIED_QUOTATION(Namespaces.PROV, "qualifiedQuotation", EntityType.OBJECT_PROPERTY),
    QUALIFIED_REVISION(Namespaces.PROV, "qualifiedRevision", EntityType.OBJECT_PROPERTY),
    QUALIFIED_START(Namespaces.PROV, "qualifiedStart", EntityType.OBJECT_PROPERTY),
    QUALIFIED_USAGE(Namespaces.PROV, "qualifiedUsage", EntityType.OBJECT_PROPERTY),
    WAS_INFLUENCED_BY(Namespaces.PROV, "wasInfluencedBy", EntityType.OBJECT_PROPERTY),
    ACTED_ON_BEHALF_OF(Namespaces.PROV, "actedOnBehalfOf", EntityType.OBJECT_PROPERTY),
    HAD_MEMBER(Namespaces.PROV, "hadMember", EntityType.OBJECT_PROPERTY),
    USED(Namespaces.PROV, "used", EntityType.OBJECT_PROPERTY),
    WAS_ASSOCIATED_WITH(Namespaces.PROV, "wasAssociatedWith", EntityType.OBJECT_PROPERTY),
    WAS_ATTRIBUTED_TO(Namespaces.PROV, "wasAttributedTo", EntityType.OBJECT_PROPERTY),
    WAS_DERIVED_FROM(Namespaces.PROV, "wasDerivedFrom", EntityType.OBJECT_PROPERTY),
    HAD_PRIMARY_SOURCE(Namespaces.PROV, "hadPrimarySource", EntityType.OBJECT_PROPERTY),
    WAS_QUOTED_FROM(Namespaces.PROV, "wasQuotedFrom", EntityType.OBJECT_PROPERTY),
    WAS_REVISION_OF(Namespaces.PROV, "wasRevisionOf", EntityType.OBJECT_PROPERTY),
    WAS_ENDED_BY(Namespaces.PROV, "wasEndedBy", EntityType.OBJECT_PROPERTY),
    WAS_GENERATED_BY(Namespaces.PROV, "wasGeneratedBy", EntityType.OBJECT_PROPERTY),
    WAS_INFORMED_BY(Namespaces.PROV, "wasInformedBy", EntityType.OBJECT_PROPERTY),
    WAS_INVALIDATED_BY(Namespaces.PROV, "wasInvalidatedBy", EntityType.OBJECT_PROPERTY),
    WAS_STARTED_BY(Namespaces.PROV, "wasStartedBy", EntityType.OBJECT_PROPERTY),
    AT_TIME(Namespaces.PROV, "atTime", EntityType.DATA_PROPERTY),
    ENDED_AT_TIME(Namespaces.PROV, "endedAtTime", EntityType.DATA_PROPERTY),
    GENERATED_AT_TIME(Namespaces.PROV, "generatedAtTime", EntityType.DATA_PROPERTY),
    INVALIDATED_AT_TIME(Namespaces.PROV, "invalidatedAtTime", EntityType.DATA_PROPERTY),
    STARTED_AT_TIME(Namespaces.PROV, "startedAtTime", EntityType.DATA_PROPERTY),
    VALUE(Namespaces.PROV, "value", EntityType.DATA_PROPERTY);

    private final IRI iri;
    private final Namespaces namespace;
    private final String shortName;
    private final String prefixedName;
    private final EntityType<?> entityType;

    private PROVVocabulary(Namespaces namespace, String shortName, EntityType<?> entityType) {
        this.namespace = namespace;
        this.shortName = shortName;
        this.prefixedName = namespace.getPrefixName() + ':' + shortName;
        this.iri = IRI.create(namespace.toString(), shortName);
        this.entityType = entityType;
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    @Override
    public String getPrefixedName() {
        return this.prefixedName;
    }

    @Override
    public String getShortForm() {
        return this.shortName;
    }

    public Namespaces getNamespace() {
        return this.namespace;
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }
}

