/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.text.MessageFormat;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.RawParseUtils;

public class MutableObjectId
extends AnyObjectId {
    public MutableObjectId() {
    }

    MutableObjectId(MutableObjectId src) {
        this.fromObjectId(src);
    }

    public void setByte(int index, int value) {
        switch (index >> 2) {
            case 0: {
                this.w1 = MutableObjectId.set(this.w1, index & 3, value);
                break;
            }
            case 1: {
                this.w2 = MutableObjectId.set(this.w2, index & 3, value);
                break;
            }
            case 2: {
                this.w3 = MutableObjectId.set(this.w3, index & 3, value);
                break;
            }
            case 3: {
                this.w4 = MutableObjectId.set(this.w4, index & 3, value);
                break;
            }
            case 4: {
                this.w5 = MutableObjectId.set(this.w5, index & 3, value);
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(index);
            }
        }
    }

    private static int set(int w, int index, int value) {
        value &= 0xFF;
        switch (index) {
            case 0: {
                return w & 0xFFFFFF | value << 24;
            }
            case 1: {
                return w & 0xFF00FFFF | value << 16;
            }
            case 2: {
                return w & 0xFFFF00FF | value << 8;
            }
            case 3: {
                return w & 0xFFFFFF00 | value;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void clear() {
        this.w1 = 0;
        this.w2 = 0;
        this.w3 = 0;
        this.w4 = 0;
        this.w5 = 0;
    }

    public void fromObjectId(AnyObjectId src) {
        this.w1 = src.w1;
        this.w2 = src.w2;
        this.w3 = src.w3;
        this.w4 = src.w4;
        this.w5 = src.w5;
    }

    public void fromRaw(byte[] bs) {
        this.fromRaw(bs, 0);
    }

    public void fromRaw(byte[] bs, int p) {
        this.w1 = NB.decodeInt32(bs, p);
        this.w2 = NB.decodeInt32(bs, p + 4);
        this.w3 = NB.decodeInt32(bs, p + 8);
        this.w4 = NB.decodeInt32(bs, p + 12);
        this.w5 = NB.decodeInt32(bs, p + 16);
    }

    public void fromRaw(int[] ints) {
        this.fromRaw(ints, 0);
    }

    public void fromRaw(int[] ints, int p) {
        this.w1 = ints[p];
        this.w2 = ints[p + 1];
        this.w3 = ints[p + 2];
        this.w4 = ints[p + 3];
        this.w5 = ints[p + 4];
    }

    public void set(int a, int b, int c, int d, int e) {
        this.w1 = a;
        this.w2 = b;
        this.w3 = c;
        this.w4 = d;
        this.w5 = e;
    }

    public void fromString(byte[] buf, int offset) {
        this.fromHexString(buf, offset);
    }

    public void fromString(String str) {
        if (str.length() != 40) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidId, str));
        }
        this.fromHexString(Constants.encodeASCII(str), 0);
    }

    private void fromHexString(byte[] bs, int p) {
        try {
            this.w1 = RawParseUtils.parseHexInt32(bs, p);
            this.w2 = RawParseUtils.parseHexInt32(bs, p + 8);
            this.w3 = RawParseUtils.parseHexInt32(bs, p + 16);
            this.w4 = RawParseUtils.parseHexInt32(bs, p + 24);
            this.w5 = RawParseUtils.parseHexInt32(bs, p + 32);
        }
        catch (ArrayIndexOutOfBoundsException e1) {
            throw new InvalidObjectIdException(bs, p, 40);
        }
    }

    @Override
    public ObjectId toObjectId() {
        return new ObjectId(this);
    }
}

