/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.Context;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.Utilities;
import javax.swing.undo.UndoManager;
import org.protege.editor.core.log.LogPreferences;
import org.protege.editor.core.log.LogPreview;
import org.protege.editor.core.log.LogViewImpl;
import org.protege.editor.core.log.TextForegroundPreviewPanel;
import org.protege.editor.core.ui.preferences.PreferencesLayoutPanel;
import org.protege.editor.core.ui.preferences.PreferencesPanel;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.NativeBrowserLauncher;
import org.protege.editor.core.ui.view.HelpIcon;
import org.slf4j.LoggerFactory;

public class LogPreferencesPanel
extends PreferencesPanel {
    private static final long serialVersionUID = -8899057690635957213L;
    private static final Logger LOGGER_ = (Logger)LoggerFactory.getLogger(LogPreferencesPanel.class);
    private static final Color LOG_PATTERN_HELP_BUTTON_COLOR_ = new Color(200, 200, 200);
    private static final String LOG_PATTERN_HELP_URL_ = "https://logback.qos.ch/manual/layouts.html#conversionWord";
    private JComboBox<String> logLevel_;
    private JCheckBox wrapLinesBox_;
    private JCheckBox limitLogOutputCheckBox_;
    private SpinnerNumberModel logCharacterLimitModel_;
    private JTextField patternField_;
    private UndoManager patternUndoManager_;
    private JColorChooser colorChooser_;
    private TextForegroundPreviewPanel colorPreview_;
    private LogViewImpl previewLog_;
    private boolean previewRefreshed_ = false;

    private void loadFrom(LogPreferences prefs) {
        this.logLevel_.setSelectedItem(prefs.logLevel);
        this.wrapLinesBox_.setSelected(prefs.wrapLines);
        this.limitLogOutputCheckBox_.setSelected(prefs.limitLogOutput);
        this.logCharacterLimitModel_.setValue(prefs.logCharacterLimit);
        this.patternField_.setText(prefs.logPattern);
        this.patternUndoManager_.discardAllEdits();
        this.previewLog_.setForegroundsFrom(prefs.logStyleForegrounds);
    }

    private void saveTo(LogPreferences prefs) {
        prefs.logLevel = this.logLevel_.getSelectedItem().toString();
        prefs.wrapLines = this.wrapLinesBox_.isSelected();
        prefs.limitLogOutput = this.limitLogOutputCheckBox_.isSelected();
        prefs.logCharacterLimit = this.logCharacterLimitModel_.getNumber().intValue();
        prefs.logPattern = this.patternField_.getText();
        this.previewLog_.copyForegroundsTo(prefs);
    }

    @Override
    public void initialise() {
        this.setLayout(new BorderLayout());
        PreferencesLayoutPanel panel = new PreferencesLayoutPanel();
        this.add((Component)panel, "North");
        panel.addGroup("Log window");
        this.wrapLinesBox_ = new JCheckBox("Line wrap");
        this.wrapLinesBox_.setToolTipText("Wraps lines that exceed the width of the window");
        panel.addGroupComponent(this.wrapLinesBox_);
        this.wrapLinesBox_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogPreferencesPanel.this.refreshPreview();
            }
        });
        this.limitLogOutputCheckBox_ = new JCheckBox("Limit displayed characters");
        this.limitLogOutputCheckBox_.setToolTipText("Deletes old log messages when the window is full");
        panel.addGroupComponent(this.limitLogOutputCheckBox_);
        this.logCharacterLimitModel_ = new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 10000);
        final JSpinner spinner = new JSpinner(this.logCharacterLimitModel_);
        this.logCharacterLimitModel_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LogPreferencesPanel.this.refreshPreview();
            }
        });
        spinner.setToolTipText("The maximal number of characters displayed in the log window");
        panel.addGroupComponent(spinner);
        spinner.setEnabled(this.limitLogOutputCheckBox_.isSelected());
        this.limitLogOutputCheckBox_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                spinner.setEnabled(LogPreferencesPanel.this.limitLogOutputCheckBox_.isSelected());
                LogPreferencesPanel.this.refreshPreview();
            }
        });
        panel.addSeparator();
        panel.addGroup("Log level");
        this.logLevel_ = new JComboBox<String>(new String[]{Level.OFF.toString(), Level.ERROR.toString(), Level.WARN.toString(), Level.INFO.toString(), Level.DEBUG.toString()});
        this.logLevel_.setToolTipText("Messages below this log level will not appear in the log");
        this.logLevel_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogPreferencesPanel.this.refreshPreview();
            }
        });
        panel.addGroupComponent(this.logLevel_);
        panel.addSeparator();
        panel.addGroup("Log pattern");
        this.patternField_ = new JTextField(30);
        this.patternField_.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                LogPreferencesPanel.this.refreshPreview();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LogPreferencesPanel.this.refreshPreview();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LogPreferencesPanel.this.refreshPreview();
            }
        });
        this.patternUndoManager_ = new UndoManager();
        this.patternField_.getDocument().addUndoableEditListener(this.patternUndoManager_);
        AbstractAction undoAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LogPreferencesPanel.this.patternUndoManager_.canUndo()) {
                    LogPreferencesPanel.this.patternUndoManager_.undo();
                }
            }
        };
        AbstractAction redoAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LogPreferencesPanel.this.patternUndoManager_.canRedo()) {
                    LogPreferencesPanel.this.patternUndoManager_.redo();
                }
            }
        };
        this.patternField_.registerKeyboardAction(undoAction, KeyStroke.getKeyStroke(90, 4), 0);
        this.patternField_.registerKeyboardAction(redoAction, KeyStroke.getKeyStroke(89, 4), 0);
        HelpIcon helpIcon = HelpIcon.get();
        JButton patternHelpButton = new JButton(new AbstractAction(null, helpIcon){
            private static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent e) {
                NativeBrowserLauncher.openURL(LogPreferencesPanel.LOG_PATTERN_HELP_URL_);
            }
        });
        patternHelpButton.setPreferredSize(new Dimension(helpIcon.getIconWidth(), helpIcon.getIconHeight()));
        patternHelpButton.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        patternHelpButton.setToolTipText("Help");
        patternHelpButton.setBorder(null);
        patternHelpButton.setBackground(LOG_PATTERN_HELP_BUTTON_COLOR_);
        patternHelpButton.setOpaque(true);
        JPanel patternPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public int getBaseline(int width, int height) {
                return LogPreferencesPanel.this.patternField_.getBaseline(width, height);
            }
        };
        patternPanel.setLayout(new BoxLayout(patternPanel, 2));
        patternPanel.add(this.patternField_);
        patternPanel.add(patternHelpButton);
        patternPanel.setBackground(this.patternField_.getBackground());
        patternPanel.setBorder(this.patternField_.getBorder());
        this.patternField_.setBorder(null);
        this.patternField_.setToolTipText("The format string that determines how log messages are printed");
        patternPanel.setMinimumSize(patternPanel.getPreferredSize());
        panel.addGroupComponent(patternPanel);
        this.colorChooser_ = new JColorChooser();
        this.colorPreview_ = new TextForegroundPreviewPanel(this.colorChooser_);
        this.colorChooser_.setPreviewPanel(this.colorPreview_);
        this.previewLog_ = new LogViewImpl();
        this.previewLog_.setContext((Context)LOGGER_.getLoggerContext());
        this.previewLog_.start();
        final JTextPane previewText = this.previewLog_.asJComponent();
        previewText.setPreferredSize(new Dimension(300, 120));
        LogPreview.addAppender(this.previewLog_);
        JPanel holder = new JPanel(new BorderLayout());
        holder.setBorder(ComponentFactory.createTitledBorder("Preview"));
        holder.add(previewText);
        previewText.setCursor(new Cursor(12));
        previewText.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int pos = previewText.viewToModel(e.getPoint());
                StyledDocument doc = previewText.getStyledDocument();
                Element element = doc.getCharacterElement(pos);
                AttributeSet addtributes = element.getAttributes();
                Style style = doc.getStyle((String)addtributes.getAttribute(StyleConstants.NameAttribute));
                previewText.setToolTipText("Click to change the " + style.getName() + " color");
            }
        });
        previewText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int pos = previewText.viewToModel(e.getPoint());
                Style style = LogPreferencesPanel.getStyleAtPoint(previewText, e.getPoint());
                Color color = StyleConstants.getForeground(style);
                try {
                    int rowStart = LogPreferencesPanel.getStyleStart(previewText, pos, style);
                    int rowEnd = LogPreferencesPanel.getStyleEnd(previewText, pos, style);
                    LogPreferencesPanel.this.colorPreview_.setText(previewText.getStyledDocument().getText(rowStart, rowEnd - rowStart));
                }
                catch (BadLocationException e1) {
                    LOGGER_.error("Error creating message preview", (Throwable)e1);
                }
                JOptionPane op = new JOptionPane(LogPreferencesPanel.this.colorChooser_, -1, 2);
                JDialog dlg = op.createDialog(previewText, "Choose Text Color");
                dlg.setLocationRelativeTo(previewText);
                LogPreferencesPanel.this.colorChooser_.setColor(color);
                dlg.setVisible(true);
                if (op.getValue() != null) {
                    color = LogPreferencesPanel.this.colorChooser_.getColor();
                    StyleConstants.setForeground(style, color);
                    LogPreferencesPanel.this.refreshPreview();
                }
            }
        });
        this.add(holder);
        panel.addSeparator();
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(e -> this.handleReset());
        resetButton.setToolTipText("Resets all settings to default values");
        panel.addGroupComponent(resetButton);
        this.loadFrom(LogPreferences.create().load());
        this.setMinimumSize(this.getPreferredSize());
    }

    private static int getStyleStart(JTextPane text, int pos, Style style) throws BadLocationException {
        StyledDocument doc = text.getStyledDocument();
        String styleName = style.getName();
        while ((pos = Utilities.getRowStart(text, pos)) != 0) {
            Element element = doc.getCharacterElement(pos - 1);
            AttributeSet addtributes = element.getAttributes();
            if (!styleName.equals(addtributes.getAttribute(StyleConstants.NameAttribute))) {
                return pos;
            }
            --pos;
        }
        return pos;
    }

    private static int getStyleEnd(JTextPane text, int pos, Style style) throws BadLocationException {
        StyledDocument doc = text.getStyledDocument();
        int maxPos = doc.getLength();
        String styleName = style.getName();
        while ((pos = Utilities.getRowEnd(text, pos)) != maxPos) {
            Element element = doc.getCharacterElement(pos + 1);
            AttributeSet addtributes = element.getAttributes();
            if (!styleName.equals(addtributes.getAttribute(StyleConstants.NameAttribute))) {
                return pos;
            }
            ++pos;
        }
        return pos;
    }

    private static Style getStyleAtPoint(JTextPane text, Point point) {
        int pos = text.viewToModel(point);
        StyledDocument doc = text.getStyledDocument();
        Element element = doc.getCharacterElement(pos);
        AttributeSet addtributes = element.getAttributes();
        return doc.getStyle((String)addtributes.getAttribute(StyleConstants.NameAttribute));
    }

    @Override
    public void dispose() throws Exception {
    }

    @Override
    public void applyChanges() {
        LogPreferences prefs = LogPreferences.create();
        this.saveTo(prefs);
        prefs.save();
    }

    private void handleReset() {
        this.loadFrom(LogPreferences.create());
    }

    private void refreshPreview() {
        this.previewRefreshed_ = false;
        SwingUtilities.invokeLater(() -> {
            if (this.previewRefreshed_) {
                return;
            }
            this.previewLog_.clearView();
            this.previewLog_.setPattern(this.patternField_.getText());
            this.previewLog_.setLineWrap(this.wrapLinesBox_.isSelected());
            this.previewLog_.setCharLimit(this.limitLogOutputCheckBox_.isSelected() ? this.logCharacterLimitModel_.getNumber().intValue() : Integer.MAX_VALUE);
            LogPreview.setLevel(Level.toLevel((String)this.logLevel_.getSelectedItem().toString()));
            LogPreview.log();
            this.previewRefreshed_ = true;
        });
    }
}

