/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.log;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.protege.editor.core.log.LogEditorKit;
import org.protege.editor.core.log.LogPreferences;
import org.protege.editor.core.log.LogStyledDocument;
import org.protege.editor.core.log.LogView;

public class LogViewImpl
extends AppenderBase<ILoggingEvent>
implements LogView {
    private static final Color ERROR_COLOR_ = new Color(220, 0, 0);
    private static final Color WARNING_COLOR_ = new Color(255, 135, 0);
    private static int[] LOG_LEVELS_ = new int[]{0, 20000, 30000, 40000};
    private static Color[] LOG_DEFAULT_FOREGROUND_COLORS_ = new Color[]{Color.LIGHT_GRAY, null, WARNING_COLOR_, ERROR_COLOR_};
    private final LogStyledDocument doc;
    private final JTextPane text;
    private final PatternLayout layout;
    private final Style[] styles = new Style[LOG_LEVELS_.length];
    private final Style commentStyle;
    private int charLimit;
    private int displayedChars = 0;
    private final LogEditorKit editorKit;

    public LogViewImpl() {
        this.text = new JTextPane();
        this.text.setFont(new Font("monospaced", 0, 12));
        this.editorKit = new LogEditorKit();
        this.text.setEditorKit(this.editorKit);
        this.doc = new LogStyledDocument();
        this.text.setDocument(this.doc);
        Style debugStyle = this.doc.addStyle("debug", null);
        Style infoStyle = this.doc.addStyle("info", null);
        Style warningStyle = this.doc.addStyle("warning", null);
        Style errorStyle = this.doc.addStyle("error", null);
        this.commentStyle = this.doc.addStyle("comment", null);
        this.styles[0] = debugStyle;
        this.styles[1] = infoStyle;
        this.styles[2] = warningStyle;
        this.styles[3] = errorStyle;
        this.layout = new PatternLayout();
        this.applyPreferences();
    }

    public boolean isLineWrap() {
        return this.editorKit.isLineWrap();
    }

    public void setLineWrap(boolean wrap) {
        this.editorKit.setLineWrap(wrap);
        this.text.revalidate();
        this.text.repaint();
    }

    public void setForegroundsFrom(Map<String, Color> foregrounds) {
        for (int i = 0; i < LOG_DEFAULT_FOREGROUND_COLORS_.length; ++i) {
            Color foreground = LOG_DEFAULT_FOREGROUND_COLORS_[i];
            this.setForeground(this.styles[i], foreground, foregrounds);
        }
        this.setForeground(this.commentStyle, Color.GRAY, foregrounds);
    }

    private void setForeground(Style style, Color defaultColor, Map<String, Color> overriden) {
        Color foreground = overriden.get(style.getName());
        if (foreground == null) {
            foreground = defaultColor;
        }
        StyleConstants.setForeground(style, foreground == null ? StyleConstants.getForeground(this.doc.getStyle("default")) : foreground);
    }

    public void copyForegroundsTo(LogPreferences prefs) {
        HashMap<String, Color> foregrounds = new HashMap<String, Color>();
        for (int i = 0; i < LOG_DEFAULT_FOREGROUND_COLORS_.length; ++i) {
            Color foreground = LOG_DEFAULT_FOREGROUND_COLORS_[i];
            this.copyForeground(this.styles[i], foreground, foregrounds);
        }
        this.copyForeground(this.commentStyle, Color.GRAY, foregrounds);
        prefs.logStyleForegrounds = foregrounds;
    }

    private void copyForeground(Style style, Color defaultColor, Map<String, Color> overriden) {
        Color newColor = StyleConstants.getForeground(style);
        if (!newColor.equals(defaultColor)) {
            overriden.put(style.getName(), newColor);
        }
    }

    public int getCharLimit() {
        return this.charLimit;
    }

    public void setCharLimit(int limit) {
        this.charLimit = limit;
    }

    public String getPattern() {
        return this.layout.getPattern();
    }

    public void setPattern(String pattern) {
        boolean started = this.isStarted();
        if (started) {
            this.layout.stop();
            this.layout.setContext(this.getContext());
        }
        this.layout.setPattern(pattern);
        if (started) {
            this.startLayout();
        }
    }

    private void startLayout() {
        PatternLayout testLayout = new PatternLayout();
        testLayout.setPattern(this.layout.getPattern());
        testLayout.setContext(this.getContext());
        try {
            testLayout.start();
            if (!testLayout.isStarted()) {
                this.setParserExceptionPattern();
            }
        }
        catch (Throwable e) {
            this.setParserExceptionPattern();
        }
        this.layout.start();
    }

    private void setParserExceptionPattern() {
        this.layout.setPattern("INVALID LOG PATTERN!%n%nopex");
    }

    @Override
    public JTextPane asJComponent() {
        return this.text;
    }

    @Override
    public void clearView() {
        SwingUtilities.invokeLater(() -> {
            this.text.setText("");
            this.displayedChars = 0;
        });
    }

    public void start() {
        this.startLayout();
        super.start();
    }

    public void stop() {
        super.stop();
        this.layout.stop();
    }

    public void setContext(Context context) {
        this.layout.setContext(context);
        super.setContext(context);
    }

    public void append(ILoggingEvent event) {
        SwingUtilities.invokeLater(() -> {
            String message;
            int level = event.getLevel().toInteger();
            int pos = Arrays.binarySearch(LOG_LEVELS_, level);
            if (pos < 0) {
                pos = -pos - 2;
            }
            Style style = this.styles[pos];
            if (level == 20000 && (message = event.getFormattedMessage()).startsWith("---") && message.endsWith("---")) {
                style = this.commentStyle;
            }
            try {
                message = this.layout.doLayout(event);
                int increment = message.length();
                this.doc.insertString(this.doc.getLength(), message, style);
                this.displayedChars += increment;
                while (this.displayedChars > this.charLimit) {
                    Element root = this.doc.getDefaultRootElement();
                    Element line = root.getElement(0);
                    int end = line.getEndOffset();
                    this.doc.remove(0, end);
                    this.displayedChars -= end;
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void applyPreferences() {
        LogPreferences prefs = LogPreferences.create().load();
        this.setLineWrap(prefs.wrapLines);
        if (prefs.limitLogOutput.booleanValue()) {
            this.setCharLimit(prefs.logCharacterLimit);
        } else {
            this.setCharLimit(Integer.MAX_VALUE);
        }
        this.setPattern(prefs.logPattern);
        this.setForegroundsFrom(prefs.logStyleForegrounds);
        this.doc.applyStyles();
    }
}

