/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.TracePoint2D;
import info.monitorenter.gui.chart.traces.Trace2DBijective;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import info.monitorenter.gui.chart.traces.Trace2DLtdReplacing;
import info.monitorenter.gui.chart.traces.Trace2DLtdSorted;
import info.monitorenter.gui.chart.traces.Trace2DReplacing;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.traces.Trace2DSorted;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Random;
import javax.swing.JFrame;

public final class TraceTester {
    public static void main(String[] stringArray) {
        try {
            int n;
            int n2;
            Class[] classArray = new Class[]{Trace2DSimple.class, Trace2DBijective.class, Trace2DReplacing.class, Trace2DSorted.class, Trace2DLtd.class, Trace2DLtdReplacing.class, Trace2DLtdSorted.class};
            RandomPoints randomPoints = new RandomPoints(0, 3, 0, 3);
            Chart2D chart2D = new Chart2D();
            JFrame jFrame = new JFrame("TraceTester");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            jFrame.getContentPane().add(chart2D);
            jFrame.setSize(600, 500);
            jFrame.setLocation(200, 200);
            jFrame.setVisible(true);
            ITrace2D iTrace2D = null;
            for (n2 = 0; n2 < classArray.length; ++n2) {
                iTrace2D = (ITrace2D)classArray[n2].newInstance();
                chart2D.addTrace(iTrace2D);
                jFrame.setTitle("TraceTester: full-random, current: " + classArray[n2].getName());
                for (n = 0; n < 200; ++n) {
                    iTrace2D.addPoint(randomPoints.nextPoint());
                    Thread.sleep(50L);
                }
                Thread.sleep(2000L);
                chart2D.removeTrace(iTrace2D);
            }
            randomPoints = new HalfRandomPoints(0, 3, 0, 3);
            for (n2 = 0; n2 < classArray.length; ++n2) {
                iTrace2D = (ITrace2D)classArray[n2].newInstance();
                chart2D.addTrace(iTrace2D);
                jFrame.setTitle("TraceTester: repeating x 10 times, current: " + classArray[n2].getName());
                for (n = 0; n < 200; ++n) {
                    iTrace2D.addPoint(randomPoints.nextPoint());
                    Thread.sleep(50L);
                }
                Thread.sleep(2000L);
                chart2D.removeTrace(iTrace2D);
            }
            System.exit(0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(0);
        }
    }

    private TraceTester() {
    }

    private static class RandomPoints {
        protected Random m_rand = new Random();
        protected double m_xmin;
        protected double m_xrange;
        protected double m_ymin;
        protected double m_yrange;

        RandomPoints(int minx, int maxx, int miny, int maxy) {
            if (minx >= maxx) {
                throw new IllegalArgumentException("minx>=maxx!");
            }
            if (miny >= maxy) {
                throw new IllegalArgumentException("miny>=maxy!");
            }
            this.m_xmin = minx;
            this.m_xrange = maxx - minx;
            this.m_ymin = miny;
            this.m_yrange = maxy - miny;
        }

        public TracePoint2D nextPoint() {
            return new TracePoint2D(this.m_rand.nextDouble() * this.m_xrange + this.m_xmin, this.m_rand.nextDouble() * this.m_yrange + this.m_ymin);
        }
    }

    static class HalfRandomPoints
    extends RandomPoints {
        private double m_oldx = 0.0;
        private double m_samexcount = 0.0;

        HalfRandomPoints(int minx, int maxx, int miny, int maxy) {
            super(minx, maxx, miny, maxy);
            this.m_oldx = (double)(maxx - minx) / 2.0;
        }

        public TracePoint2D nextPoint() {
            if (this.m_samexcount == 10.0) {
                this.m_samexcount = 0.0;
                this.m_oldx = this.m_rand.nextDouble() * this.m_xrange + this.m_xmin;
            }
            this.m_samexcount += 1.0;
            return new TracePoint2D(this.m_oldx, this.m_rand.nextDouble() * this.m_yrange + this.m_ymin);
        }
    }
}

