/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import javax.swing.event.ChangeEvent;

public class WeakPropertyChangeListener
implements PropertyChangeListener {
    private WeakReference<PropertyChangeListener> _listenerRef;
    private Object _src;

    public WeakPropertyChangeListener(PropertyChangeListener propertyChangeListener, Object object) {
        this._listenerRef = new WeakReference<PropertyChangeListener>(propertyChangeListener);
        this._src = object;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this._listenerRef.get();
        if (propertyChangeListener == null) {
            this.removeListener();
        } else {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    private void removeListener() {
        try {
            Method method = this._src.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
            method.invoke(this._src, this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

