/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import org.apache.commons.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0004J\u001a\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u001a\u0010\u0010\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u000fH\u0004J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u001a"}, d2={"Lmediathek/tool/MVInfoFile;", "", "()V", "appendFormattedTableLine", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sb", "formatString", "", "keyTitle", "value", "formatFilmAsString", "film", "Lmediathek/daten/DatenFilm;", "maxLengthHeaders", "", "splitStringIntoMaxFixedLengthLines", "input", "lineLength", "writeInfoFile", "", "datenDownload", "Lmediathek/daten/DatenDownload;", "path", "Ljava/nio/file/Path;", "Companion", "MediathekView"})
public class MVInfoFile {
    private static final Logger logger;
    private static final String FILM_GROESSE = "Gr\u00f6\u00dfe [MB]";
    private static final String FILM_SENDER = "Sender";
    private static final String FILM_THEMA = "Thema";
    private static final String FILM_TITEL = "Titel";
    private static final String FILM_DATUM = "Datum";
    private static final String FILM_ZEIT = "Zeit";
    private static final String FILM_DAUER = "Dauer";
    private static final String FILM_URL = "URL";
    @Deprecated
    public static final Companion Companion;

    @NotNull
    protected final String formatFilmAsString(@Nullable DatenFilm film, int maxLengthHeaders) {
        if (film == null) {
            return "";
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%%-%ds %%s";
        Object[] objectArray = new Object[]{maxLengthHeaders};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string2, "java.lang.String.format(format, *args)");
        String formatString = string2;
        StringBuilder sb = new StringBuilder();
        sb = this.appendFormattedTableLine(sb, formatString, FILM_SENDER, film.getSender());
        StringBuilder stringBuilder = this.appendFormattedTableLine(sb, formatString, FILM_THEMA, film.getThema()).append(System.lineSeparator());
        Intrinsics.checkExpressionValueIsNotNull(stringBuilder, "appendFormattedTableLine\u2026d(System.lineSeparator())");
        sb = stringBuilder;
        StringBuilder stringBuilder2 = this.appendFormattedTableLine(sb, formatString, FILM_TITEL, film.getTitle()).append(System.lineSeparator());
        Intrinsics.checkExpressionValueIsNotNull(stringBuilder2, "appendFormattedTableLine\u2026d(System.lineSeparator())");
        sb = stringBuilder2;
        sb = this.appendFormattedTableLine(sb, formatString, FILM_DATUM, film.getSendeDatum());
        sb = this.appendFormattedTableLine(sb, formatString, FILM_ZEIT, film.getSendeZeit());
        sb = this.appendFormattedTableLine(sb, formatString, FILM_DAUER, film.getDauer());
        StringBuilder stringBuilder3 = this.appendFormattedTableLine(sb, formatString, FILM_GROESSE, film.getSize()).append(System.lineSeparator());
        Intrinsics.checkExpressionValueIsNotNull(stringBuilder3, "appendFormattedTableLine\u2026d(System.lineSeparator())");
        sb = stringBuilder3;
        sb.append("Website");
        sb.append(System.lineSeparator());
        sb.append(film.getWebsiteLink());
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        sb.append(FILM_URL);
        sb.append(System.lineSeparator());
        sb.append(film.getUrl());
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        sb.append(this.splitStringIntoMaxFixedLengthLines(film.getDescription(), 62));
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        String string3 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string3, "sb.toString()");
        return string3;
    }

    @NotNull
    protected final StringBuilder appendFormattedTableLine(@NotNull StringBuilder sb, @Nullable String formatString, @Nullable String keyTitle, @Nullable String value) {
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull(sb, "sb");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = formatString;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = string;
        Object[] objectArray2 = StringCompanionObject.INSTANCE;
        String string3 = "%s:";
        Object[] objectArray3 = new Object[]{keyTitle};
        int n = 0;
        Object object = objectArray = new Object[2];
        StringBuilder stringBuilder = sb;
        boolean bl = false;
        String string4 = String.format(string3, Arrays.copyOf(objectArray3, objectArray3.length));
        Intrinsics.checkExpressionValueIsNotNull(string4, "java.lang.String.format(format, *args)");
        String string5 = string4;
        objectArray[n] = string5;
        object[1] = value;
        objectArray2 = object;
        boolean bl2 = false;
        String string6 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull(string6, "java.lang.String.format(format, *args)");
        object = string6;
        StringBuilder stringBuilder2 = stringBuilder.append((String)object).append(System.lineSeparator());
        Intrinsics.checkExpressionValueIsNotNull(stringBuilder2, "sb.append(String.format(\u2026d(System.lineSeparator())");
        return stringBuilder2;
    }

    @NotNull
    protected final String splitStringIntoMaxFixedLengthLines(@Nullable String input, int lineLength) {
        String string = Optional.ofNullable(input).map(new Function<T, U>(lineLength){
            final /* synthetic */ int $lineLength;

            public final String apply(@Nullable String s2) {
                return WordUtils.wrap(s2, this.$lineLength);
            }
            {
                this.$lineLength = n;
            }
        }).orElse("");
        Intrinsics.checkExpressionValueIsNotNull(string, "Optional.ofNullable(inpu\u2026              .orElse(\"\")");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeInfoFile(@Nullable DatenFilm film, @NotNull Path path) throws IOException {
        Intrinsics.checkParameterIsNotNull(path, "path");
        logger.info("Infofile schreiben nach: {}", (Object)((Object)path.toAbsolutePath()).toString());
        File file = path.toFile();
        Intrinsics.checkExpressionValueIsNotNull(file, "path.toFile()");
        file.getParentFile().mkdirs();
        Closeable closeable = Files.newOutputStream(path, new OpenOption[0]);
        boolean bl = false;
        Throwable throwable = null;
        try {
            OutputStream os = (OutputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = new DataOutputStream(os);
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                DataOutputStream dos = (DataOutputStream)closeable2;
                boolean bl4 = false;
                Closeable closeable3 = new OutputStreamWriter(dos);
                boolean bl5 = false;
                Throwable throwable3 = null;
                try {
                    OutputStreamWriter osw = (OutputStreamWriter)closeable3;
                    boolean bl6 = false;
                    Closeable closeable4 = new BufferedWriter(osw);
                    boolean bl7 = false;
                    Throwable throwable4 = null;
                    try {
                        BufferedWriter br = (BufferedWriter)closeable4;
                        boolean bl8 = false;
                        br.write(this.formatFilmAsString(film, 12));
                        br.flush();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable4, throwable4);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable3 = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally(closeable3, throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        logger.info("Infodatei geschrieben");
    }

    public final void writeInfoFile(@NotNull DatenDownload datenDownload) throws IOException {
        block0: {
            DatenFilm film;
            Intrinsics.checkParameterIsNotNull(datenDownload, "datenDownload");
            new File(datenDownload.arr[30]).mkdirs();
            Path path = Paths.get(datenDownload.getFileNameWithoutSuffix() + ".txt", new String[0]);
            DatenFilm datenFilm = film = datenDownload.film;
            if (datenFilm == null) break block0;
            DatenFilm datenFilm2 = datenFilm;
            boolean bl = false;
            boolean bl2 = false;
            DatenFilm it = datenFilm2;
            boolean bl3 = false;
            Path path2 = path;
            Intrinsics.checkExpressionValueIsNotNull(path2, "path");
            this.writeInfoFile(it, path2);
        }
    }

    static {
        Companion = new Companion(null);
        logger = LogManager.getLogger(MVInfoFile.class);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lmediathek/tool/MVInfoFile$Companion;", "", "()V", "FILM_DATUM", "", "FILM_DAUER", "FILM_GROESSE", "FILM_SENDER", "FILM_THEMA", "FILM_TITEL", "FILM_URL", "FILM_ZEIT", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

