##############################################################################
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
#
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA  02111-1307, USA.
#
#  Copyright (C) 1998-2004 Jabber Software Foundation http://jabber.org/
#
##############################################################################

package Net::Jabber::Stanza;

=head1 NAME

Net::Jabber::Stanza - Jabber Stanza Module

=head1 SYNOPSIS

  Net::Jabber::Stanza is a private package that serves as a basis
  for all Jabber stanzas generated by Net::Jabber.

=head1 DESCRIPTION

  This module is not meant to be used directly.  You should be using
  either Net::Jabber::IQ, Net::Jabber::Message, Net::Jabber::Presence, or
  another package that inherits from Net::Jabber::Stanza.

  That said, this is where all of the namespaced methods are defined.

  The current supported namespaces are:

=cut

# NS_BEGIN

=pod

    http://jabber.org/protocol/bytestreams
    http://jabber.org/protocol/commands
    http://jabber.org/protocol/disco#info
    http://jabber.org/protocol/disco#items
    http://jabber.org/protocol/feature-neg
    http://jabber.org/protocol/muc
    http://jabber.org/protocol/muc#admin
    http://jabber.org/protocol/muc#user
    http://jabber.org/protocol/pubsub
    http://jabber.org/protocol/pubsub#event
    http://jabber.org/protocol/pubsub#owner
    http://jabber.org/protocol/si
    http://jabber.org/protocol/si/profile/file-transfer
    jabber:iq:agent - DEPRECATED
    jabber:iq:agents - DEPRECATED
    jabber:iq:autoupdate
    jabber:iq:browse - DEPRECATED
    jabber:iq:conference
    jabber:iq:filter - DEPRECATED
    jabber:iq:gateway
    jabber:iq:last
    jabber:iq:oob
    jabber:iq:pass
    jabber:iq:rpc
    jabber:iq:search
    jabber:iq:time
    jabber:iq:version
    jabber:x:autoupdate
    jabber:x:conference
    jabber:x:data
    jabber:x:delay
    jabber:x:encrypted
    jabber:x:event
    jabber:x:expire
    jabber:x:oob
    jabber:x:roster
    jabber:x:signed

=cut

# NS_END

=pod
    
  For more information on what these namespaces are for, visit 
  http://www.jabber.org and browse the Jabber Programmers Guide.

  The following tables can be read as follows:

  ny:private:ns
  
  Name                        Type     Get  Set  Remove  Defined  Add
  ==========================  =======  ===  ===  ======  =======  ===
  Foo                         scalar    X    X     X        X
  Bar                         child                                X 
  Bars                        child     X
  Test                        master    X    X

  Withing the my:private:ns namespace, there exists the functions:

    GetFoo(), SetFoo(), RemoveFoo(), DefinedFoo()
    
    AddBar()
    
    GetBars(), DefinedBars()
    
    GetTest(), SetMaster()

  Hopefully it should be obvious how this all works.  If not feel free to
  contact me and I'll work on adding more documentation.

=cut

# DOC_BEGIN
=head1 http://jabber.org/protocol/bytestreams

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Activate                    scalar      X    X     X        X        
  SID                         scalar      X    X     X        X        
  StreamHostUsedJID           jid         X    X     X        X        
  StreamHost                  child                                  X 
  StreamHosts                 child       X          X        X        
  ByteStreams                 master      X    X                       

=head1 http://jabber.org/protocol/bytestreams - streamhost objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Host                        scalar      X    X     X        X        
  JID                         jid         X    X     X        X        
  Port                        scalar      X    X     X        X        
  ZeroConf                    scalar      X    X     X        X        
  StreamHost                  master      X    X                       

=head1 http://jabber.org/protocol/commands

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Action                      scalar      X    X     X        X        
  Node                        scalar      X    X     X        X        
  SessionID                   scalar      X    X     X        X        
  Status                      scalar      X    X     X        X        
  Note                        child                                  X 
  Notes                       child       X          X        X        
  Command                     master      X    X                       

=head1 http://jabber.org/protocol/commands - note objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Message                     scalar      X    X     X        X        
  Type                        scalar      X    X     X        X        
  Note                        master      X    X                       

=head1 http://jabber.org/protocol/disco#info

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Feature                     child                                  X 
  Features                    child       X          X        X        
  Identities                  child       X          X        X        
  Identity                    child                                  X 
  DiscoInfo                   master      X    X                       

=head1 http://jabber.org/protocol/disco#info - feature objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Var                         scalar      X    X     X        X        
  Feature                     master      X    X                       

=head1 http://jabber.org/protocol/disco#info - identity objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Category                    scalar      X    X     X        X        
  Name                        scalar      X    X     X        X        
  Type                        scalar      X    X     X        X        
  Identity                    master      X    X                       

=head1 http://jabber.org/protocol/disco#items

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Item                        child                                  X 
  Items                       child       X          X        X        
  DiscoItems                  master      X    X                       

=head1 http://jabber.org/protocol/disco#items - item objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Action                      scalar      X    X     X        X        
  JID                         jid         X    X     X        X        
  Name                        scalar      X    X     X        X        
  Node                        scalar      X    X     X        X        
  Item                        master      X    X                       

=head1 http://jabber.org/protocol/feature-neg

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  FeatureNeg                  master      X    X                       

=head1 http://jabber.org/protocol/muc

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Password                    scalar      X    X     X        X        
  MUC                         master      X    X                       

=head1 http://jabber.org/protocol/muc#admin

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Item                        child                                  X 
  Items                       child       X          X        X        
  Admin                       master      X    X                       

=head1 http://jabber.org/protocol/muc#admin - item objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  ActorJID                    jid         X    X     X        X        
  Affiliation                 scalar      X    X     X        X        
  JID                         jid         X    X     X        X        
  Nick                        scalar      X    X     X        X        
  Reason                      scalar      X    X     X        X        
  Role                        scalar      X    X     X        X        
  Item                        master      X    X                       

=head1 http://jabber.org/protocol/muc#user

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Alt                         scalar      X    X     X        X        
  Password                    scalar      X    X     X        X        
  StatusCode                  scalar      X    X     X        X        
  Invite                      child       X          X        X      X 
  Item                        child       X          X        X      X 
  User                        master      X    X                       

=head1 http://jabber.org/protocol/muc#user - invite objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  From                        jid         X    X     X        X        
  Reason                      scalar      X    X     X        X        
  To                          jid         X    X     X        X        
  Invite                      master      X    X                       

=head1 http://jabber.org/protocol/muc#user - item objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  ActorJID                    jid         X    X     X        X        
  Affiliation                 scalar      X    X     X        X        
  JID                         jid         X    X     X        X        
  Nick                        scalar      X    X     X        X        
  Reason                      scalar      X    X     X        X        
  Role                        scalar      X    X     X        X        
  Item                        master      X    X                       

=head1 http://jabber.org/protocol/pubsub

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Affiliations                child       X          X        X      X 
  Configure                   child       X          X        X      X 
  Create                      child       X          X        X      X 
  Delete                      child       X          X        X      X 
  Entities                    child       X          X        X      X 
  Entity                      child       X          X        X      X 
  Item                        child       X          X        X      X 
  Items                       child       X          X        X      X 
  Options                     child       X          X        X      X 
  Publish                     child       X          X        X      X 
  Purge                       child       X          X        X      X 
  Retract                     child       X          X        X      X 
  Subscribe                   child       X          X        X      X 
  Unsubscribe                 child       X          X        X      X 
  PubSub                      master      X    X                       

=head1 http://jabber.org/protocol/pubsub - affiliations objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Entity                      child       X          X        X      X 
  Affiliations                master      X    X                       

=head1 http://jabber.org/protocol/pubsub - configure objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Configure                   master      X    X                       

=head1 http://jabber.org/protocol/pubsub - create objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Create                      master      X    X                       

=head1 http://jabber.org/protocol/pubsub - delete objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Delete                      master      X    X                       

=head1 http://jabber.org/protocol/pubsub - entities objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Entity                      child       X          X        X      X 
  Entities                    master      X    X                       

=head1 http://jabber.org/protocol/pubsub - entity objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Affiliation                 scalar      X    X     X        X        
  JID                         jid         X    X     X        X        
  Node                        scalar      X    X     X        X        
  Subscription                scalar      X    X     X        X        
  SubscribeOptions            child       X          X        X      X 
  Entity                      master      X    X                       

=head1 http://jabber.org/protocol/pubsub - item objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  ID                          scalar      X    X     X        X        
  Payload                     raw         X    X     X        X        
  Item                        master      X    X                       

=head1 http://jabber.org/protocol/pubsub - items objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  MaxItems                    scalar      X    X     X        X        
  Node                        scalar      X    X     X        X        
  Item                        child       X          X        X      X 
  Items                       master      X    X                       

=head1 http://jabber.org/protocol/pubsub - options objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  JID                         jid         X    X     X        X        
  Node                        scalar      X    X     X        X        
  Options                     master      X    X                       

=head1 http://jabber.org/protocol/pubsub - publish objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Item                        child       X          X        X      X 
  Publish                     master      X    X                       

=head1 http://jabber.org/protocol/pubsub - purge objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Purge                       master      X    X                       

=head1 http://jabber.org/protocol/pubsub - retract objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Item                        child       X          X        X      X 
  Retract                     master      X    X                       

=head1 http://jabber.org/protocol/pubsub - subscribe objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  JID                         jid         X    X     X        X        
  Node                        scalar      X    X     X        X        
  Subscribe                   master      X    X                       

=head1 http://jabber.org/protocol/pubsub - subscribe-options objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Required                    flag        X    X     X        X        
  SubscribeOptions            master      X    X                       

=head1 http://jabber.org/protocol/pubsub - unsubscribe objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  JID                         jid         X    X     X        X        
  Node                        scalar      X    X     X        X        
  Unsubscribe                 master      X    X                       

=head1 http://jabber.org/protocol/pubsub#event

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Delete                      child       X          X        X      X 
  Items                       child       X          X        X      X 
  Event                       master      X    X                       

=head1 http://jabber.org/protocol/pubsub#event - delete objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Delete                      master      X    X                       

=head1 http://jabber.org/protocol/pubsub#event - item objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  ID                          scalar      X    X     X        X        
  Payload                     raw         X    X     X        X        
  Item                        master      X    X                       

=head1 http://jabber.org/protocol/pubsub#event - items objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Item                        child       X          X        X      X 
  Items                       master      X    X                       

=head1 http://jabber.org/protocol/pubsub#owner

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Action                      scalar      X    X     X        X        
  Configure                   child       X          X        X      X 
  Owner                       master      X    X                       

=head1 http://jabber.org/protocol/pubsub#owner - configure objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Configure                   master      X    X                       

=head1 http://jabber.org/protocol/si

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  ID                          scalar      X    X     X        X        
  MimeType                    scalar      X    X     X        X        
  Profile                     scalar      X    X     X        X        
  Stream                      master      X    X                       

=head1 http://jabber.org/protocol/si/profile/file-transfer

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Date                        scalar      X    X     X        X        
  Desc                        scalar      X    X     X        X        
  Hash                        scalar      X    X     X        X        
  Name                        scalar      X    X     X        X        
  Range                       flag        X    X     X        X        
  RangeLength                 scalar      X    X     X        X        
  RangeOffset                 scalar      X    X     X        X        
  Size                        scalar      X    X     X        X        
  File                        master      X    X                       

=head1 jabber:iq:agent - DEPRECATED

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Agents                      flag        X    X     X        X        
  Description                 scalar      X    X     X        X        
  GroupChat                   flag        X    X     X        X        
  JID                         jid         X    X     X        X        
  Name                        scalar      X    X     X        X        
  Register                    flag        X    X     X        X        
  Search                      flag        X    X     X        X        
  Service                     scalar      X    X     X        X        
  Transport                   scalar      X    X     X        X        
  URL                         scalar      X    X     X        X        
  Agent                       master      X    X                       

=head1 jabber:iq:agents - DEPRECATED

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Agent                       child                                  X 
  Agents                      child       X          X        X        

=head1 jabber:iq:autoupdate

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Beta                        child                                  X 
  Dev                         child                                  X 
  Release                     child                                  X 
  Releases                    child       X          X        X        

=head1 jabber:iq:autoupdate - release objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Desc                        scalar      X    X     X        X        
  Priority                    scalar      X    X     X        X        
  URL                         scalar      X    X     X        X        
  Version                     scalar      X    X     X        X        
  Release                     master      X    X                       

=head1 jabber:iq:browse - DEPRECATED

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Category                    scalar      X    X     X        X        
  JID                         jid         X    X     X        X        
  NS                          array       X    X     X        X        
  Name                        scalar      X    X     X        X        
  Type                        scalar      X    X     X        X        
  Item                        child                                  X 
  Items                       child       X          X        X        
  Browse                      master      X    X                       

=head1 jabber:iq:browse - item objects - DEPRECATED

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Category                    scalar      X    X     X        X        
  JID                         jid         X    X     X        X        
  NS                          array       X    X     X        X        
  Name                        scalar      X    X     X        X        
  Type                        scalar      X    X     X        X        
  Item                        child                                  X 
  Items                       child       X          X        X        
  Browse                      master      X    X                       

=head1 jabber:iq:conference

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  ID                          scalar      X    X     X        X        
  Name                        scalar      X    X     X        X        
  Nick                        scalar      X    X     X        X        
  Privacy                     flag        X    X     X        X        
  Secret                      scalar      X    X     X        X        
  Conference                  master      X    X                       

=head1 jabber:iq:filter - DEPRECATED

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Rule                        child                                  X 
  Rules                       child       X          X        X        

=head1 jabber:iq:filter - rule objects - DEPRECATED

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Body                        scalar      X    X     X        X        
  Continued                   scalar      X    X     X        X        
  Drop                        scalar      X    X     X        X        
  Edit                        scalar      X    X     X        X        
  Error                       scalar      X    X     X        X        
  From                        scalar      X    X     X        X        
  Offline                     scalar      X    X     X        X        
  Reply                       scalar      X    X     X        X        
  Resource                    scalar      X    X     X        X        
  Show                        scalar      X    X     X        X        
  Size                        scalar      X    X     X        X        
  Subject                     scalar      X    X     X        X        
  Time                        scalar      X    X     X        X        
  Type                        scalar      X    X     X        X        
  Unavailable                 scalar      X    X     X        X        
  Rule                        master      X    X                       

=head1 jabber:iq:gateway

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Desc                        scalar      X    X     X        X        
  JID                         jid         X    X     X        X        
  Prompt                      scalar      X    X     X        X        
  Gateway                     master      X    X                       

=head1 jabber:iq:last

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Message                     scalar      X    X     X        X        
  Seconds                     scalar      X    X     X        X        
  Last                        master      X    X                       

=head1 jabber:iq:oob

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Desc                        scalar      X    X     X        X        
  URL                         scalar      X    X     X        X        
  Oob                         master      X    X                       

=head1 jabber:iq:pass

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Client                      scalar      X    X     X        X        
  ClientPort                  scalar      X    X     X        X        
  Close                       flag        X    X     X        X        
  Expire                      scalar      X    X     X        X        
  OneShot                     flag        X    X     X        X        
  Proxy                       scalar      X    X     X        X        
  ProxyPort                   scalar      X    X     X        X        
  Server                      scalar      X    X     X        X        
  ServerPort                  scalar      X    X     X        X        
  Pass                        master      X    X                       

=head1 jabber:iq:rpc

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  MethodCall                  child       X          X        X      X 
  MethodResponse              child       X          X        X      X 

=head1 jabber:iq:rpc - array objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Data                        child                                  X 
  Datas                       child       X          X        X        

=head1 jabber:iq:rpc - data objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Value                       child       X          X        X      X 

=head1 jabber:iq:rpc - fault objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Value                       child       X          X        X      X 

=head1 jabber:iq:rpc - member objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Name                        scalar      X    X     X        X        
  Value                       child       X          X        X      X 
  Member                      master      X    X                       

=head1 jabber:iq:rpc - methodCall objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  MethodName                  scalar      X    X     X        X        
  Params                      child       X          X        X      X 
  MethodCall                  master      X    X                       

=head1 jabber:iq:rpc - methodResponse objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Fault                       child       X          X        X      X 
  Params                      child       X          X        X      X 

=head1 jabber:iq:rpc - param objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Value                       child       X          X        X      X 

=head1 jabber:iq:rpc - params objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Param                       child                                  X 
  Params                      child       X          X        X        

=head1 jabber:iq:rpc - struct objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Member                      child                                  X 
  Members                     child       X          X        X        

=head1 jabber:iq:rpc - value objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Base64                      scalar      X    X     X        X        
  Boolean                     scalar      X    X     X        X        
  DateTime                    scalar      X    X     X        X        
  Double                      scalar      X    X     X        X        
  I4                          scalar      X    X     X        X        
  Int                         scalar      X    X     X        X        
  String                      scalar      X    X     X        X        
  Value                       scalar      X    X     X        X        
  Array                       child       X          X        X      X 
  Struct                      child       X          X        X      X 
  RPCValue                    master      X    X                       

=head1 jabber:iq:search

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Email                       scalar      X    X     X        X        
  Family                      scalar      X    X     X        X        
  First                       scalar      X    X     X        X        
  Given                       scalar      X    X     X        X        
  Instructions                scalar      X    X     X        X        
  Key                         scalar      X    X     X        X        
  Last                        scalar      X    X     X        X        
  Name                        scalar      X    X     X        X        
  Nick                        scalar      X    X     X        X        
  Truncated                   flag        X    X     X        X        
  Item                        child                                  X 
  Items                       child       X          X        X        
  Search                      master      X    X                       

=head1 jabber:iq:search - item objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Email                       scalar      X    X     X        X        
  Family                      scalar      X    X     X        X        
  First                       scalar      X    X     X        X        
  Given                       scalar      X    X     X        X        
  JID                         jid         X    X     X        X        
  Key                         scalar      X    X     X        X        
  Last                        scalar      X    X     X        X        
  Name                        scalar      X    X     X        X        
  Nick                        scalar      X    X     X        X        
  Item                        master      X    X                       

=head1 jabber:iq:time

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Display                     special     X    X     X        X        
  TZ                          special     X    X     X        X        
  UTC                         special     X    X     X        X        
  Time                        master      X    X                       

=head1 jabber:iq:version

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Name                        scalar      X    X     X        X        
  OS                          special     X    X     X        X        
  Ver                         special     X    X     X        X        
  Version                     master      X    X                       

=head1 jabber:x:autoupdate

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  JID                         jid         X    X     X        X        
  Autoupdate                  master      X    X                       

=head1 jabber:x:conference

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  JID                         jid         X    X     X        X        
  Conference                  master      X    X                       

=head1 jabber:x:data

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Form                        scalar      X    X     X        X        
  Instructions                scalar      X    X     X        X        
  Title                       scalar      X    X     X        X        
  Type                        scalar      X    X     X        X        
  Field                       child                                  X 
  Fields                      child       X          X        X        
  Item                        child                                  X 
  Items                       child       X          X        X        
  Reported                    child       X          X        X      X 
  Data                        master      X    X                       

=head1 jabber:x:data - field objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Desc                        scalar      X    X     X        X        
  Label                       scalar      X    X     X        X        
  Required                    flag        X    X     X        X        
  Type                        scalar      X    X     X        X        
  Value                       array       X    X     X        X        
  Var                         scalar      X    X     X        X        
  Option                      child                                  X 
  Options                     child       X          X        X        
  Field                       master      X    X                       

=head1 jabber:x:data - item objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Field                       child                                  X 
  Fields                      child       X          X        X        
  Item                        master      X    X                       

=head1 jabber:x:data - option objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Label                       scalar      X    X     X        X        
  Value                       scalar      X    X     X        X        
  Option                      master      X    X                       

=head1 jabber:x:data - reported objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Field                       child                                  X 
  Fields                      child       X          X        X        
  Reported                    master      X    X                       

=head1 jabber:x:delay

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  From                        jid         X    X     X        X        
  Message                     scalar      X    X     X        X        
  Stamp                       timestamp   X    X     X        X        
  Delay                       master      X    X                       

=head1 jabber:x:encrypted

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Message                     scalar      X    X     X        X        
  Encrypted                   master      X    X                       

=head1 jabber:x:event

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Composing                   flag        X    X     X        X        
  Delivered                   flag        X    X     X        X        
  Displayed                   flag        X    X     X        X        
  ID                          scalar      X    X     X        X        
  Offline                     flag        X    X     X        X        
  Event                       master      X    X                       

=head1 jabber:x:expire

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Seconds                     scalar      X    X     X        X        
  Expire                      master      X    X                       

=head1 jabber:x:oob

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Desc                        scalar      X    X     X        X        
  URL                         scalar      X    X     X        X        
  Oob                         master      X    X                       

=head1 jabber:x:roster

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Item                        child                                  X 
  Items                       child       X          X        X        
  Roster                      master      X    X                       

=head1 jabber:x:roster - item objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Ask                         scalar      X    X     X        X        
  Group                       array       X    X     X        X        
  JID                         jid         X    X     X        X        
  Name                        scalar      X    X     X        X        
  Subscription                scalar      X    X     X        X        
  Item                        master      X    X                       

=head1 jabber:x:signed

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Signature                   scalar      X    X     X        X        
  Signed                      master      X    X                       

# DOC_BEGIN
=head1 http://jabber.org/protocol/bytestreams

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Activate                    scalar      X    X     X        X        
  SID                         scalar      X    X     X        X        
  StreamHostUsedJID           jid         X    X     X        X        
  StreamHost                  child                                  X 
  StreamHosts                 child       X          X        X        
  ByteStreams                 master      X    X                       

=head1 http://jabber.org/protocol/bytestreams - streamhost objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Host                        scalar      X    X     X        X        
  JID                         jid         X    X     X        X        
  Port                        scalar      X    X     X        X        
  ZeroConf                    scalar      X    X     X        X        
  StreamHost                  master      X    X                       

=head1 http://jabber.org/protocol/commands

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Action                      scalar      X    X     X        X        
  Node                        scalar      X    X     X        X        
  SessionID                   scalar      X    X     X        X        
  Status                      scalar      X    X     X        X        
  Note                        child                                  X 
  Notes                       child       X          X        X        
  Command                     master      X    X                       

=head1 http://jabber.org/protocol/commands - note objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Message                     scalar      X    X     X        X        
  Type                        scalar      X    X     X        X        
  Note                        master      X    X                       

=head1 http://jabber.org/protocol/disco#info

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Feature                     child                                  X 
  Features                    child       X          X        X        
  Identities                  child       X          X        X        
  Identity                    child                                  X 
  DiscoInfo                   master      X    X                       

=head1 http://jabber.org/protocol/disco#info - feature objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Var                         scalar      X    X     X        X        
  Feature                     master      X    X                       

=head1 http://jabber.org/protocol/disco#info - identity objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Category                    scalar      X    X     X        X        
  Name                        scalar      X    X     X        X        
  Type                        scalar      X    X     X        X        
  Identity                    master      X    X                       

=head1 http://jabber.org/protocol/disco#items

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Item                        child                                  X 
  Items                       child       X          X        X        
  DiscoItems                  master      X    X                       

=head1 http://jabber.org/protocol/disco#items - item objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Action                      scalar      X    X     X        X        
  JID                         jid         X    X     X        X        
  Name                        scalar      X    X     X        X        
  Node                        scalar      X    X     X        X        
  Item                        master      X    X                       

=head1 http://jabber.org/protocol/feature-neg

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  FeatureNeg                  master      X    X                       

=head1 http://jabber.org/protocol/muc

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Password                    scalar      X    X     X        X        
  MUC                         master      X    X                       

=head1 http://jabber.org/protocol/muc#admin

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Item                        child                                  X 
  Items                       child       X          X        X        
  Admin                       master      X    X                       

=head1 http://jabber.org/protocol/muc#admin - item objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  ActorJID                    jid         X    X     X        X        
  Affiliation                 scalar      X    X     X        X        
  JID                         jid         X    X     X        X        
  Nick                        scalar      X    X     X        X        
  Reason                      scalar      X    X     X        X        
  Role                        scalar      X    X     X        X        
  Item                        master      X    X                       

=head1 http://jabber.org/protocol/muc#user

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Alt                         scalar      X    X     X        X        
  Password                    scalar      X    X     X        X        
  StatusCode                  scalar      X    X     X        X        
  Invite                      child       X          X        X      X 
  Item                        child       X          X        X      X 
  User                        master      X    X                       

=head1 http://jabber.org/protocol/muc#user - invite objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  From                        jid         X    X     X        X        
  Reason                      scalar      X    X     X        X        
  To                          jid         X    X     X        X        
  Invite                      master      X    X                       

=head1 http://jabber.org/protocol/muc#user - item objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  ActorJID                    jid         X    X     X        X        
  Affiliation                 scalar      X    X     X        X        
  JID                         jid         X    X     X        X        
  Nick                        scalar      X    X     X        X        
  Reason                      scalar      X    X     X        X        
  Role                        scalar      X    X     X        X        
  Item                        master      X    X                       

=head1 http://jabber.org/protocol/pubsub

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Affiliations                child       X          X        X      X 
  Configure                   child       X          X        X      X 
  Create                      child       X          X        X      X 
  Delete                      child       X          X        X      X 
  Entities                    child       X          X        X      X 
  Entity                      child       X          X        X      X 
  Item                        child       X          X        X      X 
  Items                       child       X          X        X      X 
  Options                     child       X          X        X      X 
  Publish                     child       X          X        X      X 
  Purge                       child       X          X        X      X 
  Retract                     child       X          X        X      X 
  Subscribe                   child       X          X        X      X 
  Unsubscribe                 child       X          X        X      X 
  PubSub                      master      X    X                       

=head1 http://jabber.org/protocol/pubsub - affiliations objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Entity                      child       X          X        X      X 
  Affiliations                master      X    X                       

=head1 http://jabber.org/protocol/pubsub - configure objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Configure                   master      X    X                       

=head1 http://jabber.org/protocol/pubsub - create objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Create                      master      X    X                       

=head1 http://jabber.org/protocol/pubsub - delete objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Delete                      master      X    X                       

=head1 http://jabber.org/protocol/pubsub - entities objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Entity                      child       X          X        X      X 
  Entities                    master      X    X                       

=head1 http://jabber.org/protocol/pubsub - entity objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Affiliation                 scalar      X    X     X        X        
  JID                         jid         X    X     X        X        
  Node                        scalar      X    X     X        X        
  Subscription                scalar      X    X     X        X        
  SubscribeOptions            child       X          X        X      X 
  Entity                      master      X    X                       

=head1 http://jabber.org/protocol/pubsub - item objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  ID                          scalar      X    X     X        X        
  Payload                     raw         X    X     X        X        
  Item                        master      X    X                       

=head1 http://jabber.org/protocol/pubsub - items objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  MaxItems                    scalar      X    X     X        X        
  Node                        scalar      X    X     X        X        
  Item                        child       X          X        X      X 
  Items                       master      X    X                       

=head1 http://jabber.org/protocol/pubsub - options objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  JID                         jid         X    X     X        X        
  Node                        scalar      X    X     X        X        
  Options                     master      X    X                       

=head1 http://jabber.org/protocol/pubsub - publish objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Item                        child       X          X        X      X 
  Publish                     master      X    X                       

=head1 http://jabber.org/protocol/pubsub - purge objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Purge                       master      X    X                       

=head1 http://jabber.org/protocol/pubsub - retract objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Item                        child       X          X        X      X 
  Retract                     master      X    X                       

=head1 http://jabber.org/protocol/pubsub - subscribe objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  JID                         jid         X    X     X        X        
  Node                        scalar      X    X     X        X        
  Subscribe                   master      X    X                       

=head1 http://jabber.org/protocol/pubsub - subscribe-options objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Required                    flag        X    X     X        X        
  SubscribeOptions            master      X    X                       

=head1 http://jabber.org/protocol/pubsub - unsubscribe objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  JID                         jid         X    X     X        X        
  Node                        scalar      X    X     X        X        
  Unsubscribe                 master      X    X                       

=head1 http://jabber.org/protocol/pubsub#event

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Delete                      child       X          X        X      X 
  Items                       child       X          X        X      X 
  Event                       master      X    X                       

=head1 http://jabber.org/protocol/pubsub#event - delete objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Delete                      master      X    X                       

=head1 http://jabber.org/protocol/pubsub#event - item objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  ID                          scalar      X    X     X        X        
  Payload                     raw         X    X     X        X        
  Item                        master      X    X                       

=head1 http://jabber.org/protocol/pubsub#event - items objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Item                        child       X          X        X      X 
  Items                       master      X    X                       

=head1 http://jabber.org/protocol/pubsub#owner

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Action                      scalar      X    X     X        X        
  Configure                   child       X          X        X      X 
  Owner                       master      X    X                       

=head1 http://jabber.org/protocol/pubsub#owner - configure objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Node                        scalar      X    X     X        X        
  Configure                   master      X    X                       

=head1 http://jabber.org/protocol/si

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  ID                          scalar      X    X     X        X        
  MimeType                    scalar      X    X     X        X        
  Profile                     scalar      X    X     X        X        
  Stream                      master      X    X                       

=head1 http://jabber.org/protocol/si/profile/file-transfer

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Date                        scalar      X    X     X        X        
  Desc                        scalar      X    X     X        X        
  Hash                        scalar      X    X     X        X        
  Name                        scalar      X    X     X        X        
  Range                       flag        X    X     X        X        
  RangeLength                 scalar      X    X     X        X        
  RangeOffset                 scalar      X    X     X        X        
  Size                        scalar      X    X     X        X        
  File                        master      X    X                       

=head1 jabber:iq:agent - DEPRECATED

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Agents                      flag        X    X     X        X        
  Description                 scalar      X    X     X        X        
  GroupChat                   flag        X    X     X        X        
  JID                         jid         X    X     X        X        
  Name                        scalar      X    X     X        X        
  Register                    flag        X    X     X        X        
  Search                      flag        X    X     X        X        
  Service                     scalar      X    X     X        X        
  Transport                   scalar      X    X     X        X        
  URL                         scalar      X    X     X        X        
  Agent                       master      X    X                       

=head1 jabber:iq:agents - DEPRECATED

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Agent                       child                                  X 
  Agents                      child       X          X        X        

=head1 jabber:iq:autoupdate

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Beta                        child                                  X 
  Dev                         child                                  X 
  Release                     child                                  X 
  Releases                    child       X          X        X        

=head1 jabber:iq:autoupdate - release objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Desc                        scalar      X    X     X        X        
  Priority                    scalar      X    X     X        X        
  URL                         scalar      X    X     X        X        
  Version                     scalar      X    X     X        X        
  Release                     master      X    X                       

=head1 jabber:iq:browse - DEPRECATED

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Category                    scalar      X    X     X        X        
  JID                         jid         X    X     X        X        
  NS                          array       X    X     X        X        
  Name                        scalar      X    X     X        X        
  Type                        scalar      X    X     X        X        
  Item                        child                                  X 
  Items                       child       X          X        X        
  Browse                      master      X    X                       

=head1 jabber:iq:browse - item objects - DEPRECATED

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Category                    scalar      X    X     X        X        
  JID                         jid         X    X     X        X        
  NS                          array       X    X     X        X        
  Name                        scalar      X    X     X        X        
  Type                        scalar      X    X     X        X        
  Item                        child                                  X 
  Items                       child       X          X        X        
  Browse                      master      X    X                       

=head1 jabber:iq:conference

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  ID                          scalar      X    X     X        X        
  Name                        scalar      X    X     X        X        
  Nick                        scalar      X    X     X        X        
  Privacy                     flag        X    X     X        X        
  Secret                      scalar      X    X     X        X        
  Conference                  master      X    X                       

=head1 jabber:iq:filter - DEPRECATED

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Rule                        child                                  X 
  Rules                       child       X          X        X        

=head1 jabber:iq:filter - rule objects - DEPRECATED

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Body                        scalar      X    X     X        X        
  Continued                   scalar      X    X     X        X        
  Drop                        scalar      X    X     X        X        
  Edit                        scalar      X    X     X        X        
  Error                       scalar      X    X     X        X        
  From                        scalar      X    X     X        X        
  Offline                     scalar      X    X     X        X        
  Reply                       scalar      X    X     X        X        
  Resource                    scalar      X    X     X        X        
  Show                        scalar      X    X     X        X        
  Size                        scalar      X    X     X        X        
  Subject                     scalar      X    X     X        X        
  Time                        scalar      X    X     X        X        
  Type                        scalar      X    X     X        X        
  Unavailable                 scalar      X    X     X        X        
  Rule                        master      X    X                       

=head1 jabber:iq:gateway

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Desc                        scalar      X    X     X        X        
  JID                         jid         X    X     X        X        
  Prompt                      scalar      X    X     X        X        
  Gateway                     master      X    X                       

=head1 jabber:iq:last

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Message                     scalar      X    X     X        X        
  Seconds                     scalar      X    X     X        X        
  Last                        master      X    X                       

=head1 jabber:iq:oob

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Desc                        scalar      X    X     X        X        
  URL                         scalar      X    X     X        X        
  Oob                         master      X    X                       

=head1 jabber:iq:pass

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Client                      scalar      X    X     X        X        
  ClientPort                  scalar      X    X     X        X        
  Close                       flag        X    X     X        X        
  Expire                      scalar      X    X     X        X        
  OneShot                     flag        X    X     X        X        
  Proxy                       scalar      X    X     X        X        
  ProxyPort                   scalar      X    X     X        X        
  Server                      scalar      X    X     X        X        
  ServerPort                  scalar      X    X     X        X        
  Pass                        master      X    X                       

=head1 jabber:iq:rpc

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  MethodCall                  child       X          X        X      X 
  MethodResponse              child       X          X        X      X 

=head1 jabber:iq:rpc - array objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Data                        child                                  X 
  Datas                       child       X          X        X        

=head1 jabber:iq:rpc - data objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Value                       child       X          X        X      X 

=head1 jabber:iq:rpc - fault objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Value                       child       X          X        X      X 

=head1 jabber:iq:rpc - member objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Name                        scalar      X    X     X        X        
  Value                       child       X          X        X      X 
  Member                      master      X    X                       

=head1 jabber:iq:rpc - methodCall objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  MethodName                  scalar      X    X     X        X        
  Params                      child       X          X        X      X 
  MethodCall                  master      X    X                       

=head1 jabber:iq:rpc - methodResponse objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Fault                       child       X          X        X      X 
  Params                      child       X          X        X      X 

=head1 jabber:iq:rpc - param objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Value                       child       X          X        X      X 

=head1 jabber:iq:rpc - params objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Param                       child                                  X 
  Params                      child       X          X        X        

=head1 jabber:iq:rpc - struct objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Member                      child                                  X 
  Members                     child       X          X        X        

=head1 jabber:iq:rpc - value objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Base64                      scalar      X    X     X        X        
  Boolean                     scalar      X    X     X        X        
  DateTime                    scalar      X    X     X        X        
  Double                      scalar      X    X     X        X        
  I4                          scalar      X    X     X        X        
  Int                         scalar      X    X     X        X        
  String                      scalar      X    X     X        X        
  Value                       scalar      X    X     X        X        
  Array                       child       X          X        X      X 
  Struct                      child       X          X        X      X 
  RPCValue                    master      X    X                       

=head1 jabber:iq:search

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Email                       scalar      X    X     X        X        
  Family                      scalar      X    X     X        X        
  First                       scalar      X    X     X        X        
  Given                       scalar      X    X     X        X        
  Instructions                scalar      X    X     X        X        
  Key                         scalar      X    X     X        X        
  Last                        scalar      X    X     X        X        
  Name                        scalar      X    X     X        X        
  Nick                        scalar      X    X     X        X        
  Truncated                   flag        X    X     X        X        
  Item                        child                                  X 
  Items                       child       X          X        X        
  Search                      master      X    X                       

=head1 jabber:iq:search - item objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Email                       scalar      X    X     X        X        
  Family                      scalar      X    X     X        X        
  First                       scalar      X    X     X        X        
  Given                       scalar      X    X     X        X        
  JID                         jid         X    X     X        X        
  Key                         scalar      X    X     X        X        
  Last                        scalar      X    X     X        X        
  Name                        scalar      X    X     X        X        
  Nick                        scalar      X    X     X        X        
  Item                        master      X    X                       

=head1 jabber:iq:time

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Display                     special     X    X     X        X        
  TZ                          special     X    X     X        X        
  UTC                         special     X    X     X        X        
  Time                        master      X    X                       

=head1 jabber:iq:version

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Name                        scalar      X    X     X        X        
  OS                          special     X    X     X        X        
  Ver                         special     X    X     X        X        
  Version                     master      X    X                       

=head1 jabber:x:autoupdate

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  JID                         jid         X    X     X        X        
  Autoupdate                  master      X    X                       

=head1 jabber:x:conference

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  JID                         jid         X    X     X        X        
  Conference                  master      X    X                       

=head1 jabber:x:data

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Form                        scalar      X    X     X        X        
  Instructions                scalar      X    X     X        X        
  Title                       scalar      X    X     X        X        
  Type                        scalar      X    X     X        X        
  Field                       child                                  X 
  Fields                      child       X          X        X        
  Item                        child                                  X 
  Items                       child       X          X        X        
  Reported                    child       X          X        X      X 
  Data                        master      X    X                       

=head1 jabber:x:data - field objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Desc                        scalar      X    X     X        X        
  Label                       scalar      X    X     X        X        
  Required                    flag        X    X     X        X        
  Type                        scalar      X    X     X        X        
  Value                       array       X    X     X        X        
  Var                         scalar      X    X     X        X        
  Option                      child                                  X 
  Options                     child       X          X        X        
  Field                       master      X    X                       

=head1 jabber:x:data - item objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Field                       child                                  X 
  Fields                      child       X          X        X        
  Item                        master      X    X                       

=head1 jabber:x:data - option objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Label                       scalar      X    X     X        X        
  Value                       scalar      X    X     X        X        
  Option                      master      X    X                       

=head1 jabber:x:data - reported objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Field                       child                                  X 
  Fields                      child       X          X        X        
  Reported                    master      X    X                       

=head1 jabber:x:delay

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  From                        jid         X    X     X        X        
  Message                     scalar      X    X     X        X        
  Stamp                       timestamp   X    X     X        X        
  Delay                       master      X    X                       

=head1 jabber:x:encrypted

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Message                     scalar      X    X     X        X        
  Encrypted                   master      X    X                       

=head1 jabber:x:event

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Composing                   flag        X    X     X        X        
  Delivered                   flag        X    X     X        X        
  Displayed                   flag        X    X     X        X        
  ID                          scalar      X    X     X        X        
  Offline                     flag        X    X     X        X        
  Event                       master      X    X                       

=head1 jabber:x:expire

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Seconds                     scalar      X    X     X        X        
  Expire                      master      X    X                       

=head1 jabber:x:oob

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Desc                        scalar      X    X     X        X        
  URL                         scalar      X    X     X        X        
  Oob                         master      X    X                       

=head1 jabber:x:roster

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Item                        child                                  X 
  Items                       child       X          X        X        
  Roster                      master      X    X                       

=head1 jabber:x:roster - item objects

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Ask                         scalar      X    X     X        X        
  Group                       array       X    X     X        X        
  JID                         jid         X    X     X        X        
  Name                        scalar      X    X     X        X        
  Subscription                scalar      X    X     X        X        
  Item                        master      X    X                       

=head1 jabber:x:signed

  Name                        Type       Get  Set  Remove  Defined  Add
  ==========================  =========  ===  ===  ======  =======  ===
  Signature                   scalar      X    X     X        X        
  Signed                      master      X    X                       


=cut

# DOC_END

=head1 AUTHOR

Ryan Eatmon

=head1 COPYRIGHT

This module is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

use strict;
use Carp;
use Net::XMPP::Stanza;
use Net::Jabber::Namespaces;

use base qw( Net::XMPP::Stanza );

use vars qw( $TIMEZONE );

if (eval "require Time::Timezone")
{
    $TIMEZONE = 1;
    Time::Timezone->import(qw(tz_local_offset tz_name));
}
else
{
    $TIMEZONE = 0;
}


sub _init
{
    my $self = shift;

    my $result = $self->SUPER::_init(@_);

    if (defined($result))
    {
        $result->_CustomSet_init();
        return $result;
    }

    $self->_CustomSet_init();
    return;
}

sub GetX     { my $self = shift; $self->GetChild(@_);    } 
sub DefinedX { my $self = shift; $self->DefinedChild(@_); }
sub NewX     { my $self = shift; $self->NewChild(@_);    }
sub AddX     { my $self = shift; $self->AddChild(@_);    } 
sub RemoveX  { my $self = shift; $self->RemoveChild(@_); }

sub GetQuery     { my $self = shift; $self->GetChild(@_);     }
sub DefinedQuery { my $self = shift; $self->DefinedChild(@_); }
sub NewQuery     { my $self = shift; $self->NewChild(@_);     }
sub AddQuery     { my $self = shift; $self->AddChild(@_);     } 
sub RemoveQuery  { my $self = shift; $self->RemoveChild(@_);  }

sub _new_jid    { my $self = shift; return new Net::Jabber::JID(@_);    }
sub _new_packet { my $self = shift; return new Net::Jabber::Stanza(@_); }


sub _CustomSet_init
{
    my $self = shift;

    $self->{CUSTOMSET}->{"time-display"} = \&_CustomSet_timedisplay;
    $self->{CUSTOMSET}->{"time-tz"} = \&_CustomSet_timetz;
    $self->{CUSTOMSET}->{"time-utc"} = \&_CustomSet_timeutc;
    $self->{CUSTOMSET}->{"version-os"} = \&_CustomSet_versionos;
    $self->{CUSTOMSET}->{"version-version"} = \&_CustomSet_versionversion;
}


sub _CustomSet_timedisplay
{
    my $self = shift;
    my $value = shift;

    return $value if defined($value);
    $self->{DATA}->{__netjabbertime__} = time
        unless exists($self->{DATA}->{__netjabbertime__});
    return &Net::XMPP::GetTimeStamp("local",$self->{DATA}->{__netjabbertime__});
}


sub _CustomSet_timetz
{
    my $self = shift;
    my $value = shift;
    
    if (!defined($value) && ($TIMEZONE == 1))
    {
        return uc(&tz_name(&tz_local_offset()))
    }
    return $value;
}


sub _CustomSet_timeutc
{
    my $self = shift;
    my $value = shift;

    return $value if defined($value);
    $self->{DATA}->{__netjabbertime__} = time
        unless exists($self->{DATA}->{__netjabbertime__});
    return &Net::XMPP::GetTimeStamp("utc",$self->{DATA}->{__netjabbertime__},"stamp");
}


sub _CustomSet_versionos
{
    my $self = shift;
    my $value = shift;

    return (&POSIX::uname())[0];
}


sub _CustomSet_versionversion
{
    my $self = shift;
    my $value = shift;
    
    if (defined($value))
    {
        $value .= " - [ Net::Jabber v$Net::Jabber::VERSION ]";
    }
    else
    {
        $value = "Net::Jabber v$Net::Jabber::VERSION";
    }

    return $value;
}


sub GetResults
{
    my $self = shift;
    my %results;
    foreach my $item ($self->GetItems())
    {
        my %result;
        my @xData = $item->GetX("jabber:x:data");
        if ($#xData == -1) 
        {
            %result = $item->GetItem();
        }
        else
        {
            foreach my $field ($xData[0]->GetFields())
            {
                $result{$field->GetVar()} = $field->GetValue();
            }
        }
        $results{$item->GetJID()} = \%result;
    }
    return %results;
}

1;
