/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockVertical2;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class BodyEnhanced2
extends AbstractTextBlock
implements TextBlock {
    private TextBlock area;
    private final FontConfiguration titleConfig;
    private final Display rawBody;
    private final ISkinSimple spriteContainer;
    private final HorizontalAlignment align;
    private final LineBreakStrategy lineBreakStrategy;
    private final double minClassWidth;

    public BodyEnhanced2(Display rawBody, FontParam fontParam, ISkinSimple spriteContainer, HorizontalAlignment align, FontConfiguration titleConfig, LineBreakStrategy lineBreakStrategy, double minClassWidth) {
        this.rawBody = rawBody;
        this.lineBreakStrategy = lineBreakStrategy;
        this.spriteContainer = spriteContainer;
        this.minClassWidth = minClassWidth;
        this.titleConfig = titleConfig;
        this.align = align;
    }

    private TextBlock decorate(StringBounder stringBounder, TextBlock b, char separator, TextBlock title) {
        if (separator == '\u0000') {
            return b;
        }
        if (title == null) {
            return new TextBlockLineBefore(TextBlockUtils.withMargin(b, 0.0, 4.0), separator);
        }
        Dimension2D dimTitle = title.calculateDimension(stringBounder);
        TextBlockLineBefore raw = new TextBlockLineBefore(TextBlockUtils.withMargin(b, 0.0, 6.0, dimTitle.getHeight() / 2.0, 4.0), separator, title);
        return TextBlockUtils.withMargin(raw, 0.0, 0.0, dimTitle.getHeight() / 2.0, 0.0);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getArea(stringBounder).calculateDimension(stringBounder);
    }

    private TextBlock getArea(StringBounder stringBounder) {
        if (this.area != null) {
            return this.area;
        }
        ArrayList<TextBlock> blocks = new ArrayList<TextBlock>();
        char separator = '\u0000';
        TextBlock title = null;
        Display display = Display.empty();
        for (CharSequence s : this.rawBody) {
            if (BodyEnhanced2.isBlockSeparator(s.toString())) {
                blocks.add(this.decorate(stringBounder, this.getTextBlock(display, stringBounder), separator, title));
                separator = s.charAt(0);
                title = this.getTitle(s.toString(), this.spriteContainer);
                display = Display.empty();
                continue;
            }
            if (s instanceof String) {
                s = Guillemet.GUILLEMET.manageGuillemet(s.toString());
            }
            display = display.add(s);
        }
        blocks.add(this.decorate(stringBounder, this.getTextBlock(display, stringBounder), separator, title));
        this.area = blocks.size() == 1 ? (TextBlock)blocks.get(0) : new TextBlockVertical2(blocks, this.align);
        if (this.minClassWidth > 0.0) {
            this.area = TextBlockUtils.withMinWidth(this.area, this.minClassWidth, this.align);
        }
        return this.area;
    }

    private TextBlock getTextBlock(Display display, StringBounder stringBounder) {
        TextBlock result = display.create9(this.titleConfig, this.align, this.spriteContainer, this.lineBreakStrategy);
        return result;
    }

    public static boolean isBlockSeparator(String s) {
        if (s.startsWith("--") && s.endsWith("--")) {
            return true;
        }
        if (s.startsWith("==") && s.endsWith("==")) {
            return true;
        }
        if (s.startsWith("..") && s.endsWith("..")) {
            return true;
        }
        return s.startsWith("__") && s.endsWith("__");
    }

    private TextBlock getTitle(String s, ISkinSimple spriteContainer) {
        if (s.length() <= 4) {
            return null;
        }
        s = StringUtils.trin(s.substring(2, s.length() - 2));
        return Display.getWithNewlines(s).create(this.titleConfig, HorizontalAlignment.LEFT, spriteContainer);
    }

    @Override
    public void drawU(UGraphic ug) {
        this.getArea(ug.getStringBounder()).drawU(ug);
    }
}

