/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.json.Json;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.ImportedFiles;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineList;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.StartDiagramExtractReader;
import net.sourceforge.plantuml.preproc.Sub;
import net.sourceforge.plantuml.preproc.UncommentReadLine;
import net.sourceforge.plantuml.preproc2.PreprocessorIncludeStrategy;
import net.sourceforge.plantuml.preproc2.PreprocessorUtils;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.tim.EaterAffectationDefine;
import net.sourceforge.plantuml.tim.EaterAssert;
import net.sourceforge.plantuml.tim.EaterDumpMemory;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterExceptionLocated;
import net.sourceforge.plantuml.tim.EaterFunctionCall;
import net.sourceforge.plantuml.tim.EaterImport;
import net.sourceforge.plantuml.tim.EaterInclude;
import net.sourceforge.plantuml.tim.EaterIncludeDef;
import net.sourceforge.plantuml.tim.EaterIncludesub;
import net.sourceforge.plantuml.tim.EaterLog;
import net.sourceforge.plantuml.tim.EaterReturn;
import net.sourceforge.plantuml.tim.EaterUndef;
import net.sourceforge.plantuml.tim.FunctionsSet;
import net.sourceforge.plantuml.tim.TFunction;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TFunctionType;
import net.sourceforge.plantuml.tim.TLineType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.VariableManager;
import net.sourceforge.plantuml.tim.expression.Knowledge;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.iterator.CodeIterator;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorAffectation;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorForeach;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorIf;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorImpl;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorInnerComment;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorLegacyDefine;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorLongComment;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorProcedure;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorReturnFunction;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorShortComment;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorSub;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorWhile;
import net.sourceforge.plantuml.tim.stdlib.AlwaysFalse;
import net.sourceforge.plantuml.tim.stdlib.AlwaysTrue;
import net.sourceforge.plantuml.tim.stdlib.CallUserFunction;
import net.sourceforge.plantuml.tim.stdlib.DateFunction;
import net.sourceforge.plantuml.tim.stdlib.Dirpath;
import net.sourceforge.plantuml.tim.stdlib.FileExists;
import net.sourceforge.plantuml.tim.stdlib.Filename;
import net.sourceforge.plantuml.tim.stdlib.FunctionExists;
import net.sourceforge.plantuml.tim.stdlib.GetVariableValue;
import net.sourceforge.plantuml.tim.stdlib.GetVersion;
import net.sourceforge.plantuml.tim.stdlib.Getenv;
import net.sourceforge.plantuml.tim.stdlib.IntVal;
import net.sourceforge.plantuml.tim.stdlib.InvokeProcedure;
import net.sourceforge.plantuml.tim.stdlib.LogicalNot;
import net.sourceforge.plantuml.tim.stdlib.Lower;
import net.sourceforge.plantuml.tim.stdlib.RetrieveProcedure;
import net.sourceforge.plantuml.tim.stdlib.SetVariableValue;
import net.sourceforge.plantuml.tim.stdlib.StringFunction;
import net.sourceforge.plantuml.tim.stdlib.Strlen;
import net.sourceforge.plantuml.tim.stdlib.Strpos;
import net.sourceforge.plantuml.tim.stdlib.Substr;
import net.sourceforge.plantuml.tim.stdlib.Upper;
import net.sourceforge.plantuml.tim.stdlib.VariableExists;

public class TContext {
    private final List<StringLocated> resultList = new ArrayList<StringLocated>();
    private final List<StringLocated> debug = new ArrayList<StringLocated>();
    public final FunctionsSet functionsSet = new FunctionsSet();
    private ImportedFiles importedFiles;
    private final String charset;
    private final Map<String, Sub> subs = new HashMap<String, Sub>();
    private final DefinitionsContainer definitionsContainer;
    private final Set<FileWithSuffix> filesUsedCurrent = new HashSet<FileWithSuffix>();
    private String pendingAdd = null;

    public Set<FileWithSuffix> getFilesUsedCurrent() {
        return Collections.unmodifiableSet(this.filesUsedCurrent);
    }

    private void addStandardFunctions(Defines defines) {
        this.functionsSet.addFunction(new Strlen());
        this.functionsSet.addFunction(new Substr());
        this.functionsSet.addFunction(new FileExists());
        this.functionsSet.addFunction(new Getenv());
        this.functionsSet.addFunction(new Dirpath(defines));
        this.functionsSet.addFunction(new Filename(defines));
        this.functionsSet.addFunction(new DateFunction());
        this.functionsSet.addFunction(new Strpos());
        this.functionsSet.addFunction(new InvokeProcedure());
        this.functionsSet.addFunction(new AlwaysFalse());
        this.functionsSet.addFunction(new AlwaysTrue());
        this.functionsSet.addFunction(new LogicalNot());
        this.functionsSet.addFunction(new FunctionExists());
        this.functionsSet.addFunction(new VariableExists());
        this.functionsSet.addFunction(new CallUserFunction());
        this.functionsSet.addFunction(new RetrieveProcedure());
        this.functionsSet.addFunction(new SetVariableValue());
        this.functionsSet.addFunction(new GetVariableValue());
        this.functionsSet.addFunction(new IntVal());
        this.functionsSet.addFunction(new GetVersion());
        this.functionsSet.addFunction(new Upper());
        this.functionsSet.addFunction(new Lower());
        this.functionsSet.addFunction(new StringFunction());
    }

    public TContext(ImportedFiles importedFiles, Defines defines, String charset, DefinitionsContainer definitionsContainer) {
        this.definitionsContainer = definitionsContainer;
        this.importedFiles = importedFiles;
        this.charset = charset;
        this.addStandardFunctions(defines);
    }

    public Knowledge asKnowledge(final TMemory memory, final LineLocation location) {
        return new Knowledge(){

            @Override
            public TValue getVariable(String name) throws EaterException, EaterExceptionLocated {
                if (name.contains(".") || name.contains("[")) {
                    TValue result = TContext.this.fromJson(memory, name, location);
                    return result;
                }
                return memory.getVariable(name);
            }

            @Override
            public TFunction getFunction(TFunctionSignature name) {
                return TContext.this.functionsSet.getFunctionSmart(name);
            }
        };
    }

    private TValue fromJson(TMemory memory, String name, LineLocation location) throws EaterException, EaterExceptionLocated {
        String result = this.applyFunctionsAndVariables(memory, location, name);
        try {
            JsonValue json = Json.parse(result);
            return TValue.fromJson(json);
        }
        catch (Exception e) {
            return TValue.fromString(result);
        }
    }

    private TValue fromJsonOld(TMemory memory, String name) {
        int x = name.indexOf(46);
        TValue data = memory.getVariable(name.substring(0, x));
        if (data == null) {
            return null;
        }
        JsonObject json = (JsonObject)data.toJson();
        JsonValue result = json.get(name.substring(x + 1));
        return TValue.fromJson(result);
    }

    private CodeIterator buildCodeIterator(TMemory memory, List<StringLocated> body) {
        CodeIteratorAffectation it110;
        CodeIteratorImpl it10 = new CodeIteratorImpl(body);
        CodeIteratorLongComment it20 = new CodeIteratorLongComment(it10, this.debug);
        CodeIteratorShortComment it30 = new CodeIteratorShortComment(it20, this.debug);
        CodeIteratorInnerComment it40 = new CodeIteratorInnerComment(it30);
        CodeIteratorSub it50 = new CodeIteratorSub(it40, this.subs, this, memory);
        CodeIteratorReturnFunction it60 = new CodeIteratorReturnFunction(it50, this, memory, this.functionsSet, this.debug);
        CodeIteratorProcedure it61 = new CodeIteratorProcedure(it60, this, memory, this.functionsSet, this.debug);
        CodeIteratorIf it70 = new CodeIteratorIf(it61, this, memory, this.debug);
        CodeIteratorLegacyDefine it80 = new CodeIteratorLegacyDefine(it70, this, memory, this.functionsSet, this.debug);
        CodeIteratorWhile it90 = new CodeIteratorWhile(it80, this, memory, this.debug);
        CodeIteratorForeach it100 = new CodeIteratorForeach(it90, this, memory, this.debug);
        CodeIteratorAffectation it = it110 = new CodeIteratorAffectation(it100, this, memory, this.debug);
        return it;
    }

    public TValue executeLines(TMemory memory, List<StringLocated> body, TFunctionType ftype, boolean modeSpecial) throws EaterExceptionLocated {
        CodeIterator it = this.buildCodeIterator(memory, body);
        StringLocated s = null;
        try {
            while ((s = it.peek()) != null) {
                TValue result = this.executeOneLineSafe(memory, s, ftype, modeSpecial);
                if (result != null) {
                    return result;
                }
                it.next();
            }
            return null;
        }
        catch (EaterException e) {
            throw e.withLocation(s);
        }
    }

    private void executeLinesInternal(TMemory memory, List<StringLocated> body, TFunctionType ftype) throws EaterExceptionLocated, EaterException {
        CodeIterator it = this.buildCodeIterator(memory, body);
        StringLocated s = null;
        while ((s = it.peek()) != null) {
            this.executeOneLineSafe(memory, s, ftype, false);
            it.next();
        }
    }

    private TValue executeOneLineSafe(TMemory memory, StringLocated s, TFunctionType ftype, boolean modeSpecial) throws EaterException, EaterExceptionLocated {
        try {
            this.debug.add(s);
            return this.executeOneLineNotSafe(memory, s, ftype, modeSpecial);
        }
        catch (Exception e) {
            if (e instanceof EaterException) {
                throw (EaterException)e;
            }
            if (e instanceof EaterExceptionLocated) {
                throw (EaterExceptionLocated)e;
            }
            e.printStackTrace();
            throw EaterException.located("Fatal parsing error");
        }
    }

    private TValue executeOneLineNotSafe(TMemory memory, StringLocated s, TFunctionType ftype, boolean modeSpecial) throws EaterException, EaterExceptionLocated {
        TLineType type = s.getType();
        if (type == TLineType.INCLUDESUB) {
            this.executeIncludesub(memory, s);
            return null;
        }
        if (type == TLineType.INCLUDE) {
            this.executeInclude(memory, s);
            return null;
        }
        if (type == TLineType.INCLUDE_DEF) {
            this.executeIncludeDef(memory, s);
            return null;
        }
        if (type == TLineType.IMPORT) {
            this.executeImport(memory, s);
            return null;
        }
        if (type == TLineType.DUMP_MEMORY) {
            this.executeDumpMemory(memory, s.getTrimmed());
            return null;
        }
        if (type == TLineType.ASSERT) {
            this.executeAssert(memory, s.getTrimmed());
            return null;
        }
        if (type == TLineType.UNDEF) {
            this.executeUndef(memory, s);
            return null;
        }
        if (ftype != TFunctionType.RETURN_FUNCTION && type == TLineType.PLAIN) {
            this.addPlain(memory, s);
            return null;
        }
        if (ftype == TFunctionType.RETURN_FUNCTION && type == TLineType.RETURN) {
            if (modeSpecial) {
                EaterReturn eaterReturn = new EaterReturn(s);
                eaterReturn.analyze(this, memory);
                TValue result = eaterReturn.getValue2();
                return result;
            }
            return null;
        }
        if (ftype == TFunctionType.RETURN_FUNCTION && type == TLineType.PLAIN) {
            this.simulatePlain(memory, s);
            return null;
        }
        if (type == TLineType.AFFECTATION_DEFINE) {
            this.executeAffectationDefine(memory, s);
            return null;
        }
        if (ftype == null && type == TLineType.END_FUNCTION) {
            CommandExecutionResult.error("error endfunc");
            return null;
        }
        if (type == TLineType.LOG) {
            this.executeLog(memory, s);
            return null;
        }
        if (s.getString().matches("^\\s+$")) {
            return null;
        }
        throw EaterException.located("Compile Error " + (Object)((Object)ftype) + " " + (Object)((Object)type));
    }

    private void addPlain(TMemory memory, StringLocated s) throws EaterException, EaterExceptionLocated {
        StringLocated tmp = this.applyFunctionsAndVariablesInternal(memory, s);
        if (tmp != null) {
            if (this.pendingAdd != null) {
                tmp = new StringLocated(this.pendingAdd + tmp.getString(), tmp.getLocation());
                this.pendingAdd = null;
            }
            this.resultList.add(tmp);
        }
    }

    private void simulatePlain(TMemory memory, StringLocated s) throws EaterException, EaterExceptionLocated {
        StringLocated ignored = this.applyFunctionsAndVariablesInternal(memory, s);
    }

    private void executeAffectationDefine(TMemory memory, StringLocated s) throws EaterException, EaterExceptionLocated {
        new EaterAffectationDefine(s).analyze(this, memory);
    }

    private void executeDumpMemory(TMemory memory, StringLocated s) throws EaterException {
        EaterDumpMemory condition = new EaterDumpMemory(s);
        condition.analyze(this, memory);
    }

    private void executeAssert(TMemory memory, StringLocated s) throws EaterException, EaterExceptionLocated {
        EaterAssert condition = new EaterAssert(s);
        condition.analyze(this, memory);
    }

    private void executeUndef(TMemory memory, StringLocated s) throws EaterException {
        EaterUndef undef = new EaterUndef(s);
        undef.analyze(this, memory);
    }

    private StringLocated applyFunctionsAndVariablesInternal(TMemory memory, StringLocated located) throws EaterException, EaterExceptionLocated {
        if (memory.isEmpty() && this.functionsSet.size() == 0) {
            return located;
        }
        String result = this.applyFunctionsAndVariables(memory, located.getLocation(), located.getString());
        if (result == null) {
            return null;
        }
        return new StringLocated(result, located.getLocation());
    }

    public String applyFunctionsAndVariables(TMemory memory, LineLocation location, String str) throws EaterException, EaterExceptionLocated {
        if (memory.isEmpty() && this.functionsSet.size() == 0) {
            return str;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            String presentFunction = this.getFunctionNameAt(str, i);
            if (presentFunction != null) {
                String sub = str.substring(i);
                EaterFunctionCall call = new EaterFunctionCall(new StringLocated(sub, location), this.isLegacyDefine(presentFunction), this.isUnquoted(presentFunction));
                call.analyze(this, memory);
                TFunctionSignature signature = new TFunctionSignature(presentFunction, call.getValues().size(), call.getNamedArguments().keySet());
                TFunction function = this.functionsSet.getFunctionSmart(signature);
                if (function == null) {
                    throw EaterException.located("Function not found " + presentFunction);
                }
                if (function.getFunctionType() == TFunctionType.PROCEDURE) {
                    this.pendingAdd = result.toString();
                    this.executeVoid3(location, memory, sub, function);
                    return null;
                }
                if (function.getFunctionType() == TFunctionType.LEGACY_DEFINELONG) {
                    this.pendingAdd = str.substring(0, i);
                    this.executeVoid3(location, memory, sub, function);
                    return null;
                }
                assert (function.getFunctionType() == TFunctionType.RETURN_FUNCTION || function.getFunctionType() == TFunctionType.LEGACY_DEFINE);
                TValue functionReturn = function.executeReturnFunction(this, memory, location, call.getValues(), call.getNamedArguments());
                result.append(functionReturn.toString());
                i += call.getCurrentPosition() - 1;
                continue;
            }
            if (new VariableManager(this, memory, location).getVarnameAt(str, i) != null) {
                i = new VariableManager(this, memory, location).replaceVariables(str, i, result);
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private void executeVoid3(LineLocation location, TMemory memory, String s, TFunction function) throws EaterException, EaterExceptionLocated {
        function.executeProcedure(this, memory, location, s);
    }

    private void executeImport(TMemory memory, StringLocated s) throws EaterException, EaterExceptionLocated {
        EaterImport _import = new EaterImport(s.getTrimmed());
        _import.analyze(this, memory);
        try {
            SFile file = FileSystem.getInstance().getFile(this.applyFunctionsAndVariables(memory, s.getLocation(), _import.getLocation()));
            if (file.exists() && !file.isDirectory()) {
                this.importedFiles.add(file);
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw EaterException.located("Cannot import " + e.getMessage());
        }
        throw EaterException.located("Cannot import");
    }

    private void executeLog(TMemory memory, StringLocated s) throws EaterException, EaterExceptionLocated {
        EaterLog log = new EaterLog(s.getTrimmed());
        log.analyze(this, memory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeIncludesub(TMemory memory, StringLocated s) throws EaterException, EaterExceptionLocated {
        ImportedFiles saveImportedFiles = null;
        try {
            EaterIncludesub include = new EaterIncludesub(s.getTrimmed());
            include.analyze(this, memory);
            String location = include.getLocation();
            int idx = location.indexOf(33);
            Sub sub = null;
            if (idx != -1) {
                String filename = location.substring(0, idx);
                String blocname = location.substring(idx + 1);
                try {
                    FileWithSuffix f2 = this.importedFiles.getFile(filename, null);
                    if (f2.fileOk()) {
                        saveImportedFiles = this.importedFiles;
                        this.importedFiles = this.importedFiles.withCurrentDir(f2.getParentFile());
                        Reader reader = f2.getReader(this.charset);
                        if (reader == null) {
                            throw EaterException.located("cannot include " + location);
                        }
                        ReadLine readerline = ReadLineReader.create(reader, location, s.getLocation());
                        readerline = new UncommentReadLine(readerline);
                        sub = Sub.fromFile(readerline, blocname, this, memory);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw EaterException.located("cannot include " + location);
                }
            }
            if (sub == null) {
                sub = this.subs.get(location);
            }
            if (sub == null) {
                throw EaterException.located("cannot include " + location);
            }
            this.executeLinesInternal(memory, sub.lines(), null);
        }
        finally {
            if (saveImportedFiles != null) {
                this.importedFiles = saveImportedFiles;
            }
        }
    }

    private void executeIncludeDef(TMemory memory, StringLocated s) throws EaterException, EaterExceptionLocated {
        EaterIncludeDef include = new EaterIncludeDef(s.getTrimmed());
        include.analyze(this, memory);
        String definitionName = include.getLocation();
        List<String> definition = this.definitionsContainer.getDefinition(definitionName);
        ReadLineList reader2 = new ReadLineList(definition, s.getLocation());
        try {
            ArrayList<StringLocated> body = new ArrayList<StringLocated>();
            while (true) {
                StringLocated sl;
                if ((sl = reader2.readLine()) == null) {
                    this.executeLinesInternal(memory, body, null);
                    return;
                }
                body.add(sl);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw EaterException.located("" + e);
        }
    }

    private void executeInclude(TMemory memory, StringLocated s) throws EaterException, EaterExceptionLocated {
        EaterInclude include = new EaterInclude(s.getTrimmed());
        include.analyze(this, memory);
        String location = include.getLocation();
        PreprocessorIncludeStrategy strategy = include.getPreprocessorIncludeStrategy();
        int idx = location.lastIndexOf(33);
        String suf = null;
        if (idx != -1) {
            suf = location.substring(idx + 1);
            location = location.substring(0, idx);
        }
        ReadLine reader2 = null;
        ImportedFiles saveImportedFiles = null;
        try {
            if (location.startsWith("http://") || location.startsWith("https://")) {
                SURL url = SURL.create(location);
                if (url == null) {
                    throw EaterException.located("Cannot open URL");
                }
                reader2 = PreprocessorUtils.getReaderIncludeUrl2(url, s, suf, this.charset);
            }
            if (location.startsWith("<") && location.endsWith(">")) {
                reader2 = PreprocessorUtils.getReaderStdlibInclude(s, location.substring(1, location.length() - 1));
            } else {
                FileWithSuffix f2 = this.importedFiles.getFile(location, suf);
                if (f2.fileOk()) {
                    if (strategy == PreprocessorIncludeStrategy.DEFAULT && this.filesUsedCurrent.contains(f2)) {
                        return;
                    }
                    if (strategy == PreprocessorIncludeStrategy.ONCE && this.filesUsedCurrent.contains(f2)) {
                        throw EaterException.located("This file has already been included");
                    }
                    if (StartDiagramExtractReader.containsStartDiagram(f2, s, this.charset)) {
                        reader2 = StartDiagramExtractReader.build(f2, s, this.charset);
                    } else {
                        Reader reader = f2.getReader(this.charset);
                        if (reader == null) {
                            throw EaterException.located("Cannot include file");
                        }
                        reader2 = ReadLineReader.create(reader, location, s.getLocation());
                    }
                    saveImportedFiles = this.importedFiles;
                    this.importedFiles = this.importedFiles.withCurrentDir(f2.getParentFile());
                    assert (reader2 != null);
                    this.filesUsedCurrent.add(f2);
                }
            }
            if (reader2 != null) {
                try {
                    ArrayList<StringLocated> body = new ArrayList<StringLocated>();
                    while (true) {
                        StringLocated sl;
                        if ((sl = reader2.readLine()) == null) {
                            this.executeLines(memory, body, null, false);
                            return;
                        }
                        body.add(sl);
                    }
                }
                finally {
                    if (saveImportedFiles != null) {
                        this.importedFiles = saveImportedFiles;
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw EaterException.located("cannot include " + e);
        }
        throw EaterException.located("cannot include " + location);
    }

    public boolean isLegacyDefine(String functionName) {
        for (Map.Entry<TFunctionSignature, TFunction> ent : this.functionsSet.functions().entrySet()) {
            if (!ent.getKey().getFunctionName().equals(functionName) || !ent.getValue().getFunctionType().isLegacy()) continue;
            return true;
        }
        return false;
    }

    public boolean isUnquoted(String functionName) {
        for (Map.Entry<TFunctionSignature, TFunction> ent : this.functionsSet.functions().entrySet()) {
            if (!ent.getKey().getFunctionName().equals(functionName) || !ent.getValue().isUnquoted()) continue;
            return true;
        }
        return false;
    }

    public boolean doesFunctionExist(String functionName) {
        for (Map.Entry<TFunctionSignature, TFunction> ent : this.functionsSet.functions().entrySet()) {
            if (!ent.getKey().getFunctionName().equals(functionName)) continue;
            return true;
        }
        return false;
    }

    private String getFunctionNameAt(String s, int pos) {
        if (pos > 0 && TLineType.isLetterOrUnderscoreOrDigit(s.charAt(pos - 1)) && !VariableManager.justAfterBackslashN(s, pos)) {
            return null;
        }
        String fname = this.functionsSet.getLonguestMatchStartingIn(s.substring(pos));
        if (fname.length() == 0) {
            return null;
        }
        return fname.substring(0, fname.length() - 1);
    }

    public List<StringLocated> getResultList() {
        return this.resultList;
    }

    public List<StringLocated> getDebug() {
        return this.debug;
    }

    public String extractFromResultList(int n1) {
        StringBuilder sb = new StringBuilder();
        while (this.resultList.size() > n1) {
            sb.append(this.resultList.get(n1).getString());
            this.resultList.remove(n1);
            if (this.resultList.size() <= n1) continue;
            sb.append("\\n");
        }
        return sb.toString();
    }

    public void appendEndOfLine(String endOfLine) {
        if (endOfLine.length() > 0) {
            int idx = this.resultList.size() - 1;
            StringLocated last = this.resultList.get(idx);
            last = last.append(endOfLine);
            this.resultList.set(idx, last);
        }
    }

    public TFunction getFunctionSmart(TFunctionSignature signature) {
        return this.functionsSet.getFunctionSmart(signature);
    }
}

