/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import net.sf.sdedit.util.Predicate;

public class MenuBar
extends JMenuBar {
    private static final long serialVersionUID = 516995753L;
    private Map<String, JMenu> categories = new HashMap<String, JMenu>();
    private Map<String, Action> nameMap = new HashMap<String, Action>();

    public Action getActionByName(String name) {
        return this.nameMap.get(name);
    }

    public static <T extends JMenuItem> T makeMenuItem(String title, Class<T> itemType) {
        return MenuBar.makeMenuItem(title, title, String.class, itemType);
    }

    private static <T extends JMenuItem> T makeMenuItem(String title, Object arg, Class<?> argType, Class<T> itemType) {
        try {
            KeyStroke acc = null;
            if (title.charAt(0) == '[') {
                int r = title.indexOf(93);
                String stroke = title.substring(1, r);
                acc = KeyStroke.getKeyStroke(stroke);
            }
            Constructor<T> constructor = itemType.getConstructor(argType);
            int amp = title.indexOf(38);
            JMenuItem item = (JMenuItem)constructor.newInstance(arg);
            item.setText(MenuBar.getCaption(title));
            if (amp < title.length() - 1) {
                item.setMnemonic(title.charAt(amp + 1));
            }
            if (acc != null) {
                item.setAccelerator(acc);
            }
            return (T)item;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot make menu item", e);
        }
    }

    private static String getCaption(String caption) {
        String _caption = caption;
        if (caption.charAt(0) == '[') {
            int r = caption.indexOf(93);
            _caption = caption.substring(r + 1);
        }
        String c = "";
        int amp = _caption.indexOf(38);
        if (amp > 0) {
            c = _caption.substring(0, amp);
        }
        if (amp < _caption.length() - 1) {
            c = c + _caption.substring(amp + 1);
        }
        return c;
    }

    public void removeAction(String category, Action action) {
        JMenu categoryMenu = this.categories.get(MenuBar.getCaption(category));
        if (categoryMenu == null) {
            return;
        }
        for (int i = 0; i < categoryMenu.getItemCount(); ++i) {
            JMenuItem item = categoryMenu.getItem(i);
            if (item.getAction() != action) continue;
            categoryMenu.remove(i);
            return;
        }
    }

    public JMenuItem addAction(String category, Action action, int pos) {
        JMenu categoryMenu = this.categories.get(MenuBar.getCaption(category));
        if (categoryMenu == null) {
            int dot = category.lastIndexOf(46);
            if (dot == -1) {
                categoryMenu = MenuBar.makeMenuItem(category, JMenu.class);
                this.add(categoryMenu);
                this.categories.put(MenuBar.getCaption(category), categoryMenu);
            } else {
                String subCategory = category.substring(dot + 1);
                String supCategory = category.substring(0, dot);
                JMenu supMenu = this.categories.get(MenuBar.getCaption(supCategory));
                if (supMenu == null) {
                    throw new IllegalArgumentException("menu for category " + supCategory + " must exist before a subcategory " + subCategory + " can be added");
                }
                categoryMenu = MenuBar.makeMenuItem(subCategory, JMenu.class);
                supMenu.add(categoryMenu);
                this.categories.put(MenuBar.getCaption(category), categoryMenu);
            }
        }
        JMenuItem item = null;
        if (action != null) {
            this.nameMap.put((String)action.getValue("Name"), action);
            item = MenuBar.makeMenuItem((String)action.getValue("Name"), action, Action.class, JMenuItem.class);
            if (pos == -1) {
                categoryMenu.add(item);
            } else {
                categoryMenu.insert(item, pos);
            }
        }
        return item;
    }

    public void addMenu(String category, ImageIcon icon) {
        JMenu categoryMenu;
        int dot = category.lastIndexOf(46);
        if (dot == -1) {
            categoryMenu = MenuBar.makeMenuItem(category, JMenu.class);
            if (icon != null) {
                categoryMenu.setIcon(icon);
            }
            this.add(categoryMenu);
            this.categories.put(MenuBar.getCaption(category), categoryMenu);
        } else {
            String subCategory = category.substring(dot + 1);
            String supCategory = category.substring(0, dot);
            JMenu supMenu = this.categories.get(MenuBar.getCaption(supCategory));
            if (supMenu == null) {
                throw new IllegalArgumentException("menu for category " + supCategory + " must exist before a subcategory " + subCategory + " can be added");
            }
            categoryMenu = MenuBar.makeMenuItem(subCategory, JMenu.class);
            supMenu.add(categoryMenu);
            this.categories.put(MenuBar.getCaption(category), categoryMenu);
        }
        if (icon != null) {
            categoryMenu.setIcon(icon);
        }
    }

    public JMenuItem addAction(String category, Action action) {
        return this.addAction(category, action, -1);
    }

    public void addItem(String category, JMenuItem item) {
        JMenu categoryMenu = this.categories.get(MenuBar.getCaption(category));
        categoryMenu.add(item);
    }

    public void addToggleAction(String category, String name, String description, String tooltip, Icon icon, final Predicate predicate, boolean initialValue) {
        final JCheckBoxMenuItem checkBox = MenuBar.makeMenuItem(name, JCheckBoxMenuItem.class);
        checkBox.setIcon(icon);
        checkBox.setText(description);
        checkBox.setToolTipText(tooltip);
        checkBox.setSelected(initialValue);
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                predicate.set(checkBox.isSelected());
            }
        });
        this.addItem(category, checkBox);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.categories != null) {
            for (JMenu menu : this.categories.values()) {
                menu.updateUI();
                for (int i = 0; i < menu.getItemCount(); ++i) {
                    menu.getItem(i).updateUI();
                }
            }
        }
    }
}

