/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.gls2bib;

import com.dickimawbooks.gls2bib.Gls2BibException;
import com.dickimawbooks.gls2bib.Gls2BibMessages;
import com.dickimawbooks.gls2bib.Gls2BibSyntaxException;
import com.dickimawbooks.gls2bib.GlsAddKey;
import com.dickimawbooks.gls2bib.GlsData;
import com.dickimawbooks.gls2bib.GlsExpandFields;
import com.dickimawbooks.gls2bib.GlsSee;
import com.dickimawbooks.gls2bib.GlsSetExpandField;
import com.dickimawbooks.gls2bib.LongNewGlossaryEntry;
import com.dickimawbooks.gls2bib.NewAbbreviation;
import com.dickimawbooks.gls2bib.NewDualEntry;
import com.dickimawbooks.gls2bib.NewGlossary;
import com.dickimawbooks.gls2bib.NewGlossaryEntry;
import com.dickimawbooks.gls2bib.NewNumber;
import com.dickimawbooks.gls2bib.NewSymbol;
import com.dickimawbooks.gls2bib.NewTerm;
import com.dickimawbooks.gls2bib.OldAcronym;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.latex.AtGobble;
import com.dickimawbooks.texparserlib.latex.GobbleOpt;
import com.dickimawbooks.texparserlib.latex.GobbleOptMandOpt;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.NewCommand;
import com.dickimawbooks.texparserlib.primitives.Relax;
import com.dickimawbooks.texparserlib.primitives.Undefined;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class Gls2Bib
extends LaTeXParserListener
implements Writeable,
TeXApp {
    public static final String VERSION = "2.5";
    public static final String DATE = "2020-05-30";
    public static final String APP_NAME = "convertgls2bib";
    private Vector<GlsData> data;
    private File texFile;
    private File bibFile;
    private Charset charset = null;
    private String bibCharsetName = null;
    private String spaceSub = null;
    private boolean ignoreSortField = true;
    private boolean ignoreTypeField = false;
    private boolean splitOnType = false;
    private boolean ignoreCategoryField = false;
    private boolean splitOnCategory = false;
    private boolean overwriteFiles = true;
    private boolean preambleOnly = false;
    private boolean noDescEntryToIndex = false;
    private boolean absorbSee = true;
    private String[] customIgnoreFields;
    private Gls2BibMessages messages;
    public static final int SILENT = 0;
    public static final int NORMAL = 1;
    public static final int DEBUG = 2;
    private int verboseLevel = 1;
    private boolean expandFields = false;
    private HashMap<String, Boolean> expandFieldMap;
    private HashMap<String, String> keyToFieldMap;
    private TeXParser texParser;
    public static final String[] KNOWN_FIELDS = new String[]{"name", "text", "plural", "first", "firstplural", "symbol", "desc", "useri", "userii", "useriii", "useriv", "userv", "uservi"};
    public static final String[] ABBR_FIELDS = new String[]{"short", "shortpl", "long", "longpl", "full", "fullpl"};

    public Gls2Bib(String[] stringArray, String string, int n) throws Gls2BibException, IOException {
        super(null);
        this.verboseLevel = n;
        this.initMessages(string);
        this.parseArgs(stringArray);
        this.initKeyToFieldMap();
        this.setWriteable(this);
        this.texParser = new TeXParser(this);
    }

    public Gls2Bib(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, int n, boolean bl2, boolean bl3) throws Gls2BibException, IOException {
        super(null);
        this.verboseLevel = n;
        this.ignoreSortField = bl;
        this.ignoreTypeField = bl2;
        this.ignoreCategoryField = bl3;
        this.initMessages(string6);
        this.texFile = new File(string);
        this.bibFile = new File(string2);
        this.bibCharsetName = string4;
        this.spaceSub = string5;
        if (" ".equals(string5)) {
            this.spaceSub = null;
        }
        this.charset = string3 == null ? Charset.defaultCharset() : Charset.forName(string3);
        if (this.bibCharsetName == null) {
            this.bibCharsetName = this.charset.name();
        }
        this.initKeyToFieldMap();
        this.setWriteable(this);
        this.texParser = new TeXParser(this);
    }

    private void initKeyToFieldMap() {
        this.keyToFieldMap = new HashMap();
        this.keyToFieldMap.put("sortvalue", "sort");
        this.keyToFieldMap.put("firstpl", "firstplural");
        this.keyToFieldMap.put("desc", "description");
        this.keyToFieldMap.put("descplural", "descriptionplural");
        this.keyToFieldMap.put("useri", "user1");
        this.keyToFieldMap.put("userii", "user2");
        this.keyToFieldMap.put("useriii", "user3");
        this.keyToFieldMap.put("useriv", "user4");
        this.keyToFieldMap.put("userv", "user5");
        this.keyToFieldMap.put("uservi", "user6");
        this.keyToFieldMap.put("longpl", "longplural");
        this.keyToFieldMap.put("shortpl", "shortplural");
    }

    @Override
    public TeXApp getTeXApp() {
        return this;
    }

    public boolean isAbsorbSeeOn() {
        return this.absorbSee;
    }

    public boolean isIndexConversionOn() {
        return this.noDescEntryToIndex;
    }

    public boolean isCustomIgnoreField(String string) {
        if (this.customIgnoreFields == null) {
            return false;
        }
        for (String string2 : this.customIgnoreFields) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean ignoreSort() {
        return this.ignoreSortField;
    }

    public boolean ignoreType() {
        return this.ignoreTypeField;
    }

    public boolean isSplitTypeOn() {
        return this.splitOnType;
    }

    public boolean ignoreCategory() {
        return this.ignoreCategoryField;
    }

    public boolean isSplitCategoryOn() {
        return this.splitOnCategory;
    }

    public String getSpaceSub() {
        return this.spaceSub;
    }

    public void debug(String string) {
        if (this.verboseLevel >= 2) {
            System.out.println(string);
        }
    }

    public void debug(Throwable throwable) {
        if (this.verboseLevel >= 2) {
            throwable.printStackTrace();
        }
    }

    @Override
    protected void addPredefined() {
        super.addPredefined();
        this.parser.putControlSequence(new NewCommand("renewcommand", 3));
        this.parser.putControlSequence(new GenericCommand("glslongkey", null, this.createString("long")));
        this.parser.putControlSequence(new GenericCommand("glslongpluralkey", null, this.createString("longplural")));
        this.parser.putControlSequence(new GenericCommand("glsshortkey", null, this.createString("short")));
        this.parser.putControlSequence(new GenericCommand("glsshortpluralkey", null, this.createString("shortplural")));
        this.parser.putControlSequence(new NewGlossaryEntry(this));
        this.parser.putControlSequence(new NewGlossaryEntry("newentry", this));
        this.parser.putControlSequence(new NewGlossaryEntry("provideglossaryentry", this, true));
        this.parser.putControlSequence(new LongNewGlossaryEntry(this));
        this.parser.putControlSequence(new LongNewGlossaryEntry("longprovideglossaryentry", this, true));
        this.parser.putControlSequence(new NewAbbreviation(this));
        this.parser.putControlSequence(new NewAbbreviation("newacronym", "acronym", this));
        this.parser.putControlSequence(new OldAcronym(this));
        this.parser.putControlSequence(new NewTerm(this));
        this.parser.putControlSequence(new NewNumber(this));
        this.parser.putControlSequence(new NewNumber("newnum", this));
        this.parser.putControlSequence(new NewSymbol(this));
        this.parser.putControlSequence(new NewSymbol("newsym", this));
        this.parser.putControlSequence(new NewDualEntry(this));
        this.parser.putControlSequence(new GlsExpandFields(this));
        this.parser.putControlSequence(new GlsExpandFields("glsnoexpandfields", false, this));
        this.parser.putControlSequence(new GlsSetExpandField(this));
        this.parser.putControlSequence(new GlsSetExpandField("glssetnoexpandfield", false, this));
        this.parser.putControlSequence(new AtGobble("setupglossaries"));
        this.parser.putControlSequence(new AtGobble("glossariesextrasetup"));
        this.parser.putControlSequence(new GobbleOpt("makeglossaries"));
        this.parser.putControlSequence(new Relax("makenoidxglossaries"));
        this.parser.putControlSequence(new GobbleOpt("GlsXtrLoadResources"));
        this.parser.putControlSequence(new Relax("noist"));
        this.parser.putControlSequence(new NewGlossary());
        this.parser.putControlSequence(new NewGlossary("altnewglossary", 1));
        this.parser.putControlSequence(new NewGlossary("newignoredglossary", 2));
        this.parser.putControlSequence(new NewGlossary("provideignoredglossary", 2));
        this.parser.putControlSequence(new GobbleOpt("GlsSetXdyLanguage", 1, 1, new int[0]));
        this.parser.putControlSequence(new AtGobble("GlsSetXdyCodePage"));
        this.parser.putControlSequence(new AtGobble("GlsAddXdyCounters"));
        this.parser.putControlSequence(new AtGobble("GlsAddXdyAttribute"));
        this.parser.putControlSequence(new GobbleOpt("GlsAddXdyLocation", 1, 2, new int[0]));
        this.parser.putControlSequence(new AtGobble("GlsSetXdyLocationClassOrder"));
        this.parser.putControlSequence(new AtGobble("GlsSetXdyMinRangeLength"));
        this.parser.putControlSequence(new AtGobble("GlsSetXdyFirstLetterAfterDigits"));
        this.parser.putControlSequence(new AtGobble("GlsSetXdyNumberGroupOrder"));
        this.parser.putControlSequence(new AtGobble("GlsAddXdyStyle"));
        this.parser.putControlSequence(new GobbleOpt("setabbreviationstyle", 1, 1, new int[0]));
        this.parser.putControlSequence(new AtGobble("setacronymstyle"));
        this.parser.putControlSequence(new AtGobble("glssetcategoryattribute", 3));
        this.parser.putControlSequence(new AtGobble("newabbreviationstyle", 3));
        this.parser.putControlSequence(new AtGobble("newacronymstyle", 3));
        this.parser.putControlSequence(new AtGobble("setlength", 2));
        this.parser.putControlSequence(new AtGobble("pagestyle"));
        this.parser.putControlSequence(new GobbleOpt("glssetwidest", 1, 1, new int[0]));
        this.parser.putControlSequence(new AtGobble("glsdefpostlink", 2));
        this.parser.putControlSequence(new AtGobble("glsdefpostname", 2));
        this.parser.putControlSequence(new AtGobble("glsdefpostdesc", 2));
        this.parser.putControlSequence(new GlsAddKey());
        this.parser.putControlSequence(new GlsAddKey("glsaddstoragekey", true));
        this.parser.putControlSequence(new GlsSee(this));
        this.parser.putControlSequence(new GlsSee(this, "glsxtrindexseealso"));
        this.parser.putControlSequence(new GobbleOpt("glsadd", 1, 1, new int[0]));
        this.parser.putControlSequence(new GobbleOpt("glsaddall", 1, 0, new int[0]));
        if (!this.preambleOnly) {
            this.parser.putControlSequence(new GobbleOptMandOpt("gls"));
            this.parser.putControlSequence(new GobbleOptMandOpt("glspl"));
            this.parser.putControlSequence(new GobbleOptMandOpt("Gls"));
            this.parser.putControlSequence(new GobbleOptMandOpt("Glspl"));
            this.parser.putControlSequence(new GobbleOptMandOpt("GLS"));
            this.parser.putControlSequence(new GobbleOptMandOpt("GLSpl"));
            for (String string : KNOWN_FIELDS) {
                this.parser.putControlSequence(new GobbleOptMandOpt("gls" + string));
                this.parser.putControlSequence(new GobbleOptMandOpt("Gls" + string));
                this.parser.putControlSequence(new GobbleOptMandOpt("GLS" + string));
                this.parser.putControlSequence(new AtGobble("glsentry" + string));
                this.parser.putControlSequence(new AtGobble("Glsentry" + string));
                this.parser.putControlSequence(new GobbleOpt("glsfmt" + string, 1, 1, new int[0]));
                this.parser.putControlSequence(new GobbleOpt("Glsfmt" + string, 1, 1, new int[0]));
                this.parser.putControlSequence(new GobbleOpt("GLSfmt" + string, 1, 1, new int[0]));
            }
            for (String string : ABBR_FIELDS) {
                this.parser.putControlSequence(new AtGobble("glsentry" + string));
                this.parser.putControlSequence(new AtGobble("Glsentry" + string));
                this.parser.putControlSequence(new GobbleOptMandOpt("acr" + string));
                this.parser.putControlSequence(new GobbleOptMandOpt("Acr" + string));
                this.parser.putControlSequence(new GobbleOptMandOpt("ACR" + string));
                this.parser.putControlSequence(new GobbleOptMandOpt("glsxtr" + string));
                this.parser.putControlSequence(new GobbleOptMandOpt("Glsxtr" + string));
                this.parser.putControlSequence(new GobbleOptMandOpt("GLSxtr" + string));
                this.parser.putControlSequence(new GobbleOpt("glsfmt" + string, 1, 1, new int[0]));
                this.parser.putControlSequence(new GobbleOpt("Glsfmt" + string, 1, 1, new int[0]));
                this.parser.putControlSequence(new GobbleOpt("GLSfmt" + string, 1, 1, new int[0]));
            }
            this.parser.putControlSequence(new GobbleOpt("glsdisp", 1, 2, new int[0]));
            this.parser.putControlSequence(new GobbleOpt("glslink", 1, 2, new int[0]));
            this.parser.putControlSequence(new GobbleOptMandOpt("cgls"));
            this.parser.putControlSequence(new GobbleOptMandOpt("cglspl"));
            this.parser.putControlSequence(new GobbleOptMandOpt("cGls"));
            this.parser.putControlSequence(new GobbleOptMandOpt("cGlspl"));
            this.parser.putControlSequence(new GobbleOptMandOpt("cGLS"));
            this.parser.putControlSequence(new GobbleOptMandOpt("cGLSpl"));
            this.parser.putControlSequence(new GobbleOptMandOpt("pgls"));
            this.parser.putControlSequence(new GobbleOptMandOpt("pglspl"));
            this.parser.putControlSequence(new GobbleOptMandOpt("Pgls"));
            this.parser.putControlSequence(new GobbleOptMandOpt("Pglspl"));
            this.parser.putControlSequence(new GobbleOptMandOpt("PGLS"));
            this.parser.putControlSequence(new GobbleOptMandOpt("PGLSpl"));
            this.parser.putControlSequence(new AtGobble("glsentrynumberlist"));
            this.parser.putControlSequence(new AtGobble("glsdisplaynumberlist"));
            this.parser.putControlSequence(new GobbleOpt("chapter", 1, 1, 42));
            this.parser.putControlSequence(new GobbleOpt("printglossary", 1, 0, new int[0]));
            this.parser.putControlSequence(new GobbleOpt("printnoidxglossary", 1, 0, new int[0]));
            this.parser.putControlSequence(new Relax("printglossaries"));
            this.parser.putControlSequence(new Relax("printnoidxglossaries"));
        }
    }

    @Override
    public ControlSequence createUndefinedCs(String string) {
        return new Undefined(string, this.verboseLevel == 0 ? (byte)3 : 1);
    }

    @Override
    public void newcommand(byte by, String string, String string2, boolean bl, int n, TeXObject teXObject, TeXObject teXObject2) throws IOException {
        if (string2.equals("newdualentry") && by == 0) {
            this.message(this.getMessage("gls2bib.override.newdualentry"));
            this.addLaTeXCommand(string2, bl, n, teXObject, teXObject2);
            return;
        }
        super.newcommand(by, string, string2, bl, n, teXObject, teXObject2);
    }

    @Override
    public void beginDocument() throws IOException {
        super.beginDocument();
        if (this.preambleOnly) {
            this.endDocument();
        }
    }

    @Override
    public void write(String string) throws IOException {
    }

    @Override
    public void writeln(String string) throws IOException {
    }

    @Override
    public void write(char c) throws IOException {
    }

    @Override
    public void writeCodePoint(int n) throws IOException {
    }

    @Override
    public void overwithdelims(TeXObject teXObject, TeXObject teXObject2, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
        this.debug("Ignoring \\overwithdelims");
    }

    @Override
    public void abovewithdelims(TeXObject teXObject, TeXObject teXObject2, TeXDimension teXDimension, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
        this.debug("Ignoring \\abovewithdelims");
    }

    @Override
    public void skipping(Ignoreable ignoreable) throws IOException {
    }

    @Override
    public void href(String string, TeXObject teXObject) throws IOException {
        this.debug("Ignoring \\href");
    }

    @Override
    public void subscript(TeXObject teXObject) throws IOException {
        this.debug("Ignoring _");
    }

    @Override
    public void superscript(TeXObject teXObject) throws IOException {
        this.debug("Ignoring ^");
    }

    @Override
    public void includegraphics(KeyValList keyValList, String string) throws IOException {
        this.debug("Ignoring \\includegraphics");
    }

    @Override
    public boolean isWriteAccessAllowed(File file) {
        return file.canWrite();
    }

    @Override
    public boolean isWriteAccessAllowed(TeXPath teXPath) {
        return teXPath.getFile().canWrite();
    }

    @Override
    public boolean isReadAccessAllowed(File file) {
        return file.canRead();
    }

    @Override
    public boolean isReadAccessAllowed(TeXPath teXPath) {
        return teXPath.getFile().canRead();
    }

    @Override
    public void copyFile(File file, File file2) throws IOException, InterruptedException {
        if (this.verboseLevel >= 2) {
            System.err.format("Ignoring unexpected request to copy files %s -> %s%n", file.toString(), file2.toString());
        }
    }

    @Override
    public String requestUserInput(String string) throws IOException {
        if (this.verboseLevel >= 2) {
            System.err.format("Ignoring unexpected request for user input. Message: %s%n", string);
        }
        return "";
    }

    @Override
    public String kpsewhich(String string) {
        return null;
    }

    @Override
    public void epstopdf(File file, File file2) throws IOException, InterruptedException {
        if (this.verboseLevel >= 2) {
            System.err.format("Ignoring unexpected request to convert %s to %s%n", file.toString(), file2.toString());
        }
    }

    @Override
    public void wmftoeps(File file, File file2) throws IOException, InterruptedException {
        if (this.verboseLevel >= 2) {
            System.err.format("Ignoring unexpected request to convert %s to %s%n", file.toString(), file2.toString());
        }
    }

    @Override
    public void progress(int n) {
    }

    @Override
    public void substituting(TeXParser teXParser, String string, String string2) {
        this.debug(this.getMessage("warning.substituting", string, string2));
    }

    @Override
    public void substituting(String string, String string2) {
        this.debug(this.getMessage("warning.substituting", string, string2));
    }

    public String getMessage(String string) {
        if (this.messages == null) {
            return string;
        }
        String string2 = string;
        try {
            string2 = this.messages.getMessage(string, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning(String.format("Error fetching message for label '%s': %s", string, illegalArgumentException.getMessage()), illegalArgumentException);
        }
        return string2;
    }

    public String getMessage(String string, String string2) {
        if (this.messages == null) {
            return String.format("%s[%s]", string, string2);
        }
        String string3 = string;
        try {
            string3 = this.messages.getMessage(string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string3;
    }

    public String getMessage(String string, String[] stringArray) {
        if (this.messages == null) {
            String string2 = stringArray.length == 0 ? "" : stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string2 = string2 + "," + stringArray[0];
            }
            return String.format("%s[%s]", string, string2);
        }
        String string3 = string;
        try {
            string3 = this.messages.getMessage(string, stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string3;
    }

    @Override
    public String getMessage(String string, Object ... objectArray) {
        if (this.messages == null) {
            String string2 = objectArray.length == 0 ? "" : objectArray[0].toString();
            for (int i = 1; i < objectArray.length; ++i) {
                string2 = string2 + "," + objectArray[0].toString();
            }
            return String.format("%s[%s]", string, string2);
        }
        String string3 = string;
        try {
            string3 = this.messages.getMessage(string, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string3;
    }

    public String getMessage(TeXParser teXParser, String string, Object ... objectArray) {
        if (teXParser == null) {
            return this.getMessage(string, objectArray);
        }
        int n = teXParser.getLineNumber();
        File file = teXParser.getCurrentFile();
        if (n == -1 || file == null) {
            return this.getMessage(string, objectArray);
        }
        return Gls2Bib.fileLineMessage(file, n, this.getMessage(string, objectArray));
    }

    public String getMessageWithFallback(String string, String string2, Object ... objectArray) {
        if (this.messages == null) {
            MessageFormat messageFormat = new MessageFormat(string2);
            return MessageFormat.format(string2, objectArray);
        }
        try {
            return this.messages.getMessage(string, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
            MessageFormat messageFormat = new MessageFormat(string2);
            return MessageFormat.format(string2, objectArray);
        }
    }

    public String getChoiceMessage(String string, int n, String string2, int n2, Object ... objectArray) {
        if (this.messages == null) {
            String string3 = objectArray.length == 0 ? "" : objectArray[0].toString();
            for (int i = 1; i < objectArray.length; ++i) {
                string3 = string3 + "," + objectArray[0].toString();
            }
            return String.format("%s[%s]", string, string3);
        }
        String string4 = string;
        try {
            string4 = this.messages.getChoiceMessage(string, n, string2, n2, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string4;
    }

    @Override
    public void message(String string) {
        if (this.verboseLevel != 0) {
            System.out.println(string);
        }
    }

    public static String fileLineMessage(File file, int n, String string) {
        return String.format("%s:%d: %s", file.toString(), n, string);
    }

    @Override
    public void endParse(File file) throws IOException {
    }

    @Override
    public void beginParse(File file, Charset charset) throws IOException {
        this.message(this.getMessage("message.reading", file));
        if (charset == null) {
            this.message(this.getMessage("message.default.charset", Charset.defaultCharset()));
        } else {
            this.message(this.getMessage("message.tex.charset", charset));
        }
    }

    @Override
    public Charset getCharSet() {
        return this.charset;
    }

    @Override
    public void warning(TeXParser teXParser, String string) {
        if (this.verboseLevel != 0) {
            int n = teXParser.getLineNumber();
            File file = teXParser.getCurrentFile();
            if (n == -1 || file == null) {
                this.warning(string);
            } else {
                this.warning(file, n, string);
            }
        }
    }

    public void warning(File file, int n, String string) {
        this.warning(Gls2Bib.fileLineMessage(file, n, string));
    }

    public void warning(File file, int n, String string, Exception exception) {
        this.warning(Gls2Bib.fileLineMessage(file, n, string), exception);
    }

    public void warning(String string) {
        if (this.verboseLevel != 0) {
            string = this.getMessageWithFallback("warning.title", "Warning: {0}", string);
            System.err.println(string);
        }
    }

    public void warning() {
        if (this.verboseLevel != 0) {
            System.err.println();
        }
    }

    public void warning(String string, Exception exception) {
        if (this.verboseLevel >= 1) {
            System.err.println(string);
            if (this.verboseLevel >= 2) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void error(Exception exception) {
        if (exception instanceof TeXSyntaxException) {
            this.error(((TeXSyntaxException)exception).getMessage(this));
        } else {
            String string = exception.getMessage();
            if (string == null) {
                string = exception.getClass().getSimpleName();
            }
            this.error(string);
        }
        if (this.verboseLevel >= 2) {
            exception.printStackTrace();
        }
    }

    public void error(String string) {
        string = this.getMessageWithFallback("error.title", "Error: {0}", string);
        System.err.println(string);
    }

    @Override
    public float emToPt(float f) {
        this.warning(this.getParser(), "Can't convert from em to pt, no font information loaded");
        return 9.5f * f;
    }

    @Override
    public float exToPt(float f) {
        this.warning(this.getParser(), "Can't convert from ex to pt, no font information loaded");
        return 4.4f * f;
    }

    public void addData(GlsData glsData) {
        this.data.add(glsData);
    }

    public boolean hasEntry(String string) {
        for (GlsData glsData : this.data) {
            if (!glsData.getId().equals(string)) continue;
            return true;
        }
        return false;
    }

    public GlsData getEntry(String string) {
        for (GlsData glsData : this.data) {
            if (!glsData.getId().equals(string)) continue;
            return glsData;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws IOException {
        String string;
        this.requirepackage("etoolbox");
        this.data = new Vector();
        this.parser.parse(this.texFile, this.charset);
        PrintWriter printWriter = null;
        HashMap<String, PrintWriter> hashMap = null;
        if (this.splitOnType || this.splitOnCategory) {
            hashMap = new HashMap<String, PrintWriter>();
        }
        try {
            if (this.data.isEmpty()) {
                throw new IOException("No entries found");
            }
            if (!this.overwriteFiles && this.bibFile.exists()) {
                throw new IOException(this.getMessage("error.file_exists.nooverwrite", this.bibFile, "--overwrite"));
            }
            this.message(this.getMessage("message.writing", this.bibFile));
            if (this.bibCharsetName == null) {
                printWriter = new PrintWriter(this.bibFile);
            } else {
                printWriter = new PrintWriter(this.bibFile, this.bibCharsetName);
                printWriter.println("% Encoding: " + this.bibCharsetName);
            }
            for (GlsData object : this.data) {
                if (this.splitOnType || this.splitOnCategory) {
                    String string2;
                    string = this.splitOnType ? object.getGlossaryType() : null;
                    String string3 = string2 = this.splitOnCategory ? object.getCategory() : null;
                    if (string == null && string2 == null) {
                        object.writeBibEntry(printWriter);
                        continue;
                    }
                    String string4 = string == null ? string2 : (string2 == null || string.equals(string2) ? string : String.format("%s-%s", string, string2));
                    PrintWriter printWriter2 = (PrintWriter)hashMap.get(string4);
                    if (printWriter2 == null) {
                        File file = new File(this.bibFile.getParent(), string4 + ".bib");
                        if (!this.overwriteFiles && file.exists()) {
                            throw new IOException(this.getMessage("error.file_exists.nooverwrite", file, "--overwrite"));
                        }
                        this.message(this.getMessage("message.writing", file));
                        if (this.bibCharsetName == null) {
                            printWriter2 = new PrintWriter(file);
                        } else {
                            printWriter2 = new PrintWriter(file, this.bibCharsetName);
                            printWriter2.println("% Encoding: " + this.bibCharsetName);
                        }
                        hashMap.put(string4, printWriter2);
                    }
                    object.writeBibEntry(printWriter2);
                    continue;
                }
                object.writeBibEntry(printWriter);
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (hashMap != null) {
                Set set = hashMap.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    ((PrintWriter)hashMap.get(string)).close();
                }
            }
        }
    }

    private String getLanguageFileName(String string) {
        return String.format("/resources/bib2gls-%s.xml", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMessages(String string) throws Gls2BibException, IOException {
        Object object;
        Locale locale = string == null || "".equals(string) ? Locale.getDefault() : Locale.forLanguageTag(string);
        String string2 = locale.toLanguageTag();
        String string3 = this.getLanguageFileName(string2);
        URL uRL = this.getClass().getResource(string3);
        String string4 = "";
        if (this.verboseLevel >= 2) {
            string4 = this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        }
        if (uRL == null) {
            this.debug(String.format("Can't find language resource: %s!%s", string4, string3));
            string2 = locale.getLanguage();
            string3 = this.getLanguageFileName(string2);
            this.debug("Trying: " + string3);
            uRL = this.getClass().getResource(string3);
            if (uRL == null) {
                this.debug(String.format("Can't find language resource: %s!%s", string4, string3));
                object = locale.getScript();
                if (object != null && !((String)object).isEmpty()) {
                    string3 = this.getLanguageFileName(String.format("%s-%s", string2, object));
                    this.debug("Trying: " + string3);
                    uRL = this.getClass().getResource(string3);
                    if (uRL == null && !string2.equals("en")) {
                        this.debug(String.format("Can't find language resource: %s!%s%nDefaulting to 'en'", string4, string3));
                        uRL = this.getClass().getResource(this.getLanguageFileName("en"));
                    }
                } else if (!string2.equals("en")) {
                    this.debug("Defaulting to 'en'");
                    uRL = this.getClass().getResource(this.getLanguageFileName("en"));
                }
                if (uRL == null) {
                    throw new Gls2BibException("Can't find language resource file.");
                }
            }
        }
        object = null;
        try {
            this.debug("Reading " + uRL);
            object = uRL.openStream();
            Properties properties = new Properties();
            properties.loadFromXML((InputStream)object);
            ((InputStream)object).close();
            object = null;
            this.messages = new Gls2BibMessages(properties);
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
    }

    public void version() {
        System.out.format("%s v%s (%s)%n", APP_NAME, VERSION, DATE);
        System.out.format("Copyright 2017-%s Nicola Talbot%n", DATE.substring(0, 4));
        System.out.print("License GPLv3+: GNU GPL version 3 or later");
        System.out.println(" <http://gnu.org/licenses/gpl.html>");
        System.out.print("This is free software: you are free to change");
        System.out.println(" and redistribute it.");
        System.out.println("There is NO WARRANTY, to the extent permitted by law.");
    }

    public void help() {
        System.out.println(this.getMessage("gls2bib.syntax", APP_NAME));
        System.out.println();
        System.out.println(this.getMessage("gls2bib.syntax.options"));
        System.out.println();
        System.out.println(this.getMessage("gls2bib.syntax.options.general"));
        System.out.println();
        System.out.println(this.getMessage("gls2bib.syntax.version", "--version", "-v"));
        System.out.println(this.getMessage("gls2bib.syntax.help", "--help", "-h"));
        System.out.println(this.getMessage("gls2bib.syntax.silent", "--silent"));
        System.out.println(this.getMessage("gls2bib.syntax.verbose", "--verbose"));
        System.out.println(this.getMessage("gls2bib.syntax.debug", "--debug"));
        System.out.println();
        System.out.println(this.getMessage("gls2bib.syntax.options.locale"));
        System.out.println();
        System.out.println(this.getMessage("gls2bib.syntax.texenc", "--texenc"));
        System.out.println(this.getMessage("gls2bib.syntax.bibenc", "--bibenc"));
        System.out.println(this.getMessage("gls2bib.syntax.locale", "--locale"));
        System.out.println();
        System.out.println(this.getMessage("gls2bib.syntax.options.filter"));
        System.out.println();
        System.out.println(this.getMessage("gls2bib.syntax.ignore-sort", "--ignore-sort"));
        System.out.println(this.getMessage("gls2bib.syntax.no-ignore-sort", "--no-ignore-sort"));
        System.out.println(this.getMessage("gls2bib.syntax.ignore-type", "--ignore-type"));
        System.out.println(this.getMessage("gls2bib.syntax.no-ignore-type", "--no-ignore-type"));
        System.out.println(this.getMessage("gls2bib.syntax.ignore-category", "--ignore-category"));
        System.out.println(this.getMessage("gls2bib.syntax.no-ignore-category", "--no-ignore-category"));
        System.out.println(this.getMessage("gls2bib.syntax.ignore-fields", "--ignore-fields", "-f"));
        System.out.println(this.getMessage("gls2bib.syntax.preamble-only", "--preamble-only", "-p"));
        System.out.println(this.getMessage("gls2bib.syntax.no-preamble-only", "--no-preamble-only"));
        System.out.println();
        System.out.println(this.getMessage("gls2bib.syntax.options.io"));
        System.out.println();
        System.out.println(this.getMessage("gls2bib.syntax.split-on-type", "--split-on-type", "-t"));
        System.out.println(this.getMessage("gls2bib.syntax.no-split-on-type", "--no-split-on-type"));
        System.out.println(this.getMessage("gls2bib.syntax.split-on-category", "--split-on-category", "-c"));
        System.out.println(this.getMessage("gls2bib.syntax.no-split-on-category", "--no-split-on-category"));
        System.out.println(this.getMessage("gls2bib.syntax.overwrite", "--overwrite", "--split-on-type", "--split-on-category"));
        System.out.println(this.getMessage("gls2bib.syntax.no-overwrite", "--no-overwrite"));
        System.out.println();
        System.out.println(this.getMessage("gls2bib.syntax.options.adjust"));
        System.out.println();
        System.out.println(this.getMessage("gls2bib.syntax.space-sub", "--space-sub", "-s"));
        System.out.println(this.getMessage("gls2bib.syntax.index-conversion", "--index-conversion", "-i"));
        System.out.println(this.getMessage("gls2bib.syntax.no-index-conversion", "--no-index-conversion"));
        System.out.println(this.getMessage("gls2bib.syntax.absorb-see", "--absorb-see"));
        System.out.println(this.getMessage("gls2bib.syntax.no-absorb-see", "--no-absorb-see"));
    }

    protected void parseArgs(String[] stringArray) throws Gls2BibSyntaxException {
        this.texFile = null;
        this.bibFile = null;
        this.spaceSub = null;
        this.charset = Charset.defaultCharset();
        this.bibCharsetName = null;
        this.ignoreSortField = true;
        this.ignoreTypeField = false;
        this.splitOnType = false;
        this.ignoreCategoryField = false;
        this.customIgnoreFields = null;
        this.splitOnCategory = false;
        this.overwriteFiles = true;
        this.preambleOnly = false;
        this.noDescEntryToIndex = false;
        this.absorbSee = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--help") || stringArray[i].equals("-h")) {
                this.help();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("--version") || stringArray[i].equals("-v")) {
                this.version();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("--texenc")) {
                if (i == stringArray.length - 1) {
                    throw new Gls2BibSyntaxException(this.getMessage("gls2bib.missing.encoding.value", stringArray[i]));
                }
                this.charset = Charset.forName(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("--bibenc")) {
                if (i == stringArray.length - 1) {
                    throw new Gls2BibSyntaxException(this.getMessage("gls2bib.missing.encoding.value", stringArray[i]));
                }
                this.bibCharsetName = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("--space-sub") || stringArray[i].equals("-s")) {
                if (i == stringArray.length - 1) {
                    throw new Gls2BibSyntaxException(this.getMessage("gls2bib.missing.arg.value", stringArray[i]));
                }
                this.spaceSub = stringArray[++i];
                if (!" ".equals(this.spaceSub)) continue;
                this.spaceSub = null;
                continue;
            }
            if (stringArray[i].equals("--locale")) {
                ++i;
                continue;
            }
            if (stringArray[i].equals("--ignore-sort")) {
                this.ignoreSortField = true;
                continue;
            }
            if (stringArray[i].equals("--no-ignore-sort")) {
                this.ignoreSortField = false;
                continue;
            }
            if (stringArray[i].equals("--ignore-type")) {
                this.ignoreTypeField = true;
                continue;
            }
            if (stringArray[i].equals("--no-ignore-type")) {
                this.ignoreTypeField = false;
                continue;
            }
            if (stringArray[i].equals("--split-on-type") || stringArray[i].equals("-t")) {
                this.splitOnType = true;
                this.ignoreTypeField = true;
                this.overwriteFiles = false;
                continue;
            }
            if (stringArray[i].equals("--no-split-on-type")) {
                this.splitOnType = false;
                continue;
            }
            if (stringArray[i].equals("--ignore-category")) {
                this.ignoreCategoryField = true;
                continue;
            }
            if (stringArray[i].equals("--no-ignore-category")) {
                this.ignoreCategoryField = false;
                continue;
            }
            if (stringArray[i].equals("--split-on-category") || stringArray[i].equals("-c")) {
                this.splitOnCategory = true;
                this.ignoreCategoryField = true;
                this.overwriteFiles = false;
                continue;
            }
            if (stringArray[i].equals("--no-split-on-category")) {
                this.splitOnCategory = false;
                continue;
            }
            if (stringArray[i].equals("--overwrite")) {
                this.overwriteFiles = true;
                continue;
            }
            if (stringArray[i].equals("--no-overwrite")) {
                this.overwriteFiles = false;
                continue;
            }
            if (stringArray[i].equals("--index-conversion") || stringArray[i].equals("-i")) {
                this.noDescEntryToIndex = true;
                continue;
            }
            if (stringArray[i].equals("--no-index-conversion")) {
                this.noDescEntryToIndex = false;
                continue;
            }
            if (stringArray[i].equals("--absorb-see")) {
                this.absorbSee = true;
                continue;
            }
            if (stringArray[i].equals("--no-absorb-see")) {
                this.absorbSee = false;
                continue;
            }
            if (stringArray[i].equals("--ignore-fields") || stringArray[i].equals("-f")) {
                String string;
                if (i == stringArray.length - 1) {
                    throw new Gls2BibSyntaxException(this.getMessage("gls2bib.missing.arg.value", stringArray[i]));
                }
                if ((string = stringArray[++i].trim()).isEmpty()) {
                    this.customIgnoreFields = null;
                    continue;
                }
                for (String string2 : this.customIgnoreFields = string.split(" *, *")) {
                    if (string2.equals("sort")) {
                        this.ignoreSortField = true;
                        continue;
                    }
                    if (string2.equals("type")) {
                        this.ignoreTypeField = true;
                        continue;
                    }
                    if (!string2.equals("category")) continue;
                    this.ignoreCategoryField = true;
                }
                continue;
            }
            if (stringArray[i].equals("--preamble-only") || stringArray[i].equals("-p")) {
                this.preambleOnly = true;
                continue;
            }
            if (stringArray[i].equals("--no-preamble-only")) {
                this.preambleOnly = false;
                continue;
            }
            if (stringArray[i].equals("--debug") || stringArray[i].equals("--silent") || stringArray[i].equals("--verbose")) continue;
            if (stringArray[i].startsWith("-")) {
                throw new Gls2BibSyntaxException(this.getMessage("gls2bib.unknown.arg", stringArray[i], "--help"));
            }
            if (this.texFile == null) {
                this.texFile = new File(stringArray[i]);
                continue;
            }
            if (this.bibFile == null) {
                if (stringArray[i].toLowerCase().endsWith(".bib")) {
                    this.bibFile = new File(stringArray[i]);
                    continue;
                }
                this.bibFile = new File(stringArray[i] + ".bib");
                continue;
            }
            throw new Gls2BibSyntaxException(this.getMessage("gls2bib.toomany.arg", "--help"));
        }
        if (this.texFile == null) {
            throw new Gls2BibSyntaxException(this.getMessage("gls2bib.missing.tex.arg", this.getMessage("gls2bib.syntax", APP_NAME), "--help"));
        }
        if (this.bibFile == null) {
            throw new Gls2BibSyntaxException(this.getMessage("gls2bib.missing.bib.arg", this.getMessage("gls2bib.syntax", APP_NAME), "--help"));
        }
        if (this.bibCharsetName == null) {
            this.bibCharsetName = this.charset.name();
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        int n = 1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--texenc") || stringArray[i].equals("--bibenc") || stringArray[i].equals("--space-sub") || stringArray[i].equals("-s") || stringArray[i].equals("--ignore-fields") || stringArray[i].equals("-f")) {
                ++i;
                continue;
            }
            if (stringArray[i].equals("--locale")) {
                if (i == stringArray.length - 1) {
                    System.err.println("Missing <lang tag> after " + stringArray[i]);
                    System.exit(1);
                }
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("--debug")) {
                n = 2;
                continue;
            }
            if (stringArray[i].equals("--silent")) {
                n = 0;
                continue;
            }
            if (!stringArray[i].equals("--verbose")) continue;
            n = 1;
        }
        try {
            Gls2Bib gls2Bib = new Gls2Bib(stringArray, string, n);
            gls2Bib.process();
        }
        catch (Gls2BibSyntaxException gls2BibSyntaxException) {
            System.err.println(gls2BibSyntaxException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(3);
        }
    }

    public boolean fieldExpansionOn(String string) {
        Boolean bl;
        if (this.expandFieldMap != null && (bl = this.expandFieldMap.get(string)) != null) {
            return bl;
        }
        return this.expandFields;
    }

    public void setFieldExpansion(boolean bl) {
        this.expandFields = bl;
    }

    public void setFieldExpansion(String string, boolean bl) {
        String string2 = this.keyToFieldMap.get(string);
        if (string2 != null) {
            string = string2;
        }
        if (this.expandFieldMap == null) {
            this.expandFieldMap = new HashMap();
        }
        this.expandFieldMap.put(string, bl);
    }
}

