// Generated by gmmproc 2.64.2 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_ELEMENTFACTORY_H
#define _GSTREAMERMM_ELEMENTFACTORY_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/pad.h>
#include <gstreamermm/pluginfeature.h>
#include <gstreamermm/urihandler.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GstElementFactory = struct _GstElementFactory;
using GstElementFactoryClass = struct _GstElementFactoryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gst
{ class  ElementFactory_Class; } // namespace Gst
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gst
{

enum ElementFactoryListType
{
  ELEMENT_FACTORY_TYPE_ANY,
  ELEMENT_FACTORY_TYPE_AUDIOVIDEO_SINKS,
  ELEMENT_FACTORY_TYPE_AUDIO_ENCODER,
  ELEMENT_FACTORY_TYPE_DECODABLE,
  ELEMENT_FACTORY_TYPE_DECODER,
  ELEMENT_FACTORY_TYPE_DEMUXER,
  ELEMENT_FACTORY_TYPE_DEPAYLOADER,
  ELEMENT_FACTORY_TYPE_ENCODER,
  ELEMENT_FACTORY_TYPE_FORMATTER,
  ELEMENT_FACTORY_TYPE_MAX_ELEMENTS,
  ELEMENT_FACTORY_TYPE_MEDIA_AUDIO,
  ELEMENT_FACTORY_TYPE_MEDIA_IMAGE,
  ELEMENT_FACTORY_TYPE_MEDIA_METADATA,
  ELEMENT_FACTORY_TYPE_MEDIA_SUBTITLE,
  ELEMENT_FACTORY_TYPE_MEDIA_VIDEO,
  ELEMENT_FACTORY_TYPE_MEDIA_ANY,
  ELEMENT_FACTORY_TYPE_MUXER,
  ELEMENT_FACTORY_TYPE_PARSER,
  ELEMENT_FACTORY_TYPE_PAYLOADER,
  ELEMENT_FACTORY_TYPE_SINK,
  ELEMENT_FACTORY_TYPE_SRC,
  ELEMENT_FACTORY_TYPE_VIDEO_ENCODER
};

class ArrayHandler;
class Caps;
class Element;
class StaticPadTemplate;
struct StaticPadTemplateTraits;
class Plugin;

/** Create Gst::Element 's from a factory
 *
 * Gst::ElementFactory is used to create instances of elements. A
 * Gst::ElementFactory can be added to a Gst::Plugin as it is also a
 * Gst::PluginFeature.
 *
 * Use the find() and create()
 * functions to create element instances or use create_element() as a
 * convenient shortcut.
 *
 * The following code example shows you how to create a 'filesrc' element.
 *
 * @code
 *  #include <gstreamermm.h>
 *  #include <iostream>
 *
 *  int main (int argc, char *argc[])
 *  {
 *    Glib::RefPtr<Gst::Element> src;
 *    Glib::RefPtr<Gst::ElementFactory> srcfactory;
 *
 *    Gst::init(&argc,&argv);
 *
 *    srcfactory = Gst::ElementFactory::find("filesrc");
 *
 *    if(!srcfactory)
 *    {
 *      std::cout << "Could not find factory 'filesrc'" << std::endl;
 *      exit(1);
 *    }
 *
 *    src = srcfactory->create("src");
 *
 *    if(!src)
 *    {
 *      std::cout << "Could not create element 'src'" << std::endl;
 *      exit(1);
 *    }
 *    ...
 *  }
 * @endcode
 *
 * Last reviewed on 2016-05-21 (1.8.0).
 *
 */

class ElementFactory : public PluginFeature
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = ElementFactory;
  using CppClassType = ElementFactory_Class;
  using BaseObjectType = GstElementFactory;
  using BaseClassType = GstElementFactoryClass;

  // noncopyable
  ElementFactory(const ElementFactory&) = delete;
  ElementFactory& operator=(const ElementFactory&) = delete;

private:  friend class ElementFactory_Class;
  static CppClassType elementfactory_class_;

protected:
  explicit ElementFactory(const Glib::ConstructParams& construct_params);
  explicit ElementFactory(GstElementFactory* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  ElementFactory(ElementFactory&& src) noexcept;
  ElementFactory& operator=(ElementFactory&& src) noexcept;

  ~ElementFactory() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstElementFactory*       gobj()       { return reinterpret_cast<GstElementFactory*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstElementFactory* gobj() const { return reinterpret_cast<GstElementFactory*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstElementFactory* gobj_copy();

private:


public:
  
  /** Create a new elementfactory capable of instantiating objects of the
   *  @a type and add the factory to @a plugin.
   * 
   * @param plugin Gst::Plugin to register the element with, or <tt>nullptr</tt> for
   * a static element.
   * @param name Name of elements of this type.
   * @param rank Rank of element (higher rank means more importance when autoplugging).
   * @param type GType of element to register.
   * @return <tt>true</tt>, if the registering succeeded, <tt>false</tt> on error.
   */
  static bool register_element(const Glib::RefPtr<Gst::Plugin>& plugin, const Glib::ustring& name, guint rank, GType type);

  
  /** Search for an element factory of the given name. Refs the returned
   * element factory; caller is responsible for unreffing.
   * 
   * @param name Name of factory to find.
   * @return Gst::ElementFactory if found,
   * <tt>nullptr</tt> otherwise.
   */
  static Glib::RefPtr<Gst::ElementFactory> find(const Glib::ustring& name);

  
  /** Create a new element of the type defined by the given elementfactory.
   * It will be given the name supplied, since all elements require a name as
   * their first argument.
   * 
   * @param name Name of new element, or <tt>nullptr</tt> to automatically create
   * a unique name.
   * @return New Gst::Element or <tt>nullptr</tt>
   * if the element couldn't be created.
   */
  Glib::RefPtr<Gst::Element> create(const Glib::ustring& name);

  /// A create() convenience overload.
  Glib::RefPtr<Gst::Element> create();

  
  /** Create a new element of the type defined by the given element factory.
   * 
   * @param factory_name A named factory to instantiate.
   * @param name Name of new element.
   * @return New Gst::Element or <tt>nullptr</tt> if unable to create element.
   */
  static Glib::RefPtr<Gst::Element> create_element(const Glib::ustring& factory_name, const Glib::ustring& name);

  /// A create_element() convenience overload.
  static Glib::RefPtr<Gst::Element> create_element(const Glib::ustring& factory_name);

  
  /** Checks if the factory can sink all possible capabilities.
   * 
   * @param caps The caps to check.
   * @return <tt>true</tt> if the caps are fully compatible.
   */
  bool can_sink_all_caps(const Glib::RefPtr<const Gst::Caps>& caps) const;
  
  /** Checks if the factory can src all possible capabilities.
   * 
   * @param caps The caps to check.
   * @return <tt>true</tt> if the caps are fully compatible.
   */
  bool can_src_all_caps(const Glib::RefPtr<const Gst::Caps>& caps) const;
  
  /** Checks if the factory can sink any possible capability.
   * 
   * @param caps The caps to check.
   * @return <tt>true</tt> if the caps have a common subset.
   */
  bool can_sink_any_caps(const Glib::RefPtr<const Gst::Caps>& caps) const;
  
  /** Checks if the factory can src any possible capability.
   * 
   * @param caps The caps to check.
   * @return <tt>true</tt> if the caps have a common subset.
   */
  bool can_src_any_caps(const Glib::RefPtr<const Gst::Caps>& caps) const;

  
  /** Get the Type for elements managed by this factory. The type can
   * only be retrieved if the element factory is loaded, which can be
   * assured with Gst::PluginFeature::load().
   * 
   * @return The Type for elements managed by this factory or 0 if
   * the factory is not loaded.
   */
  GType get_element_type() const;

   
  /** Get the available keys for the metadata on @a factory.
   * 
   * @return A <tt>nullptr</tt>-terminated array of key strings, or <tt>nullptr</tt> when there is no
   * metadata.
   */
  std::vector<Glib::ustring> get_metadata_keys() const;
  
  /** Get the metadata on @a factory with @a key.
   * 
   * @param key A key.
   * @return The metadata with @a key on @a factory or <tt>nullptr</tt>
   * when there was no metadata with the given @a key.
   */
  Glib::ustring get_metadata(const Glib::ustring& key) const;

  
  /** Gets the number of pad_templates in this factory.
   * 
   * @return The number of pad_templates.
   */
  guint get_num_pad_templates() const;
  
  /** Gets the type of URIs the element supports or Gst::URI_UNKNOWN if none.
   * 
   * @return Type of URIs this element supports.
   */
  URIType get_uri_type() const;

 
  /** Gets a <tt>nullptr</tt>-terminated array of protocols this element supports or <tt>nullptr</tt> if
   * no protocols are supported. You may not change the contents of the returned
   * array, as it is still owned by the element factory. Use Glib::strdupv() to
   * make a copy of the protocol string array if you need to.
   * 
   * @return The supported protocols
   * or <tt>nullptr</tt>.
   */
  std::vector<Glib::ustring> get_uri_protocols() const;

  
  /** Check if @a factory implements the interface with name @a name.
   * 
   * @param name An interface name.
   * @return <tt>true</tt> when @a factory implement the interface.
   */
  bool has_interface(const Glib::ustring& name) const;

 
  /** Gets the List of Gst::StaticPadTemplate for this factory.
   * 
   * @return The
   * static pad templates.
   */
  std::vector< Gst::StaticPadTemplate > get_static_pad_templates() const;

 
  /** Filter out all the elementfactories in @a list that can handle @a caps in
   * the given direction.
   * 
   * If @a subsetonly is <tt>true</tt>, then only the elements whose pads templates
   * are a complete superset of @a caps will be returned. Else any element
   * whose pad templates caps can intersect with @a caps will be returned.
   * 
   * @param list A List of
   * Gst::ElementFactory to filter.
   * @param caps A Gst::Caps.
   * @param direction A Gst::PadDirection to filter on.
   * @param subsetonly Whether to filter on caps subsets or not.
   * @return A List of
   * Gst::ElementFactory elements that match the given requisites.
   * Use #gst_plugin_feature_list_free after usage.
   */
  static std::vector< Glib::RefPtr<Gst::ElementFactory> > filter(const std::vector< Glib::RefPtr<Gst::ElementFactory> >& list, const Glib::RefPtr<const Gst::Caps>& caps, PadDirection direction, bool subsetonly);

 
  /** Get a list of factories that match the given @a type. Only elements
   * with a rank greater or equal to @a minrank will be returned.
   * The list of factories is returned by decreasing rank.
   * 
   * @param type A Gst::ElementFactoryListType.
   * @param minrank Minimum rank.
   * @return A List of
   * Gst::ElementFactory elements. Use Gst::PluginFeature::list_free() after
   * usage.
   */
  static std::vector< Glib::RefPtr<Gst::ElementFactory> > get_elements(ElementFactoryListType type, Rank minrank);
  
  /** Check if @a factory is of the given types.
   * 
   * @param type A Gst::ElementFactoryListType.
   * @return <tt>true</tt> if @a factory is of @a type.
   */
  bool is_type(ElementFactoryListType type) const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

/*! A gstreamermm Gst::ElementFactory example.
 * @example basics/element_factory.cc
 */

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::ElementFactory
   */
  
  Glib::RefPtr<Gst::ElementFactory> wrap(GstElementFactory* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_ELEMENTFACTORY_H */

