/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import javajs.api.GenericCifDataParser;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.readers.cif.Cif2DataParser;
import org.jmol.adapter.readers.cif.CifReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.SymmetryInterface;

public class TopoCifParser
implements CifReader.Parser {
    private static final String[] topolFields = new String[]{"_topol_link_node_label_1", "_topol_link_node_label_2", "_topol_link_distance", "_topol_link_site_symmetry_symop_1", "_topol_link_site_symmetry_translation_1_x", "_topol_link_site_symmetry_translation_1_y", "_topol_link_site_symmetry_translation_1_z", "_topol_link_site_symmetry_symop_2", "_topol_link_site_symmetry_translation_2_x", "_topol_link_site_symmetry_translation_2_y", "_topol_link_site_symmetry_translation_2_z", "_topol_link_type", "_topol_link_multiplicity", "_topol_link_voronoi_solidangle"};
    private static final byte topol_link_node_label_1 = 0;
    private static final byte topol_link_node_label_2 = 1;
    private static final byte topol_link_distance = 2;
    private static final byte topol_link_site_symmetry_symop_1 = 3;
    private static final byte topol_link_site_symmetry_translation_1_x = 4;
    private static final byte topol_link_site_symmetry_translation_1_y = 5;
    private static final byte topol_link_site_symmetry_translation_1_z = 6;
    private static final byte topol_link_site_symmetry_symop_2 = 7;
    private static final byte topol_link_site_symmetry_translation_2_x = 8;
    private static final byte topol_link_site_symmetry_translation_2_y = 9;
    private static final byte topol_link_site_symmetry_translation_2_z = 10;
    private static final byte topol_link_type = 11;
    private static final byte topol_link_multiplicity = 12;
    private static final byte topol_link_voronoi_solidangle = 13;
    private static final byte topol_link_site_symmetry_translation_1 = 14;
    private static final byte topol_link_site_symmetry_translation_2 = 15;
    CifReader reader;
    GenericCifDataParser cifParser;
    private String types;
    private Lst<TopoLink> links = new Lst();
    String bondlist = "";

    @Override
    public TopoCifParser setReader(CifReader reader) {
        if (reader.checkFilterKey("TOPOS_IGNORE")) {
            return this;
        }
        this.reader = reader;
        this.cifParser = reader.cifParser;
        this.types = reader.getFilter("TOPOS_TYPES");
        if (this.types != null && this.types.length() > 1) {
            this.types = "+" + this.types.substring(1).toLowerCase() + "+";
        }
        if (reader.doApplySymmetry) {
            reader.asc.setNoAutoBond();
        }
        return this;
    }

    @Override
    public boolean finalizeReader() throws Exception {
        return false;
    }

    static boolean isEqualD(T3 p1, T3 p2, double d, double err) {
        return Math.abs((double)p1.distance(p2) - d) < err;
    }

    @Override
    public void finalizeSymmetry(boolean haveSymmetry) throws Exception {
        if (this.reader == null || !haveSymmetry || !this.reader.doApplySymmetry) {
            return;
        }
        SymmetryInterface sym = this.reader.asc.getXSymmetry().getBaseSymmetry();
        int nLinks = this.links.size();
        int nOps = sym.getSpaceGroupOperationCount();
        M4[] operations = new M4[nOps];
        for (int i = 0; i < nOps; ++i) {
            operations[i] = sym.getSpaceGroupOperationRaw(i);
        }
        P3[] carts = new P3[this.reader.asc.ac];
        Atom[] atoms = this.reader.asc.atoms;
        int i = this.reader.asc.ac;
        while (--i >= 0) {
            carts[i] = P3.newP(atoms[i]);
            sym.toCartesian(carts[i], true);
        }
        int n = 0;
        BS bsConnected = new BS();
        for (int i2 = 0; i2 < nLinks; ++i2) {
            TopoLink link = (TopoLink)this.links.get(i2);
            link.setPrimitives(sym, operations);
            n += this.setBonds(i2, atoms, carts, link, sym, nOps, bsConnected);
        }
        if (bsConnected.cardinality() > 0) {
            this.reader.asc.bsAtoms = bsConnected;
        }
        this.reader.appendLoadNote("TopoCifParser created " + n + " edges and " + bsConnected.cardinality() + " nodes");
    }

    private int setBonds(int index, Atom[] atoms, P3[] carts, TopoLink link, SymmetryInterface sym, int nOps, BS bsConnected) {
        int nbonds = 0;
        BS bs1 = new BS();
        BS bs2 = new BS();
        int i = this.reader.asc.ac;
        while (--i >= 0) {
            Atom a = atoms[i];
            if (a.atomSite == link.a1.atomSite) {
                bs1.set(i);
            }
            if (a.atomSite != link.a2.atomSite) continue;
            bs2.set(i);
        }
        P3 pa = new P3();
        BS bsym = new BS();
        int i1 = bs1.nextSetBit(0);
        while (i1 >= 0) {
            Atom at1 = atoms[i1];
            bsym.clearAll();
            for (int i2 = 0; i2 < nOps; ++i2) {
                TopoPrimitive prim = link.primitives[i2];
                if (prim == null) continue;
                pa.setT(at1);
                sym.unitize(pa);
                if (!TopoCifParser.isEqualD(pa, prim.p1u, 0.0, 0.001)) continue;
                bsym.set(i2);
            }
            int i2 = bs2.nextSetBit(0);
            while (i2 >= 0) {
                Atom at2 = atoms[i2];
                if (i1 != i2 && TopoCifParser.isEqualD(carts[i1], carts[i2], link.d, 0.001)) {
                    V3 va12 = V3.newVsub(at2, at1);
                    int i3 = bsym.nextSetBit(0);
                    while (i3 >= 0) {
                        String key;
                        if (TopoCifParser.isEqualD(va12, link.primitives[i3].v12f, 0.0, 0.001) && this.bondlist.indexOf(key = "," + at1.index + "," + at2.index + "," + at1.index + ",") < 0) {
                            this.bondlist = this.bondlist + key;
                            ++nbonds;
                            this.reader.asc.addNewBondWithOrderA(at1, at2, link.order);
                            bsConnected.set(at1.index);
                            bsConnected.set(at2.index);
                        }
                        i3 = bsym.nextSetBit(i3 + 1);
                    }
                }
                i2 = bs2.nextSetBit(i2 + 1);
            }
            i1 = bs1.nextSetBit(i1 + 1);
        }
        return nbonds;
    }

    @Override
    public void processBlock(String key) throws Exception {
        if (this.reader == null) {
            return;
        }
        if (this.reader.ucItems != null) {
            this.reader.allow_a_len_1 = true;
            for (int i = 0; i < 6; ++i) {
                this.reader.setUnitCellItem(i, this.reader.ucItems[i]);
            }
        }
        this.reader.parseLoopParameters(topolFields);
        while (this.cifParser.getData()) {
            String type = this.reader.getField((byte)11);
            if (this.types == null ? "vw".equals(type) : this.types.indexOf("+" + type + "+") < 0) continue;
            double[] t1 = new double[3];
            double[] t2 = new double[3];
            Atom a1 = null;
            Atom a2 = null;
            String name1 = null;
            String name2 = null;
            name1 = this.reader.getField((byte)0);
            a1 = this.reader.asc.getAtomFromName(name1);
            if (a1 == null || (a2 = this.reader.asc.getAtomFromName(name2 = this.reader.getField((byte)1))) == null) {
                System.out.println("TopoCifParser atom " + (a1 == null ? name1 : name2) + " could not be found");
                continue;
            }
            String sdist = this.reader.getField((byte)2);
            float d = this.reader.parseFloatStr(sdist);
            if (!(d > 0.0f)) {
                System.out.println("TopoCifParser invalid distance " + sdist);
                continue;
            }
            int op1 = Integer.parseInt(this.reader.getField((byte)3));
            int op2 = Integer.parseInt(this.reader.getField((byte)7));
            String field = this.reader.getField((byte)14);
            if (field.length() > 1) {
                t1 = Cif2DataParser.getArrayFromStringList(field, 3);
            } else {
                t1[0] = Float.parseFloat(this.reader.getField((byte)4));
                t1[1] = Float.parseFloat(this.reader.getField((byte)5));
                t1[2] = Float.parseFloat(this.reader.getField((byte)6));
            }
            field = this.reader.getField((byte)15);
            if (field.length() > 1) {
                t2 = Cif2DataParser.getArrayFromStringList(field, 3);
            } else {
                t2[0] = Float.parseFloat(this.reader.getField((byte)8));
                t2[1] = Float.parseFloat(this.reader.getField((byte)9));
                t2[2] = Float.parseFloat(this.reader.getField((byte)10));
            }
            this.links.addLast(new TopoLink(a1, a2, op1, t1, op2, t2, d, type));
        }
    }

    private class TopoPrimitive {
        M4 op;
        TopoLink link;
        P3 p1u;
        P3 p2f;
        V3 v12f;
        boolean isValid;

        TopoPrimitive(TopoLink link, SymmetryInterface sym, M4 op) {
            this.link = link;
            this.op = op;
            P3 p1 = P3.newP(link.p1f);
            P3 p2 = P3.newP(link.p2f);
            sym.toCartesian(p1, true);
            sym.toCartesian(p2, true);
            System.out.println(p1.distance(p2) + " " + link.p1f + " " + link.p2f);
            p1.setT(link.p1f);
            p2.setT(link.p2f);
            op.rotTrans(p1);
            op.rotTrans(p2);
            this.p1u = P3.newP(p1);
            sym.unitize(this.p1u);
            this.p2f = P3.newP(p2);
            this.p2f.add(V3.newVsub(this.p1u, p1));
            System.out.println(op + "\n " + p1 + " " + this.p1u);
            this.v12f = V3.newVsub(this.p2f, this.p1u);
            p1.setT(this.p1u);
            p2.setT(this.p2f);
            sym.toCartesian(p1, true);
            sym.toCartesian(p2, true);
            System.out.println(p1.distance(p2) + " " + p1 + " " + p2 + " " + link.d);
            this.isValid = TopoCifParser.isEqualD(p1, p2, link.d, 0.001);
        }

        public String toString() {
            return "" + this.v12f;
        }
    }

    private class TopoLink {
        Atom a1;
        Atom a2;
        int op1;
        int op2;
        String type;
        P3 p1f;
        P3 p2f;
        double d;
        P3 dt;
        int order;
        TopoPrimitive[] primitives;

        TopoLink(Atom a1, Atom a2, int op1, double[] t1, int op2, double[] t2, double d, String type) {
            this.a1 = a1;
            this.a2 = a2;
            this.d = d;
            this.op1 = op1 - 1;
            this.op2 = op2 - 1;
            this.type = type;
            this.order = "hb".equals(type) ? 4096 : 1;
            this.dt = P3.new3((float)(t2[0] - t1[0]), (float)(t2[1] - t1[1]), (float)(t2[2] - t1[2]));
        }

        void setPrimitives(SymmetryInterface sym, M4[] operations) {
            int nOps = operations.length;
            if (this.p1f == null) {
                this.p1f = P3.new3(this.a1.x, this.a1.y, this.a1.z);
                this.p2f = P3.new3(this.a2.x, this.a2.y, this.a2.z);
                operations[this.op1].rotTrans(this.p1f);
                operations[this.op2].rotTrans(this.p2f);
                this.p2f.add(this.dt);
                this.primitives = new TopoPrimitive[nOps];
            }
            for (int j = 0; j < nOps; ++j) {
                TopoPrimitive prim = new TopoPrimitive(this, sym, operations[j]);
                if (!prim.isValid) continue;
                System.out.println("TopoCifParser primitive: op=" + j + " " + this.a1.atomName + " " + this.a2.atomName + "\n" + prim + "\n" + this);
                this.primitives[j] = prim;
            }
        }

        public String toString() {
            return "[link " + this.a1.atomName + " " + this.a2.atomName + " " + this.d + " " + this.type + "]";
        }
    }
}

