/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.ExpressionDecomposer;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsIterables;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nullable;

final class Es6RewriteGenerators
implements HotSwapCompilerPass {
    private static final String GENERATOR_FUNCTION = "$jscomp$generator$function";
    private static final String GENERATOR_CONTEXT = "$jscomp$generator$context";
    private static final String GENERATOR_ARGUMENTS = "$jscomp$generator$arguments";
    private static final String GENERATOR_THIS = "$jscomp$generator$this";
    private static final String GENERATOR_FORIN_PREFIX = "$jscomp$generator$forin$";
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.GENERATORS);
    private final AbstractCompiler compiler;
    private final JSTypeRegistry registry;
    private final boolean shouldAddTypes;
    private final JSType unknownType;
    private final JSType numberType;
    private final JSType booleanType;
    private final JSType nullType;
    private final JSType nullableStringType;
    private final JSType voidType;

    Es6RewriteGenerators(AbstractCompiler compiler) {
        Preconditions.checkNotNull(compiler);
        this.compiler = compiler;
        this.registry = compiler.getTypeRegistry();
        if (compiler.hasTypeCheckingRun()) {
            this.shouldAddTypes = true;
            this.unknownType = this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            this.numberType = this.registry.getNativeType(JSTypeNative.NUMBER_TYPE);
            this.booleanType = this.registry.getNativeType(JSTypeNative.BOOLEAN_TYPE);
            this.nullType = this.registry.getNativeType(JSTypeNative.NULL_TYPE);
            this.nullableStringType = this.registry.createNullableType(this.registry.getNativeType(JSTypeNative.STRING_TYPE));
            this.voidType = this.registry.getNativeType(JSTypeNative.VOID_TYPE);
        } else {
            this.shouldAddTypes = false;
            this.unknownType = null;
            this.numberType = null;
            this.booleanType = null;
            this.nullType = null;
            this.nullableStringType = null;
            this.voidType = null;
        }
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, new GeneratorFunctionsTranspiler());
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, transpiledFeatures, new GeneratorFunctionsTranspiler());
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    private static class YieldNodeMarker
    implements NodeTraversal.Callback {
        private YieldNodeMarker() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return !n.isFunction();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isYield()) {
                n.setGeneratorMarker(true);
            }
            if (parent != null && n.isGeneratorMarker()) {
                parent.setGeneratorMarker(true);
            }
        }
    }

    private class SingleGeneratorFunctionTranspiler {
        final int generatorNestingLevel;
        final TranspilationContext context;
        final Node originalGeneratorBody;
        Node newGeneratorHoistBlock;
        JSType originalGenReturnType;
        JSType yieldType;

        SingleGeneratorFunctionTranspiler(Node genFunc, int genaratorNestingLevel) {
            this.generatorNestingLevel = genaratorNestingLevel;
            this.originalGeneratorBody = genFunc.getLastChild();
            ObjectType contextType = null;
            if (Es6RewriteGenerators.this.shouldAddTypes) {
                JSType globalContextType;
                this.yieldType = Es6RewriteGenerators.this.unknownType;
                if (genFunc.getJSType() != null && genFunc.getJSType().isFunctionType()) {
                    FunctionType fnType = genFunc.getJSType().toMaybeFunctionType();
                    this.originalGenReturnType = fnType.getReturnType();
                    this.yieldType = JsIterables.getElementType(this.originalGenReturnType, Es6RewriteGenerators.this.registry);
                }
                contextType = (globalContextType = Es6RewriteGenerators.this.registry.getGlobalType("$jscomp.generator.Context")) == null ? Es6RewriteGenerators.this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE) : Es6RewriteGenerators.this.registry.createTemplatizedType(globalContextType.toMaybeObjectType(), this.yieldType);
            }
            this.context = new TranspilationContext(contextType);
        }

        private void hoistNode(Node node) {
            this.newGeneratorHoistBlock.addChildBefore(node, this.newGeneratorHoistBlock.getLastChild());
        }

        private boolean isTranspiledAsyncFunction(Node generatorFunction) {
            if (generatorFunction.getParent().isCall() && generatorFunction.getPrevious() != null) {
                Node callTarget = generatorFunction.getParent().getFirstChild();
                if (generatorFunction.getPrevious() == callTarget && generatorFunction.getNext() == null && callTarget.matchesQualifiedName("$jscomp.asyncExecutePromiseGeneratorFunction")) {
                    Preconditions.checkState(generatorFunction.getGrandparent().isReturn());
                    Preconditions.checkState(generatorFunction.getGrandparent().getNext() == null);
                    return true;
                }
            }
            return false;
        }

        public void transpile() {
            boolean shouldAddFinalJump;
            Node program;
            Node changeScopeNode;
            Node generatorFunction = this.originalGeneratorBody.getParent();
            Preconditions.checkState(generatorFunction.isGeneratorFunction());
            generatorFunction.putBooleanProp(Node.GENERATOR_FN, false);
            FunctionType programType = Es6RewriteGenerators.this.shouldAddTypes ? Es6RewriteGenerators.this.registry.createFunctionType(Es6RewriteGenerators.this.registry.createUnionType(Es6RewriteGenerators.this.voidType, Es6RewriteGenerators.this.registry.createRecordType(ImmutableMap.of("value", this.yieldType))), this.context.contextType) : null;
            Node generatorBody = IR.block();
            if (this.isTranspiledAsyncFunction(generatorFunction)) {
                Node callTarget = generatorFunction.getPrevious();
                Preconditions.checkState(callTarget.isGetProp());
                this.newGeneratorHoistBlock = generatorFunction.getGrandparent().getParent();
                Preconditions.checkState(this.newGeneratorHoistBlock.isBlock(), this.newGeneratorHoistBlock);
                changeScopeNode = NodeUtil.getEnclosingFunction(this.newGeneratorHoistBlock);
                Preconditions.checkState(changeScopeNode.isFunction(), changeScopeNode);
                callTarget.getSecondChild().setString("asyncExecutePromiseGeneratorProgram");
                JSType oldType = callTarget.getJSType();
                if (oldType != null && oldType.isFunctionType()) {
                    callTarget.setJSType(Es6RewriteGenerators.this.registry.createFunctionType(oldType.toMaybeFunctionType().getReturnType(), programType));
                }
                program = this.originalGeneratorBody.getParent();
                this.originalGeneratorBody.getPrevious().addChildToBack(this.context.getJsContextNameNode(this.originalGeneratorBody));
                this.originalGeneratorBody.replaceWith(generatorBody);
            } else {
                changeScopeNode = generatorFunction;
                Node genFuncName = generatorFunction.getFirstChild();
                Preconditions.checkState(genFuncName.isName());
                if (genFuncName.getString().isEmpty()) {
                    genFuncName.setString(this.context.getScopedName(Es6RewriteGenerators.GENERATOR_FUNCTION).getString());
                }
                program = IR.function(IR.name(""), IR.paramList(this.context.getJsContextNameNode(this.originalGeneratorBody)), generatorBody);
                Node createGenerator = IR.getprop(Es6ToEs3Util.withType(IR.getprop(Es6ToEs3Util.withType(IR.name("$jscomp"), Es6RewriteGenerators.this.unknownType), "generator", new String[0]), Es6RewriteGenerators.this.unknownType), "createGenerator", new String[0]);
                if (Es6RewriteGenerators.this.shouldAddTypes) {
                    createGenerator.setJSType(Es6RewriteGenerators.this.registry.createFunctionType(this.originalGenReturnType, programType));
                }
                this.newGeneratorHoistBlock = IR.block(IR.returnNode(Es6ToEs3Util.withType(IR.call(createGenerator, Es6ToEs3Util.withType(genFuncName.cloneNode(), generatorFunction.getJSType()), program), this.originalGenReturnType)).useSourceInfoFromForTree(this.originalGeneratorBody));
                this.originalGeneratorBody.replaceWith(this.newGeneratorHoistBlock);
            }
            program.setJSType(programType);
            Es6RewriteGenerators.this.compiler.reportChangeToChangeScope(program);
            NodeTraversal.traverse(Es6RewriteGenerators.this.compiler, this.originalGeneratorBody, new YieldNodeMarker());
            boolean bl = shouldAddFinalJump = !this.isEndOfBlockUnreachable(this.originalGeneratorBody);
            while (this.originalGeneratorBody.hasChildren()) {
                this.transpileStatement(this.originalGeneratorBody.removeFirstChild());
            }
            Node finalBlock = IR.block();
            if (shouldAddFinalJump) {
                finalBlock.addChildToBack(this.context.callContextMethodResult(this.originalGeneratorBody, "jumpToEnd", new Node[0]));
            }
            this.context.currentCase.jumpTo(this.context.programEndCase, finalBlock);
            this.context.currentCase.mayFallThrough = true;
            this.context.finalizeTransformation(generatorBody);
            this.context.checkStateIsEmpty();
            Es6RewriteGenerators.this.compiler.reportChangeToChangeScope(changeScopeNode);
        }

        void transpileStatement(Node statement) {
            this.transpileStatement(statement, null, null);
        }

        void transpileStatement(Node statement, @Nullable TranspilationContext.Case breakCase, @Nullable TranspilationContext.Case continueCase) {
            Preconditions.checkState(IR.mayBeStatement(statement));
            Preconditions.checkState(statement.getParent() == null);
            if (!statement.isGeneratorMarker()) {
                this.transpileUnmarkedNode(statement);
                return;
            }
            switch (statement.getToken()) {
                case LABEL: {
                    this.transpileLabel(statement);
                    break;
                }
                case BLOCK: {
                    this.transpileBlock(statement);
                    break;
                }
                case EXPR_RESULT: {
                    this.transpileExpressionResult(statement);
                    break;
                }
                case VAR: {
                    this.transpileVar(statement);
                    break;
                }
                case RETURN: {
                    this.transpileReturn(statement);
                    break;
                }
                case THROW: {
                    this.transpileThrow(statement);
                    break;
                }
                case IF: {
                    this.transpileIf(statement, breakCase);
                    break;
                }
                case FOR: {
                    this.transpileFor(statement, breakCase, continueCase);
                    break;
                }
                case FOR_IN: {
                    this.transpileForIn(statement, breakCase, continueCase);
                    break;
                }
                case WHILE: {
                    this.transpileWhile(statement, breakCase, continueCase);
                    break;
                }
                case DO: {
                    this.transpileDo(statement, breakCase, continueCase);
                    break;
                }
                case TRY: {
                    this.transpileTry(statement, breakCase);
                    break;
                }
                case SWITCH: {
                    this.transpileSwitch(statement, breakCase);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported token: " + (Object)((Object)statement.getToken()));
                }
            }
        }

        void transpileUnmarkedNode(Node n) {
            Preconditions.checkState(!n.isGeneratorMarker());
            if (n.isFunction()) {
                String functionName = n.getFirstChild().getString();
                Preconditions.checkState(!functionName.isEmpty() && !functionName.startsWith(Es6RewriteGenerators.GENERATOR_FUNCTION));
                this.hoistNode(n);
                return;
            }
            this.context.transpileUnmarkedBlock(n.isBlock() || n.isAddedBlock() ? n : IR.block(n));
        }

        void transpileLabel(Node n) {
            ArrayList<Node> labelNames = new ArrayList<Node>();
            while (n.isLabel()) {
                labelNames.add(n.removeFirstChild());
                n = n.removeFirstChild();
            }
            TranspilationContext.Case continueCase = NodeUtil.isLoopStructure(n) ? this.context.createCase() : null;
            TranspilationContext.Case breakCase = this.context.createCase();
            this.context.pushLabels(labelNames, breakCase, continueCase);
            this.transpileStatement(n, breakCase, continueCase);
            this.context.popLabels(labelNames);
            if (breakCase != this.context.currentCase) {
                this.context.switchCaseTo(breakCase);
            }
        }

        void transpileBlock(Node n) {
            while (n.hasChildren()) {
                this.transpileStatement(n.removeFirstChild());
            }
        }

        void transpileExpressionResult(Node n) {
            Node exposedExpression = this.exposeYieldAndTranspileRest(n.removeFirstChild());
            Node decomposed = this.transpileYields(exposedExpression);
            if (!exposedExpression.isYield()) {
                n.addChildToFront(this.prepareNodeForWrite(decomposed));
                n.setGeneratorMarker(false);
                this.context.writeGeneratedNode(n);
            }
        }

        void transpileVar(Node n) {
            n.setGeneratorMarker(false);
            Node newVars = n.cloneNode();
            while (n.hasChildren()) {
                Node var;
                while ((var = n.removeFirstChild()) != null && !var.isGeneratorMarker()) {
                    newVars.addChildToBack(var);
                }
                if (newVars.hasChildren()) {
                    this.transpileUnmarkedNode(newVars);
                    newVars = n.cloneNode();
                }
                if (var == null) continue;
                Preconditions.checkState(var.isGeneratorMarker());
                var.addChildToFront(this.maybeDecomposeExpression(var.removeFirstChild()));
                var.setGeneratorMarker(false);
                newVars.addChildToBack(var);
            }
            if (newVars.hasChildren()) {
                this.transpileUnmarkedNode(newVars);
            }
        }

        void transpileReturn(Node n) {
            n.addChildToFront(this.context.returnExpression(n, this.prepareNodeForWrite(this.maybeDecomposeExpression(n.removeFirstChild()))));
            this.context.writeGeneratedNode(n);
            this.context.currentCase.mayFallThrough = false;
        }

        void transpileThrow(Node n) {
            n.addChildToFront(this.prepareNodeForWrite(this.maybeDecomposeExpression(n.removeFirstChild())));
            this.context.writeGeneratedNode(n);
            this.context.currentCase.mayFallThrough = false;
        }

        Node exposeYieldAndTranspileRest(Node n) {
            Preconditions.checkState(n.isGeneratorMarker());
            if (n.isYield()) {
                return n;
            }
            boolean isExpression = IR.mayBeExpression(n);
            Node block = IR.block(isExpression ? IR.returnNode(n) : n);
            NodeTraversal.traverse(Es6RewriteGenerators.this.compiler, n, new YieldExposer());
            NodeTraversal.traverse(Es6RewriteGenerators.this.compiler, block, new YieldNodeMarker());
            Node decomposed = block.getLastChild().detach();
            this.transpileStatement(block);
            return isExpression ? decomposed.removeFirstChild() : decomposed;
        }

        Node maybeDecomposeExpression(@Nullable Node n) {
            if (n == null || !n.isGeneratorMarker()) {
                return n;
            }
            return this.transpileYields(this.exposeYieldAndTranspileRest(n));
        }

        Node prepareNodeForWrite(@Nullable Node n) {
            if (n == null) {
                return null;
            }
            Node wrapper = IR.mayBeStatement(n) ? IR.block(n) : IR.exprResult(n);
            AbstractCompiler abstractCompiler = Es6RewriteGenerators.this.compiler;
            TranspilationContext transpilationContext = this.context;
            Objects.requireNonNull(transpilationContext);
            NodeTraversal.traverse(abstractCompiler, wrapper, transpilationContext.new TranspilationContext.UnmarkedNodeTranspiler());
            Preconditions.checkState(wrapper.hasOneChild());
            return wrapper.removeFirstChild();
        }

        Node transpileYields(Node n) {
            Node yieldResult;
            if (!n.isGeneratorMarker()) {
                return n;
            }
            TranspilationContext.Case jumpToSection = this.context.createCase();
            Node yieldNode = this.findYield(n);
            Node yieldExpression = this.prepareNodeForWrite(this.maybeDecomposeExpression(yieldNode.removeFirstChild()));
            if (yieldNode.isYieldAll()) {
                this.context.yieldAll(yieldExpression, jumpToSection, yieldNode);
            } else {
                this.context.yield(yieldExpression, jumpToSection, yieldNode);
            }
            this.context.switchCaseTo(jumpToSection);
            if (yieldNode == n) {
                return yieldResult;
            }
            yieldNode.replaceWith(yieldResult);
            for (yieldResult = this.context.yieldResult(yieldNode); yieldResult != n; yieldResult = yieldResult.getParent()) {
                yieldResult.setGeneratorMarker(false);
            }
            return n;
        }

        void transpileIf(Node n, @Nullable TranspilationContext.Case breakCase) {
            Node condition = this.maybeDecomposeExpression(n.removeFirstChild());
            Node ifBlock = n.getFirstChild();
            Node elseBlock = ifBlock.getNext();
            if (!(ifBlock.isGeneratorMarker() || elseBlock != null && elseBlock.isGeneratorMarker())) {
                n.addChildToFront(condition);
                n.setGeneratorMarker(false);
                this.transpileUnmarkedNode(n);
                return;
            }
            ifBlock.detach();
            if (elseBlock == null) {
                elseBlock = IR.block().useSourceInfoFrom(n);
            } else {
                elseBlock.detach();
            }
            if (ifBlock.isGeneratorMarker() && !elseBlock.isGeneratorMarker()) {
                condition = Es6ToEs3Util.withType(IR.not(condition), Es6RewriteGenerators.this.booleanType).useSourceInfoFrom(condition);
                Node tmpNode = ifBlock;
                ifBlock = elseBlock;
                elseBlock = tmpNode;
            }
            if (!ifBlock.isGeneratorMarker()) {
                TranspilationContext.Case endCase = this.context.maybeCreateCase(breakCase);
                Node jumoToBlock = this.context.createJumpToBlock(endCase, false, ifBlock);
                while (jumoToBlock.hasChildren()) {
                    Node jumpToNode = jumoToBlock.removeFirstChild();
                    jumpToNode.setGeneratorSafe(true);
                    ifBlock.addChildToBack(jumpToNode);
                }
                this.transpileUnmarkedNode(IR.ifNode(condition, ifBlock).useSourceInfoFrom(n));
                this.transpileStatement(elseBlock);
                this.context.switchCaseTo(endCase);
                return;
            }
            TranspilationContext.Case ifCase = this.context.createCase();
            TranspilationContext.Case endCase = this.context.maybeCreateCase(breakCase);
            condition = this.prepareNodeForWrite(condition);
            Node newIfBlock = this.context.createJumpToBlock(ifCase, true, n);
            this.context.writeGeneratedNode(IR.ifNode(this.prepareNodeForWrite(condition), newIfBlock).useSourceInfoFrom(n));
            this.transpileStatement(elseBlock);
            this.context.writeJumpTo(endCase, elseBlock);
            this.context.switchCaseTo(ifCase);
            this.transpileStatement(ifBlock);
            this.context.switchCaseTo(endCase);
        }

        void transpileFor(Node n, @Nullable TranspilationContext.Case breakCase, @Nullable TranspilationContext.Case continueCase) {
            Node init = this.maybeDecomposeExpression(n.removeFirstChild());
            Node condition = n.getFirstChild();
            Node increment = condition.getNext();
            Node body = increment.getNext();
            if (!(condition.isGeneratorMarker() || increment.isGeneratorMarker() || body.isGeneratorMarker())) {
                n.addChildToFront(init);
                n.setGeneratorMarker(false);
                this.transpileUnmarkedNode(n);
                return;
            }
            if (!init.isEmpty()) {
                if (IR.mayBeExpression(init)) {
                    init = IR.exprResult(init).useSourceInfoFrom(init);
                }
                this.transpileUnmarkedNode(init);
            }
            TranspilationContext.Case startCase = this.context.createCase();
            TranspilationContext.Case incrementCase = this.context.maybeCreateCase(continueCase);
            TranspilationContext.Case endCase = this.context.maybeCreateCase(breakCase);
            this.context.switchCaseTo(startCase);
            if (!condition.isEmpty()) {
                condition = this.prepareNodeForWrite(this.maybeDecomposeExpression(condition.detach()));
                this.context.writeGeneratedNode(IR.ifNode(Es6ToEs3Util.withType(IR.not(condition), Es6RewriteGenerators.this.booleanType).useSourceInfoFrom(condition), this.context.createJumpToBlock(endCase, true, n)).useSourceInfoFrom(n));
            }
            this.context.pushBreakContinueContext(endCase, incrementCase);
            this.transpileStatement(body.detach());
            this.context.popBreakContinueContext();
            this.context.switchCaseTo(incrementCase);
            if (!increment.isEmpty()) {
                increment = this.maybeDecomposeExpression(increment.detach());
                this.transpileUnmarkedNode(IR.exprResult(increment).useSourceInfoFrom(increment));
            }
            this.context.writeJumpTo(startCase, n);
            this.context.switchCaseTo(endCase);
        }

        void transpileForIn(Node n, @Nullable TranspilationContext.Case breakCase, @Nullable TranspilationContext.Case continueCase) {
            Node init;
            Node detachedExpr = this.maybeDecomposeExpression(n.getSecondChild().detach());
            Node target = n.getFirstChild();
            Node body = n.getSecondChild();
            if (!target.isGeneratorMarker() && !body.isGeneratorMarker()) {
                n.addChildAfter(detachedExpr, target);
                n.setGeneratorMarker(false);
                this.transpileUnmarkedNode(n);
                return;
            }
            if (target.detach().isVar()) {
                Preconditions.checkState(!target.isGeneratorMarker());
                init = target;
                Preconditions.checkState(!init.getFirstChild().hasChildren());
                target = init.getFirstChild().cloneNode();
            } else {
                init = new Node(Token.VAR).useSourceInfoFrom(target);
            }
            Node forIn = this.context.getScopedName(Es6RewriteGenerators.GENERATOR_FORIN_PREFIX + Es6RewriteGenerators.this.compiler.getUniqueNameIdSupplier().get()).useSourceInfoFrom(target);
            forIn.addChildToFront(this.context.callContextMethod(target, "forIn", detachedExpr));
            ObjectType propertyIteratorType = Es6RewriteGenerators.this.shouldAddTypes ? forIn.getFirstChild().getJSType().toMaybeObjectType() : null;
            forIn.setJSType(propertyIteratorType);
            init.addChildToBack(forIn);
            Node forInGetNext = Es6ToEs3Util.withType(IR.getprop(forIn.cloneNode(), IR.string("getNext").useSourceInfoFrom(detachedExpr)), Es6RewriteGenerators.this.shouldAddTypes ? propertyIteratorType.getPropertyType("getNext") : null).useSourceInfoFrom(detachedExpr);
            Node forCond = Es6ToEs3Util.withType(IR.ne(Es6ToEs3Util.withType(IR.assign(Es6ToEs3Util.withType(target, Es6RewriteGenerators.this.nullableStringType), Es6ToEs3Util.withType(IR.call(forInGetNext, new Node[0]), Es6RewriteGenerators.this.nullableStringType).useSourceInfoFrom(detachedExpr)), Es6RewriteGenerators.this.nullableStringType).useSourceInfoFrom(detachedExpr), Es6ToEs3Util.withType(IR.nullNode(), Es6RewriteGenerators.this.nullType).useSourceInfoFrom(forIn)), Es6RewriteGenerators.this.booleanType).useSourceInfoFrom(detachedExpr);
            forCond.setGeneratorMarker(target.isGeneratorMarker());
            Node forNode = IR.forNode(init, forCond, IR.empty().useSourceInfoFrom(n), body.detach()).useSourceInfoFrom(n);
            this.transpileFor(forNode, breakCase, continueCase);
        }

        void transpileWhile(Node n, @Nullable TranspilationContext.Case breakCase, @Nullable TranspilationContext.Case continueCase) {
            TranspilationContext.Case startCase = this.context.maybeCreateCase(continueCase);
            TranspilationContext.Case endCase = this.context.maybeCreateCase(breakCase);
            this.context.switchCaseTo(startCase);
            Node condition = this.prepareNodeForWrite(this.maybeDecomposeExpression(n.removeFirstChild()));
            Node body = n.removeFirstChild();
            this.context.writeGeneratedNode(IR.ifNode(Es6ToEs3Util.withType(IR.not(condition), Es6RewriteGenerators.this.booleanType).useSourceInfoFrom(condition), this.context.createJumpToBlock(endCase, true, n)).useSourceInfoFrom(n));
            this.context.pushBreakContinueContext(endCase, startCase);
            this.transpileStatement(body);
            this.context.popBreakContinueContext();
            this.context.writeJumpTo(startCase, n);
            this.context.switchCaseTo(endCase);
        }

        void transpileDo(Node n, @Nullable TranspilationContext.Case breakCase, @Nullable TranspilationContext.Case continueCase) {
            TranspilationContext.Case startCase = this.context.createCase();
            breakCase = this.context.maybeCreateCase(breakCase);
            continueCase = this.context.maybeCreateCase(continueCase);
            this.context.switchCaseTo(startCase);
            Node body = n.removeFirstChild();
            this.context.pushBreakContinueContext(breakCase, continueCase);
            this.transpileStatement(body);
            this.context.popBreakContinueContext();
            this.context.switchCaseTo(continueCase);
            Node condition = this.prepareNodeForWrite(this.maybeDecomposeExpression(n.removeFirstChild()));
            this.context.writeGeneratedNode(IR.ifNode(condition, this.context.createJumpToBlock(startCase, false, n)).useSourceInfoFrom(n));
            this.context.switchCaseTo(breakCase);
        }

        void transpileTry(Node n, @Nullable TranspilationContext.Case breakCase) {
            Node tryBlock = n.removeFirstChild();
            Node catchBlock = n.removeFirstChild();
            Node finallyBlock = n.removeFirstChild();
            TranspilationContext.Case catchCase = catchBlock.hasChildren() ? this.context.createCase() : null;
            TranspilationContext.Case finallyCase = finallyBlock == null ? null : this.context.createCase();
            TranspilationContext.Case endCase = this.context.maybeCreateCase(breakCase);
            this.context.enterTryBlock(catchCase, finallyCase, tryBlock);
            this.transpileStatement(tryBlock);
            if (finallyBlock == null) {
                this.context.leaveTryBlock(catchCase, endCase, tryBlock);
            } else {
                this.context.switchCaseTo(finallyCase);
                this.context.enterFinallyBlock(catchCase, finallyCase, finallyBlock);
                this.transpileStatement(finallyBlock);
                this.context.leaveFinallyBlock(endCase, finallyBlock);
            }
            if (catchBlock.hasChildren()) {
                Preconditions.checkState(catchBlock.getFirstChild().isCatch());
                this.context.switchCaseTo(catchCase);
                Node exceptionName = catchBlock.getFirstFirstChild().detach();
                this.context.enterCatchBlock(finallyCase, exceptionName);
                Node catchBody = catchBlock.getFirstFirstChild().detach();
                Preconditions.checkState(catchBody.isBlock());
                this.transpileStatement(catchBody);
                this.context.leaveCatchBlock(finallyCase, catchBody);
            }
            this.context.switchCaseTo(endCase);
        }

        void transpileSwitch(Node n, @Nullable TranspilationContext.Case breakCase) {
            n.addChildToFront(this.maybeDecomposeExpression(n.removeFirstChild()));
            boolean hasGeneratorMarker = false;
            for (Node caseSection = n.getSecondChild(); caseSection != null; caseSection = caseSection.getNext()) {
                if (!caseSection.isGeneratorMarker()) continue;
                hasGeneratorMarker = true;
                break;
            }
            if (!hasGeneratorMarker) {
                n.setGeneratorMarker(false);
                this.transpileUnmarkedNode(n);
                return;
            }
            class SwitchCase {
                private final TranspilationContext.Case generatedCase;
                private final Node body;

                SwitchCase(TranspilationContext.Case generatedCase, Node caseNode) {
                    this.generatedCase = generatedCase;
                    this.body = caseNode;
                }
            }
            ArrayList<SwitchCase> detachedCases = new ArrayList<SwitchCase>();
            boolean canSkipUnmarkedCases = true;
            for (Node caseSection = n.getSecondChild(); caseSection != null; caseSection = caseSection.getNext()) {
                if (!caseSection.isDefaultCase() && caseSection.getFirstChild().isGeneratorMarker()) {
                    Es6RewriteGenerators.this.compiler.report(JSError.make(n, Es6ToEs3Util.CANNOT_CONVERT_YET, "Case statements that contain yields"));
                    return;
                }
                Node body = caseSection.getLastChild();
                if (!body.hasChildren() || canSkipUnmarkedCases && !body.isGeneratorMarker()) continue;
                canSkipUnmarkedCases = this.isEndOfBlockUnreachable(body);
                TranspilationContext.Case generatedCase = this.context.createCase();
                generatedCase.caseBlock.useSourceInfoFrom(body);
                Node newBody = IR.block(this.context.createJumpToNode(generatedCase, body));
                newBody.setIsAddedBlock(true);
                newBody.setGeneratorSafe(true);
                body.replaceWith(newBody);
                detachedCases.add(new SwitchCase(generatedCase, body));
                caseSection.setGeneratorMarker(false);
            }
            TranspilationContext.Case endCase = this.context.maybeCreateCase(breakCase);
            n.setGeneratorMarker(false);
            this.transpileUnmarkedNode(n);
            this.context.writeJumpTo(endCase, n);
            this.context.pushBreakContext(endCase);
            for (SwitchCase detachedCase : detachedCases) {
                TranspilationContext.Case generatedCase = detachedCase.generatedCase;
                this.context.switchCaseTo(generatedCase);
                this.transpileStatement(detachedCase.body);
            }
            this.context.popBreakContext();
            this.context.switchCaseTo(endCase);
        }

        Node findYield(Node n) {
            YieldFinder yieldFinder = new YieldFinder();
            NodeTraversal.traverse(Es6RewriteGenerators.this.compiler, n, yieldFinder);
            return yieldFinder.getYieldNode();
        }

        private boolean isEndOfBlockUnreachable(Node block) {
            Preconditions.checkState(block.isBlock());
            if (!block.hasChildren()) {
                return false;
            }
            switch (block.getLastChild().getToken()) {
                case BLOCK: {
                    return this.isEndOfBlockUnreachable(block.getLastChild());
                }
                case RETURN: 
                case THROW: 
                case CONTINUE: 
                case BREAK: {
                    return true;
                }
            }
            return false;
        }

        private class TranspilationContext {
            final HashMap<String, LabelCases> namedLabels = new HashMap();
            final ArrayDeque<Case> breakCases = new ArrayDeque();
            final ArrayDeque<Case> continueCases = new ArrayDeque();
            final ArrayDeque<CatchCase> catchCases = new ArrayDeque();
            final ArrayDeque<Case> finallyCases = new ArrayDeque();
            final HashSet<String> catchNames = new HashSet();
            final ArrayList<Case> allCases = new ArrayList();
            final ArrayList<Node> switchBreaks = new ArrayList();
            final Case programEndCase = new Case();
            int caseIdCounter;
            Case currentCase;
            int nestedFinallyBlockCount = 0;
            boolean thisReferenceFound;
            boolean argumentsReferenceFound;
            final ObjectType contextType;

            TranspilationContext(ObjectType contextType) {
                Preconditions.checkState(this.programEndCase.id == 0);
                this.currentCase = new Case();
                Preconditions.checkState(this.currentCase.id == 1);
                this.allCases.add(this.currentCase);
                this.contextType = contextType;
            }

            void optimizeCaseIds() {
                Preconditions.checkState(!this.allCases.isEmpty(), this.allCases);
                for (Case currentCase : this.allCases) {
                    if (currentCase.jumpTo == null) continue;
                    while (currentCase.jumpTo.jumpTo != null) {
                        currentCase.jumpTo = currentCase.jumpTo.jumpTo;
                    }
                    if (currentCase.embedInto != null && currentCase.references.size() == 1) {
                        currentCase.jumpTo.embedInto = currentCase.embedInto;
                    }
                    currentCase.embedInto = null;
                    for (Node reference : currentCase.references) {
                        reference.setDouble(currentCase.jumpTo.id);
                    }
                    currentCase.jumpTo.references.addAll(currentCase.references);
                    currentCase.references.clear();
                }
                Iterator<Case> it = this.allCases.iterator();
                Case prevCase = it.next();
                Preconditions.checkState(prevCase.id == 1);
                while (it.hasNext()) {
                    Case currentCase = it.next();
                    if (currentCase.references.isEmpty()) {
                        Preconditions.checkState(currentCase.embedInto == null);
                        if (prevCase.mayFallThrough) {
                            prevCase.caseBlock.addChildrenToBack(currentCase.caseBlock.removeChildren());
                            prevCase.mayFallThrough = currentCase.mayFallThrough;
                        }
                        it.remove();
                        continue;
                    }
                    if (currentCase.embedInto != null) {
                        Preconditions.checkState(currentCase.jumpTo == null);
                        if (currentCase.references.size() == 1 && !currentCase.mayFallThrough) {
                            currentCase.embedInto.replaceWith(currentCase.caseBlock);
                            it.remove();
                            continue;
                        }
                    }
                    if (prevCase.jumpTo == currentCase) {
                        Preconditions.checkState(prevCase.mayFallThrough);
                        Preconditions.checkState(!prevCase.caseBlock.hasChildren());
                        Preconditions.checkState(currentCase.jumpTo == null);
                        prevCase.caseBlock.addChildrenToBack(currentCase.caseBlock.removeChildren());
                        prevCase.mayFallThrough = currentCase.mayFallThrough;
                        for (Node reference : currentCase.references) {
                            reference.setDouble(prevCase.id);
                        }
                        prevCase.jumpTo = currentCase.jumpTo;
                        prevCase.references.addAll(currentCase.references);
                        it.remove();
                        continue;
                    }
                    prevCase = currentCase;
                }
            }

            void eliminateSwitchBreaks() {
                for (Node breakNode : this.switchBreaks) {
                    Node prevStatement = breakNode.getPrevious();
                    Preconditions.checkState(prevStatement != null);
                    Preconditions.checkState(prevStatement.isExprResult());
                    prevStatement.replaceWith(IR.returnNode(prevStatement.removeFirstChild()));
                    breakNode.detach();
                }
                this.switchBreaks.clear();
            }

            public void finalizeTransformation(Node generatorBody) {
                this.optimizeCaseIds();
                if (this.allCases.size() == 2 || this.allCases.size() == 3) {
                    generatorBody.addChildToBack(IR.ifNode(Es6ToEs3Util.withType(IR.eq(this.getContextField(generatorBody, "nextAddress"), Es6ToEs3Util.withType(IR.number(1.0), Es6RewriteGenerators.this.numberType)), Es6RewriteGenerators.this.booleanType), this.allCases.remove((int)0).caseBlock).useSourceInfoIfMissingFromForTree(generatorBody));
                }
                if (this.allCases.size() == 2) {
                    generatorBody.addChildToBack(IR.ifNode(Es6ToEs3Util.withType(IR.ne(this.getContextField(generatorBody, "nextAddress"), Es6ToEs3Util.withType(IR.number(this.allCases.get((int)1).id), Es6RewriteGenerators.this.numberType)), Es6RewriteGenerators.this.booleanType), this.allCases.remove((int)0).caseBlock).useSourceInfoIfMissingFromForTree(generatorBody));
                }
                if (this.allCases.size() == 1) {
                    generatorBody.addChildrenToBack(this.allCases.remove((int)0).caseBlock.removeChildren());
                    this.eliminateSwitchBreaks();
                    return;
                }
                Node switchNode = IR.switchNode(this.getContextField(generatorBody, "nextAddress"), new Node[0]).useSourceInfoFrom(generatorBody);
                generatorBody.addChildToBack(switchNode);
                for (Case currentCase : this.allCases) {
                    switchNode.addChildToBack(currentCase.createCaseNode());
                }
                this.allCases.clear();
            }

            public void checkStateIsEmpty() {
                Preconditions.checkState(this.namedLabels.isEmpty());
                Preconditions.checkState(this.breakCases.isEmpty());
                Preconditions.checkState(this.continueCases.isEmpty());
                Preconditions.checkState(this.catchCases.isEmpty());
                Preconditions.checkState(this.finallyCases.isEmpty());
                Preconditions.checkState(this.nestedFinallyBlockCount == 0);
                Preconditions.checkState(this.allCases.isEmpty());
            }

            void transpileUnmarkedBlock(Node block) {
                if (block.hasChildren()) {
                    NodeTraversal.traverse(Es6RewriteGenerators.this.compiler, block, new UnmarkedNodeTranspiler());
                    while (block.hasChildren()) {
                        this.writeGeneratedNode(block.removeFirstChild());
                    }
                }
            }

            void writeGeneratedNode(Node n) {
                this.currentCase.addNode(n);
            }

            void writeGeneratedNodeAndBreak(Node n) {
                this.writeGeneratedNode(n);
                this.writeGeneratedNode(this.createBreakNodeFor(n));
                this.currentCase.mayFallThrough = false;
            }

            Case createCase() {
                return new Case();
            }

            Case maybeCreateCase(@Nullable Case other) {
                if (other != null) {
                    return other;
                }
                return this.createCase();
            }

            Node getJsContextNameNode(Node sourceNode) {
                return Es6ToEs3Util.withType(this.getScopedName(Es6RewriteGenerators.GENERATOR_CONTEXT), this.contextType).useSourceInfoFrom(sourceNode);
            }

            Node getScopedName(String name) {
                return IR.name(name + (SingleGeneratorFunctionTranspiler.this.generatorNestingLevel == 0 ? "" : "$" + SingleGeneratorFunctionTranspiler.this.generatorNestingLevel));
            }

            Node getContextField(Node sourceNode, String fieldName) {
                return Es6ToEs3Util.withType(IR.getprop(this.getJsContextNameNode(sourceNode), IR.string(fieldName).useSourceInfoFrom(sourceNode)), Es6RewriteGenerators.this.shouldAddTypes ? this.contextType.getPropertyType(fieldName) : null).useSourceInfoFrom(sourceNode);
            }

            Node callContextMethod(Node sourceNode, String methodName, Node ... args) {
                Node contextField = this.getContextField(sourceNode, methodName);
                Node callNode = IR.call(contextField, args).useSourceInfoFrom(sourceNode);
                if (Es6RewriteGenerators.this.shouldAddTypes) {
                    callNode.setJSType(contextField.getJSType().isFunctionType() ? contextField.getJSType().toMaybeFunctionType().getReturnType() : Es6RewriteGenerators.this.unknownType);
                }
                return callNode;
            }

            Node callContextMethodResult(Node sourceNode, String methodName, Node ... args) {
                return IR.exprResult(this.callContextMethod(sourceNode, methodName, args)).useSourceInfoFrom(sourceNode);
            }

            Node returnContextMethod(Node sourceNode, String methodName, Node ... args) {
                return IR.returnNode(this.callContextMethod(sourceNode, methodName, args)).useSourceInfoFrom(sourceNode);
            }

            Node createBreakNodeFor(Node preBreak) {
                Node breakNode = IR.breakNode().useSourceInfoFrom(preBreak);
                this.switchBreaks.add(breakNode);
                return breakNode;
            }

            Node createJumpToNode(Case section, Node sourceNode) {
                return this.returnContextMethod(sourceNode, "jumpTo", section.getNumber(sourceNode));
            }

            void writeJumpTo(Case section, Node sourceNode) {
                this.currentCase.jumpTo(section, this.createJumpToBlock(section, false, sourceNode));
            }

            Node createJumpToBlock(Case section, boolean allowEmbedding, Node sourceNode) {
                Preconditions.checkState(section.embedInto == null);
                Node jumpBlock = IR.block(this.callContextMethodResult(sourceNode, "jumpTo", section.getNumber(sourceNode)), this.createBreakNodeFor(sourceNode)).useSourceInfoFrom(sourceNode);
                if (allowEmbedding) {
                    section.embedInto = jumpBlock;
                }
                return jumpBlock;
            }

            void replaceBreakContinueWithJump(Node sourceNode, Case section, int breakSuppressors) {
                String jumpMethod;
                if (this.finallyCases.isEmpty() || this.finallyCases.getFirst().id < section.id) {
                    jumpMethod = "jumpTo";
                } else {
                    Preconditions.checkState(this.finallyCases.getFirst().id != section.id);
                    jumpMethod = "jumpThroughFinallyBlocks";
                }
                if (breakSuppressors == 0) {
                    sourceNode.getParent().addChildBefore(this.callContextMethodResult(sourceNode, jumpMethod, section.getNumber(sourceNode)), sourceNode);
                    sourceNode.replaceWith(this.createBreakNodeFor(sourceNode));
                } else {
                    sourceNode.replaceWith(this.returnContextMethod(sourceNode, jumpMethod, section.getNumber(sourceNode)));
                }
            }

            void yield(@Nullable Node expression, Case jumpToSection, Node sourceNode) {
                ArrayList<Node> args = new ArrayList<Node>();
                args.add(expression == null ? Es6ToEs3Util.withType(IR.name("undefined"), Es6RewriteGenerators.this.voidType).useSourceInfoFrom(sourceNode) : expression);
                args.add(jumpToSection.getNumber(sourceNode));
                SingleGeneratorFunctionTranspiler.this.context.writeGeneratedNode(this.returnContextMethod(sourceNode, "yield", args.toArray(new Node[0])));
                SingleGeneratorFunctionTranspiler.this.context.currentCase.mayFallThrough = false;
            }

            void yieldAll(Node expression, Case jumpToSection, Node sourceNode) {
                this.writeGeneratedNode(this.returnContextMethod(sourceNode, "yieldAll", expression, jumpToSection.getNumber(sourceNode)));
                SingleGeneratorFunctionTranspiler.this.context.currentCase.mayFallThrough = false;
            }

            Node returnExpression(Node sourceNode, @Nullable Node expression) {
                if (expression == null) {
                    return this.callContextMethod(sourceNode, "return", new Node[0]);
                }
                return this.callContextMethod(sourceNode, "return", expression);
            }

            Node yieldResult(Node sourceNode) {
                return this.getContextField(sourceNode, "yieldResult");
            }

            private void addCatchFinallyCases(@Nullable Case catchCase, @Nullable Case finallyCase) {
                if (finallyCase != null) {
                    if (!this.catchCases.isEmpty()) {
                        ++this.catchCases.getFirst().finallyBlocks;
                    }
                    this.finallyCases.addFirst(finallyCase);
                }
                if (catchCase != null) {
                    this.catchCases.addFirst(new CatchCase(catchCase));
                }
            }

            @Nullable
            private Case getNextCatchCase() {
                Iterator<CatchCase> iterator = this.catchCases.iterator();
                if (iterator.hasNext()) {
                    CatchCase catchCase = iterator.next();
                    if (catchCase.finallyBlocks == 0) {
                        return catchCase.catchCase;
                    }
                }
                return null;
            }

            @Nullable
            private Case getNextFinallyCase() {
                return this.finallyCases.isEmpty() ? null : this.finallyCases.getFirst();
            }

            private void removeCatchFinallyCases(@Nullable Case catchCase, @Nullable Case finallyCase) {
                if (catchCase != null) {
                    CatchCase lastCatch = this.catchCases.removeFirst();
                    Preconditions.checkState(lastCatch.finallyBlocks == 0);
                    Preconditions.checkState(lastCatch.catchCase == catchCase);
                }
                if (finallyCase != null) {
                    Case lastFinally;
                    if (!this.catchCases.isEmpty()) {
                        int finallyBlocks;
                        Preconditions.checkState((finallyBlocks = --this.catchCases.getFirst().finallyBlocks) >= 0);
                    }
                    Preconditions.checkState((lastFinally = this.finallyCases.removeFirst()) == finallyCase);
                }
            }

            void enterTryBlock(@Nullable Case catchCase, @Nullable Case finallyCase, Node sourceNode) {
                String methodName;
                this.addCatchFinallyCases(catchCase, finallyCase);
                ArrayList<Node> args = new ArrayList<Node>();
                if (catchCase == null) {
                    methodName = "setFinallyBlock";
                    args.add(finallyCase.getNumber(sourceNode));
                } else {
                    methodName = "setCatchFinallyBlocks";
                    args.add(catchCase.getNumber(sourceNode));
                    if (finallyCase != null) {
                        args.add(finallyCase.getNumber(sourceNode));
                    }
                }
                this.writeGeneratedNode(this.callContextMethodResult(sourceNode, methodName, args.toArray(new Node[0])));
            }

            void leaveTryBlock(@Nullable Case catchCase, Case endCase, Node sourceNode) {
                this.removeCatchFinallyCases(catchCase, null);
                ArrayList<Node> args = new ArrayList<Node>();
                args.add(endCase.getNumber(sourceNode));
                Case nextCatchCase = this.getNextCatchCase();
                if (nextCatchCase != null) {
                    args.add(nextCatchCase.getNumber(sourceNode));
                }
                this.writeGeneratedNodeAndBreak(this.callContextMethodResult(sourceNode, "leaveTryBlock", args.toArray(new Node[0])));
            }

            void enterCatchBlock(@Nullable Case finallyCase, Node exceptionName) {
                Preconditions.checkState(exceptionName.isName());
                this.addCatchFinallyCases(null, finallyCase);
                Case nextCatchCase = this.getNextCatchCase();
                if (this.catchNames.add(exceptionName.getString())) {
                    SingleGeneratorFunctionTranspiler.this.hoistNode(IR.var(exceptionName.cloneNode()).useSourceInfoFrom(exceptionName));
                }
                ArrayList<Node> args = new ArrayList<Node>();
                if (nextCatchCase != null) {
                    args.add(nextCatchCase.getNumber(exceptionName));
                }
                Node enterCatchBlockCall = this.callContextMethod(exceptionName, "enterCatchBlock", args.toArray(new Node[0]));
                exceptionName.setJSType(enterCatchBlockCall.getJSType());
                this.writeGeneratedNode(IR.exprResult(Es6ToEs3Util.withType(IR.assign(exceptionName, enterCatchBlockCall), enterCatchBlockCall.getJSType()).useSourceInfoFrom(exceptionName)).useSourceInfoFrom(exceptionName));
            }

            void leaveCatchBlock(@Nullable Case finallyCase, Node sourceNode) {
                if (finallyCase != null) {
                    this.removeCatchFinallyCases(null, finallyCase);
                    this.writeJumpTo(finallyCase, sourceNode);
                }
            }

            void enterFinallyBlock(@Nullable Case catchCase, @Nullable Case finallyCase, Node sourceNode) {
                this.removeCatchFinallyCases(catchCase, finallyCase);
                Case nextCatchCase = this.getNextCatchCase();
                Case nextFinallyCase = this.getNextFinallyCase();
                ArrayList<Node> args = new ArrayList<Node>();
                if (this.nestedFinallyBlockCount == 0) {
                    if (nextCatchCase != null || nextFinallyCase != null) {
                        args.add(nextCatchCase == null ? Es6ToEs3Util.withType(IR.number(0.0), Es6RewriteGenerators.this.numberType).useSourceInfoFrom(sourceNode) : nextCatchCase.getNumber(sourceNode));
                        if (nextFinallyCase != null) {
                            args.add(nextFinallyCase.getNumber(sourceNode));
                        }
                    }
                } else {
                    args.add(nextCatchCase == null ? Es6ToEs3Util.withType(IR.number(0.0), Es6RewriteGenerators.this.numberType).useSourceInfoFrom(sourceNode) : nextCatchCase.getNumber(sourceNode));
                    args.add(nextFinallyCase == null ? Es6ToEs3Util.withType(IR.number(0.0), Es6RewriteGenerators.this.numberType).useSourceInfoFrom(sourceNode) : nextFinallyCase.getNumber(sourceNode));
                    args.add(IR.number(this.nestedFinallyBlockCount).useSourceInfoFrom(sourceNode));
                }
                this.writeGeneratedNode(this.callContextMethodResult(sourceNode, "enterFinallyBlock", args.toArray(new Node[0])));
                ++this.nestedFinallyBlockCount;
            }

            void leaveFinallyBlock(Case endCase, Node sourceNode) {
                ArrayList<Node> args = new ArrayList<Node>();
                args.add(endCase.getNumber(sourceNode));
                if (--this.nestedFinallyBlockCount != 0) {
                    args.add(IR.number(this.nestedFinallyBlockCount).useSourceInfoFrom(sourceNode));
                }
                this.writeGeneratedNodeAndBreak(this.callContextMethodResult(sourceNode, "leaveFinallyBlock", args.toArray(new Node[0])));
            }

            void switchCaseTo(Case caseSection) {
                this.currentCase.willFollowBy(caseSection);
                this.allCases.add(caseSection);
                this.currentCase = caseSection;
            }

            public void pushLabels(ArrayList<Node> labelNames, Case breakCase, @Nullable Case continueCase) {
                for (Node labelName : labelNames) {
                    Preconditions.checkState(labelName.isLabelName());
                    this.namedLabels.put(labelName.getString(), new LabelCases(breakCase, continueCase));
                }
            }

            public void popLabels(ArrayList<Node> labelNames) {
                for (Node labelName : labelNames) {
                    Preconditions.checkState(labelName.isLabelName());
                    this.namedLabels.remove(labelName.getString());
                }
            }

            public void pushBreakContext(Case breakCase) {
                this.breakCases.push(breakCase);
            }

            public void pushBreakContinueContext(Case breakCase, Case continueCase) {
                this.pushBreakContext(breakCase);
                this.continueCases.push(continueCase);
            }

            public void popBreakContext() {
                this.breakCases.pop();
            }

            public void popBreakContinueContext() {
                this.popBreakContext();
                this.continueCases.pop();
            }

            class LabelCases {
                final Case breakCase;
                @Nullable
                final Case continueCase;

                LabelCases(@Nullable Case breakCase, Case continueCase) {
                    this.breakCase = breakCase;
                    this.continueCase = continueCase;
                }
            }

            class CatchCase {
                final Case catchCase;
                int finallyBlocks;

                CatchCase(Case catchCase) {
                    this.catchCase = catchCase;
                }
            }

            private class UnmarkedNodeTranspiler
            implements NodeTraversal.Callback {
                int breakSuppressors;
                int continueSuppressors;

                private UnmarkedNodeTranspiler() {
                }

                @Override
                public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
                    if (n.isGeneratorSafe()) {
                        n.setGeneratorSafe(false);
                        return false;
                    }
                    Preconditions.checkState(!n.isGeneratorMarker());
                    Preconditions.checkState(!n.isSuper(), "Reference to SUPER is not supported");
                    if (NodeUtil.isLoopStructure(n)) {
                        ++this.continueSuppressors;
                        ++this.breakSuppressors;
                    } else if (n.isSwitch()) {
                        ++this.breakSuppressors;
                    }
                    if (n.isBreak() || n.isContinue()) {
                        if (n.hasChildren()) {
                            this.visitNamedBreakContinue(n);
                        } else {
                            this.visitBreakContinue(n);
                        }
                        return false;
                    }
                    return !n.isFunction();
                }

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    if (NodeUtil.isLoopStructure(n)) {
                        --this.continueSuppressors;
                        --this.breakSuppressors;
                    } else if (n.isSwitch()) {
                        --this.breakSuppressors;
                    } else if (n.isThis()) {
                        this.visitThis(n);
                    } else if (n.isReturn()) {
                        this.visitReturn(n);
                    } else if (n.isName() && n.getString().equals("arguments")) {
                        this.visitArguments(n);
                    } else if (n.isVar()) {
                        if (parent.isVanillaFor()) {
                            this.visitVanillaForLoopVar(n);
                        } else if (parent.isForIn()) {
                            this.visitForInLoopVar(n);
                        } else {
                            this.visitVarStatement(n);
                        }
                    }
                }

                void visitReturn(Node n) {
                    n.addChildToFront(TranspilationContext.this.returnExpression(n, n.removeFirstChild()));
                }

                void visitNamedBreakContinue(Node n) {
                    Preconditions.checkState(n.getFirstChild().isLabelName());
                    LabelCases cases = TranspilationContext.this.namedLabels.get(n.getFirstChild().getString());
                    if (cases != null) {
                        Case caseSection = n.isBreak() ? cases.breakCase : cases.continueCase;
                        SingleGeneratorFunctionTranspiler.this.context.replaceBreakContinueWithJump(n, caseSection, this.breakSuppressors);
                    }
                }

                void visitBreakContinue(Node n) {
                    Case caseSection = null;
                    if (n.isBreak() && this.breakSuppressors == 0) {
                        caseSection = TranspilationContext.this.breakCases.getFirst();
                    }
                    if (n.isContinue() && this.continueSuppressors == 0) {
                        caseSection = TranspilationContext.this.continueCases.getFirst();
                    }
                    if (caseSection != null) {
                        SingleGeneratorFunctionTranspiler.this.context.replaceBreakContinueWithJump(n, caseSection, this.breakSuppressors);
                    }
                }

                void visitThis(Node n) {
                    Node newThis = Es6ToEs3Util.withType(SingleGeneratorFunctionTranspiler.this.context.getScopedName(Es6RewriteGenerators.GENERATOR_THIS), n.getJSType());
                    n.replaceWith(newThis);
                    if (!TranspilationContext.this.thisReferenceFound) {
                        Node var = IR.var(newThis.cloneNode().useSourceInfoFrom(n), n).useSourceInfoFrom(SingleGeneratorFunctionTranspiler.this.newGeneratorHoistBlock);
                        SingleGeneratorFunctionTranspiler.this.hoistNode(var);
                        TranspilationContext.this.thisReferenceFound = true;
                    }
                }

                void visitArguments(Node n) {
                    Node newArguments = SingleGeneratorFunctionTranspiler.this.context.getScopedName(Es6RewriteGenerators.GENERATOR_ARGUMENTS).useSourceInfoFrom(n);
                    n.replaceWith(newArguments);
                    if (!TranspilationContext.this.argumentsReferenceFound) {
                        Node var = IR.var(newArguments.cloneNode(), n).useSourceInfoFrom(SingleGeneratorFunctionTranspiler.this.newGeneratorHoistBlock);
                        SingleGeneratorFunctionTranspiler.this.hoistNode(var);
                        TranspilationContext.this.argumentsReferenceFound = true;
                    }
                }

                void visitVarStatement(Node varStatement) {
                    Node commaExpression = this.extractAssignmentsToCommaExpression(varStatement);
                    if (commaExpression == null) {
                        varStatement.detach();
                    } else {
                        varStatement.replaceWith(IR.exprResult(commaExpression));
                    }
                    SingleGeneratorFunctionTranspiler.this.hoistNode(varStatement);
                }

                private void visitVanillaForLoopVar(Node varDeclaration) {
                    Node commaExpression = this.extractAssignmentsToCommaExpression(varDeclaration);
                    if (commaExpression == null) {
                        varDeclaration.replaceWith(IR.empty());
                    } else {
                        varDeclaration.replaceWith(commaExpression);
                    }
                    SingleGeneratorFunctionTranspiler.this.hoistNode(varDeclaration);
                }

                private void visitForInLoopVar(Node varDeclaration) {
                    Node varName = varDeclaration.getOnlyChild();
                    Preconditions.checkState(!varName.hasChildren(), varName);
                    Node clonedVarName = varName.cloneNode().setJSDocInfo(null);
                    varDeclaration.replaceWith(clonedVarName);
                    SingleGeneratorFunctionTranspiler.this.hoistNode(varDeclaration);
                }

                @Nullable
                private Node extractAssignmentsToCommaExpression(Node varDeclaration) {
                    ArrayList<Node> assignments = new ArrayList<Node>();
                    for (Node varName : varDeclaration.children()) {
                        if (!varName.hasChildren()) continue;
                        Node copiedVarName = varName.cloneNode().setJSDocInfo(null);
                        Node assign = Es6ToEs3Util.withType(IR.assign(copiedVarName, varName.removeFirstChild()), varName.getJSType()).useSourceInfoFrom(varName);
                        assignments.add(assign);
                    }
                    Node commaExpression = null;
                    for (Node assignment : assignments) {
                        commaExpression = commaExpression == null ? assignment : Es6ToEs3Util.withType(IR.comma(commaExpression, assignment), assignment.getJSType()).useSourceInfoFrom(assignment);
                    }
                    return commaExpression;
                }
            }

            private class Case {
                final int id;
                final Node caseBlock;
                final ArrayList<Node> references = new ArrayList();
                @Nullable
                Case jumpTo;
                @Nullable
                Node embedInto;
                boolean mayFallThrough = true;

                Case() {
                    this.id = TranspilationContext.this.caseIdCounter++;
                    this.caseBlock = IR.block().useSourceInfoFrom(SingleGeneratorFunctionTranspiler.this.originalGeneratorBody);
                }

                Node createCaseNode() {
                    return IR.caseNode(Es6ToEs3Util.withType(IR.number(this.id), Es6RewriteGenerators.this.numberType).useSourceInfoFrom(this.caseBlock), this.caseBlock).useSourceInfoFrom(this.caseBlock);
                }

                Node getNumber(Node sourceNode) {
                    if (this.jumpTo != null) {
                        return this.jumpTo.getNumber(sourceNode);
                    }
                    Node node = Es6ToEs3Util.withType(IR.number(this.id), Es6RewriteGenerators.this.numberType).useSourceInfoFrom(sourceNode);
                    this.references.add(node);
                    return node;
                }

                void jumpTo(Case other, Node jumpBlock) {
                    Preconditions.checkState(jumpBlock.isBlock());
                    Preconditions.checkState(this.jumpTo == null);
                    this.willFollowBy(other);
                    this.caseBlock.addChildrenToBack(jumpBlock.removeChildren());
                    this.mayFallThrough = false;
                }

                void willFollowBy(Case other) {
                    if (this.jumpTo == null && !this.caseBlock.hasChildren()) {
                        Preconditions.checkState(other.jumpTo == null);
                        this.jumpTo = other;
                    }
                }

                void addNode(Node n) {
                    Preconditions.checkState(this.jumpTo == null);
                    Preconditions.checkState(IR.mayBeStatement(n));
                    this.caseBlock.addChildToBack(n);
                }
            }
        }

        private class YieldFinder
        extends NodeTraversal.AbstractPreOrderCallback {
            private Node yieldNode;

            private YieldFinder() {
            }

            @Override
            public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
                if (n.isFunction()) {
                    return false;
                }
                if (n.isYield()) {
                    Preconditions.checkState(this.yieldNode == null);
                    this.yieldNode = n;
                    return false;
                }
                return true;
            }

            Node getYieldNode() {
                Preconditions.checkNotNull(this.yieldNode);
                return this.yieldNode;
            }
        }
    }

    private class GeneratorFunctionsTranspiler
    implements NodeTraversal.Callback {
        int generatorNestingLevel = 0;

        private GeneratorFunctionsTranspiler() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            if (n.isGeneratorFunction()) {
                ++this.generatorNestingLevel;
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGeneratorFunction()) {
                new SingleGeneratorFunctionTranspiler(n, --this.generatorNestingLevel).transpile();
            }
        }
    }

    private class YieldExposer
    extends NodeTraversal.AbstractPreOrderCallback {
        final ExpressionDecomposer decomposer;

        YieldExposer() {
            this.decomposer = new ExpressionDecomposer(Es6RewriteGenerators.this.compiler, Es6RewriteGenerators.this.compiler.getUniqueNameIdSupplier(), new HashSet<String>(), Scope.createGlobalScope(new Node(Token.SCRIPT)), true);
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            n.setGeneratorMarker(false);
            if (n.isFunction()) {
                return false;
            }
            if (n.isYield()) {
                this.visitYield(n);
                return false;
            }
            return true;
        }

        void visitYield(Node n) {
            if (n.getParent().isExprResult()) {
                return;
            }
            if (this.decomposer.canExposeExpression(n) != ExpressionDecomposer.DecompositionType.UNDECOMPOSABLE) {
                this.decomposer.maybeExposeExpression(n);
            } else {
                String link = "https://github.com/google/closure-compiler/wiki/FAQ#i-get-an-undecomposable-expression-error-for-my-yield-or-await-expression-what-do-i-do";
                String suggestion = "Please rewrite the yield or await as a separate statement.";
                String message = "Undecomposable expression: " + suggestion + "\nSee " + link;
                Es6RewriteGenerators.this.compiler.report(JSError.make(n, Es6ToEs3Util.CANNOT_CONVERT, message));
            }
        }
    }
}

