/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CodingConventions;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Immutable
public class GoogleCodingConvention
extends CodingConventions.Proxy {
    private static final long serialVersionUID = 1L;
    private static final String OPTIONAL_ARG_PREFIX = "opt_";
    private static final String VAR_ARGS_NAME = "var_args";
    private static final Pattern ENUM_KEY_PATTERN = Pattern.compile("[A-Z0-9][A-Z0-9_]*");
    private static final Pattern PACKAGE_WITH_TEST_DIR = Pattern.compile("^(.*)/(?:test|tests|testing)/(?:[^/]+)$");
    private static final Pattern GENFILES_DIR = Pattern.compile("-out/.*/(bin|genfiles)/(.*)$");

    public GoogleCodingConvention() {
        this(new ClosureCodingConvention());
    }

    public GoogleCodingConvention(CodingConvention convention) {
        super(convention);
    }

    @Override
    public boolean isConstant(String name) {
        if (name.length() <= 1) {
            return false;
        }
        int pos = name.lastIndexOf(36);
        if (pos >= 0 && (name = name.substring(pos + 1)).isEmpty()) {
            return false;
        }
        return this.isConstantKey(name);
    }

    @Override
    public boolean isConstantKey(String name) {
        if (name.isEmpty() || !Character.isUpperCase(name.charAt(0))) {
            return false;
        }
        return name.toUpperCase(Locale.ROOT).equals(name);
    }

    @Override
    public boolean isValidEnumKey(String key) {
        return ENUM_KEY_PATTERN.matcher(key).matches();
    }

    @Override
    public boolean isOptionalParameter(Node parameter) {
        return super.isOptionalParameter(parameter) || parameter.isName() && parameter.getString().startsWith(OPTIONAL_ARG_PREFIX);
    }

    @Override
    public boolean isVarArgsParameter(Node parameter) {
        return super.isVarArgsParameter(parameter) || parameter.isName() && VAR_ARGS_NAME.equals(parameter.getString());
    }

    @Override
    public boolean isExported(String name, boolean local) {
        return super.isExported(name, local) || !local && name.startsWith("_");
    }

    @Override
    public boolean isClassFactoryCall(Node callNode) {
        Node callTarget = callNode.getFirstChild();
        return super.isClassFactoryCall(callNode) || callTarget.isName() && callTarget.toString().equals("Polymer");
    }

    @Override
    @GwtIncompatible
    public String getPackageName(StaticSourceFile source) {
        Matcher m;
        String name = source.getName();
        Matcher genfilesMatcher = GENFILES_DIR.matcher(name);
        if (genfilesMatcher.find()) {
            name = genfilesMatcher.group(2);
        }
        if ((m = PACKAGE_WITH_TEST_DIR.matcher(name)).find()) {
            return m.group(1);
        }
        int lastSlash = name.lastIndexOf(47);
        return lastSlash == -1 ? "" : name.substring(0, lastSlash);
    }

    @Override
    public boolean isPrivate(String name) {
        return name.endsWith("_") && !name.endsWith("__") && !this.isExported(name);
    }

    @Override
    public boolean hasPrivacyConvention() {
        return true;
    }
}

