/*
 * Decompiled with CFR 0.152.
 */
package esmska.persistence;

import a_vcard.android.syncml.pim.PropertyNode;
import a_vcard.android.syncml.pim.VDataBuilder;
import a_vcard.android.syncml.pim.VNode;
import a_vcard.android.syncml.pim.vcard.VCardException;
import a_vcard.android.syncml.pim.vcard.VCardParser;
import esmska.data.Contact;
import esmska.data.Gateway;
import esmska.data.Gateways;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.RandomUtils;

public class ContactParser
extends SwingWorker<ArrayList<Contact>, Void> {
    private static final Logger logger = Logger.getLogger(ContactParser.class.getName());
    private File file;
    private ContactType type;
    private ArrayList<Contact> contacts = new ArrayList();

    public ContactParser(File file, ContactType type) {
        this.file = file;
        this.type = type;
    }

    @Override
    protected ArrayList<Contact> doInBackground() throws Exception {
        switch (this.type) {
            case VCARD_FILE: {
                return this.parseVCARD();
            }
            case ESMSKA_FILE: 
            case KUBIK_DREAMCOM_FILE: 
            case DREAMCOM_SE_FILE: {
                return this.parseCSV();
            }
        }
        throw new UnsupportedOperationException("Enum element " + (Object)((Object)this.type) + " not currently supported");
    }

    /*
     * Exception decompiling
     */
    private ArrayList<Contact> parseCSV() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ArrayList<Contact> parseVCARD() throws IOException, VCardException {
        logger.finer("Parsing vCard file '" + this.file + "' as type " + (Object)((Object)this.type));
        this.contacts.clear();
        VCardParser parser = new VCardParser();
        VDataBuilder builder = new VDataBuilder();
        String vcardString = FileUtils.readFileToString(this.file, "UTF-8");
        boolean parsed = parser.parse(vcardString, "UTF-8", builder);
        if (!parsed) {
            throw new VCardException("Could not parse vCard file: " + this.file);
        }
        List<VNode> pimContacts = builder.vNodeList;
        for (VNode contact : pimContacts) {
            ArrayList<PropertyNode> props = contact.propList;
            String name = null;
            for (PropertyNode prop : props) {
                if (!"FN".equals(prop.propName)) continue;
                name = prop.propValue;
                break;
            }
            if (name == null) {
                for (PropertyNode prop : props) {
                    if (!"N".equals(prop.propName)) continue;
                    name = StringUtils.replace(prop.propValue, ";", " ");
                    break;
                }
            }
            if (name == null) {
                for (PropertyNode prop : props) {
                    if (!"ORG".equals(prop.propName)) continue;
                    name = prop.propValue;
                    break;
                }
            }
            if (StringUtils.isEmpty(name)) continue;
            String number = null;
            boolean preferred = false;
            boolean cellular = false;
            for (PropertyNode prop : props) {
                if (!"TEL".equals(prop.propName)) continue;
                Set<String> types = prop.paramMap_TYPE;
                if (StringUtils.isEmpty(number)) {
                    number = prop.propValue;
                }
                if (!preferred && this.containsIgnoreCase(types, "PREF")) {
                    number = prop.propValue;
                    preferred = true;
                }
                if (preferred || cellular || !this.containsIgnoreCase(types, "CELL")) continue;
                number = prop.propValue;
                cellular = true;
            }
            if ((number = Contact.parseNumber(number)) == null) continue;
            ArrayList<Gateway> gateways = Gateways.getInstance().suggestGateway(number).get1();
            String gatewayName = gateways.isEmpty() ? null : gateways.get(RandomUtils.nextInt(gateways.size())).getName();
            this.contacts.add(new Contact(name, number, gatewayName));
        }
        logger.finer("Parsed " + this.contacts.size() + " contacts");
        return this.contacts;
    }

    private boolean containsIgnoreCase(Set<String> set, String item) {
        Validate.notNull(set);
        Validate.notNull(item);
        for (String s : set) {
            if (!StringUtils.equalsIgnoreCase(s, item)) continue;
            return true;
        }
        return false;
    }

    public static enum ContactType {
        ESMSKA_FILE,
        KUBIK_DREAMCOM_FILE,
        DREAMCOM_SE_FILE,
        VCARD_FILE;

    }
}

