/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.cache;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheFactory;
import org.apache.commons.jcs3.auxiliary.disk.AbstractDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.block.BlockDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.block.BlockDiskCacheFactory;
import org.apache.commons.jcs3.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.indexed.IndexedDiskCacheFactory;
import org.apache.commons.jcs3.engine.CompositeCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class JCSCacheManager {
    private static final long maxObjectTTL = -1L;
    private static final String PREFERENCE_PREFIX = "jcs.cache";
    public static final BooleanProperty USE_BLOCK_CACHE;
    private static final AuxiliaryCacheFactory DISK_CACHE_FACTORY;
    private static FileLock cacheDirLock;
    public static final IntegerProperty DEFAULT_MAX_OBJECTS_IN_MEMORY;
    private static final Logger jcsLog;

    private JCSCacheManager() {
    }

    public static <K, V> CacheAccess<K, V> getCache(String cacheName) {
        return JCSCacheManager.getCache(cacheName, DEFAULT_MAX_OBJECTS_IN_MEMORY.get(), 0, null);
    }

    public static <K, V> CacheAccess<K, V> getCache(String cacheName, int maxMemoryObjects, int maxDiskObjects, String cachePath) {
        CacheAccess cacheAccess = JCS.getInstance(cacheName, JCSCacheManager.getCacheAttributes(maxMemoryObjects));
        CompositeCache cc = cacheAccess.getCacheControl();
        if (cachePath != null && cacheDirLock != null) {
            IDiskCacheAttributes diskAttributes = JCSCacheManager.getDiskCacheAttributes(maxDiskObjects, cachePath, cacheName);
            try {
                if (cc.getAuxCaches().length == 0) {
                    cc.setAuxCaches(new AuxiliaryCache[]{DISK_CACHE_FACTORY.createCache(diskAttributes, null, null, new StandardSerializer())});
                }
            }
            catch (Exception e) {
                cc.setAuxCaches(new AuxiliaryCache[0]);
                Logging.debug(e);
            }
        }
        return cacheAccess;
    }

    public static void shutdown() {
        JCS.shutdown();
    }

    private static IDiskCacheAttributes getDiskCacheAttributes(int maxDiskObjects, String cachePath, String cacheName) {
        AbstractDiskCacheAttributes ret;
        JCSCacheManager.removeStaleFiles(cachePath + File.separator + cacheName, USE_BLOCK_CACHE.get() != false ? "_INDEX_v2" : "_BLOCK_v2");
        String newCacheName = cacheName + (USE_BLOCK_CACHE.get() != false ? "_BLOCK_v2" : "_INDEX_v2");
        if (USE_BLOCK_CACHE.get().booleanValue()) {
            BlockDiskCacheAttributes blockAttr = new BlockDiskCacheAttributes();
            File diskCacheFile = new File(cachePath + File.separator + newCacheName + ".data");
            if (diskCacheFile.exists()) {
                blockAttr.setMaxKeySize((int)Math.max((long)maxDiskObjects, diskCacheFile.length() / 1024L));
            } else {
                blockAttr.setMaxKeySize(maxDiskObjects);
            }
            blockAttr.setBlockSizeBytes(4096);
            ret = blockAttr;
        } else {
            IndexedDiskCacheAttributes indexAttr = new IndexedDiskCacheAttributes();
            indexAttr.setMaxKeySize(maxDiskObjects);
            ret = indexAttr;
        }
        ret.setDiskLimitType(IDiskCacheAttributes.DiskLimitType.SIZE);
        File path = new File(cachePath);
        if (!path.exists() && !path.mkdirs()) {
            Logging.warn("Failed to create cache path: {0}", cachePath);
        } else {
            ret.setDiskPath(cachePath);
        }
        ret.setCacheName(newCacheName);
        return ret;
    }

    private static void removeStaleFiles(String basePathPart, String suffix) {
        JCSCacheManager.deleteCacheFiles(basePathPart + suffix);
    }

    private static void deleteCacheFiles(String basePathPart) {
        Utils.deleteFileIfExists(new File(basePathPart + ".key"));
        Utils.deleteFileIfExists(new File(basePathPart + ".data"));
    }

    private static CompositeCacheAttributes getCacheAttributes(int maxMemoryElements) {
        CompositeCacheAttributes ret = new CompositeCacheAttributes();
        ret.setMaxObjects(maxMemoryElements);
        ret.setDiskUsagePattern(ICompositeCacheAttributes.DiskUsagePattern.UPDATE);
        return ret;
    }

    static {
        block11: {
            USE_BLOCK_CACHE = new BooleanProperty("jcs.cache.use_block_cache", true);
            DISK_CACHE_FACTORY = USE_BLOCK_CACHE.get() != false ? new BlockDiskCacheFactory() : new IndexedDiskCacheFactory();
            DEFAULT_MAX_OBJECTS_IN_MEMORY = new IntegerProperty("jcs.cache.max_objects_in_memory", 1000);
            jcsLog = Logger.getLogger("org.apache.commons.jcs3");
            try {
                jcsLog.setLevel(Level.INFO);
                jcsLog.setUseParentHandlers(false);
                Arrays.stream(jcsLog.getHandlers()).forEach(jcsLog::removeHandler);
                jcsLog.addHandler(new Handler(){
                    final SimpleFormatter formatter = new SimpleFormatter();

                    @Override
                    public void publish(LogRecord record) {
                        String msg = this.formatter.formatMessage(record);
                        if (record.getLevel().intValue() >= Level.SEVERE.intValue()) {
                            Logging.error(msg);
                        } else if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
                            Logging.warn(msg);
                        } else if (record.getLevel().intValue() >= Level.INFO.intValue()) {
                            Logging.debug(msg);
                        } else {
                            Logging.trace(msg);
                        }
                    }

                    @Override
                    public void flush() {
                    }

                    @Override
                    public void close() {
                    }
                });
            }
            catch (Exception e) {
                Logging.log(Logging.LEVEL_ERROR, "Unable to configure JCS logs", e);
            }
            File cacheDir = new File(Config.getDirs().getCacheDirectory(true), "jcs");
            try {
                if (!cacheDir.exists() && !cacheDir.mkdirs()) {
                    Logging.warn("Cache directory " + cacheDir.toString() + " does not exists and could not create it");
                    break block11;
                }
                File cacheDirLockPath = new File(cacheDir, ".lock");
                try {
                    if (!cacheDirLockPath.exists() && !cacheDirLockPath.createNewFile()) {
                        Logging.warn("Cannot create cache dir lock file");
                    }
                    if ((cacheDirLock = FileChannel.open(cacheDirLockPath.toPath(), StandardOpenOption.WRITE).tryLock()) == null) {
                        Logging.warn("Cannot lock cache directory. Will not use disk cache");
                    }
                }
                catch (IOException e) {
                    Logging.log(Logging.LEVEL_WARN, "Cannot create cache dir \"" + cacheDirLockPath + "\" lock file:", e);
                    Logging.warn("Will not use disk cache");
                }
            }
            catch (Exception e) {
                Logging.log(Logging.LEVEL_WARN, "Unable to configure disk cache. Will not use it", e);
            }
        }
        Properties props = new Properties();
        props.setProperty("jcs.default.cacheattributes", CompositeCacheAttributes.class.getCanonicalName());
        props.setProperty("jcs.default.cacheattributes.MaxObjects", DEFAULT_MAX_OBJECTS_IN_MEMORY.get().toString());
        props.setProperty("jcs.default.cacheattributes.UseMemoryShrinker", "true");
        props.setProperty("jcs.default.cacheattributes.DiskUsagePatternName", "UPDATE");
        props.setProperty("jcs.default.elementattributes", CacheEntryAttributes.class.getCanonicalName());
        props.setProperty("jcs.default.elementattributes.IsEternal", "false");
        props.setProperty("jcs.default.elementattributes.MaxLife", Long.toString(-1L));
        props.setProperty("jcs.default.elementattributes.IdleTime", Long.toString(-1L));
        props.setProperty("jcs.default.elementattributes.IsSpool", "true");
        try {
            JCS.setConfigProperties(props);
        }
        catch (Exception e) {
            Logging.log(Logging.LEVEL_WARN, "Unable to initialize JCS", e);
        }
    }
}

