/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxConstants;
import org.openstreetmap.josm.data.gpx.GpxExtension;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.IGpxTrack;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.gpx.WithAttributes;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.StreamUtils;

public class GpxTrack
extends WithAttributes
implements IGpxTrack {
    private final List<IGpxTrackSegment> segments;
    private final double length;
    private final Bounds bounds;
    private Color colorCache;
    private final ListenerList<IGpxTrack.GpxTrackChangeListener> listeners = ListenerList.create();
    private static final HashMap<Color, String> closestGarminColorCache = new HashMap();
    private GpxConstants.ColorFormat colorFormat;

    public GpxTrack(Collection<Collection<WayPoint>> trackSegs, Map<String, Object> attributes) {
        this.segments = trackSegs.stream().filter(trackSeg -> trackSeg != null && !trackSeg.isEmpty()).map(GpxTrackSegment::new).collect(StreamUtils.toUnmodifiableList());
        this.length = this.calculateLength();
        this.bounds = this.calculateBounds();
        this.attr = new HashMap<String, Object>(attributes);
    }

    public GpxTrack(List<IGpxTrackSegment> trackSegs, Map<String, Object> attributes) {
        this.attr = new HashMap<String, Object>(attributes);
        this.segments = Collections.unmodifiableList(trackSegs);
        this.length = this.calculateLength();
        this.bounds = this.calculateBounds();
    }

    private double calculateLength() {
        return this.segments.stream().mapToDouble(IGpxTrackSegment::length).sum();
    }

    private Bounds calculateBounds() {
        Bounds result = null;
        for (IGpxTrackSegment segment : this.segments) {
            Bounds segBounds = segment.getBounds();
            if (segBounds == null) continue;
            if (result == null) {
                result = new Bounds(segBounds);
                continue;
            }
            result.extend(segBounds);
        }
        return result;
    }

    @Override
    public void setColor(Color color) {
        this.setColorExtension(color);
        this.colorCache = color;
    }

    private void setColorExtension(Color color) {
        this.getExtensions().findAndRemove("gpxx", "DisplayColor");
        if (color == null) {
            this.getExtensions().findAndRemove("gpxd", "color");
        } else {
            this.getExtensions().addOrUpdate("gpxd", "color", String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue()));
        }
        this.fireInvalidate();
    }

    @Override
    public Color getColor() {
        if (this.colorCache == null) {
            this.colorCache = this.getColorFromExtension();
        }
        return this.colorCache;
    }

    private Color getColorFromExtension() {
        GpxExtension gpxd = this.getExtensions().find("gpxd", "color");
        if (gpxd != null) {
            this.colorFormat = GpxConstants.ColorFormat.GPXD;
            String cs = gpxd.getValue();
            try {
                return Color.decode(cs);
            }
            catch (NumberFormatException ex) {
                Logging.warn("Could not read gpxd color: " + cs);
            }
        } else {
            GpxExtension gpxx = this.getExtensions().find("gpxx", "DisplayColor");
            if (gpxx != null) {
                Color cc;
                this.colorFormat = GpxConstants.ColorFormat.GPXX;
                String cs = gpxx.getValue();
                if (cs != null && (cc = (Color)GARMIN_COLORS.get(cs)) != null) {
                    return cc;
                }
                Logging.warn("Could not read garmin color: " + cs);
            }
        }
        return null;
    }

    public void convertColor(GpxConstants.ColorFormat cFormat) {
        Color c = this.getColor();
        if (c == null) {
            return;
        }
        if (cFormat != this.colorFormat) {
            if (cFormat == null) {
                Optional.ofNullable(this.getExtensions().find("gpxx", "DisplayColor")).ifPresent(GpxExtension::hide);
                Optional.ofNullable(this.getExtensions().find("gpxd", "color")).ifPresent(GpxExtension::hide);
            } else if (cFormat == GpxConstants.ColorFormat.GPXX) {
                this.getExtensions().findAndRemove("gpxd", "color");
                String colorString = null;
                if (closestGarminColorCache.containsKey(c)) {
                    colorString = closestGarminColorCache.get(c);
                } else {
                    double closestDiff = -1.0;
                    for (Map.Entry e : GARMIN_COLORS.entrySet()) {
                        double diff = this.colorDist((Color)e.getValue(), c);
                        if (!(closestDiff < 0.0) && !(diff < closestDiff)) continue;
                        colorString = (String)e.getKey();
                        closestDiff = diff;
                        if (closestDiff != 0.0) continue;
                        break;
                    }
                }
                closestGarminColorCache.put(c, colorString);
                this.getExtensions().addIfNotPresent("gpxx", "TrackExtension").getExtensions().addOrUpdate("gpxx", "DisplayColor", colorString);
            } else if (cFormat == GpxConstants.ColorFormat.GPXD) {
                this.setColor(c);
            }
            this.colorFormat = cFormat;
        }
    }

    private double colorDist(Color c1, Color c2) {
        return Math.sqrt(Math.pow(c1.getRed() - c2.getRed(), 2.0) + Math.pow(c1.getGreen() - c2.getGreen(), 2.0) + Math.pow(c1.getBlue() - c2.getBlue(), 2.0));
    }

    @Override
    public void put(String key, Object value) {
        super.put(key, value);
        this.fireInvalidate();
    }

    private void fireInvalidate() {
        this.listeners.fireEvent(l -> l.gpxDataChanged(new IGpxTrack.GpxTrackChangeEvent(this)));
    }

    @Override
    public Bounds getBounds() {
        return this.bounds == null ? null : new Bounds(this.bounds);
    }

    @Override
    public double length() {
        return this.length;
    }

    @Override
    public Collection<IGpxTrackSegment> getSegments() {
        return this.segments;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (this.segments == null ? 0 : this.segments.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GpxTrack other = (GpxTrack)obj;
        return !(this.segments == null ? other.segments != null : !this.segments.equals(other.segments));
    }

    @Override
    public void addListener(IGpxTrack.GpxTrackChangeListener l) {
        this.listeners.addListener(l);
    }

    @Override
    public void removeListener(IGpxTrack.GpxTrackChangeListener l) {
        this.listeners.removeListener(l);
    }

    public void invalidate() {
        this.colorCache = null;
    }

    @Deprecated
    static class GpxTrackChangeEvent
    extends IGpxTrack.GpxTrackChangeEvent {
        GpxTrackChangeEvent(IGpxTrack source) {
            super(source);
        }
    }

    @Deprecated
    @FunctionalInterface
    static interface GpxTrackChangeListener {
        public void gpxDataChanged(GpxTrackChangeEvent var1);
    }
}

