/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.runner.ExpressionRunner;
import org.jetbrains.kotlin.runner.FindCompilerKt;
import org.jetbrains.kotlin.runner.JarRunner;
import org.jetbrains.kotlin.runner.MainClassRunner;
import org.jetbrains.kotlin.runner.ReplRunner;
import org.jetbrains.kotlin.runner.Runner;
import org.jetbrains.kotlin.runner.RunnerException;
import org.jetbrains.kotlin.runner.ScriptRunner;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\u0006H\u0002J\b\u0010\f\u001a\u00020\u0006H\u0002J\u001b\u0010\r\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000e\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/runner/Main;", "", "()V", "KOTLIN_HOME", "Ljava/io/File;", "main", "", "args", "", "", "([Ljava/lang/String;)V", "printUsageAndExit", "printVersionAndExit", "run", "addPath", "", "Ljava/net/URL;", "path", "kotlin-runner"})
public final class Main {
    private static final File KOTLIN_HOME;
    @NotNull
    public static final Main INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final void run(String[] args) {
        void i;
        void expression;
        boolean bl = false;
        ArrayList classpath = new ArrayList();
        boolean bl2 = false;
        ArrayList<URL> compilerClasspath = new ArrayList<URL>();
        Runner runner = null;
        boolean collectingArguments = false;
        boolean collectingExpressions = false;
        boolean needsCompiler = false;
        boolean bl3 = false;
        ArrayList<String> arguments = new ArrayList<String>();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        boolean noReflect = false;
        Function1<String, Unit> $fun$setExpression$1 = new Function1<String, Unit>((Ref.ObjectRef)expression){
            final /* synthetic */ Ref.ObjectRef $expression;

            public final void invoke(@NotNull String expr) {
                Intrinsics.checkNotNullParameter(expr, "expr");
                if ((String)this.$expression.element != null) {
                    throw (Throwable)new RunnerException("Only single -e/-expression argument supported");
                }
                this.$expression.element = expr;
            }
            {
                this.$expression = objectRef;
                super(1);
            }
        };
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        while (i.element < args.length) {
            boolean bl4;
            CharSequence charSequence;
            String p1;
            Iterable $this$filterTo$iv$iv;
            boolean $i$f$filterTo;
            Collection destination$iv$iv;
            boolean $i$f$filter;
            Iterable $this$filter$iv;
            int n;
            String arg = args[i.element];
            Function0<String> $fun$next$2 = new Function0<String>((Ref.IntRef)i, args, arg){
                final /* synthetic */ Ref.IntRef $i;
                final /* synthetic */ String[] $args;
                final /* synthetic */ String $arg;

                @NotNull
                public final String invoke() {
                    Ref.IntRef intRef = this.$i;
                    ++intRef.element;
                    if (intRef.element == this.$args.length) {
                        throw (Throwable)new RunnerException("argument expected to " + this.$arg);
                    }
                    return this.$args[this.$i.element];
                }
                {
                    this.$i = intRef;
                    this.$args = stringArray;
                    this.$arg = string;
                    super(0);
                }
            };
            if (collectingExpressions) {
                if (Intrinsics.areEqual("-expression", arg) || Intrinsics.areEqual("-e", arg)) {
                    $fun$setExpression$1.invoke((String)$fun$next$2.invoke());
                    n = i.element;
                    i.element = n + 1;
                    continue;
                }
                collectingArguments = true;
            }
            if (collectingArguments) {
                arguments.add(arg);
                n = i.element;
                i.element = n + 1;
                continue;
            }
            if (Intrinsics.areEqual("-help", arg) || Intrinsics.areEqual("-h", arg)) {
                this.printUsageAndExit();
            } else if (Intrinsics.areEqual("-version", arg)) {
                this.printVersionAndExit();
            } else if (Intrinsics.areEqual("-classpath", arg) || Intrinsics.areEqual("-cp", arg)) {
                CharSequence charSequence2 = (CharSequence)$fun$next$2.invoke();
                String[] stringArray = new String[1];
                String string = File.pathSeparator;
                Intrinsics.checkNotNullExpressionValue(string, "File.pathSeparator");
                stringArray[0] = string;
                $this$filter$iv = StringsKt.split$default(charSequence2, stringArray, false, 0, 6, null);
                $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    p1 = (String)element$iv$iv;
                    boolean bl5 = false;
                    charSequence = p1;
                    bl4 = false;
                    if (!(charSequence.length() > 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (String path : (List)destination$iv$iv) {
                    this.addPath(classpath, path);
                }
            } else if (Intrinsics.areEqual("-compiler-path", arg)) {
                CharSequence charSequence3 = (CharSequence)$fun$next$2.invoke();
                String[] stringArray = new String[1];
                String string = File.pathSeparator;
                Intrinsics.checkNotNullExpressionValue(string, "File.pathSeparator");
                stringArray[0] = string;
                $this$filter$iv = StringsKt.split$default(charSequence3, stringArray, false, 0, 6, null);
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    p1 = (String)element$iv$iv;
                    boolean bl6 = false;
                    charSequence = p1;
                    bl4 = false;
                    if (!(charSequence.length() > 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (String path : (List)destination$iv$iv) {
                    this.addPath((List<URL>)compilerClasspath, path);
                }
            } else if (Intrinsics.areEqual("-expression", arg) || Intrinsics.areEqual("-e", arg)) {
                $fun$setExpression$1.invoke((String)$fun$next$2.invoke());
                collectingExpressions = true;
                needsCompiler = true;
            } else if (Intrinsics.areEqual("-no-reflect", arg)) {
                noReflect = true;
            } else {
                if (StringsKt.startsWith$default(arg, "-", false, 2, null)) {
                    throw (Throwable)new RunnerException("unsupported argument: " + arg);
                }
                if (StringsKt.endsWith$default(arg, ".jar", false, 2, null)) {
                    runner = new JarRunner(arg);
                    collectingArguments = true;
                } else if (StringsKt.endsWith$default(arg, ".kts", false, 2, null)) {
                    runner = new ScriptRunner(arg);
                    collectingArguments = true;
                    needsCompiler = true;
                } else {
                    runner = new MainClassRunner(arg);
                    collectingArguments = true;
                }
            }
            n = i.element;
            i.element = n + 1;
        }
        if (classpath.isEmpty()) {
            this.addPath(classpath, ".");
        }
        this.addPath(classpath, KOTLIN_HOME + "/lib/kotlin-stdlib.jar");
        if (!noReflect) {
            this.addPath(classpath, KOTLIN_HOME + "/lib/kotlin-reflect.jar");
        }
        if ((String)expression.element != null) {
            String string = (String)expression.element;
            Intrinsics.checkNotNull(string);
            runner = new ExpressionRunner(string);
        } else if (runner == null) {
            runner = new ReplRunner();
            needsCompiler = true;
        }
        if (needsCompiler && compilerClasspath.isEmpty()) {
            Iterable $this$forEach$iv = FindCompilerKt.findCompilerJar(this.getClass(), FilesKt.resolve(KOTLIN_HOME, "lib"));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl7 = false;
                compilerClasspath.add(it.getAbsoluteFile().toURI().toURL());
            }
        }
        runner.run(classpath, (List<String>)arguments, (List<URL>)compilerClasspath);
    }

    private final void addPath(List<URL> $this$addPath, String path) {
        URL uRL = new File(path).getAbsoluteFile().toURI().toURL();
        Intrinsics.checkNotNullExpressionValue(uRL, "File(path).absoluteFile.toURI().toURL()");
        $this$addPath.add(uRL);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter(args, "args");
        try {
            INSTANCE.run(args);
        }
        catch (RunnerException e) {
            System.err.println("error: " + e.getMessage());
            int n = 1;
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void printUsageAndExit() {
        String string = "kotlin: run Kotlin programs, scripts or REPL.\n\nUsage: kotlin <options> <command> <arguments>\nwhere command may be one of:\n  foo.Bar                    Runs the 'main' function from the class with the given qualified name\n  app.jar                    Runs the given JAR file as 'java -jar' would do\n                             (-classpath argument is ignored and no Kotlin runtime is added to the classpath)\nand possible options include:\n  -classpath (-cp) <path>    Paths where to find user class files\n  -Dname=value               Set a system JVM property\n  -J<option>                 Pass an option directly to JVM\n  -no-reflect                Don't include Kotlin reflection implementation into classpath\n  -version                   Display Kotlin version\n  -help (-h)                 Print a synopsis of options\n";
        boolean bl = false;
        System.out.println((Object)string);
        int n = 0;
        bl = false;
        System.exit(n);
        throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private final void printVersionAndExit() {
        String string;
        try {
            string = new Scanner(new File(KOTLIN_HOME, "build.txt")).nextLine();
        }
        catch (FileNotFoundException e) {
            throw (Throwable)new RunnerException("no build.txt was found at home=" + KOTLIN_HOME);
        }
        String version = string;
        string = "Kotlin version " + version + " (JRE " + System.getProperty("java.runtime.version") + ")";
        boolean bl = false;
        System.out.println((Object)string);
        int n = 0;
        bl = false;
        System.exit(n);
        throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private Main() {
    }

    static {
        Main main;
        INSTANCE = main = new Main();
        String home = System.getProperty("kotlin.home");
        if (home == null) {
            System.err.println("error: no kotlin.home system property was passed");
            int n = 1;
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        KOTLIN_HOME = new File(home);
    }
}

