/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.awt.Color;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import mediathek.config.MVColor;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenFilm;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class Filter {
    private static final LoadingCache<String, Pattern> CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(new PatternCacheLoader());
    private static final Logger logger = LogManager.getLogger(Filter.class);

    public static boolean aboExistiertBereits(DatenAbo aboExistiert, DatenAbo aboPruefen) {
        String senderExistiert = aboExistiert.arr[3];
        String themaExistiert = aboExistiert.arr[4];
        String[] titelExistiert = StringUtils.split(aboExistiert.arr[5].toLowerCase(), ",");
        String[] themaTitelExistiert = StringUtils.split(aboExistiert.arr[6].toLowerCase(), ",");
        String[] irgendwoExistiert = StringUtils.split(aboExistiert.arr[7].toLowerCase(), ",");
        String senderPruefen = aboPruefen.arr[3];
        String themaPruefen = aboPruefen.arr[4];
        String titelPruefen = aboPruefen.arr[5];
        String irgendwoPruefen = aboPruefen.arr[7];
        return !(!senderExistiert.isEmpty() && !senderPruefen.equalsIgnoreCase(senderExistiert) || !themaExistiert.isEmpty() && !themaPruefen.equalsIgnoreCase(themaExistiert) || titelExistiert.length != 0 && !Filter.pruefen(titelExistiert, titelPruefen) || themaTitelExistiert.length != 0 && !Filter.pruefen(themaTitelExistiert, themaPruefen) && !Filter.pruefen(themaTitelExistiert, titelPruefen) || irgendwoExistiert.length != 0 && !Filter.pruefen(irgendwoExistiert, themaPruefen) && !Filter.pruefen(irgendwoExistiert, titelPruefen) && !Filter.pruefen(irgendwoExistiert, irgendwoPruefen));
    }

    public static boolean filterAufFilmPruefen(String senderSuchen, String themaSuchen, String[] titelSuchen, String[] themaTitelSuchen, String[] irgendwoSuchen, int laengeMinutenSuchen, boolean min2, DatenFilm film, boolean mitLaenge) {
        boolean result = false;
        String thema = film.getThema();
        String title = film.getTitle();
        if ((senderSuchen.isEmpty() || film.getSender().compareTo(senderSuchen) == 0) && (themaSuchen.isEmpty() || thema.equalsIgnoreCase(themaSuchen)) && (titelSuchen.length == 0 || Filter.pruefen(titelSuchen, title)) && (themaTitelSuchen.length == 0 || Filter.pruefen(themaTitelSuchen, thema) || Filter.pruefen(themaTitelSuchen, title)) && (irgendwoSuchen.length == 0 || Filter.pruefen(irgendwoSuchen, film.getDescription()) || Filter.pruefen(irgendwoSuchen, thema) || Filter.pruefen(irgendwoSuchen, title))) {
            if (mitLaenge) {
                if (Filter.laengePruefen(laengeMinutenSuchen, film.getFilmLength(), min2)) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    public static boolean lengthCheck(int filterLaengeInMinuten, long filmLaenge) {
        return filterLaengeInMinuten == 0 || filmLaenge == 0L;
    }

    private static boolean checkLengthNoMin(int filterLaengeInMinuten, long filmLaenge) {
        int filterLength = filterLaengeInMinuten * 60;
        return Filter.lengthCheck(filterLaengeInMinuten, filmLaenge) || filmLaenge < (long)filterLength;
    }

    public static boolean checkLengthWithMin(int filterLaengeInMinuten, long filmLaenge) {
        int filterLength = filterLaengeInMinuten * 60;
        return Filter.lengthCheck(filterLaengeInMinuten, filmLaenge) || filmLaenge > (long)filterLength;
    }

    public static boolean laengePruefen(int filterLaengeInMinuten, long filmLaenge, boolean min2) {
        boolean result = min2 ? Filter.checkLengthWithMin(filterLaengeInMinuten, filmLaenge) : Filter.checkLengthNoMin(filterLaengeInMinuten, filmLaenge);
        return result;
    }

    public static boolean pruefen(String[] filter, String im) {
        if (filter.length == 1) {
            if (filter[0].isEmpty()) {
                return true;
            }
            Pattern p = Filter.makePattern(filter[0]);
            if (p != null) {
                return p.matcher(im).matches();
            }
        }
        return Filter.checkLowercase(filter, im.toLowerCase());
    }

    public static boolean checkLowercase(String[] filter, String im) {
        for (String s2 : filter) {
            if (!im.contains(s2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPattern(String textSuchen) {
        return textSuchen.startsWith("#:");
    }

    public static Pattern makePattern(String textSuchen) {
        Pattern p;
        if (Filter.isPattern(textSuchen)) {
            try {
                p = CACHE.get(textSuchen);
            }
            catch (ExecutionException ex) {
                p = null;
            }
        } else {
            p = null;
        }
        return p;
    }

    public static void checkPattern1(JTextField tf) {
        String text = tf.getText();
        if (Filter.isPattern(text)) {
            if (Filter.makePattern(text) == null) {
                tf.setBackground(MVColor.FILTER_REGEX_FEHLER.color);
            } else {
                tf.setBackground(MVColor.FILTER_REGEX.color);
            }
        } else {
            tf.setBackground(Color.WHITE);
        }
    }

    static class PatternCacheLoader
    extends CacheLoader<String, Pattern> {
        PatternCacheLoader() {
        }

        @Override
        public Pattern load(@NotNull String pattern) throws IllegalArgumentException {
            logger.trace("COMPILING PATTERN: " + pattern);
            Pattern p = Pattern.compile(pattern.substring(2), 98);
            return p;
        }
    }
}

