/*
 * Decompiled with CFR 0.152.
 */
package mediathek.x11;

import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.Field;
import mediathek.config.MVConfig;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.notification.GenericNotificationCenter;
import mediathek.tool.notification.INotificationCenter;
import mediathek.tool.notification.LinuxNotificationCenter;
import mediathek.tool.notification.NullNotificationCenter;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MediathekGuiX11
extends MediathekGui {
    private static final Logger logger = LogManager.getLogger(MediathekGuiX11.class);

    public MediathekGuiX11() {
        this.setupX11WindowManagerClassName();
    }

    private void setupX11WindowManagerClassName() {
        try {
            Toolkit xToolkit = Toolkit.getDefaultToolkit();
            Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
            awtAppClassNameField.setAccessible(true);
            awtAppClassNameField.set(xToolkit, "MediathekView");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.warn("Could not set awtAppClassName");
        }
    }

    @Override
    protected void setupNotificationCenter() {
        try {
            INotificationCenter notificationCenter = this.daten.notificationCenter();
            if (notificationCenter != null) {
                notificationCenter.close();
            }
        }
        catch (IOException e) {
            logger.error("error closing notification center", (Throwable)e);
        }
        boolean showNotifications = this.config.getBoolean("application.notifications.show", true);
        LinuxNotificationCenter notificationCenter = new LinuxNotificationCenter();
        boolean hasNativeSupport = notificationCenter.hasNativeSupport();
        this.config.setProperty("application.notifications.native_support", hasNativeSupport);
        if (!hasNativeSupport) {
            this.config.setProperty("application.notifications.show_native", false);
        }
        if (!showNotifications) {
            this.daten.setNotificationCenter(new NullNotificationCenter());
        } else if (this.config.getBoolean("application.notifications.show_native", false)) {
            this.daten.setNotificationCenter(notificationCenter);
        } else {
            this.daten.setNotificationCenter(new GenericNotificationCenter());
        }
    }

    @Override
    protected void shutdownComputer() {
        String strShutdownCommand;
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_FREE_BSD) {
            strShutdownCommand = MVConfig.get(MVConfig.Configs.SYSTEM_LINUX_SHUTDOWN);
            if (strShutdownCommand.isEmpty()) {
                strShutdownCommand = "shutdown -h now";
                MVConfig.add(MVConfig.Configs.SYSTEM_LINUX_SHUTDOWN, "shutdown -h now");
            }
        } else {
            logger.error("shutdown command is unknown for this operating system");
            return;
        }
        try {
            logger.info("Shutdown: {}", (Object)strShutdownCommand);
            Runtime.getRuntime().exec(strShutdownCommand);
        }
        catch (IOException ex) {
            logger.error(ex);
        }
    }
}

