/*
 * Decompiled with CFR 0.152.
 */
package org.protege.xmlcatalog.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.log4j.Logger;
import org.protege.xmlcatalog.swing.CatalogJTree;
import org.protege.xmlcatalog.swing.CatalogTreeNode;
import org.protege.xmlcatalog.swing.EntryTreeNode;

public class CatalogEditorTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1160492460896419035L;
    public static final Logger LOGGER = Logger.getLogger(CatalogEditorTransferHandler.class);

    @Override
    public int getSourceActions(JComponent c) {
        EntryTreeNode e = this.getEntryTreeNode(c);
        if (e == null) {
            return 0;
        }
        if (e.isAutoGenerated()) {
            return 1;
        }
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        final EntryTreeNode e = this.getEntryTreeNode(c);
        if (e == null) {
            return null;
        }
        return new Transferable(){

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor.getRepresentationClass().equals(EntryTreeNode.class);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{new DataFlavor(EntryTreeNode.class, "XML Catalog Entry")};
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                return e;
            }
        };
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        EntryTreeNode e;
        if (LOGGER.isDebugEnabled() && comp instanceof CatalogJTree) {
            LOGGER.debug((Object)("Last selected component " + ((CatalogJTree)comp).getLastSelectedPathComponent()));
        }
        if ((e = this.getEntryTreeNode(comp)) != null && (e.isAutoGenerated() || e.getEditor() != null)) {
            return false;
        }
        if (e == null && this.getCatalogTreeNode(comp) == null) {
            return false;
        }
        for (DataFlavor flavor : transferFlavors) {
            if (!EntryTreeNode.class.equals(flavor.getRepresentationClass())) continue;
            return true;
        }
        return false;
    }

    private EntryTreeNode getEntryTreeNode(JComponent c) {
        if (!(c instanceof CatalogJTree)) {
            return null;
        }
        CatalogJTree tree = (CatalogJTree)c;
        Object o = tree.getLastSelectedPathComponent();
        if (!(o instanceof EntryTreeNode)) {
            return null;
        }
        return (EntryTreeNode)o;
    }

    private CatalogTreeNode getCatalogTreeNode(JComponent c) {
        if (!(c instanceof CatalogJTree)) {
            return null;
        }
        CatalogJTree tree = (CatalogJTree)c;
        Object o = tree.getLastSelectedPathComponent();
        if (!(o instanceof CatalogTreeNode)) {
            return null;
        }
        return (CatalogTreeNode)o;
    }
}

