complete -c sq -n "__fish_use_subcommand" -l home -d 'Sets the home directory to use'
complete -c sq -n "__fish_use_subcommand" -s m -l mapping -d 'Sets the realm and mapping to use'
complete -c sq -n "__fish_use_subcommand" -s p -l policy -d 'Sets the network policy to use'
complete -c sq -n "__fish_use_subcommand" -l known-notation -d 'The notation name is considered known. This is used when validating signatures. Signatures that have unknown notations with the critical bit set are considered invalid.'
complete -c sq -n "__fish_use_subcommand" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_use_subcommand" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_use_subcommand" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_use_subcommand" -f -a "decrypt" -d 'Decrypts an OpenPGP message'
complete -c sq -n "__fish_use_subcommand" -f -a "encrypt" -d 'Encrypts a message'
complete -c sq -n "__fish_use_subcommand" -f -a "sign" -d 'Signs a message'
complete -c sq -n "__fish_use_subcommand" -f -a "verify" -d 'Verifies a message'
complete -c sq -n "__fish_use_subcommand" -f -a "enarmor" -d 'Applies ASCII Armor to a file'
complete -c sq -n "__fish_use_subcommand" -f -a "dearmor" -d 'Removes ASCII Armor from a file'
complete -c sq -n "__fish_use_subcommand" -f -a "autocrypt" -d 'Autocrypt support'
complete -c sq -n "__fish_use_subcommand" -f -a "inspect" -d 'Inspects a sequence of OpenPGP packets'
complete -c sq -n "__fish_use_subcommand" -f -a "keyserver" -d 'Interacts with keyservers'
complete -c sq -n "__fish_use_subcommand" -f -a "mapping" -d 'Interacts with key mappings'
complete -c sq -n "__fish_use_subcommand" -f -a "list" -d 'Lists key mappings and known keys'
complete -c sq -n "__fish_use_subcommand" -f -a "key" -d 'Manipulates keys'
complete -c sq -n "__fish_use_subcommand" -f -a "packet" -d 'OpenPGP Packet manipulation'
complete -c sq -n "__fish_use_subcommand" -f -a "wkd" -d 'Interacts with Web Key Directories'
complete -c sq -n "__fish_use_subcommand" -f -a "help" -d 'Prints this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s o -l output -d 'Sets the output file to use'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s n -l signatures -d 'The number of valid signatures required.  Default: 0'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l sender-cert-file -d 'The sender\'s certificate verify signatures with, given as a file (can be given multiple times)'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l secret-key-file -d 'Secret key to decrypt with, given as a file (can be given multiple times)'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l dump-session-key -d 'Prints the session key to stderr'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l dump -d 'Print a packet dump to stderr'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s x -l hex -d 'Print a hexdump (implies --dump)'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s o -l output -d 'Sets the output file to use'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s r -l recipient -d 'Recipient to encrypt for (can be given multiple times)'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l recipient-key-file -d 'Recipient to encrypt for, given as a file (can be given multiple times)'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l signer-key-file -d 'Secret key to sign with, given as a file (can be given multiple times)'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l mode -d 'Selects what kind of keys are considered for encryption.  Transport select subkeys marked as suitable for transport encryption, rest selects those for encrypting data at rest, and all selects all encryption-capable subkeys' -r -f -a "transport rest all"
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l compression -d 'Selects compression scheme to use' -r -f -a "none pad zip zlib bzip2"
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s t -l time -d 'Chooses keys valid at the specified time and sets the signature\'s creation time'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s B -l binary -d 'Don\'t ASCII-armor encode the OpenPGP data'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s s -l symmetric -d 'Encrypt with a password (can be given multiple times)'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from sign" -s o -l output -d 'Sets the output file to use'
complete -c sq -n "__fish_seen_subcommand_from sign" -l secret-key-file -d 'Secret key to sign with, given as a file (can be given multiple times)'
complete -c sq -n "__fish_seen_subcommand_from sign" -s t -l time -d 'Chooses keys valid at the specified time and sets the signature\'s creation time'
complete -c sq -n "__fish_seen_subcommand_from sign" -s B -l binary -d 'Don\'t ASCII-armor encode the OpenPGP data'
complete -c sq -n "__fish_seen_subcommand_from sign" -l detached -d 'Create a detached signature'
complete -c sq -n "__fish_seen_subcommand_from sign" -s a -l append -d 'Append signature to existing signature'
complete -c sq -n "__fish_seen_subcommand_from sign" -s n -l notarize -d 'Signs a message and all existing signatures'
complete -c sq -n "__fish_seen_subcommand_from sign" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from sign" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from verify" -s o -l output -d 'Sets the output file to use'
complete -c sq -n "__fish_seen_subcommand_from verify" -l detached -d 'Verifies a detached signature'
complete -c sq -n "__fish_seen_subcommand_from verify" -s n -l signatures -d 'The number of valid signatures required.  Default: 0'
complete -c sq -n "__fish_seen_subcommand_from verify" -l sender-cert-file -d 'The sender\'s certificate verify signatures with, given as a file (can be given multiple times)'
complete -c sq -n "__fish_seen_subcommand_from verify" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from verify" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from enarmor" -s o -l output -d 'Sets the output file to use'
complete -c sq -n "__fish_seen_subcommand_from enarmor" -l kind -d 'Selects the kind of header line to produce' -r -f -a "message publickey secretkey signature file"
complete -c sq -n "__fish_seen_subcommand_from enarmor" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from enarmor" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from dearmor" -s o -l output -d 'Sets the output file to use'
complete -c sq -n "__fish_seen_subcommand_from dearmor" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from dearmor" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from autocrypt" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from autocrypt" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from autocrypt" -f -a "decode" -d 'Converts Autocrypt-encoded keys to OpenPGP Certificates'
complete -c sq -n "__fish_seen_subcommand_from autocrypt" -f -a "encode-sender" -d 'Encodes the sender\'s OpenPGP Certificates into an Autocrypt header'
complete -c sq -n "__fish_seen_subcommand_from autocrypt" -f -a "help" -d 'Prints this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from decode" -s o -l output -d 'Sets the output file to use'
complete -c sq -n "__fish_seen_subcommand_from decode" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from decode" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from encode-sender" -s o -l output -d 'Sets the output file to use'
complete -c sq -n "__fish_seen_subcommand_from encode-sender" -l address -d 'Select userid to use.  [default: primary userid]'
complete -c sq -n "__fish_seen_subcommand_from encode-sender" -l prefer-encrypt -d 'Sets the prefer-encrypt attribute' -r -f -a "nopreference mutual"
complete -c sq -n "__fish_seen_subcommand_from encode-sender" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from encode-sender" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from help" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from help" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from inspect" -l keygrips -d 'Print keygrips of keys and subkeys'
complete -c sq -n "__fish_seen_subcommand_from inspect" -l certifications -d 'Print third-party certifications'
complete -c sq -n "__fish_seen_subcommand_from inspect" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from inspect" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from keyserver" -s s -l server -d 'Sets the keyserver to use'
complete -c sq -n "__fish_seen_subcommand_from keyserver" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from keyserver" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from keyserver" -f -a "get" -d 'Retrieves a key'
complete -c sq -n "__fish_seen_subcommand_from keyserver" -f -a "send" -d 'Sends a key'
complete -c sq -n "__fish_seen_subcommand_from keyserver" -f -a "help" -d 'Prints this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from get" -s o -l output -d 'Sets the output file to use'
complete -c sq -n "__fish_seen_subcommand_from get" -s B -l binary -d 'Don\'t ASCII-armor encode the OpenPGP data'
complete -c sq -n "__fish_seen_subcommand_from get" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from get" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from send" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from send" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from help" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from help" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from mapping" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from mapping" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from mapping" -f -a "list" -d 'Lists keys in the mapping'
complete -c sq -n "__fish_seen_subcommand_from mapping" -f -a "add" -d 'Add a key identified by fingerprint'
complete -c sq -n "__fish_seen_subcommand_from mapping" -f -a "import" -d 'Imports a key'
complete -c sq -n "__fish_seen_subcommand_from mapping" -f -a "export" -d 'Exports a key'
complete -c sq -n "__fish_seen_subcommand_from mapping" -f -a "delete" -d 'Deletes bindings or mappings'
complete -c sq -n "__fish_seen_subcommand_from mapping" -f -a "stats" -d 'Get stats for the given label'
complete -c sq -n "__fish_seen_subcommand_from mapping" -f -a "log" -d 'Lists the keystore log'
complete -c sq -n "__fish_seen_subcommand_from mapping" -f -a "help" -d 'Prints this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from list" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from list" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from add" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from add" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from import" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from import" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from export" -s o -l output -d 'Sets the output file to use'
complete -c sq -n "__fish_seen_subcommand_from export" -s B -l binary -d 'Don\'t ASCII-armor encode the OpenPGP data'
complete -c sq -n "__fish_seen_subcommand_from export" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from export" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from delete" -l the-mapping -d 'Delete the selected mapping (change with --mapping)'
complete -c sq -n "__fish_seen_subcommand_from delete" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from delete" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from stats" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from stats" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from log" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from log" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from help" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from help" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from list" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from list" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from list" -f -a "mappings" -d 'Lists key mappings'
complete -c sq -n "__fish_seen_subcommand_from list" -f -a "bindings" -d 'Lists all bindings in all key mappings'
complete -c sq -n "__fish_seen_subcommand_from list" -f -a "keys" -d 'Lists all keys in the common key pool'
complete -c sq -n "__fish_seen_subcommand_from list" -f -a "log" -d 'Lists the server log'
complete -c sq -n "__fish_seen_subcommand_from list" -f -a "help" -d 'Prints this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from mappings" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from mappings" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from bindings" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from bindings" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from keys" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from keys" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from log" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from log" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from help" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from help" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from key" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from key" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from key" -f -a "generate" -d 'Generates a new key'
complete -c sq -n "__fish_seen_subcommand_from key" -f -a "help" -d 'Prints this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from generate" -s u -l userid -d 'Add userid to the key (can be given multiple times)'
complete -c sq -n "__fish_seen_subcommand_from generate" -s c -l cipher-suite -d 'Cryptographic algorithms used for the key.' -r -f -a "rsa3k rsa4k cv25519"
complete -c sq -n "__fish_seen_subcommand_from generate" -l expires -d 'Absolute time When the key should expire, or \'never\'.'
complete -c sq -n "__fish_seen_subcommand_from generate" -l expires-in -d 'Relative time when the key should expire.  Either \'N[ymwd]\', for N years, months, weeks, or days, or \'never\'.'
complete -c sq -n "__fish_seen_subcommand_from generate" -l can-encrypt -d 'The key has an encryption-capable subkey (default: universal)' -r -f -a "transport storage universal"
complete -c sq -n "__fish_seen_subcommand_from generate" -s e -l export -d 'Exports the key instead of saving it in the store'
complete -c sq -n "__fish_seen_subcommand_from generate" -l rev-cert -d 'Sets the output file for the revocation certificate. Default is <OUTFILE>.rev, mandatory if OUTFILE is \'-\'.'
complete -c sq -n "__fish_seen_subcommand_from generate" -l with-password -d 'Prompt for a password to protect the generated key with.'
complete -c sq -n "__fish_seen_subcommand_from generate" -l can-sign -d 'The key has a signing-capable subkey (default)'
complete -c sq -n "__fish_seen_subcommand_from generate" -l cannot-sign -d 'The key will not be able to sign data'
complete -c sq -n "__fish_seen_subcommand_from generate" -l cannot-encrypt -d 'The key will not be able to encrypt data'
complete -c sq -n "__fish_seen_subcommand_from generate" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from generate" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from help" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from help" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from packet" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from packet" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from packet" -f -a "dump" -d 'Lists OpenPGP packets'
complete -c sq -n "__fish_seen_subcommand_from packet" -f -a "decrypt" -d 'Decrypts an OpenPGP message, dumping the content of the encryption container without further processing'
complete -c sq -n "__fish_seen_subcommand_from packet" -f -a "split" -d 'Splits a message into OpenPGP packets'
complete -c sq -n "__fish_seen_subcommand_from packet" -f -a "join" -d 'Joins OpenPGP packets split across files'
complete -c sq -n "__fish_seen_subcommand_from packet" -f -a "help" -d 'Prints this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from dump" -s o -l output -d 'Sets the output file to use'
complete -c sq -n "__fish_seen_subcommand_from dump" -l session-key -d 'Session key to decrypt encryption containers'
complete -c sq -n "__fish_seen_subcommand_from dump" -l mpis -d 'Print MPIs'
complete -c sq -n "__fish_seen_subcommand_from dump" -s x -l hex -d 'Print a hexdump'
complete -c sq -n "__fish_seen_subcommand_from dump" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from dump" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s o -l output -d 'Sets the output file to use'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l secret-key-file -d 'Secret key to decrypt with, given as a file (can be given multiple times)'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s B -l binary -d 'Don\'t ASCII-armor encode the OpenPGP data'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l dump-session-key -d 'Prints the session key to stderr'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from split" -s p -l prefix -d 'Sets the prefix to use for output files (defaults to the input filename with a dash, or \'output\')'
complete -c sq -n "__fish_seen_subcommand_from split" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from split" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from join" -s o -l output -d 'Sets the output file to use'
complete -c sq -n "__fish_seen_subcommand_from join" -l kind -d 'Selects the kind of header line to produce' -r -f -a "message publickey secretkey signature file"
complete -c sq -n "__fish_seen_subcommand_from join" -s B -l binary -d 'Don\'t ASCII-armor encode the OpenPGP data'
complete -c sq -n "__fish_seen_subcommand_from join" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from join" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from help" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from help" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from wkd" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from wkd" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from wkd" -f -a "url" -d 'Prints the Web Key Directory URL of an email address.'
complete -c sq -n "__fish_seen_subcommand_from wkd" -f -a "get" -d 'Writes to the standard output the Cert retrieved from a Web Key Directory, given an email address'
complete -c sq -n "__fish_seen_subcommand_from wkd" -f -a "generate" -d 'Generates a Web Key Directory for the given domain and keys.  If the WKD exists, the new keys will be inserted and it is updated and existing ones will be updated.'
complete -c sq -n "__fish_seen_subcommand_from wkd" -f -a "help" -d 'Prints this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from url" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from url" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from get" -s B -l binary -d 'Don\'t ASCII-armor encode the OpenPGP data'
complete -c sq -n "__fish_seen_subcommand_from get" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from get" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from generate" -s d -l direct_method -d 'Use the direct method. [default: advanced method]'
complete -c sq -n "__fish_seen_subcommand_from generate" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from generate" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from help" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from help" -s V -l version -d 'Prints version information'
complete -c sq -n "__fish_seen_subcommand_from help" -s h -l help -d 'Prints help information'
complete -c sq -n "__fish_seen_subcommand_from help" -s V -l version -d 'Prints version information'
