/**
 * SECTION:backend-store
 * @short_description: Responsible for backend loading.
 * @folks_backend_store_KEY_FILE_GROUP_ALL_OTHERS: This keyword in the keyfile acts as a wildcard for all backends not already listed in the same file.<para>This is particularly useful for tests which want to ensure they&apos;re only operating with backends they were designed for (and thus may not be able to enumerate entries for).</para><para>To avoid conflicts, backends must not use this as a name.</para>
 * 
 * <para>The BackendStore manages the set of available Folks backends. The <link linkend="folks-backend-store-load-backends"><function>folks_backend_store_load_backends()</function></link> function loads all compatible and enabled backends and the <link linkend="FolksBackendStore-backend-available"><type>"backend-available"</type></link> signal notifies when these backends are ready.</para>
 */
/**
 * FOLKS_TYPE_BACKEND_STORE:
 * 
 * The type for <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link>.
 */
/**
 * folks_backend_store_prepare:
 * @self: the <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> instance
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Prepare the BackendStore for use.
 * 
 * <para>This must only ever be called before <link linkend="folks-backend-store-load-backends"><function>folks_backend_store_load_backends()</function></link> is called for the first time. If it isn&apos;t called explicitly, <link linkend="folks-backend-store-load-backends"><function>folks_backend_store_load_backends()</function></link> will call it.</para><para>This method is safe to call multiple times concurrently (e.g. an asynchronous call may begin between a subsequent asynchronous call beginning and finishing).</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-backend-store-prepare-finish"><function>folks_backend_store_prepare_finish()</function></link>
 *
 * Since: 0.3.0
 */
/**
 * folks_backend_store_prepare_finish:
 * @self: the <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * 
 * Prepare the BackendStore for use.
 * 
 * <para>This must only ever be called before <link linkend="folks-backend-store-load-backends"><function>folks_backend_store_load_backends()</function></link> is called for the first time. If it isn&apos;t called explicitly, <link linkend="folks-backend-store-load-backends"><function>folks_backend_store_load_backends()</function></link> will call it.</para><para>This method is safe to call multiple times concurrently (e.g. an asynchronous call may begin between a subsequent asynchronous call beginning and finishing).</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-backend-store-prepare"><function>folks_backend_store_prepare()</function></link>
 *
 * Since: 0.3.0
 */
/**
 * folks_backend_store_load_backends:
 * @self: the <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> instance
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Find, load, and prepare all backends which are not disabled.
 * 
 * <para>Backends will be searched for in the path given by the <code>FOLKS_BACKEND_PATH</code> environment variable, if it&apos;s set. If it&apos;s not set, backends will be searched for in a path set at compilation time.</para><para>This method is not safe to call multiple times concurrently.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>currently unused </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-backend-store-load-backends-finish"><function>folks_backend_store_load_backends_finish()</function></link>
 */
/**
 * folks_backend_store_load_backends_finish:
 * @self: the <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Find, load, and prepare all backends which are not disabled.
 * 
 * <para>Backends will be searched for in the path given by the <code>FOLKS_BACKEND_PATH</code> environment variable, if it&apos;s set. If it&apos;s not set, backends will be searched for in a path set at compilation time.</para><para>This method is not safe to call multiple times concurrently.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>currently unused </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-backend-store-load-backends"><function>folks_backend_store_load_backends()</function></link>
 */
/**
 * folks_backend_store_add_backend:
 * @self: the <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> instance
 * @backend: (in): &nbsp;.  <para>the <link linkend="FolksBackend"><type>FolksBackend</type></link> to add </para>
 * 
 * Add a new <link linkend="FolksBackend"><type>FolksBackend</type></link> to the BackendStore.
 */
/**
 * folks_backend_store_dup_backend_by_name:
 * @self: the <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> instance
 * @name: (in): &nbsp;.  <para>the backend name to retrieve </para>
 * 
 * Get a backend from the store by name. If a backend is returned, its reference count is increased.
 * 
 * Returns: <para>the backend, or <code>null</code> if none could be found </para>
 *
 * Since: 0.3.5
 */
/**
 * folks_backend_store_list_backends:
 * @self: the <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> instance
 * 
 * List the currently loaded backends.
 * 
 * Returns: <para>a list of the backends currently in the BackendStore </para>
 */
/**
 * folks_backend_store_enable_backend:
 * @self: the <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> instance
 * @name: (in): &nbsp;.  <para>the name of the backend to enable </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Enable a backend.
 * 
 * <para>Mark a backend as enabled, such that the BackendStore will always attempt to load it when <link linkend="folks-backend-store-load-backends"><function>folks_backend_store_load_backends()</function></link> is called. This will not load the backend if it&apos;s not currently loaded.</para><para>This method is safe to call multiple times concurrently (e.g. an asynchronous call may begin after a previous asynchronous call for the same backend name has begun and before it has finished).</para><para>If the backend is disallowed by the FOLKS_BACKENDS_ALLOWED and/or FOLKS_BACKENDS_DISABLED environment variables, this method will store the fact that it should be enabled in future, but will not enable it during this application run.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-backend-store-enable-backend-finish"><function>folks_backend_store_enable_backend_finish()</function></link>
 *
 * Since: 0.3.2
 */
/**
 * folks_backend_store_enable_backend_finish:
 * @self: the <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * 
 * Enable a backend.
 * 
 * <para>Mark a backend as enabled, such that the BackendStore will always attempt to load it when <link linkend="folks-backend-store-load-backends"><function>folks_backend_store_load_backends()</function></link> is called. This will not load the backend if it&apos;s not currently loaded.</para><para>This method is safe to call multiple times concurrently (e.g. an asynchronous call may begin after a previous asynchronous call for the same backend name has begun and before it has finished).</para><para>If the backend is disallowed by the FOLKS_BACKENDS_ALLOWED and/or FOLKS_BACKENDS_DISABLED environment variables, this method will store the fact that it should be enabled in future, but will not enable it during this application run.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-backend-store-enable-backend"><function>folks_backend_store_enable_backend()</function></link>
 *
 * Since: 0.3.2
 */
/**
 * folks_backend_store_disable_backend:
 * @self: the <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> instance
 * @name: (in): &nbsp;.  <para>the name of the backend to disable </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Disable a backend.
 * 
 * <para>Mark a backend as disabled, such that it won&apos;t be loaded even when the client application is restarted. This will not remove the backend if it&apos;s already loaded.</para><para>This method is safe to call multiple times concurrently (e.g. an asynchronous call may begin after a previous asynchronous call for the same backend name has begun and before it has finished).</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-backend-store-disable-backend-finish"><function>folks_backend_store_disable_backend_finish()</function></link>
 *
 * Since: 0.3.2
 */
/**
 * folks_backend_store_disable_backend_finish:
 * @self: the <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * 
 * Disable a backend.
 * 
 * <para>Mark a backend as disabled, such that it won&apos;t be loaded even when the client application is restarted. This will not remove the backend if it&apos;s already loaded.</para><para>This method is safe to call multiple times concurrently (e.g. an asynchronous call may begin after a previous asynchronous call for the same backend name has begun and before it has finished).</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-backend-store-disable-backend"><function>folks_backend_store_disable_backend()</function></link>
 *
 * Since: 0.3.2
 */
/**
 * FolksBackendStore:enabled-backends:
 * 
 * The list of backends visible to this store which have not been explicitly disabled.
 * 
 * <para>This list will be empty before <link linkend="folks-backend-store-load-backends"><function>folks_backend_store_load_backends()</function></link> has been called.</para><para>The backends in this list have been prepared and are ready to use.</para>
 *
 * Since: 0.5.1
 */
/**
 * folks_backend_store_get_enabled_backends:
 * @self: the <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksBackendStore--enabled-backends"><type>"enabled-backends"</type></link> property.
 * 
 * The list of backends visible to this store which have not been explicitly disabled.
 * 
 * <para>This list will be empty before <link linkend="folks-backend-store-load-backends"><function>folks_backend_store_load_backends()</function></link> has been called.</para><para>The backends in this list have been prepared and are ready to use.</para>
 * 
 * Returns: the value of the <link linkend="FolksBackendStore--enabled-backends"><type>"enabled-backends"</type></link> property
 *
 * Since: 0.5.1
 */
/**
 * FolksBackendStore:is-prepared:
 * 
 * Whether <link linkend="folks-backend-store-prepare"><function>folks_backend_store_prepare()</function></link> has successfully completed for this store.
 *
 * Since: 0.3.0
 */
/**
 * folks_backend_store_get_is_prepared:
 * @self: the <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksBackendStore--is-prepared"><type>"is-prepared"</type></link> property.
 * 
 * Whether <link linkend="folks-backend-store-prepare"><function>folks_backend_store_prepare()</function></link> has successfully completed for this store.
 * 
 * Returns: the value of the <link linkend="FolksBackendStore--is-prepared"><type>"is-prepared"</type></link> property
 *
 * Since: 0.3.0
 */
/**
 * FolksBackendStore::backend-available:
 * @backend_store: the <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> instance that received the signal
 * @backend: &nbsp;.  <para>the new <link linkend="FolksBackend"><type>FolksBackend</type></link> </para><para></para>
 * 
 * Emitted when a backend has been added to the BackendStore.
 * 
 * <para>This will not be emitted until after <link linkend="folks-backend-store-load-backends"><function>folks_backend_store_load_backends()</function></link> has been called.</para><para><link linkend="FolksBackend"><type>FolksBackend</type></link>s referenced in this signal are also included in <link linkend="FolksBackendStore--enabled-backends"><type>"enabled-backends"</type></link>.</para>
 */
/**
 * folks_backend_store_dup:
 * 
 * Create a new BackendStore.
 */
/**
 * FolksBackendStore:
 * @folks_backend_store_KEY_FILE_GROUP_ALL_OTHERS: This keyword in the keyfile acts as a wildcard for all backends not already listed in the same file.<para>This is particularly useful for tests which want to ensure they&apos;re only operating with backends they were designed for (and thus may not be able to enumerate entries for).</para><para>To avoid conflicts, backends must not use this as a name.</para>
 * 
 * Responsible for backend loading.
 * 
 * <para>The BackendStore manages the set of available Folks backends. The <link linkend="folks-backend-store-load-backends"><function>folks_backend_store_load_backends()</function></link> function loads all compatible and enabled backends and the <link linkend="FolksBackendStore-backend-available"><type>"backend-available"</type></link> signal notifies when these backends are ready.</para>
 */
/**
 * FolksBackendStoreClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-BACKEND-STORE:CAPS"><literal>FOLKS_TYPE_BACKEND_STORE</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
