/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.Component;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.search.BufferListSet;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class AllBufferSet
extends BufferListSet {
    private final String glob;
    private final View view;

    public AllBufferSet(String string, View view) {
        this.glob = string;
        this.view = view;
    }

    public View getView() {
        return this.view;
    }

    public String getFileFilter() {
        return this.glob;
    }

    @Override
    public String getCode() {
        return "new AllBufferSet(\"" + StandardUtilities.charsToEscapes(this.glob) + "\", view)";
    }

    @Override
    protected String[] _getFiles(Component component) {
        Pattern pattern;
        Buffer[] bufferArray = this.view.getBuffers();
        ArrayList<String> arrayList = new ArrayList<String>(bufferArray.length);
        try {
            pattern = Pattern.compile(StandardUtilities.globToRE(this.glob), 2);
        }
        catch (Exception exception) {
            Log.log(9, this, "Error compiling Glob Pattern: " + this.glob, exception);
            return null;
        }
        for (Buffer buffer : bufferArray) {
            if (!pattern.matcher(buffer.getName()).matches()) continue;
            arrayList.add(buffer.getPath());
        }
        return arrayList.toArray(StandardUtilities.EMPTY_STRING_ARRAY);
    }
}

