/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public enum LoadingState {
    BOOTSTRAP("bootstrap"),
    LAF_INITIALIZED("LaF is initialized"),
    COMPONENTS_REGISTERED("app component registered"),
    CONFIGURATION_STORE_INITIALIZED("app store initialized"),
    COMPONENTS_LOADED("app component loaded"),
    APP_STARTED("app started"),
    PROJECT_OPENED("project opened"),
    INDEXING_FINISHED("indexing finished");

    final String displayName;
    private static boolean CHECK_LOADING_PHASE;
    private static Set<Throwable> stackTraces;

    private LoadingState(String displayName) {
        if (displayName == null) {
            LoadingState.$$$reportNull$$$0(0);
        }
        this.displayName = displayName;
    }

    @NotNull
    static Logger getLogger() {
        Logger logger = Logger.getInstance(LoadingState.class);
        if (logger == null) {
            LoadingState.$$$reportNull$$$0(1);
        }
        return logger;
    }

    public void checkOccurred() {
        if (!CHECK_LOADING_PHASE) {
            return;
        }
        LoadingState currentState = StartUpMeasurer.currentState.get();
        if (currentState.ordinal() >= this.ordinal() || LoadingState.isKnownViolator()) {
            return;
        }
        this.logStateError(currentState);
    }

    private synchronized void logStateError(@NotNull LoadingState currentState) {
        if (currentState == null) {
            LoadingState.$$$reportNull$$$0(2);
        }
        Throwable t = new Throwable();
        if (stackTraces == null) {
            stackTraces = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<Throwable>(){

                public int computeHashCode(Throwable throwable) {
                    return this.fingerprint(throwable).hashCode();
                }

                public boolean equals(Throwable o1, Throwable o2) {
                    return o1 == o2 || o1 != null && o2 != null && this.fingerprint(o1).equals(this.fingerprint(o2));
                }

                private String fingerprint(Throwable throwable) {
                    StringBuilder sb = new StringBuilder();
                    for (StackTraceElement traceElement : throwable.getStackTrace()) {
                        sb.append(traceElement.getClassName()).append(traceElement.getMethodName());
                    }
                    return sb.toString();
                }
            });
        }
        if (!stackTraces.add(t)) {
            return;
        }
        LoadingState.getLogger().error("Should be called at least in the state " + (Object)((Object)this) + ", the current state is: " + (Object)((Object)currentState) + "\nCurrent violators count: " + stackTraces.size() + "\n\n", t);
    }

    private static boolean isKnownViolator() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            String className2 = element.getClassName();
            if (!className2.contains("com.intellij.util.indexing.IndexInfrastructure") && !className2.contains("com.intellij.psi.impl.search.IndexPatternSearcher") && !className2.contains("com.jetbrains.performancePlugin.ProjectLoaded") && !className2.contains("com.jetbrains.python.conda.InstallCondaUtils")) continue;
            return true;
        }
        return false;
    }

    public boolean isOccurred() {
        return StartUpMeasurer.currentState.get().ordinal() >= this.ordinal();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/LoadingState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/LoadingState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "logStateError";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

