/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.bridj.BridJ;
import org.bridj.StructFieldDescription;
import org.bridj.ann.Alignment;
import org.bridj.ann.Array;
import org.bridj.ann.Bits;
import org.bridj.ann.CLong;
import org.bridj.ann.Field;
import org.bridj.ann.Ptr;
import org.bridj.ann.Union;
import org.bridj.util.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StructFieldDeclaration {
    final StructFieldDescription desc = new StructFieldDescription();
    Method setter;
    long index = -1L;
    long unionWith = -1L;
    Class<?> valueClass;
    Class<?> declaringClass;

    StructFieldDeclaration() {
    }

    public String toString() {
        return this.desc.name + " (index = " + this.index + (this.unionWith < 0L ? "" : ", unionWith = " + this.unionWith) + ", desc = " + this.desc + ")";
    }

    protected static boolean acceptFieldGetter(Member member, boolean getter) {
        if (member instanceof Method && ((Method)member).getParameterTypes().length != (getter ? 0 : 1)) {
            return false;
        }
        if (((AnnotatedElement)((Object)member)).getAnnotation(Field.class) == null) {
            return false;
        }
        int modifiers = member.getModifiers();
        return !Modifier.isStatic(modifiers);
    }

    protected static List<StructFieldDeclaration> listFields(Class<?> structClass) {
        ArrayList<StructFieldDeclaration> list2 = new ArrayList<StructFieldDeclaration>();
        for (Method method : structClass.getMethods()) {
            if (!StructFieldDeclaration.acceptFieldGetter(method, true)) continue;
            StructFieldDeclaration io = StructFieldDeclaration.fromGetter(method);
            try {
                Method setter = structClass.getMethod(method.getName(), io.valueClass);
                if (StructFieldDeclaration.acceptFieldGetter(setter, false)) {
                    io.setter = setter;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (io == null) continue;
            list2.add(io);
        }
        int nFieldFields = 0;
        for (java.lang.reflect.Field field : structClass.getFields()) {
            StructFieldDeclaration io;
            if (!StructFieldDeclaration.acceptFieldGetter(field, true) || (io = StructFieldDeclaration.fromField(field)) == null) continue;
            list2.add(io);
            ++nFieldFields;
        }
        if (nFieldFields > 0 && BridJ.warnStructFields) {
            BridJ.warning("Struct " + structClass.getName() + " has " + nFieldFields + " struct fields implemented as Java fields, which won't give the best performance and might require counter-intuitive calls to BridJ.readFromNative / .writeToNative. Please consider using JNAerator to generate your struct instead, or use BRIDJ_WARN_STRUCT_FIELDS=0 or -Dbridj.warnStructFields=false to mute this warning.");
        }
        return list2;
    }

    protected static StructFieldDeclaration fromField(java.lang.reflect.Field getter) {
        StructFieldDeclaration field = StructFieldDeclaration.fromMember(getter);
        field.desc.field = getter;
        field.desc.valueType = getter.getGenericType();
        field.valueClass = getter.getType();
        return field;
    }

    protected static StructFieldDeclaration fromGetter(Method getter) {
        StructFieldDeclaration field = StructFieldDeclaration.fromMember(getter);
        field.desc.getter = getter;
        field.desc.valueType = getter.getGenericReturnType();
        field.valueClass = getter.getReturnType();
        return field;
    }

    private static StructFieldDeclaration fromMember(Member member) {
        StructFieldDeclaration field = new StructFieldDeclaration();
        field.declaringClass = member.getDeclaringClass();
        String name = member.getName();
        if (name.matches("get[A-Z].*")) {
            name = Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        field.desc.name = name;
        AnnotatedElement getter = (AnnotatedElement)((Object)member);
        Field fil = getter.getAnnotation(Field.class);
        Bits bits = getter.getAnnotation(Bits.class);
        Alignment alignment = getter.getAnnotation(Alignment.class);
        Array arr = getter.getAnnotation(Array.class);
        if (fil != null) {
            field.index = fil.value();
            field.unionWith = fil.unionWith();
        }
        if (field.unionWith < 0L && field.declaringClass.getAnnotation(Union.class) != null) {
            field.unionWith = 0L;
        }
        if (bits != null) {
            field.desc.bitLength = bits.value();
        }
        if (alignment != null) {
            field.desc.alignment = alignment.value();
        }
        if (arr != null) {
            long length = 1L;
            for (long dim : arr.value()) {
                length *= dim;
            }
            field.desc.arrayLength = length;
            field.desc.isArray = true;
        }
        field.desc.isCLong = AnnotationUtils.isAnnotationPresent(CLong.class, getter, new Annotation[0]);
        field.desc.isSizeT = AnnotationUtils.isAnnotationPresent(Ptr.class, getter, new Annotation[0]);
        return field;
    }
}

