/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.util.Date;
import javax.swing.KeyStroke;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.Configurator;
import net.sf.sdedit.ui.components.configuration.DataObject;
import net.sf.sdedit.ui.components.configuration.configurators.BooleanConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.ButtonConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.ColorConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.DateConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.FileConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.FileSetConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.FontConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.FreeStringConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.KeyStrokeConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.NumberConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.SingleStringSelectionConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.SmallStringSelectionConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.StringSetConfigurator;

public class ConfiguratorFactory<C extends DataObject> {
    public Configurator<?, C> createConfigurator(Bean<C> bean, PropertyDescriptor property) {
        Adjustable adj = property.getWriteMethod().getAnnotation(Adjustable.class);
        if (property.getPropertyType().equals(String.class)) {
            String[] choices = adj.choices();
            if (choices.length > 0) {
                if (!adj.forceComboBox() && choices.length <= 3) {
                    return new SmallStringSelectionConfigurator<C>(bean, property);
                }
                return new SingleStringSelectionConfigurator<C>(bean, property, adj.isComboBoxEditable());
            }
            if (!adj.stringSelectionProvided()) {
                return new FreeStringConfigurator<C>(bean, property);
            }
            return new SingleStringSelectionConfigurator<C>(bean, property, adj.isComboBoxEditable());
        }
        if (property.getPropertyType().equals(String[].class)) {
            return new StringSetConfigurator<C>(bean, property);
        }
        if (property.getPropertyType().equals(Integer.TYPE)) {
            return new NumberConfigurator<C>(bean, property);
        }
        if (property.getPropertyType().equals(Boolean.TYPE)) {
            if (adj.button()) {
                return new ButtonConfigurator<C>(bean, property);
            }
            return new BooleanConfigurator<C>(bean, property);
        }
        if (property.getPropertyType().equals(Font.class)) {
            return new FontConfigurator<C>(bean, property);
        }
        if (property.getPropertyType().equals(File.class)) {
            return new FileConfigurator<C>(bean, property);
        }
        if (property.getPropertyType().equals(File[].class)) {
            return new FileSetConfigurator<C>(bean, property);
        }
        if (property.getPropertyType().equals(KeyStroke.class)) {
            return new KeyStrokeConfigurator<C>(bean, property);
        }
        if (property.getPropertyType().equals(Color.class)) {
            return new ColorConfigurator<C>(bean, property);
        }
        if (property.getPropertyType().equals(Date.class)) {
            return new DateConfigurator<C>(bean, property);
        }
        throw new IllegalArgumentException("cannot create configurator for property type " + property.getPropertyType().getSimpleName());
    }
}

