/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java.impl;

import com.sun.tools.visualvm.heapviewer.HeapContext;
import com.sun.tools.visualvm.heapviewer.java.JavaHeapFragment;
import com.sun.tools.visualvm.heapviewer.java.impl.Bundle;
import com.sun.tools.visualvm.heapviewer.java.impl.FilterUtils;
import com.sun.tools.visualvm.heapviewer.java.impl.JavaClassesProvider;
import com.sun.tools.visualvm.heapviewer.java.impl.JavaDiffDumpSelector;
import com.sun.tools.visualvm.heapviewer.java.impl.JavaDiffObjectsView;
import com.sun.tools.visualvm.heapviewer.java.impl.JavaInstancesProvider;
import com.sun.tools.visualvm.heapviewer.model.DataType;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNodeFilter;
import com.sun.tools.visualvm.heapviewer.model.Progress;
import com.sun.tools.visualvm.heapviewer.model.RootNode;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerActions;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerFeature;
import com.sun.tools.visualvm.heapviewer.ui.PluggableTreeTableView;
import com.sun.tools.visualvm.heapviewer.ui.TreeTableViewColumn;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.swing.ActionPopupButton;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.RequestProcessor;

public class JavaObjectsView
extends HeapViewerFeature {
    private final HeapContext context;
    private final HeapViewerActions actions;
    private final PluggableTreeTableView objectsView;
    private ProfilerToolbar toolbar;
    private Preset preset;
    private Aggregation aggregation;
    private JToggleButton tbType;
    private JToggleButton tbPackages;
    private JToggleButton tbClasses;
    private JToggleButton tbInstances;
    private Runnable dominatorsRefresher;

    public JavaObjectsView(HeapContext context, HeapViewerActions actions) {
        super("java_objects", Bundle.JavaObjectsView_Name(), Bundle.JavaObjectsView_Description(), Icons.getIcon((String)"LanguageIcons.Class"), 200);
        this.context = context;
        this.actions = actions;
        final Heap heap = context.getFragment().getHeap();
        this.objectsView = new PluggableTreeTableView("java_objects", context, actions, TreeTableViewColumn.classes(heap, true)){

            @Override
            protected HeapViewerNode[] computeData(RootNode root, Heap heap2, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) {
                switch (JavaObjectsView.this.getPreset()) {
                    case ALL_OBJECTS: {
                        switch (JavaObjectsView.this.getAggregation()) {
                            case PACKAGES: {
                                return JavaClassesProvider.getHeapPackages(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress);
                            }
                            case CLASSES: {
                                return JavaClassesProvider.getHeapClasses(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress);
                            }
                        }
                        return JavaInstancesProvider.getHeapInstances(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress);
                    }
                    case DOMINATORS: {
                        switch (JavaObjectsView.this.getAggregation()) {
                            case PACKAGES: {
                                return JavaClassesProvider.getHeapDominators(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress, 2);
                            }
                            case CLASSES: {
                                return JavaClassesProvider.getHeapDominators(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress, 1);
                            }
                        }
                        return JavaClassesProvider.getHeapDominators(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress, 0);
                    }
                    case GC_ROOTS: {
                        switch (JavaObjectsView.this.getAggregation()) {
                            case TYPES: {
                                return JavaClassesProvider.getHeapGCRoots(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress, 3);
                            }
                            case PACKAGES: {
                                return JavaClassesProvider.getHeapGCRoots(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress, 2);
                            }
                            case CLASSES: {
                                return JavaClassesProvider.getHeapGCRoots(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress, 1);
                            }
                        }
                        return JavaClassesProvider.getHeapGCRoots(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress, 0);
                    }
                }
                return HeapViewerNode.NO_NODES;
            }

            @Override
            protected JComponent createComponent() {
                JComponent comp = super.createComponent();
                this.setFilterComponent(FilterUtils.createFilterPanel(this));
                return comp;
            }

            @Override
            protected void populatePopupLast(HeapViewerNode node, JPopupMenu popup) {
                super.populatePopupLast(node, popup);
                JavaClass javaClass = HeapViewerNode.getValue(node, DataType.CLASS, heap);
                final String className = javaClass == null || javaClass.isArray() ? null : javaClass.getName();
                popup.add(new JMenuItem(Bundle.JavaObjectsView_FilterSubclasses()){
                    {
                        super(x0);
                        this.setEnabled(className != null);
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        JComponent filterComponent = this.getFilterComponent();
                        filterComponent.setVisible(true);
                        FilterUtils.filterSubclasses(className, filterComponent);
                    }
                });
            }
        };
    }

    @Override
    public JComponent getComponent() {
        if (this.toolbar == null) {
            this.init();
        }
        return this.objectsView.getComponent();
    }

    @Override
    public ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.init();
        }
        return this.toolbar;
    }

    private synchronized void setPreset(Preset preset) {
        Heap heap;
        if (preset == Preset.DOMINATORS && !DataType.RETAINED_SIZE.valuesAvailable(heap = this.context.getFragment().getHeap())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JavaObjectsView.this.dominatorsRefresher = new Runnable(){

                        @Override
                        public void run() {
                            if (JavaObjectsView.this.getPreset() == Preset.DOMINATORS) {
                                JavaObjectsView.this.objectsView.reloadView();
                            }
                            JavaObjectsView.this.dominatorsRefresher = null;
                        }
                    };
                    DataType.RETAINED_SIZE.notifyWhenAvailable(heap, JavaObjectsView.this.dominatorsRefresher);
                    DataType.RETAINED_SIZE.computeValues(heap, null);
                }
            });
        }
        this.preset = preset;
        this.objectsView.setViewName(preset.toString());
        this.tbType.setVisible(preset == Preset.GC_ROOTS);
        if (this.tbType.isSelected() && !this.tbType.isVisible()) {
            this.tbClasses.setSelected(true);
        } else {
            this.objectsView.reloadView();
        }
    }

    private synchronized Preset getPreset() {
        return this.preset;
    }

    private synchronized void setAggregation(Aggregation aggregation) {
        this.aggregation = aggregation;
        this.objectsView.reloadView();
    }

    private synchronized Aggregation getAggregation() {
        return this.aggregation;
    }

    private void init() {
        this.toolbar = ProfilerToolbar.create((boolean)false);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(2);
        JButton compareButton = new JButton(Icons.getIcon((String)"ProfilerIcons.SnapshotsCompare")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final JavaDiffDumpSelector.Result r = JavaDiffDumpSelector.selectSnapshot(JavaObjectsView.this.context, false);
                        if (r != null) {
                            new RequestProcessor().post(new Runnable(){

                                @Override
                                public void run() {
                                    JavaDiffObjectsView v = new JavaDiffObjectsView(JavaObjectsView.this.context, r.getFile(), r.compareRetained(), JavaObjectsView.this.actions);
                                    JavaObjectsView.this.actions.addView(v, true);
                                }
                            });
                        }
                    }
                });
            }
        };
        compareButton.setToolTipText(Bundle.JavaObjectsView_Compare());
        this.toolbar.add((Component)compareButton);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new GrayLabel(Bundle.JavaObjectsView_Preset()));
        this.toolbar.addSpace(2);
        Preset[] presetItems = Preset.values();
        class PresetAction
        extends AbstractAction {
            final Preset preset;

            PresetAction(Preset preset) {
                this.preset = preset;
                this.putValue("Name", preset.toString());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaObjectsView.this.setPreset(this.preset);
            }
        }
        Action[] presetActions = new PresetAction[presetItems.length];
        for (int i = 0; i < presetItems.length; ++i) {
            presetActions[i] = new PresetAction(presetItems[i]);
        }
        this.preset = Preset.ALL_OBJECTS;
        this.objectsView.setViewName(Preset.ALL_OBJECTS.toString());
        this.toolbar.add((Component)new ActionPopupButton(0, presetActions));
        this.toolbar.addSpace(8);
        this.toolbar.add((Component)new GrayLabel(Bundle.JavaObjectsView_Aggregation()));
        this.toolbar.addSpace(2);
        final ButtonGroup aggregationBG = new ButtonGroup();
        this.tbType = new AggregationButton(Aggregation.TYPES){
            {
                class AggregationButton
                extends JToggleButton {
                    private final Aggregation aggregation;

                    AggregationButton(Aggregation aggregation) {
                        super(aggregation.getIcon());
                        this.aggregation = aggregation;
                        this.setToolTipText(aggregation.toString());
                        aggregationBG.add(this);
                    }

                    @Override
                    protected void fireItemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            JavaObjectsView.this.setAggregation(this.aggregation);
                        }
                    }
                }
                super(JavaObjectsView.this, aggregation, buttonGroup);
            }

            @Override
            public void setVisible(boolean b) {
                super.setVisible(b);
                if (JavaObjectsView.this.tbPackages != null) {
                    JavaObjectsView.this.tbPackages.putClientProperty("JButton.segmentPosition", b ? "middle" : "first");
                }
            }
        };
        this.tbType.putClientProperty("JButton.buttonType", "segmented");
        this.tbType.putClientProperty("JButton.segmentPosition", "first");
        this.toolbar.add((Component)this.tbType);
        this.tbPackages = new AggregationButton(Aggregation.PACKAGES);
        this.tbPackages.putClientProperty("JButton.buttonType", "segmented");
        this.tbPackages.putClientProperty("JButton.segmentPosition", "first");
        this.toolbar.add((Component)this.tbPackages);
        this.tbClasses = new AggregationButton(Aggregation.CLASSES);
        this.tbClasses.putClientProperty("JButton.buttonType", "segmented");
        this.tbClasses.putClientProperty("JButton.segmentPosition", "middle");
        this.toolbar.add((Component)this.tbClasses);
        this.tbInstances = new AggregationButton(Aggregation.INSTANCES);
        this.tbInstances.putClientProperty("JButton.buttonType", "segmented");
        this.tbInstances.putClientProperty("JButton.segmentPosition", "last");
        this.toolbar.add((Component)this.tbInstances);
        this.tbClasses.setSelected(true);
        this.aggregation = Aggregation.CLASSES;
        this.tbType.setVisible(false);
        if (this.objectsView.hasPlugins()) {
            this.toolbar.addSpace(8);
            this.toolbar.add((Component)new GrayLabel(Bundle.JavaObjectsView_Details()));
            this.toolbar.addSpace(2);
            this.toolbar.add(this.objectsView.getToolbar());
        }
    }

    public static class Provider
    extends HeapViewerFeature.Provider {
        @Override
        public HeapViewerFeature getFeature(HeapContext context, HeapViewerActions actions) {
            if (JavaHeapFragment.isJavaHeap(context)) {
                return new JavaObjectsView(context, actions);
            }
            return null;
        }
    }

    private static enum Aggregation {
        TYPES(Bundle.JavaObjectsView_Types(), Icons.getIcon((String)"ProfilerIcons.RunGC")),
        PACKAGES(Bundle.JavaObjectsView_Packages(), Icons.getIcon((String)"LanguageIcons.Package")),
        CLASSES(Bundle.JavaObjectsView_Classes(), Icons.getIcon((String)"LanguageIcons.Class")),
        INSTANCES(Bundle.JavaObjectsView_Instances(), Icons.getIcon((String)"LanguageIcons.Instance"));

        private final String aggregationName;
        private final Icon aggregationIcon;

        private Aggregation(String aggregationName, Icon aggregationIcon) {
            this.aggregationName = aggregationName;
            this.aggregationIcon = aggregationIcon;
        }

        public String toString() {
            return this.aggregationName;
        }

        public Icon getIcon() {
            return this.aggregationIcon;
        }
    }

    private static enum Preset {
        ALL_OBJECTS(Bundle.JavaObjectsView_AllObjects()),
        DOMINATORS(Bundle.JavaObjectsView_Dominators()),
        GC_ROOTS(Bundle.JavaObjectsView_GcRoots());

        private final String presetName;

        private Preset(String presetName) {
            this.presetName = presetName;
        }

        public String toString() {
            return this.presetName;
        }
    }
}

