/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.netbeans;

import java.util.AbstractList;
import java.util.List;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

public class EditorDetailsProvider
extends DetailsProvider.Basic {
    private static final String CHAR_CONTENT = "org.netbeans.modules.editor.lib2.document.CharContent";

    public EditorDetailsProvider() {
        super(CHAR_CONTENT);
    }

    @Override
    public String getDetailsString(String string, Instance instance, Heap heap) {
        if (CHAR_CONTENT.equals(string)) {
            int n = DetailsUtils.getIntFieldValue(instance, "gapStart", -1);
            int n2 = DetailsUtils.getIntFieldValue(instance, "gapLength", -1);
            PrimitiveArrayInstance primitiveArrayInstance = (PrimitiveArrayInstance)instance.getValueOfField("buffer");
            if (n >= 0 && n2 >= 0 && primitiveArrayInstance != null) {
                CharArrayWithGap charArrayWithGap = new CharArrayWithGap(primitiveArrayInstance, n, n2);
                return DetailsUtils.getPrimitiveArrayString((Instance)charArrayWithGap, 0, charArrayWithGap.getLength(), "", "...");
            }
        }
        return null;
    }

    private class CharArrayWithGap
    implements PrimitiveArrayInstance {
        PrimitiveArrayInstance buffer;
        int gapStart;
        int gapLength;

        private CharArrayWithGap(PrimitiveArrayInstance primitiveArrayInstance, int n, int n2) {
            this.buffer = primitiveArrayInstance;
            this.gapStart = n;
            this.gapLength = n2;
        }

        public int getLength() {
            return this.buffer.getLength() - this.gapLength;
        }

        public List getValues() {
            final List list = this.buffer.getValues();
            return new AbstractList(){

                @Override
                public Object get(int n) {
                    return list.get(CharArrayWithGap.this.rawOffset(n));
                }

                @Override
                public int size() {
                    return CharArrayWithGap.this.getLength();
                }
            };
        }

        private int rawOffset(int n) {
            return n < this.gapStart ? n : n + this.gapLength;
        }

        public List getFieldValues() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isGCRoot() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getInstanceId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getInstanceNumber() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public JavaClass getJavaClass() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Instance getNearestGCRootPointer() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getReachableSize() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List getReferences() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getRetainedSize() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getSize() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List getStaticFieldValues() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object getValueOfField(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

