/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.locks;

import javax.swing.Icon;
import org.netbeans.lib.profiler.results.locks.LockCCTNode;
import org.netbeans.lib.profiler.ui.results.PackageColorer;
import org.netbeans.lib.profiler.ui.swing.renderer.NormalBoldGrayRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

public class LockContentionRenderer
extends NormalBoldGrayRenderer {
    private static final Icon THREAD_ICON = Icons.getIcon((String)"ProfilerIcons.Thread");
    private static final Icon LOCK_ICON = Icons.getIcon((String)"ProfilerIcons.WindowLocks");

    @Override
    public void setValue(Object object, int n) {
        if (object == null) {
            this.setNormalValue("");
            this.setBoldValue("");
            this.setGrayValue("");
            this.setIcon(null);
        } else {
            LockCCTNode lockCCTNode = (LockCCTNode)object;
            boolean bl = lockCCTNode.isThreadLockNode();
            boolean bl2 = lockCCTNode.isMonitorNode();
            String string = lockCCTNode.getNodeName();
            int n2 = string.indexOf(40);
            int n3 = string.lastIndexOf(46);
            String string2 = this.getNormalValue(lockCCTNode, string, n2, n3, bl);
            String string3 = this.getBoldValue(lockCCTNode, string, n2, n3, bl);
            String string4 = this.getGrayValue(lockCCTNode, string, n2, n3, bl);
            this.setNormalValue(string2);
            this.setBoldValue(string3);
            this.setGrayValue(string4);
            Icon icon = null;
            if (bl) {
                icon = THREAD_ICON;
            } else if (bl2) {
                icon = LOCK_ICON;
            }
            this.setIcon(icon);
            this.setCustomForeground(bl2 ? PackageColorer.getForeground(string2) : null);
        }
    }

    private String getNormalValue(LockCCTNode lockCCTNode, String string, int n, int n2, boolean bl) {
        if (bl) {
            return lockCCTNode.getParent().getParent() == null ? "" : string;
        }
        if (n2 == -1 && n == -1) {
            return string;
        }
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string.substring(0, n2 + 1);
    }

    private String getBoldValue(LockCCTNode lockCCTNode, String string, int n, int n2, boolean bl) {
        if (bl) {
            return lockCCTNode.getParent().getParent() == null ? string : "";
        }
        if (n2 == -1 && n == -1) {
            return "";
        }
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string.substring(n2 + 1);
    }

    private String getGrayValue(LockCCTNode lockCCTNode, String string, int n, int n2, boolean bl) {
        if (bl) {
            return "";
        }
        return n != -1 ? " " + string.substring(n) : "";
    }
}

