/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.ByteArrayInputStream;
import java.util.zip.Deflater;
import net.sourceforge.plantuml.code.ByteArray;
import net.sourceforge.plantuml.code.Compression;
import net.sourceforge.plantuml.code.CompressionZopfliZlib;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import net.sourceforge.plantuml.code.deflate.ByteBitInputStream;
import net.sourceforge.plantuml.code.deflate.Decompressor;

public class CompressionZlibPure
implements Compression {
    private static boolean USE_ZOPFLI = false;
    private static final int COMPRESSION_LEVEL = 9;

    @Override
    public byte[] compress(byte[] in) {
        if (USE_ZOPFLI) {
            return new CompressionZopfliZlib().compress(in);
        }
        if (in.length == 0) {
            return null;
        }
        int len = in.length * 2;
        if (len < 1000) {
            len = 1000;
        }
        Deflater compresser = new Deflater(9, true);
        compresser.setInput(in);
        compresser.finish();
        byte[] output = new byte[len];
        int compressedDataLength = compresser.deflate(output);
        if (!compresser.finished()) {
            return null;
        }
        return this.copyArray(output, compressedDataLength);
    }

    @Override
    public ByteArray decompress(byte[] in) throws NoPlantumlCompressionException {
        ByteBitInputStream in2 = new ByteBitInputStream(new ByteArrayInputStream(in));
        try {
            return ByteArray.from(Decompressor.decompress(in2));
        }
        catch (Exception e) {
            throw new NoPlantumlCompressionException(e);
        }
    }

    private byte[] copyArray(byte[] data, int len) {
        byte[] result = new byte[len];
        System.arraycopy(data, 0, result, 0, len);
        return result;
    }
}

