/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.wbs.Fork;
import net.sourceforge.plantuml.wbs.WElement;

public class WBSDiagram
extends UmlDiagram {
    public static final Pattern2 patternStereotype = MyPattern.cmpile("^\\s*(.*?)(?:\\s*\\<\\<\\s*(.*)\\s*\\>\\>)\\s*$");
    private WElement root;
    private WElement last;

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("Work Breakdown Structure");
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.WBS;
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        double margin2;
        double margin1;
        Scale scale = this.getScale();
        double dpiFactor = scale == null ? this.getScaleCoef(fileFormatOption) : scale.getScale(100.0, 100.0);
        ISkinParam skinParam = this.getSkinParam();
        if (SkinParam.USE_STYLES()) {
            margin1 = SkinParam.zeroMargin(10);
            margin2 = SkinParam.zeroMargin(10);
        } else {
            margin1 = 10.0;
            margin2 = 10.0;
        }
        ImageBuilder imageBuilder = ImageBuilder.buildB(skinParam.getColorMapper(), skinParam.handwritten(), ClockwiseTopRightBottomLeft.margin1margin2(margin1, margin2), null, fileFormatOption.isWithMetadata() ? this.getMetadata() : null, "", dpiFactor, skinParam.getBackgroundColor(false));
        TextBlockBackcolored result = this.getTextBlock();
        result = new AnnotatedWorker(this, skinParam, fileFormatOption.getDefaultStringBounder()).addAdd(result);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.seed(), os);
    }

    private TextBlockBackcolored getTextBlock() {
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                WBSDiagram.this.drawMe(ug);
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return WBSDiagram.this.getDrawingElement().calculateDimension(stringBounder);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HColor getBackcolor() {
                return null;
            }
        };
    }

    private void drawMe(UGraphic ug) {
        this.getDrawingElement().drawU(ug);
    }

    private TextBlock getDrawingElement() {
        return new Fork(this.getSkinParam(), this.root);
    }

    public CommandExecutionResult addIdea(int level, String label, Direction direction, IdeaShape shape) {
        Matcher2 m = patternStereotype.matcher(label);
        String stereotype = null;
        if (m.matches()) {
            label = m.group(1);
            stereotype = m.group(2);
        }
        if (level == 0) {
            if (this.root != null) {
                return CommandExecutionResult.error("Error 44");
            }
            this.initRoot(label, stereotype);
            return CommandExecutionResult.ok();
        }
        return this.add(level, label, stereotype, direction, shape);
    }

    private void initRoot(String label, String stereotype) {
        this.last = this.root = new WElement(Display.getWithNewlines(label), stereotype, this.getSkinParam().getCurrentStyleBuilder());
    }

    private WElement getParentOfLast(int nb) {
        WElement result = this.last;
        for (int i = 0; i < nb; ++i) {
            result = result.getParent();
        }
        return result;
    }

    private CommandExecutionResult add(int level, String label, String stereotype, Direction direction, IdeaShape shape) {
        if (level == this.last.getLevel() + 1) {
            WElement newIdea;
            this.last = newIdea = this.last.createElement(level, Display.getWithNewlines(label), stereotype, direction, shape, this.getSkinParam().getCurrentStyleBuilder());
            return CommandExecutionResult.ok();
        }
        if (level <= this.last.getLevel()) {
            WElement newIdea;
            int diff = this.last.getLevel() - level + 1;
            this.last = newIdea = this.getParentOfLast(diff).createElement(level, Display.getWithNewlines(label), stereotype, direction, shape, this.getSkinParam().getCurrentStyleBuilder());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("error42L");
    }
}

