/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.tomcat.dbcp.dbcp.AbandonedConfig;
import org.apache.tomcat.dbcp.dbcp.DelegatingConnection;
import org.apache.tomcat.dbcp.pool.ObjectPool;

public class PoolableConnection
extends DelegatingConnection {
    protected ObjectPool<PoolableConnection> _pool = null;

    public PoolableConnection(Connection connection, ObjectPool<PoolableConnection> objectPool) {
        super(connection);
        this._pool = objectPool;
    }

    public PoolableConnection(Connection connection, ObjectPool<PoolableConnection> objectPool, AbandonedConfig abandonedConfig) {
        super(connection, abandonedConfig);
        this._pool = objectPool;
    }

    @Override
    public synchronized void close() throws SQLException {
        boolean bl;
        if (this._closed) {
            return;
        }
        try {
            bl = this._conn.isClosed();
        }
        catch (SQLException sQLException) {
            try {
                this._pool.invalidateObject(this);
            }
            catch (IllegalStateException illegalStateException) {
                this.passivate();
                this.getInnermostDelegate().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw (SQLException)new SQLException("Cannot close connection (isClosed check failed)").initCause(sQLException);
        }
        if (!bl) {
            try {
                this._pool.returnObject(this);
            }
            catch (IllegalStateException illegalStateException) {
                this.passivate();
                this.getInnermostDelegate().close();
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (SQLException)new SQLException("Cannot close connection (return to pool failed)").initCause(exception);
            }
        } else {
            try {
                this._pool.invalidateObject(this);
            }
            catch (IllegalStateException illegalStateException) {
                this.passivate();
                this.getInnermostDelegate().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SQLException("Already closed.");
        }
    }

    public void reallyClose() throws SQLException {
        super.close();
    }
}

