{
    This file is part of the Free Component Library

    A perfect hash for XPath keywords

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

const
  XPathKeywords: array [TXPathKeyword] of PWideChar = (
    '',
    #08'ancestor',
    #16'ancestor-or-self',
    #09'attribute',
    #05'child',
    #10'descendant',
    #18'descendant-or-self',
    #09'following',
    #17'following-sibling',
    #09'namespace',
    #06'parent',
    #09'preceding',
    #17'preceding-sibling',
    #04'self',
    #07'comment',
    #04'text',
    #22'processing-instruction',
    #04'node',
    #03'and',
    #02'or',
    #03'div',
    #03'mod',
    #04'last',
    #08'position',
    #05'count',
    #02'id',
    #10'local-name',
    #13'namespace-uri',
    #04'name',
    #06'string',
    #06'concat',
    #11'starts-with',
    #08'contains',
    #16'substring-before',
    #15'substring-after',
    #09'substring',
    #13'string-length',
    #15'normalize-space',
    #09'translate',
    #07'boolean',
    #03'not',
    #04'true',
    #05'false',
    #04'lang',
    #06'number',
    #03'sum',
    #05'floor',
    #07'ceiling',
    #05'round'
  );

{ The following code is not very maintainable because it was hand-ported from 
  C code generated by gperf. Unless a tool like gperf is ported or modified to
  generate Pascal, modifying it will be painful.
  The good side is that one shouldn't ever need to modify it. }

  MaxHash = 55;

  KeywordIndex: array[0..MaxHash-1] of TXPathKeyword = (
    xkNone, xkNone,
    xkId,
    xkNone, xkNone, xkNone,
    xkString,
    xkSum,
    xkParent,
    xkSubstring,
    xkNone,
    xkComment,
    xkName,
    xkStringLength,
    xkNumber,
    xkSubstringAfter,
    xkSubstringBefore,
    xkNamespace,
    xkFloor,
    xkNormalizeSpace,
    xkSelf,
    xkNamespaceUri,
    xkPreceding,
    xkOr,
    xkPosition,
    xkText,
    xkProcessingInstruction,
    xkConcat,
    xkLast,
    xkContains,
    xkPrecedingSibling,
    xkAncestor,
    xkFalse,
    xkLocalName,
    xkCount,
    xkLang,
    xkFollowing,
    xkDescendant,
    xkNode,
    xkAncestorOrSelf,
    xkBoolean,
    xkNot,
    xkStartsWith,
    xkAnd,
    xkFollowingSibling,
    xkDescendantOrSelf,
    xkChild,
    xkTrue,
    xkCeiling,
    xkMod,
    xkDiv,
    xkRound,
    xkNone,
    xkAttribute,
    xkTranslate
  );

  AssoValues: array[97..122] of Byte = (
    10, 31,  0, 13, 30, 11, 55, 55, 0, 41,
    55, 10, 16,  4, 21,  2, 55, 17, 0, 14,
    34, 29, 34, 55,  7, 55
  );

function LookupXPathKeyword(p: PWideChar; Len: Integer): TXPathKeyword;
var
  hash: Integer;
  p1: PWideChar;
begin
  result := xkNone;
  hash := Len;
  if Len >= 1 then
  begin
    if (p^ >= 'a') and (p^ <= 'y') then
      Inc(hash, AssoValues[ord(p^)])
    else
      Exit;
    if Len > 2 then
      if (p[2] >= 'a') and (p[2] <= 'y') then
        Inc(hash, AssoValues[ord(p[2])+1])
      else
        Exit;
  end;
  if (hash >= 0) and (hash <= MaxHash) then
  begin
    p1 := XPathKeywords[KeywordIndex[hash]];
    if (ord(p1^) = Len) and
      CompareMem(p, p1+1, Len*sizeof(WideChar)) then
        Result := KeywordIndex[hash];
  end;
end;
