/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.event.ProfilingStateAdapter;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.common.event.SimpleProfilingStateAdapter;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedRadioButton;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.Bundle;
import org.netbeans.modules.profiler.v2.ProfilerFeature;
import org.netbeans.modules.profiler.v2.ProfilerFeatures;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.ui.ProjectSelector;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

final class ProfilerSessions {
    private static final int MIN_WAIT_WIDTH = 350;
    private static final int ENABLE_CANCEL_MS = 5000;
    private static volatile boolean waitingCancelled;

    ProfilerSessions() {
    }

    static void configure(final ProfilerSession profilerSession, final Lookup lookup, final String string) {
        final ProfilerFeatures profilerFeatures = profilerSession.getFeatures();
        final Set<ProfilerFeature> set = ProfilerFeatures.getCompatible(profilerFeatures.getAvailable(), lookup);
        if (set.isEmpty()) {
            ProfilerDialogs.displayInfo((String)Bundle.ProfilerSessions_actionNotSupported());
        } else {
            UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Set<ProfilerFeature> set2 = ProfilerFeatures.getCompatible(profilerFeatures.getActivated(), lookup);
                    ProfilerFeature profilerFeature = set2.size() == 1 ? set2.iterator().next() : (!set2.isEmpty() ? ProfilerSessions.selectFeature(set2, string) : (set.size() == 1 ? (ProfilerFeature)set.iterator().next() : ProfilerSessions.selectFeature(set, string)));
                    if (profilerFeature != null) {
                        profilerFeatures.activateFeature(profilerFeature);
                        profilerFeature.configure(lookup);
                        profilerSession.selectFeature(profilerFeature);
                        profilerSession.open();
                    }
                }
            });
        }
    }

    static void createAndConfigure(final Lookup lookup, Lookup.Provider provider, final String string) {
        if (provider == null) {
            provider = ProjectUtilities.getMainProject();
        }
        final Lookup.Provider provider2 = provider;
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                UI uI = UI.createAndConfigure(lookup, provider2);
                HelpCtx helpCtx = new HelpCtx("SelectFeatureDialog.HelpCtx");
                String string2 = string == null ? Bundle.ProfilerSessions_selectProjectAndFeature() : string;
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)uI, string2, true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, helpCtx, null);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.setVisible(true);
                final ProfilerSession profilerSession = uI.selectedSession();
                if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                    final ProfilerFeature profilerFeature = uI.selectedFeature();
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            final ProfilerFeatures profilerFeatures = profilerSession.getFeatures();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    profilerFeatures.activateFeature(profilerFeature);
                                    profilerFeature.configure(lookup);
                                    profilerSession.selectFeature(profilerFeature);
                                    profilerSession.open();
                                }
                            });
                        }
                    });
                } else if (profilerSession != null) {
                    profilerSession.close();
                }
                dialogDescriptor.setMessage(null);
            }
        });
    }

    private static ProfilerFeature selectFeature(Set<ProfilerFeature> set, String string) {
        UI uI = UI.selectFeature(set);
        HelpCtx helpCtx = new HelpCtx("SelectFeatureDialog.HelpCtx");
        String string2 = string == null ? Bundle.ProfilerSessions_selectFeature() : string;
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)uI, string2, true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, helpCtx, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        ProfilerFeature profilerFeature = dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION ? uI.selectedFeature() : null;
        dialogDescriptor.setMessage(null);
        return profilerFeature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean waitForProfiler() {
        final Profiler profiler = Profiler.getDefault();
        if (profiler.getProfilingState() == 1) {
            return true;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            waitingCancelled = ProfilerSessions.blockingWaitDialog(profiler, null);
        } else {
            Object object;
            Object object2 = object = new Object();
            synchronized (object2) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        waitingCancelled = ProfilerSessions.blockingWaitDialog(profiler, object);
                    }
                });
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return !waitingCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean blockingWaitDialog(Profiler profiler, Object object) {
        try {
            if (profiler.getProfilingState() == 1) {
                boolean bl = false;
                return bl;
            }
            JPanel jPanel = new JPanel(new BorderLayout(5, 5));
            jPanel.setBorder(new EmptyBorder(15, 15, 15, 10));
            jPanel.add((Component)new JLabel(Bundle.ProfilerSessions_finishingSession()), "North");
            JProgressBar jProgressBar = new JProgressBar();
            jProgressBar.setIndeterminate(true);
            jPanel.add((Component)jProgressBar, "South");
            Dimension dimension = jPanel.getPreferredSize();
            jPanel.setPreferredSize(new Dimension(Math.max(dimension.width, 350), dimension.height));
            final JButton jButton = new JButton(Bundle.ProfilerSessions_cancel());
            jButton.setVisible(false);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, Bundle.ProfilerSessions_finishSessionCaption(), true, new Object[]{jButton}, null, 0, null, null);
            final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            final JDialog jDialog = dialog instanceof JDialog ? (JDialog)dialog : null;
            ProfilingStateAdapter profilingStateAdapter = new ProfilingStateAdapter(){

                public void profilingStateChanged(ProfilingStateEvent profilingStateEvent) {
                    if (profilingStateEvent.getNewState() == 1) {
                        dialog.setVisible(false);
                    }
                }
            };
            profiler.addProfilingStateListener((ProfilingStateListener)profilingStateAdapter);
            int n = -1;
            if (jDialog != null) {
                n = jDialog.getDefaultCloseOperation();
                jDialog.setDefaultCloseOperation(0);
            }
            final int n2 = n;
            Timer timer = new Timer(5000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (jDialog != null) {
                        jDialog.setDefaultCloseOperation(n2);
                    }
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            dialog.setVisible(false);
                        }
                    });
                    jButton.setVisible(true);
                    dialog.pack();
                }
            });
            timer.setRepeats(false);
            timer.start();
            dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
            dialog.setVisible(true);
            profiler.removeProfilingStateListener((ProfilingStateListener)profilingStateAdapter);
            boolean bl = dialogDescriptor.getValue() != null;
            return bl;
        }
        finally {
            if (object != null) {
                Object object2 = object;
                synchronized (object2) {
                    object.notifyAll();
                }
            }
        }
    }

    public static final class ExitHandler
    implements Runnable {
        @Override
        public void run() {
            ProfilerSession profilerSession = ProfilerSession.currentSession();
            if (profilerSession != null) {
                profilerSession.persistStorage(true);
            }
        }
    }

    public static final class StopAction
    extends AbstractAction {
        private ProfilerSession session;
        private final ProfilingStateListener listener = new SimpleProfilingStateAdapter(){

            protected void update() {
                StopAction.this.updateState();
            }
        };

        public static StopAction getInstance() {
            return Singleton.INSTANCE;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.session != null) {
                this.setEnabled(false);
                final ProfilerSession profilerSession = this.session;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!profilerSession.doStop()) {
                            StopAction.this.setEnabled(true);
                        }
                    }
                });
            }
        }

        void setSession(ProfilerSession profilerSession) {
            if (this.session != null) {
                this.session.removeListener(this.listener);
            }
            this.session = profilerSession;
            if (this.session != null) {
                this.session.addListener(this.listener);
            }
            this.putValue("ShortDescription", this.session != null && this.session.isAttach() ? Bundle.HINT_DetachAction() : Bundle.HINT_StopAction());
            this.updateState();
        }

        private void updateState() {
            this.setEnabled(this.session != null && this.session.getState() == 4);
        }

        private StopAction() {
            this.putValue("Name", Bundle.LBL_StopAction());
            this.putValue("ShortDescription", Bundle.HINT_StopAction());
            this.putValue("SmallIcon", Icons.getIcon((String)"GeneralIcons.Stop"));
            this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Stop"));
            this.updateState();
        }

        private static final class Singleton {
            private static final StopAction INSTANCE = new StopAction();

            private Singleton() {
            }
        }
    }

    private static class UI
    extends JPanel {
        private ProfilerFeature selectedFeature;
        private ProfilerSession selectedSession;
        private JPanel contents;
        private JRadioButton profileProject;
        private JRadioButton attachProject;
        private JLabel selectModeLabel;

        static UI selectFeature(Set<ProfilerFeature> set) {
            return new UI(set);
        }

        static UI createAndConfigure(Lookup lookup, Lookup.Provider provider) {
            return new UI(lookup, provider);
        }

        ProfilerFeature selectedFeature() {
            return this.selectedFeature;
        }

        ProfilerSession selectedSession() {
            if (this.selectedSession != null) {
                this.selectedSession.setAttach(this.attachProject.isSelected());
            }
            return this.selectedSession;
        }

        UI(Set<ProfilerFeature> set) {
            super(new GridBagLayout());
            int n = 0;
            this.selectModeLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.selectModeLabel, (String)Bundle.ProfilerSessions_selectHandlingFeature());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            this.add((Component)this.selectModeLabel, gridBagConstraints);
            ButtonGroup buttonGroup = new ButtonGroup();
            for (final ProfilerFeature profilerFeature : set) {
                JExtendedRadioButton jExtendedRadioButton = new JExtendedRadioButton(profilerFeature.getName(), profilerFeature.getIcon()){

                    protected void fireItemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            UI.this.selectedFeature = profilerFeature;
                        }
                    }
                };
                buttonGroup.add((AbstractButton)jExtendedRadioButton);
                if (buttonGroup.getSelection() == null) {
                    jExtendedRadioButton.setSelected(true);
                }
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n++;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(0, 20, 0, 10);
                this.add((Component)jExtendedRadioButton, gridBagConstraints);
                if (this.selectModeLabel.getLabelFor() != null) continue;
                this.selectModeLabel.setLabelFor((Component)jExtendedRadioButton);
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(15, 0, 0, 300);
            this.add((Component)UIUtils.createFillerPanel(), gridBagConstraints);
        }

        private void repaintContents() {
            this.contents.invalidate();
            this.contents.revalidate();
            this.contents.repaint();
        }

        UI(final Lookup lookup, final Lookup.Provider provider) {
            super(new GridBagLayout());
            int n = 0;
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)Bundle.ProfilerSessions_selectProject());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            this.add((Component)jLabel, gridBagConstraints);
            this.contents = new JPanel(new GridBagLayout());
            ProjectSelector.Populator populator = new ProjectSelector.Populator(){

                @Override
                protected Lookup.Provider initialProject() {
                    return provider;
                }
            };
            ProjectSelector projectSelector = new ProjectSelector(populator){

                protected void selectionChanged() {
                    Lookup.Provider provider = this.getProject();
                    UI.this.refreshProfileAttach(provider);
                    UI.this.refreshFeatures(lookup, provider);
                }
            };
            jLabel.setLabelFor((Component)((Object)projectSelector));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 20, 4, 10);
            this.add((Component)((Object)projectSelector), gridBagConstraints);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.profileProject = new JRadioButton();
            buttonGroup.add(this.profileProject);
            this.profileProject.setSelected(true);
            Mnemonics.setLocalizedText((AbstractButton)this.profileProject, (String)Bundle.ProfilerSessions_profileProject());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 20, 10, 5);
            this.add((Component)this.profileProject, gridBagConstraints);
            this.attachProject = new JRadioButton();
            buttonGroup.add(this.attachProject);
            Mnemonics.setLocalizedText((AbstractButton)this.attachProject, (String)Bundle.ProfilerSessions_attachProject());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 10, 10);
            this.add((Component)this.attachProject, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            this.add((Component)UIUtils.createFillerPanel(), gridBagConstraints);
            this.selectModeLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.selectModeLabel, (String)Bundle.ProfilerSessions_selectHandlingFeature());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            this.add((Component)this.selectModeLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.contents, gridBagConstraints);
            JExtendedRadioButton jExtendedRadioButton = new JExtendedRadioButton("XXX");
            final int n2 = jExtendedRadioButton.getPreferredSize().height;
            JPanel jPanel = new JPanel(null){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(300, n2 * 2);
                }
            };
            jPanel.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(15, 0, 0, 0);
            this.add((Component)jPanel, gridBagConstraints);
            Lookup.Provider provider2 = projectSelector.getProject();
            this.refreshProfileAttach(provider2);
            this.refreshFeatures(lookup, provider2);
        }

        private void refreshProfileAttach(Lookup.Provider provider) {
            boolean bl = !this.profileProject.isEnabled();
            this.profileProject.setEnabled(provider != null);
            if (provider == null) {
                this.attachProject.setSelected(true);
            } else if (bl) {
                this.profileProject.setSelected(true);
            }
        }

        private void refreshFeatures(final Lookup lookup, final Lookup.Provider provider) {
            this.contents.removeAll();
            final JLabel jLabel = new JLabel(Bundle.ProfilerSessions_loadingFeatures(), 0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 20, 0, 10);
            this.contents.add((Component)jLabel, gridBagConstraints);
            this.repaintContents();
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    if (UI.this.selectedSession != null) {
                        UI.this.selectedSession.close();
                    }
                    Lookup lookup2 = provider == null ? Lookup.EMPTY : Lookups.fixed((Object[])new Object[]{provider});
                    UI.this.selectedSession = ProfilerSession.forContext(lookup2);
                    final ProfilerFeatures profilerFeatures = UI.this.selectedSession == null ? null : UI.this.selectedSession.getFeatures();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (profilerFeatures == null || profilerFeatures.getAvailable().isEmpty()) {
                                jLabel.setText(Bundle.ProfilerSessions_noFeature());
                            } else {
                                UI.this.contents.removeAll();
                                UI.this.selectModeLabel.setLabelFor(null);
                                int n = 0;
                                ButtonGroup buttonGroup = new ButtonGroup();
                                for (final ProfilerFeature profilerFeature : profilerFeatures.getAvailable()) {
                                    if (!profilerFeature.supportsConfiguration(lookup)) continue;
                                    JExtendedRadioButton jExtendedRadioButton = new JExtendedRadioButton(profilerFeature.getName(), profilerFeature.getIcon()){

                                        protected void fireItemStateChanged(ItemEvent itemEvent) {
                                            if (itemEvent.getStateChange() == 1) {
                                                UI.this.selectedFeature = profilerFeature;
                                            }
                                        }
                                    };
                                    buttonGroup.add((AbstractButton)jExtendedRadioButton);
                                    if (buttonGroup.getSelection() == null) {
                                        jExtendedRadioButton.setSelected(true);
                                    }
                                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                                    gridBagConstraints.gridx = 0;
                                    gridBagConstraints.gridy = n++;
                                    gridBagConstraints.anchor = 17;
                                    gridBagConstraints.insets = new Insets(0, 20, 0, 10);
                                    UI.this.contents.add((Component)jExtendedRadioButton, gridBagConstraints);
                                    if (UI.this.selectModeLabel.getLabelFor() != null) continue;
                                    UI.this.selectModeLabel.setLabelFor((Component)jExtendedRadioButton);
                                }
                                UI.this.repaintContents();
                            }
                        }
                    });
                }
            });
        }
    }
}

