/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.filters.InstrumentationFilter;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainerBacked;
import org.netbeans.lib.profiler.results.cpu.MethodInfoMapper;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeBacked;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeFree;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.TimedCPUCCTNode;

public class CPUCCTContainer {
    private static final Logger LOGGER = Logger.getLogger(CPUCCTContainer.class.getName());
    protected static final int OFS_METHODID = 0;
    protected static final int OFS_NCALLS = 2;
    protected static final int OFS_TIME0 = 6;
    protected static final int OFS_SELFTIME0 = 11;
    protected static final int OFS_TIME1 = 16;
    protected static final int OFS_SELFTIME1 = 21;
    protected static final int OFS_NSUBNODES1 = 16;
    protected static final int OFS_NSUBNODES2 = 26;
    protected static final int OFS_SUBNODE01 = 18;
    protected static final int OFS_SUBNODE02 = 28;
    protected static final int CHILD_OFS_SIZE_3 = 3;
    protected static final int CHILD_OFS_SIZE_4 = 4;
    private static double timeInInjectedCodeInMS;
    private static double wholeGraphGrossTimeAbsInMS;
    protected CPUResultsSnapshot cpuResSnapshot;
    protected FlatProfileContainer cachedFlatProfile;
    public PrestimeCPUCCTNode rootNode;
    protected String threadName;
    protected byte[] compactData;
    protected int[] invPerMethodId;
    protected long[] timePerMethodId0;
    protected long[] timePerMethodId1;
    protected long[] totalTimePerMethodId0;
    protected long[] totalTimePerMethodId1;
    protected Set methodsOnStack;
    protected boolean collectingTwoTimeStamps;
    protected boolean displayWholeThreadCPUTime;
    protected double timeInInjectedCodeInAbsCounts;
    protected double timeInInjectedCodeInThreadCPUCounts;
    protected int childOfsSize = -1;
    protected int nodeSize;
    protected int threadId;
    protected long wholeGraphGrossTimeAbs;
    protected long wholeGraphGrossTimeThreadCPU;
    protected long wholeGraphNetTime0;
    protected long wholeGraphNetTime1;
    protected long wholeGraphPureTimeAbs;
    protected long wholeGraphPureTimeThreadCPU;
    private InstrumentationFilter filter;
    private PrestimeCPUCCTNodeFree reverseCCTRootNode;
    private int[] nodeStack;
    private int childTotalNCalls;
    private int currentNodeStackSize;
    private int nodeStackPtr;
    private int selectedMethodId;
    private long childTotalTime0InTimerUnits;
    private long childTotalTime1InTimerUnits;
    long totalInvNo;
    private TimingAdjusterOld timingAdjuster;
    private MethodInfoMapper methodInfoMapper = MethodInfoMapper.DEFAULT;

    public CPUCCTContainer(TimedCPUCCTNode timedCPUCCTNode, CPUResultsSnapshot cPUResultsSnapshot, MethodInfoMapper methodInfoMapper, TimingAdjusterOld timingAdjusterOld, InstrumentationFilter instrumentationFilter, int n, double[] dArray, int n2, String string) {
        this(cPUResultsSnapshot);
        this.threadId = n2;
        this.threadName = string;
        this.methodInfoMapper = methodInfoMapper;
        this.timingAdjuster = timingAdjusterOld;
        this.filter = instrumentationFilter;
        this.collectingTwoTimeStamps = cPUResultsSnapshot.isCollectingTwoTimeStamps();
        this.generateCompactData(timedCPUCCTNode, n);
        this.calculateThreadActiveTimesInMS(dArray);
        this.rootNode = new PrestimeCPUCCTNodeBacked(this, null, 0);
        if (timedCPUCCTNode.isRoot()) {
            this.rootNode.setThreadNode();
        }
    }

    protected CPUCCTContainer(CPUResultsSnapshot cPUResultsSnapshot) {
        this.cpuResSnapshot = cPUResultsSnapshot;
    }

    public CPUResultsSnapshot getCPUResSnapshot() {
        return this.cpuResSnapshot;
    }

    public int getChildOfsForNodeOfs(int n, int n2) {
        if (this.childOfsSize == 4) {
            return this.get4Bytes(n + (this.collectingTwoTimeStamps ? 28 : 18) + this.childOfsSize * n2);
        }
        return this.get3Bytes(n + (this.collectingTwoTimeStamps ? 28 : 18) + this.childOfsSize * n2);
    }

    public boolean isCollectingTwoTimeStamps() {
        return this.collectingTwoTimeStamps;
    }

    public FlatProfileContainer getFlatProfile() {
        return this.generateFlatProfile();
    }

    public String[] getMethodClassNameAndSig(int n) {
        return this.cpuResSnapshot.getMethodClassNameAndSig(n, 0);
    }

    public int getMethodIdForNodeOfs(int n) {
        return this.get2Bytes(n + 0);
    }

    public int getNCallsForNodeOfs(int n) {
        return this.get4Bytes(n + 2);
    }

    public int getNChildrenForNodeOfs(int n) {
        return this.get2Bytes(n + (this.collectingTwoTimeStamps ? 26 : 16));
    }

    public PrestimeCPUCCTNode getReverseCCT(int n) {
        return this.generateReverseCCT(n);
    }

    public PrestimeCPUCCTNode getRootNode() {
        return this.rootNode;
    }

    public long getSelfTime0ForNodeOfs(int n) {
        return this.get5Bytes(n + 11);
    }

    public long getSelfTime1ForNodeOfs(int n) {
        return this.get5Bytes(n + 21);
    }

    public long getSleepTime0ForNodeOfs(int n) {
        return 0L;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public static double getTimeInInjectedCodeForDisplayedThread() {
        return timeInInjectedCodeInMS;
    }

    public long getTotalTime0ForNodeOfs(int n) {
        return this.get5Bytes(n + 6);
    }

    public long getTotalTime1ForNodeOfs(int n) {
        return this.get5Bytes(n + 16);
    }

    public long getWaitTime0ForNodeOfs(int n) {
        return 0L;
    }

    public static double getWholeGraphGrossTimeAbsForDisplayedThread() {
        return wholeGraphGrossTimeAbsInMS;
    }

    public long getWholeGraphNetTime0() {
        return this.wholeGraphNetTime0;
    }

    public long getWholeGraphNetTime1() {
        return this.wholeGraphNetTime1;
    }

    public long getWholeGraphPureTimeAbs() {
        return this.wholeGraphPureTimeAbs;
    }

    public long getWholeGraphPureTimeThreadCPU() {
        return this.wholeGraphPureTimeThreadCPU;
    }

    public boolean canDisplayWholeGraphCPUTime() {
        return this.displayWholeThreadCPUTime;
    }

    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        this.threadId = dataInputStream.readInt();
        this.threadName = dataInputStream.readUTF();
        this.collectingTwoTimeStamps = dataInputStream.readBoolean();
        int n = dataInputStream.readInt();
        this.compactData = new byte[n];
        this.childOfsSize = this.compactData.length > 0xFFFFFF ? 4 : 3;
        dataInputStream.readFully(this.compactData);
        this.nodeSize = dataInputStream.readInt();
        this.wholeGraphGrossTimeAbs = dataInputStream.readLong();
        this.wholeGraphGrossTimeThreadCPU = dataInputStream.readLong();
        this.timeInInjectedCodeInAbsCounts = dataInputStream.readDouble();
        this.timeInInjectedCodeInThreadCPUCounts = dataInputStream.readDouble();
        this.wholeGraphPureTimeAbs = dataInputStream.readLong();
        this.wholeGraphPureTimeThreadCPU = dataInputStream.readLong();
        this.wholeGraphNetTime0 = dataInputStream.readLong();
        this.wholeGraphNetTime1 = dataInputStream.readLong();
        this.totalInvNo = dataInputStream.readLong();
        this.displayWholeThreadCPUTime = dataInputStream.readBoolean();
        this.rootNode = new PrestimeCPUCCTNodeBacked(this, null, 0);
        if (this.getMethodIdForNodeOfs(0) == 0) {
            this.rootNode.setThreadNode();
        }
    }

    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.threadId);
        dataOutputStream.writeUTF(this.threadName);
        dataOutputStream.writeBoolean(this.collectingTwoTimeStamps);
        dataOutputStream.writeInt(this.compactData.length);
        dataOutputStream.write(this.compactData);
        dataOutputStream.writeInt(this.nodeSize);
        dataOutputStream.writeLong(this.wholeGraphGrossTimeAbs);
        dataOutputStream.writeLong(this.wholeGraphGrossTimeThreadCPU);
        dataOutputStream.writeDouble(this.timeInInjectedCodeInAbsCounts);
        dataOutputStream.writeDouble(this.timeInInjectedCodeInThreadCPUCounts);
        dataOutputStream.writeLong(this.wholeGraphPureTimeAbs);
        dataOutputStream.writeLong(this.wholeGraphPureTimeThreadCPU);
        dataOutputStream.writeLong(this.wholeGraphNetTime0);
        dataOutputStream.writeLong(this.wholeGraphNetTime1);
        dataOutputStream.writeLong(this.totalInvNo);
        dataOutputStream.writeBoolean(this.displayWholeThreadCPUTime);
    }

    protected void setChildOfsForNodeOfs(int n, int n2, int n3) {
        if (this.childOfsSize == 4) {
            this.store4Bytes(n + (this.collectingTwoTimeStamps ? 28 : 18) + this.childOfsSize * n2, n3);
        } else {
            this.store3Bytes(n + (this.collectingTwoTimeStamps ? 28 : 18) + this.childOfsSize * n2, n3);
        }
    }

    protected void setMethodIdForNodeOfs(int n, int n2) {
        this.store2Bytes(n + 0, n2);
    }

    protected void setNCallsForNodeOfs(int n, int n2) {
        this.store4Bytes(n + 2, n2);
    }

    protected void setNChildrenForNodeOfs(int n, int n2) {
        this.store2Bytes(n + (this.collectingTwoTimeStamps ? 26 : 16), n2);
    }

    protected void setSelfTime0ForNodeOfs(int n, long l) {
        this.store5Bytes(n + 11, l);
    }

    protected void setSelfTime1ForNodeOfs(int n, long l) {
        this.store5Bytes(n + 21, l);
    }

    protected void setSleepTime0ForNodeOfs(int n, long l) {
    }

    protected void setTotalTime0ForNodeOfs(int n, long l) {
        this.store5Bytes(n + 6, l);
    }

    protected void setTotalTime1ForNodeOfs(int n, long l) {
        this.store5Bytes(n + 16, l);
    }

    protected void setWaitTime0ForNodeOfs(int n, long l) {
    }

    protected void addFlatProfTimeForNode(int n) {
        int n2 = this.getMethodIdForNodeOfs(n);
        Integer n3 = new Integer(n2);
        boolean bl = this.methodsOnStack.contains(n3);
        if (n2 >= this.invPerMethodId.length) {
            LOGGER.log(Level.WARNING, "Method ID ({0}) out of bounds ({1})", new Object[]{n2, this.invPerMethodId.length});
            return;
        }
        int n4 = this.getNChildrenForNodeOfs(n);
        if (n4 > 0) {
            if (!bl) {
                this.methodsOnStack.add(n3);
            }
            for (int i = 0; i < n4; ++i) {
                int n5 = this.getChildOfsForNodeOfs(n, i);
                this.addFlatProfTimeForNode(n5);
            }
            if (!bl) {
                this.methodsOnStack.remove(n3);
            }
        }
        int n6 = n2;
        this.timePerMethodId0[n6] = this.timePerMethodId0[n6] + this.getSelfTime0ForNodeOfs(n);
        if (!bl) {
            int n7 = n2;
            this.totalTimePerMethodId0[n7] = this.totalTimePerMethodId0[n7] + this.getTotalTime0ForNodeOfs(n);
        }
        if (this.collectingTwoTimeStamps) {
            int n8 = n2;
            this.timePerMethodId1[n8] = this.timePerMethodId1[n8] + this.getSelfTime1ForNodeOfs(n);
            if (!bl) {
                int n9 = n2;
                this.totalTimePerMethodId1[n9] = this.totalTimePerMethodId1[n9] + this.getTotalTime1ForNodeOfs(n);
            }
        }
        int n10 = n2;
        this.invPerMethodId[n10] = this.invPerMethodId[n10] + this.getNCallsForNodeOfs(n);
    }

    protected void addToReverseCCT(PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree, int n) {
        this.selectedMethodId = n;
        this.reverseCCTRootNode = prestimeCPUCCTNodeFree;
        this.currentNodeStackSize = 320;
        this.nodeStack = new int[this.currentNodeStackSize];
        this.nodeStackPtr = 0;
        this.checkStraightGraphNode(0);
        this.nodeStack = null;
        this.reverseCCTRootNode = null;
    }

    protected void checkStraightGraphNode(int n) {
        if (this.nodeStackPtr >= this.currentNodeStackSize) {
            int[] nArray = new int[this.currentNodeStackSize * 2];
            System.arraycopy(this.nodeStack, 0, nArray, 0, this.currentNodeStackSize);
            this.nodeStack = nArray;
            this.currentNodeStackSize *= 2;
        }
        this.nodeStack[this.nodeStackPtr++] = n;
        if (this.getMethodIdForNodeOfs(n) == this.selectedMethodId) {
            this.addReversePath();
        }
        int n2 = this.getNChildrenForNodeOfs(n);
        for (int i = 0; i < n2; ++i) {
            this.checkStraightGraphNode(this.getChildOfsForNodeOfs(n, i));
        }
        --this.nodeStackPtr;
    }

    protected FlatProfileContainer generateFlatProfile() {
        this.preGenerateFlatProfile();
        this.addFlatProfTimeForNode(0);
        return this.postGenerateFlatProfile();
    }

    protected PrestimeCPUCCTNodeFree generateReverseCCT(int n) {
        this.selectedMethodId = n;
        this.currentNodeStackSize = 320;
        this.nodeStack = new int[this.currentNodeStackSize];
        this.nodeStackPtr = 0;
        this.checkStraightGraphNode(0);
        PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree = this.reverseCCTRootNode;
        this.nodeStack = null;
        this.reverseCCTRootNode = null;
        return prestimeCPUCCTNodeFree;
    }

    protected int get2Bytes(int n) {
        return (this.compactData[n] & 0xFF) << 8 | this.compactData[n + 1] & 0xFF;
    }

    protected int get3Bytes(int n) {
        return (this.compactData[n++] & 0xFF) << 16 | (this.compactData[n++] & 0xFF) << 8 | this.compactData[n++] & 0xFF;
    }

    protected int get4Bytes(int n) {
        return (this.compactData[n++] & 0xFF) << 24 | (this.compactData[n++] & 0xFF) << 16 | (this.compactData[n++] & 0xFF) << 8 | this.compactData[n++] & 0xFF;
    }

    protected long get5Bytes(int n) {
        return ((long)this.compactData[n++] & 0xFFL) << 32 | ((long)this.compactData[n++] & 0xFFL) << 24 | ((long)this.compactData[n++] & 0xFFL) << 16 | ((long)this.compactData[n++] & 0xFFL) << 8 | (long)this.compactData[n++] & 0xFFL;
    }

    protected FlatProfileContainer postGenerateFlatProfile() {
        FlatProfileContainerBacked flatProfileContainerBacked = new FlatProfileContainerBacked(this, this.timePerMethodId0, this.timePerMethodId1, this.totalTimePerMethodId0, this.totalTimePerMethodId1, this.invPerMethodId, this.timePerMethodId0.length);
        this.timePerMethodId1 = null;
        this.timePerMethodId0 = null;
        this.totalTimePerMethodId1 = null;
        this.totalTimePerMethodId0 = null;
        this.invPerMethodId = null;
        this.methodsOnStack = null;
        return flatProfileContainerBacked;
    }

    protected void preGenerateFlatProfile() {
        int n = this.cpuResSnapshot.getNInstrMethods();
        this.timePerMethodId0 = new long[n];
        this.totalTimePerMethodId0 = new long[n];
        if (this.collectingTwoTimeStamps) {
            this.timePerMethodId1 = new long[n];
            this.totalTimePerMethodId1 = new long[n];
        }
        this.invPerMethodId = new int[n];
        this.timePerMethodId0[0] = -1L;
        this.totalTimePerMethodId0[0] = -1L;
        this.methodsOnStack = new HashSet();
    }

    protected void store2Bytes(int n, int n2) {
        this.compactData[n] = (byte)(n2 >> 8 & 0xFF);
        this.compactData[n + 1] = (byte)(n2 & 0xFF);
    }

    protected void store3Bytes(int n, int n2) {
        int n3 = n;
        this.compactData[n3++] = (byte)(n2 >> 16 & 0xFF);
        this.compactData[n3++] = (byte)(n2 >> 8 & 0xFF);
        this.compactData[n3++] = (byte)(n2 & 0xFF);
    }

    protected void store4Bytes(int n, int n2) {
        int n3 = n;
        this.compactData[n3++] = (byte)(n2 >> 24 & 0xFF);
        this.compactData[n3++] = (byte)(n2 >> 16 & 0xFF);
        this.compactData[n3++] = (byte)(n2 >> 8 & 0xFF);
        this.compactData[n3++] = (byte)(n2 & 0xFF);
    }

    protected void store5Bytes(int n, long l) {
        int n2 = n;
        this.compactData[n2++] = (byte)(l >> 32 & 0xFFL);
        this.compactData[n2++] = (byte)(l >> 24 & 0xFFL);
        this.compactData[n2++] = (byte)(l >> 16 & 0xFFL);
        this.compactData[n2++] = (byte)(l >> 8 & 0xFFL);
        this.compactData[n2++] = (byte)(l & 0xFFL);
    }

    private void addChild(AddChildLocalVars addChildLocalVars) {
        if (addChildLocalVars.node == null || addChildLocalVars.parent == null) {
            return;
        }
        addChildLocalVars.filterStatus = addChildLocalVars.node.getFilteredStatus();
        if (!(addChildLocalVars.node instanceof MethodCPUCCTNode)) {
            addChildLocalVars.filterStatus = 2;
        }
        switch (addChildLocalVars.filterStatus) {
            case 2: {
                addChildLocalVars.compParent = addChildLocalVars.parent;
                break;
            }
            case 1: {
                if (addChildLocalVars.node instanceof MethodCPUCCTNode) {
                    this.methodInfoMapper.lock(false);
                    try {
                        addChildLocalVars.className = this.methodInfoMapper.getInstrMethodClass(((MethodCPUCCTNode)addChildLocalVars.node).getMethodId()).replace('.', '/');
                        if (!this.filter.passes(addChildLocalVars.className)) {
                            addChildLocalVars.compParent = addChildLocalVars.parent;
                            break;
                        }
                        addChildLocalVars.newChild = (TimedCPUCCTNode)addChildLocalVars.node.clone();
                        addChildLocalVars.compParent = addChildLocalVars.newChild;
                        break;
                    }
                    finally {
                        this.methodInfoMapper.unlock();
                    }
                }
                addChildLocalVars.compParent = addChildLocalVars.parent;
                break;
            }
            case 0: {
                addChildLocalVars.existingChild = MethodCPUCCTNode.Locator.locate(((MethodCPUCCTNode)addChildLocalVars.node).getMethodId(), addChildLocalVars.parent.getChildren());
                if (addChildLocalVars.existingChild == null) {
                    addChildLocalVars.newChild = (TimedCPUCCTNode)addChildLocalVars.node.clone();
                    addChildLocalVars.compParent = addChildLocalVars.newChild;
                    break;
                }
                addChildLocalVars.newChild = null;
                addChildLocalVars.existingChild.addNCalls(addChildLocalVars.node.getNCalls());
                addChildLocalVars.existingChild.addNCallsDiff(addChildLocalVars.node.getNCallsDiff());
                addChildLocalVars.existingChild.addNetTime0(addChildLocalVars.node.getNetTime0());
                addChildLocalVars.existingChild.addNetTime1(addChildLocalVars.node.getNetTime1());
                addChildLocalVars.existingChild.addSleepTime0(addChildLocalVars.node.getSleepTime0());
                addChildLocalVars.existingChild.addWaitTime0(addChildLocalVars.node.getWaitTime0());
                addChildLocalVars.compParent = addChildLocalVars.existingChild;
                break;
            }
            default: {
                ProfilerLogger.warning("Unknown filtered status (" + addChildLocalVars.filterStatus + ") for " + addChildLocalVars.node);
            }
        }
        addChildLocalVars.nChildren = addChildLocalVars.node.getChildren() != null ? addChildLocalVars.node.getChildren().length : 0;
        for (int i = 0; i < addChildLocalVars.nChildren; ++i) {
            this.addChild(new AddChildLocalVars((TimedCPUCCTNode)addChildLocalVars.node.getChildren()[i], addChildLocalVars.compParent));
        }
        if (addChildLocalVars.newChild != null) {
            addChildLocalVars.parent.attachNodeAsChild(addChildLocalVars.newChild);
        } else if (addChildLocalVars.compParent == addChildLocalVars.parent && !addChildLocalVars.parent.isRoot()) {
            addChildLocalVars.parent.addNetTime0(addChildLocalVars.node.getNetTime0());
            addChildLocalVars.parent.addSleepTime0(addChildLocalVars.node.getSleepTime0());
            addChildLocalVars.parent.addWaitTime0(addChildLocalVars.node.getWaitTime0());
            addChildLocalVars.parent.addNCallsDiff(addChildLocalVars.node.getNCalls());
            if (this.collectingTwoTimeStamps) {
                addChildLocalVars.parent.addNetTime1(addChildLocalVars.node.getNetTime1());
            }
        }
    }

    private void addReversePath() {
        int n;
        Object object = null;
        for (int i = n = this.nodeStackPtr - 1; i >= 0; --i) {
            int n2;
            Object object2;
            int n3 = this.nodeStack[i];
            int n4 = this.getMethodIdForNodeOfs(n3);
            if (n4 == 0) {
                return;
            }
            boolean bl = false;
            if (i < n) {
                object2 = (PrestimeCPUCCTNodeFree[])((PrestimeCPUCCTNode)object).getChildren();
                if (object2 != null) {
                    for (int j = 0; j < ((PrestimeCPUCCTNodeFree[])object2).length; ++j) {
                        if (object2[j].getMethodId() != n4) continue;
                        object = object2[j];
                        if (((PrestimeCPUCCTNode)object).isContextCallsNode()) {
                            n2 = this.nodeStack[i + 1];
                            this.mergeBySelfTime((PrestimeCPUCCTNodeFree)object, n2);
                            object = (PrestimeCPUCCTNodeFree)((PrestimeCPUCCTNode)object).getChildren()[0];
                        }
                        this.mergeBySelfTime((PrestimeCPUCCTNodeFree)object, n3);
                        bl = true;
                        break;
                    }
                }
            } else {
                object = this.reverseCCTRootNode;
                if (object == null) {
                    object = this.createChildlessCopyBySelfTime(n3);
                    this.reverseCCTRootNode = object;
                } else {
                    this.mergeBySelfTime((PrestimeCPUCCTNodeFree)object, n3);
                }
                bl = true;
            }
            if (bl) continue;
            object2 = this.createChildlessCopyBySelfTime(n3);
            PrestimeCPUCCTNodeFree[] prestimeCPUCCTNodeFreeArray = (PrestimeCPUCCTNodeFree[])((PrestimeCPUCCTNode)object).getChildren();
            if (prestimeCPUCCTNodeFreeArray != null) {
                PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree;
                n2 = this.nodeStack[i + 1];
                if (prestimeCPUCCTNodeFreeArray.length == 1) {
                    prestimeCPUCCTNodeFree = prestimeCPUCCTNodeFreeArray[0];
                    PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree2 = ((PrestimeCPUCCTNodeFree)object).createChildlessCopy();
                    this.subtractNodeDataBySelfTime(prestimeCPUCCTNodeFree2, n2);
                    prestimeCPUCCTNodeFree2.setMethodId(prestimeCPUCCTNodeFree.getMethodId());
                    prestimeCPUCCTNodeFree2.setContextCallsNode();
                    prestimeCPUCCTNodeFreeArray[0] = prestimeCPUCCTNodeFree2;
                    prestimeCPUCCTNodeFree2.parent = object;
                    prestimeCPUCCTNodeFree2.addChild(prestimeCPUCCTNodeFree);
                    prestimeCPUCCTNodeFree.parent = prestimeCPUCCTNodeFree2;
                }
                prestimeCPUCCTNodeFree = this.createChildlessCopyBySelfTime(n2);
                prestimeCPUCCTNodeFree.setMethodId(this.getMethodIdForNodeOfs(n3));
                prestimeCPUCCTNodeFree.setContextCallsNode();
                ((PrestimeCPUCCTNodeFree)object).addChild(prestimeCPUCCTNodeFree);
                prestimeCPUCCTNodeFree.parent = object;
                object = prestimeCPUCCTNodeFree;
            }
            ((PrestimeCPUCCTNodeFree)object).addChild((PrestimeCPUCCTNodeFree)object2);
            ((PrestimeCPUCCTNodeFree)object2).parent = object;
            object = object2;
        }
    }

    private void calculateThreadActiveTimesInMS(double[] dArray) {
        this.wholeGraphGrossTimeAbs = (long)dArray[0];
        this.wholeGraphGrossTimeThreadCPU = (long)dArray[1];
        this.timeInInjectedCodeInAbsCounts = dArray[2];
        this.timeInInjectedCodeInThreadCPUCounts = dArray[3];
        wholeGraphGrossTimeAbsInMS += (double)this.wholeGraphGrossTimeAbs * 1000.0 / (double)this.timingAdjuster.getInstrTimingData().timerCountsInSecond0;
        timeInInjectedCodeInMS += this.timeInInjectedCodeInAbsCounts * 1000.0 / (double)this.timingAdjuster.getInstrTimingData().timerCountsInSecond0;
        this.wholeGraphPureTimeAbs += (long)((int)(((double)this.wholeGraphGrossTimeAbs - this.timeInInjectedCodeInAbsCounts) * 1000000.0 / (double)this.timingAdjuster.getInstrTimingData().timerCountsInSecond1));
        if (this.wholeGraphGrossTimeThreadCPU > 0L) {
            this.displayWholeThreadCPUTime = true;
            this.wholeGraphPureTimeThreadCPU += (long)((int)(((double)this.wholeGraphGrossTimeThreadCPU - this.timeInInjectedCodeInThreadCPUCounts) * 1000000.0 / (double)this.timingAdjuster.getInstrTimingData().timerCountsInSecond1));
        } else {
            this.displayWholeThreadCPUTime = false;
        }
        if (this.wholeGraphPureTimeAbs < 0L) {
            this.wholeGraphPureTimeAbs = 0L;
        }
        if (this.wholeGraphPureTimeThreadCPU < 0L) {
            this.wholeGraphPureTimeThreadCPU = 0L;
        }
        this.wholeGraphNetTime0 += this.get5Bytes(6);
        if (this.collectingTwoTimeStamps) {
            this.wholeGraphNetTime1 += this.get5Bytes(16);
        }
    }

    private PrestimeCPUCCTNodeFree createChildlessCopyBySelfTime(int n) {
        PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree = new PrestimeCPUCCTNodeFree(this, null, this.getMethodIdForNodeOfs(n));
        this.mergeBySelfTime(prestimeCPUCCTNodeFree, n);
        return prestimeCPUCCTNodeFree;
    }

    private TimedCPUCCTNode filterCCT(TimedCPUCCTNode timedCPUCCTNode) {
        TimedCPUCCTNode timedCPUCCTNode2 = (TimedCPUCCTNode)timedCPUCCTNode.clone();
        int n = timedCPUCCTNode.getChildren() != null ? timedCPUCCTNode.getChildren().length : 0;
        for (int i = 0; i < n; ++i) {
            this.addChild(new AddChildLocalVars((TimedCPUCCTNode)timedCPUCCTNode.getChildren()[i], timedCPUCCTNode2));
        }
        timedCPUCCTNode2.setNetTime0(0L);
        if (this.collectingTwoTimeStamps) {
            timedCPUCCTNode2.setNetTime1(0L);
        }
        return timedCPUCCTNode2;
    }

    private void generateCompactData(TimedCPUCCTNode timedCPUCCTNode, int n) {
        this.nodeSize = this.collectingTwoTimeStamps ? 28 : 18;
        this.childOfsSize = 3;
        int n2 = this.nodeSize * n + this.childOfsSize * (n - 1);
        if (n2 > 0xFFFFFF) {
            this.childOfsSize = 4;
            n2 = this.nodeSize * n + this.childOfsSize * (n - 1);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "generateCompact data: nNodes {0}", n);
            LOGGER.log(Level.FINEST, "generateCompact data: node size {0}", this.nodeSize);
            LOGGER.log(Level.FINEST, "generateCompact data: array size {0}", n2);
            LOGGER.log(Level.FINEST, "generateCompact data: child offset {0}", this.childOfsSize);
        }
        this.compactData = new byte[n2];
        timedCPUCCTNode = this.filterCCT(timedCPUCCTNode);
        this.generateMirrorNode(new GenerateMirrorNodeLocalVars(timedCPUCCTNode, 0));
    }

    private int generateMirrorNode(GenerateMirrorNodeLocalVars generateMirrorNodeLocalVars) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Generate mirror node for ofs: {0}, node: {1}", new Object[]{generateMirrorNodeLocalVars.dataOfs, generateMirrorNodeLocalVars.rtNode});
        }
        this.generateNodeBase(generateMirrorNodeLocalVars.rtNode, generateMirrorNodeLocalVars.dataOfs);
        this.totalInvNo += (long)generateMirrorNodeLocalVars.rtNode.getNCalls();
        GenerateMirrorNodeLocalVars.access$1102(generateMirrorNodeLocalVars, generateMirrorNodeLocalVars.rtNode.getChildren());
        generateMirrorNodeLocalVars.nChildren = generateMirrorNodeLocalVars.nodeChildren != null ? generateMirrorNodeLocalVars.nodeChildren.length : 0;
        generateMirrorNodeLocalVars.nextNodeOfs = generateMirrorNodeLocalVars.dataOfs + this.nodeSize + generateMirrorNodeLocalVars.nChildren * this.childOfsSize;
        GenerateMirrorNodeLocalVars generateMirrorNodeLocalVars2 = generateMirrorNodeLocalVars;
        generateMirrorNodeLocalVars2.nCallsFromThisNode = generateMirrorNodeLocalVars2.nCallsFromThisNode + generateMirrorNodeLocalVars.rtNode.getNCallsDiff();
        if (generateMirrorNodeLocalVars.nChildren > 0) {
            generateMirrorNodeLocalVars.childCounter = 0;
            generateMirrorNodeLocalVars.i = 0;
            while (generateMirrorNodeLocalVars.i < generateMirrorNodeLocalVars.nChildren) {
                generateMirrorNodeLocalVars.aNode = (RuntimeCPUCCTNode)generateMirrorNodeLocalVars.nodeChildren[generateMirrorNodeLocalVars.i];
                if (generateMirrorNodeLocalVars.aNode instanceof MethodCPUCCTNode) {
                    this.setChildOfsForNodeOfs(generateMirrorNodeLocalVars.dataOfs, generateMirrorNodeLocalVars.childCounter, generateMirrorNodeLocalVars.nextNodeOfs);
                    generateMirrorNodeLocalVars.nextNodeOfs = this.generateMirrorNode(new GenerateMirrorNodeLocalVars((MethodCPUCCTNode)generateMirrorNodeLocalVars.aNode, generateMirrorNodeLocalVars.nextNodeOfs));
                    generateMirrorNodeLocalVars2 = generateMirrorNodeLocalVars;
                    generateMirrorNodeLocalVars2.thisNodeTotalTime0InTimerUnits = generateMirrorNodeLocalVars2.thisNodeTotalTime0InTimerUnits + this.childTotalTime0InTimerUnits;
                    if (this.collectingTwoTimeStamps) {
                        generateMirrorNodeLocalVars2 = generateMirrorNodeLocalVars;
                        generateMirrorNodeLocalVars2.thisNodeTotalTime1InTimerUnits = generateMirrorNodeLocalVars2.thisNodeTotalTime1InTimerUnits + this.childTotalTime1InTimerUnits;
                    }
                    generateMirrorNodeLocalVars2 = generateMirrorNodeLocalVars;
                    generateMirrorNodeLocalVars2.nCallsFromThisNode = generateMirrorNodeLocalVars2.nCallsFromThisNode + ((MethodCPUCCTNode)generateMirrorNodeLocalVars.aNode).getNCalls();
                    generateMirrorNodeLocalVars2 = generateMirrorNodeLocalVars;
                    generateMirrorNodeLocalVars2.totalNCallsFromThisNode = generateMirrorNodeLocalVars2.totalNCallsFromThisNode + this.childTotalNCalls;
                    generateMirrorNodeLocalVars.childCounter++;
                }
                generateMirrorNodeLocalVars.i++;
            }
        }
        generateMirrorNodeLocalVars.time = (long)this.timingAdjuster.adjustTime(generateMirrorNodeLocalVars.rtNode.getNetTime0(), generateMirrorNodeLocalVars.rtNode.getNCalls() + generateMirrorNodeLocalVars.rtNode.getNCallsDiff(), generateMirrorNodeLocalVars.nCallsFromThisNode, false);
        if (generateMirrorNodeLocalVars.time < 0L) {
            generateMirrorNodeLocalVars.time = 0L;
        }
        this.setSelfTime0ForNodeOfs(generateMirrorNodeLocalVars.dataOfs, generateMirrorNodeLocalVars.time);
        this.setWaitTime0ForNodeOfs(generateMirrorNodeLocalVars.dataOfs, generateMirrorNodeLocalVars.rtNode.getWaitTime0());
        this.setSleepTime0ForNodeOfs(generateMirrorNodeLocalVars.dataOfs, generateMirrorNodeLocalVars.rtNode.getSleepTime0());
        generateMirrorNodeLocalVars2 = generateMirrorNodeLocalVars;
        generateMirrorNodeLocalVars2.thisNodeTotalTime0InTimerUnits = generateMirrorNodeLocalVars2.thisNodeTotalTime0InTimerUnits + generateMirrorNodeLocalVars.rtNode.getNetTime0();
        this.childTotalTime0InTimerUnits = generateMirrorNodeLocalVars.thisNodeTotalTime0InTimerUnits;
        generateMirrorNodeLocalVars.time = (long)this.timingAdjuster.adjustTime(generateMirrorNodeLocalVars.thisNodeTotalTime0InTimerUnits, generateMirrorNodeLocalVars.rtNode.getNCalls() + generateMirrorNodeLocalVars.totalNCallsFromThisNode, generateMirrorNodeLocalVars.totalNCallsFromThisNode, false);
        if (generateMirrorNodeLocalVars.time < 0L) {
            generateMirrorNodeLocalVars.time = 0L;
        }
        this.setTotalTime0ForNodeOfs(generateMirrorNodeLocalVars.dataOfs, generateMirrorNodeLocalVars.time);
        if (this.collectingTwoTimeStamps) {
            generateMirrorNodeLocalVars.time = (long)this.timingAdjuster.adjustTime(generateMirrorNodeLocalVars.rtNode.getNetTime1(), generateMirrorNodeLocalVars.rtNode.getNCalls() + generateMirrorNodeLocalVars.rtNode.getNCallsDiff(), generateMirrorNodeLocalVars.nCallsFromThisNode, true);
            if (generateMirrorNodeLocalVars.time < 0L) {
                generateMirrorNodeLocalVars.time = 0L;
            }
            this.setSelfTime1ForNodeOfs(generateMirrorNodeLocalVars.dataOfs, generateMirrorNodeLocalVars.time);
            generateMirrorNodeLocalVars2 = generateMirrorNodeLocalVars;
            generateMirrorNodeLocalVars2.thisNodeTotalTime1InTimerUnits = generateMirrorNodeLocalVars2.thisNodeTotalTime1InTimerUnits + generateMirrorNodeLocalVars.rtNode.getNetTime1();
            this.childTotalTime1InTimerUnits = generateMirrorNodeLocalVars.thisNodeTotalTime1InTimerUnits;
            generateMirrorNodeLocalVars.time = (long)this.timingAdjuster.adjustTime(generateMirrorNodeLocalVars.thisNodeTotalTime1InTimerUnits, generateMirrorNodeLocalVars.rtNode.getNCalls() + generateMirrorNodeLocalVars.totalNCallsFromThisNode, generateMirrorNodeLocalVars.totalNCallsFromThisNode, true);
            if (generateMirrorNodeLocalVars.time < 0L) {
                generateMirrorNodeLocalVars.time = 0L;
            }
            this.setTotalTime1ForNodeOfs(generateMirrorNodeLocalVars.dataOfs, generateMirrorNodeLocalVars.time);
        }
        this.childTotalNCalls = generateMirrorNodeLocalVars.totalNCallsFromThisNode + generateMirrorNodeLocalVars.rtNode.getNCalls();
        return generateMirrorNodeLocalVars.nextNodeOfs;
    }

    private void generateNodeBase(TimedCPUCCTNode timedCPUCCTNode, int n) {
        int n2 = timedCPUCCTNode instanceof MethodCPUCCTNode ? ((MethodCPUCCTNode)timedCPUCCTNode).getMethodId() : 0;
        int n3 = timedCPUCCTNode.getNCalls();
        int n4 = timedCPUCCTNode.getChildren() != null ? timedCPUCCTNode.getChildren().length : 0;
        this.setMethodIdForNodeOfs(n, n2);
        this.setNCallsForNodeOfs(n, n3);
        this.setNChildrenForNodeOfs(n, n4);
    }

    private void mergeBySelfTime(PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree, int n) {
        prestimeCPUCCTNodeFree.addNCalls(this.getNCallsForNodeOfs(n));
        prestimeCPUCCTNodeFree.addTotalTime0(this.getSelfTime0ForNodeOfs(n));
        if (this.collectingTwoTimeStamps) {
            prestimeCPUCCTNodeFree.addTotalTime1(this.getSelfTime1ForNodeOfs(n));
        }
        prestimeCPUCCTNodeFree.addWaitTime0(this.getWaitTime0ForNodeOfs(n));
        prestimeCPUCCTNodeFree.addSleepTime0(this.getSleepTime0ForNodeOfs(n));
    }

    private void subtractNodeDataBySelfTime(PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree, int n) {
        prestimeCPUCCTNodeFree.addNCalls(-this.getNCallsForNodeOfs(n));
        prestimeCPUCCTNodeFree.addTotalTime0(-this.getSelfTime0ForNodeOfs(n));
        if (this.collectingTwoTimeStamps) {
            prestimeCPUCCTNodeFree.addTotalTime1(-this.getSelfTime1ForNodeOfs(n));
        }
        prestimeCPUCCTNodeFree.addWaitTime0(-this.getWaitTime0ForNodeOfs(n));
        prestimeCPUCCTNodeFree.addSleepTime0(-this.getSleepTime0ForNodeOfs(n));
    }

    private static class GenerateMirrorNodeLocalVars {
        private final TimedCPUCCTNode rtNode;
        private final int dataOfs;
        private long thisNodeTotalTime0InTimerUnits;
        private long thisNodeTotalTime1InTimerUnits;
        private int nCallsFromThisNode;
        private int totalNCallsFromThisNode;
        private RuntimeCCTNode[] nodeChildren;
        private int nChildren;
        private int nextNodeOfs;
        private int childCounter;
        private int i;
        private RuntimeCPUCCTNode aNode;
        private long time;

        private GenerateMirrorNodeLocalVars(TimedCPUCCTNode timedCPUCCTNode, int n) {
            this.rtNode = timedCPUCCTNode;
            this.dataOfs = n;
        }

        static /* synthetic */ RuntimeCCTNode[] access$1102(GenerateMirrorNodeLocalVars generateMirrorNodeLocalVars, RuntimeCCTNode[] runtimeCCTNodeArray) {
            generateMirrorNodeLocalVars.nodeChildren = runtimeCCTNodeArray;
            return runtimeCCTNodeArray;
        }
    }

    private static final class AddChildLocalVars {
        private final TimedCPUCCTNode node;
        private final TimedCPUCCTNode parent;
        private TimedCPUCCTNode compParent;
        private TimedCPUCCTNode newChild;
        private int filterStatus;
        private int nChildren;
        private MethodCPUCCTNode existingChild;
        private String className;

        AddChildLocalVars(TimedCPUCCTNode timedCPUCCTNode, TimedCPUCCTNode timedCPUCCTNode2) {
            this.node = timedCPUCCTNode;
            this.parent = timedCPUCCTNode2;
        }
    }
}

