/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.fr;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "001", "Monde" },
            { "002", "Afrique" },
            { "003", "Am\u00e9rique du Nord" },
            { "005", "Am\u00e9rique du Sud" },
            { "009", "Oc\u00e9anie" },
            { "011", "Afrique occidentale" },
            { "013", "Am\u00e9rique centrale" },
            { "014", "Afrique orientale" },
            { "015", "Afrique septentrionale" },
            { "017", "Afrique centrale" },
            { "018", "Afrique australe" },
            { "019", "Am\u00e9riques" },
            { "021", "Am\u00e9rique septentrionale" },
            { "029", "Cara\u00efbes" },
            { "030", "Asie orientale" },
            { "034", "Asie du Sud" },
            { "035", "Asie du Sud-Est" },
            { "039", "Europe m\u00e9ridionale" },
            { "053", "Australie et Nouvelle-Z\u00e9lande" },
            { "054", "M\u00e9lan\u00e9sie" },
            { "057", "r\u00e9gion micron\u00e9sienne" },
            { "061", "Polyn\u00e9sie" },
            { "142", "Asie" },
            { "143", "Asie centrale" },
            { "145", "Asie occidentale" },
            { "150", "Europe" },
            { "151", "Europe orientale" },
            { "154", "Europe septentrionale" },
            { "155", "Europe occidentale" },
            { "419", "Am\u00e9rique latine" },
            { "AC", "\u00cele de l'Ascension" },
            { "AD", "Andorre" },
            { "AE", "\u00c9mirats arabes unis" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua-et-Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanie" },
            { "AM", "Arm\u00e9nie" },
            { "AN", "Antilles n\u00e9erlandaises" },
            { "AO", "Angola" },
            { "AQ", "Antarctique" },
            { "AR", "Argentine" },
            { "AS", "Samoa am\u00e9ricaines" },
            { "AT", "Autriche" },
            { "AU", "Australie" },
            { "AW", "Aruba" },
            { "AX", "\u00celes \u00c5land" },
            { "AZ", "Azerba\u00efdjan" },
            { "BA", "Bosnie-Herz\u00e9govine" },
            { "BB", "Barbade" },
            { "BD", "Bangladesh" },
            { "BE", "Belgique" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarie" },
            { "BH", "Bahre\u00efn" },
            { "BI", "Burundi" },
            { "BJ", "B\u00e9nin" },
            { "BL", "Saint-Barth\u00e9l\u00e9my" },
            { "BM", "Bermudes" },
            { "BN", "Brun\u00e9i Darussalam" },
            { "BO", "Bolivie" },
            { "BR", "Br\u00e9sil" },
            { "BS", "Bahamas" },
            { "BT", "Bhoutan" },
            { "BV", "\u00cele Bouvet" },
            { "BW", "Botswana" },
            { "BY", "B\u00e9larus" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "\u00celes Cocos - Keeling" },
            { "CD", "R\u00e9publique d\u00e9mocratique du Congo" },
            { "CF", "R\u00e9publique centrafricaine" },
            { "CG", "Congo-Brazzaville" },
            { "CH", "Suisse" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "\u00celes Cook" },
            { "CL", "Chili" },
            { "CM", "Cameroun" },
            { "CN", "Chine" },
            { "CO", "Colombie" },
            { "CP", "\u00cele Clipperton" },
            { "CR", "Costa Rica" },
            { "CS", "Serbie-et-Mont\u00e9n\u00e9gro" },
            { "CU", "Cuba" },
            { "CV", "Cap-Vert" },
            { "CX", "\u00cele Christmas" },
            { "CY", "Chypre" },
            { "CZ", "R\u00e9publique tch\u00e8que" },
            { "DE", "Allemagne" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Danemark" },
            { "DM", "Dominique" },
            { "DO", "R\u00e9publique dominicaine" },
            { "DZ", "Alg\u00e9rie" },
            { "EA", "Ceuta et Melilla" },
            { "EC", "\u00c9quateur" },
            { "EE", "Estonie" },
            { "EG", "\u00c9gypte" },
            { "EH", "Sahara occidental" },
            { "ER", "\u00c9rythr\u00e9e" },
            { "ES", "Espagne" },
            { "ET", "\u00c9thiopie" },
            { "EU", "Union europ\u00e9enne" },
            { "FI", "Finlande" },
            { "FJ", "Fidji" },
            { "FK", "\u00celes Malouines" },
            { "FM", "\u00c9tats f\u00e9d\u00e9r\u00e9s de Micron\u00e9sie" },
            { "FO", "\u00celes F\u00e9ro\u00e9" },
            { "FR", "France" },
            { "FX", "France m\u00e9tropolitaine" },
            { "GA", "Gabon" },
            { "GB", "Royaume-Uni" },
            { "GD", "Grenade" },
            { "GE", "G\u00e9orgie" },
            { "GF", "Guyane fran\u00e7aise" },
            { "GG", "Guernesey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenland" },
            { "GM", "Gambie" },
            { "GN", "Guin\u00e9e" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guin\u00e9e \u00e9quatoriale" },
            { "GR", "Gr\u00e8ce" },
            { "GS", "G\u00e9orgie du Sud et les \u00eeles Sandwich du Sud" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guin\u00e9e-Bissau" },
            { "GY", "Guyana" },
            { "HK", "R.A.S. chinoise de Hong Kong" },
            { "HM", "\u00celes Heard et MacDonald" },
            { "HN", "Honduras" },
            { "HR", "Croatie" },
            { "HT", "Ha\u00efti" },
            { "HU", "Hongrie" },
            { "IC", "\u00celes Canaries" },
            { "ID", "Indon\u00e9sie" },
            { "IE", "Irlande" },
            { "IL", "Isra\u00ebl" },
            { "IM", "\u00cele de Man" },
            { "IN", "Inde" },
            { "IO", "Territoire britannique de l'oc\u00e9an Indien" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islande" },
            { "IT", "Italie" },
            { "JE", "Jersey" },
            { "JM", "Jama\u00efque" },
            { "JO", "Jordanie" },
            { "JP", "Japon" },
            { "KE", "Kenya" },
            { "KG", "Kirghizistan" },
            { "KH", "Cambodge" },
            { "KI", "Kiribati" },
            { "KM", "Comores" },
            { "KN", "Saint-Kitts-et-Nevis" },
            { "KP", "Cor\u00e9e du Nord" },
            { "KR", "Cor\u00e9e du Sud" },
            { "KW", "Kowe\u00eft" },
            { "KY", "\u00celes Ca\u00efmans" },
            { "KZ", "Kazakhstan" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Sainte-Lucie" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Lib\u00e9ria" },
            { "LS", "Lesotho" },
            { "LT", "Lituanie" },
            { "LU", "Luxembourg" },
            { "LV", "Lettonie" },
            { "LY", "Libye" },
            { "MA", "Maroc" },
            { "MC", "Monaco" },
            { "MD", "Moldavie" },
            { "ME", "Mont\u00e9n\u00e9gro" },
            { "MF", "Saint-Martin" },
            { "MG", "Madagascar" },
            { "MH", "\u00celes Marshall" },
            { "MK", "Mac\u00e9doine" },
            { "ML", "Mali" },
            { "MM", "Myanmar" },
            { "MN", "Mongolie" },
            { "MO", "R.A.S. chinoise de Macao" },
            { "MP", "\u00celes Mariannes du Nord" },
            { "MQ", "Martinique" },
            { "MR", "Mauritanie" },
            { "MS", "Montserrat" },
            { "MT", "Malte" },
            { "MU", "Maurice" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexique" },
            { "MY", "Malaisie" },
            { "MZ", "Mozambique" },
            { "NA", "Namibie" },
            { "NC", "Nouvelle-Cal\u00e9donie" },
            { "NE", "Niger" },
            { "NF", "\u00cele Norfolk" },
            { "NG", "Nig\u00e9ria" },
            { "NI", "Nicaragua" },
            { "NL", "Pays-Bas" },
            { "NO", "Norv\u00e8ge" },
            { "NP", "N\u00e9pal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nouvelle-Z\u00e9lande" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "P\u00e9rou" },
            { "PF", "Polyn\u00e9sie fran\u00e7aise" },
            { "PG", "Papouasie-Nouvelle-Guin\u00e9e" },
            { "PH", "Philippines" },
            { "PK", "Pakistan" },
            { "PL", "Pologne" },
            { "PM", "Saint-Pierre-et-Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Porto Rico" },
            { "PS", "Territoire palestinien" },
            { "PT", "Portugal" },
            { "PW", "Palaos" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "r\u00e9gions \u00e9loign\u00e9es de l\u2019Oc\u00e9anie" },
            { "RE", "R\u00e9union" },
            { "RO", "Roumanie" },
            { "RS", "Serbie" },
            { "RU", "Russie" },
            { "RW", "Rwanda" },
            { "SA", "Arabie saoudite" },
            { "SB", "\u00celes Salomon" },
            { "SC", "Seychelles" },
            { "SD", "Soudan" },
            { "SE", "Su\u00e8de" },
            { "SG", "Singapour" },
            { "SH", "Sainte-H\u00e9l\u00e8ne" },
            { "SI", "Slov\u00e9nie" },
            { "SJ", "Svalbard et \u00cele Jan Mayen" },
            { "SK", "Slovaquie" },
            { "SL", "Sierra Leone" },
            { "SM", "Saint-Marin" },
            { "SN", "S\u00e9n\u00e9gal" },
            { "SO", "Somalie" },
            { "SR", "Suriname" },
            { "ST", "Sao Tom\u00e9-et-Principe" },
            { "SV", "El Salvador" },
            { "SY", "Syrie" },
            { "SZ", "Swaziland" },
            { "TA", "Tristan da Cunha" },
            { "TC", "\u00celes Turks et Ca\u00efques" },
            { "TD", "Tchad" },
            { "TF", "Terres australes fran\u00e7aises" },
            { "TG", "Togo" },
            { "TH", "Tha\u00eflande" },
            { "TJ", "Tadjikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor oriental" },
            { "TM", "Turkm\u00e9nistan" },
            { "TN", "Tunisie" },
            { "TO", "Tonga" },
            { "TR", "Turquie" },
            { "TT", "Trinit\u00e9-et-Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Ta\u00efwan" },
            { "TZ", "Tanzanie" },
            { "UA", "Ukraine" },
            { "UG", "Ouganda" },
            { "UM", "\u00celes Mineures \u00c9loign\u00e9es des \u00c9tats-Unis" },
            { "US", "\u00c9tats-Unis" },
            { "UY", "Uruguay" },
            { "UZ", "Ouzb\u00e9kistan" },
            { "VA", "\u00c9tat de la Cit\u00e9 du Vatican" },
            { "VC", "Saint-Vincent-et-les Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "\u00celes Vierges britanniques" },
            { "VI", "\u00celes Vierges des \u00c9tats-Unis" },
            { "VN", "Vi\u00eat Nam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis-et-Futuna" },
            { "WS", "Samoa" },
            { "YE", "Y\u00e9men" },
            { "YT", "Mayotte" },
            { "ZA", "Afrique du Sud" },
            { "ZM", "Zambie" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "r\u00e9gion ind\u00e9termin\u00e9e" },
            { "aa", "afar" },
            { "ab", "abkhaze" },
            { "ae", "avestique" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amharique" },
            { "an", "aragonais" },
            { "ar", "arabe" },
            { "as", "assamais" },
            { "av", "avar" },
            { "ay", "aymara" },
            { "az", "az\u00e9ri" },
            { "ba", "bachkir" },
            { "be", "bi\u00e9lorusse" },
            { "bg", "bulgare" },
            { "bh", "bihari" },
            { "bi", "bichelamar" },
            { "bm", "bambara" },
            { "bn", "bengali" },
            { "bo", "tib\u00e9tain" },
            { "br", "breton" },
            { "bs", "bosniaque" },
            { "ca", "catalan" },
            { "ce", "tch\u00e9tch\u00e8ne" },
            { "ch", "chamorro" },
            { "co", "corse" },
            { "cr", "cree" },
            { "cs", "tch\u00e8que" },
            { "cu", "slavon d\u2019\u00e9glise" },
            { "cv", "tchouvache" },
            { "cy", "gallois" },
            { "da", "danois" },
            { "de", "allemand" },
            { "dv", "maldivien" },
            { "dz", "dzongkha" },
            { "ee", "\u00e9w\u00e9" },
            { "el", "grec" },
            { "en", "anglais" },
            { "eo", "esp\u00e9ranto" },
            { "es", "espagnol" },
            { "et", "estonien" },
            { "eu", "basque" },
            { "fa", "persan" },
            { "ff", "peul" },
            { "fi", "finnois" },
            { "fj", "fidjien" },
            { "fo", "f\u00e9ro\u00efen" },
            { "fr", "fran\u00e7ais" },
            { "fy", "frison" },
            { "ga", "irlandais" },
            { "gd", "ga\u00e9lique \u00e9cossais" },
            { "gl", "galicien" },
            { "gn", "guarani" },
            { "gu", "goudjar\u00e2t\u00ee" },
            { "gv", "manx" },
            { "ha", "haoussa" },
            { "he", "h\u00e9breu" },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "croate" },
            { "ht", "ha\u00eftien" },
            { "hu", "hongrois" },
            { "hy", "arm\u00e9nien" },
            { "hz", "h\u00e9r\u00e9ro" },
            { "ia", "interlingua" },
            { "id", "indon\u00e9sien" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "yi de Sichuan" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "islandais" },
            { "it", "italien" },
            { "iu", "inuktitut" },
            { "ja", "japonais" },
            { "jv", "javanais" },
            { "ka", "g\u00e9orgien" },
            { "kg", "kongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazakh" },
            { "kl", "groenlandais" },
            { "km", "khmer" },
            { "kn", "kannada" },
            { "ko", "cor\u00e9en" },
            { "kr", "kanouri" },
            { "ks", "k\u00e2shm\u00eer\u00ee" },
            { "ku", "kurde" },
            { "kv", "komi" },
            { "kw", "cornique" },
            { "ky", "kirghize" },
            { "la", "latin" },
            { "lb", "luxembourgeois" },
            { "lg", "ganda" },
            { "li", "limbourgeois" },
            { "ln", "lingala" },
            { "lo", "lao" },
            { "lt", "lituanien" },
            { "lu", "luba-katanga" },
            { "lv", "letton" },
            { "mg", "malgache" },
            { "mh", "marshall" },
            { "mi", "maori" },
            { "mk", "mac\u00e9donien" },
            { "ml", "malayalam" },
            { "mn", "mongol" },
            { "mo", "moldave" },
            { "mr", "marathe" },
            { "ms", "malais" },
            { "mt", "maltais" },
            { "my", "birman" },
            { "na", "nauruan" },
            { "nb", "norv\u00e9gien bokm\u00e5l" },
            { "nd", "nd\u00e9b\u00e9l\u00e9 du Nord" },
            { "ne", "n\u00e9palais" },
            { "ng", "ndonga" },
            { "nl", "n\u00e9erlandais" },
            { "nn", "norv\u00e9gien nynorsk" },
            { "no", "norv\u00e9gien" },
            { "nr", "nd\u00e9b\u00e9l\u00e9 du Sud" },
            { "nv", "navaho" },
            { "ny", "nyanja" },
            { "oc", "occitan" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", "oriya" },
            { "os", "oss\u00e8te" },
            { "pa", "pendjabi" },
            { "pi", "pali" },
            { "pl", "polonais" },
            { "ps", "pachto" },
            { "pt", "portugais" },
            { "qu", "langue quechua" },
            { "rm", "rh\u00e9to-roman" },
            { "rn", "roundi" },
            { "ro", "roumain" },
            { "ru", "russe" },
            { "rw", "rwanda" },
            { "sa", "sanskrit" },
            { "sc", "sarde" },
            { "sd", "sindh\u00ee" },
            { "se", "sami du Nord" },
            { "sg", "sangho" },
            { "sh", "serbo-croate" },
            { "si", "singhalais" },
            { "sk", "slovaque" },
            { "sl", "slov\u00e8ne" },
            { "sm", "samoan" },
            { "sn", "shona" },
            { "so", "somali" },
            { "sq", "albanais" },
            { "sr", "serbe" },
            { "ss", "swati" },
            { "st", "sesotho" },
            { "su", "soundanais" },
            { "sv", "su\u00e9dois" },
            { "sw", "swahili" },
            { "ta", "tamoul" },
            { "te", "t\u00e9lougou" },
            { "tg", "tadjik" },
            { "th", "tha\u00ef" },
            { "ti", "tigrigna" },
            { "tk", "turkm\u00e8ne" },
            { "tl", "tagalog" },
            { "tn", "tswana" },
            { "to", "tongan" },
            { "tr", "turc" },
            { "ts", "tsonga" },
            { "tt", "tatar" },
            { "tw", "twi" },
            { "ty", "tahitien" },
            { "ug", "ou\u00efgour" },
            { "uk", "ukrainien" },
            { "ur", "ourdou" },
            { "uz", "ouzbek" },
            { "ve", "venda" },
            { "vi", "vietnamien" },
            { "vo", "volapuk" },
            { "wa", "wallon" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "yiddish" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "chinois" },
            { "zu", "zoulou" },
            { "ace", "aceh" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adygh\u00e9en" },
            { "afa", "langue afro-asiatique" },
            { "afh", "afrihili" },
            { "ain", "a\u00efnou" },
            { "akk", "akkadien" },
            { "ale", "al\u00e9oute" },
            { "alg", "langue algonquienne" },
            { "alt", "alta\u00ef du Sud" },
            { "ang", "ancien anglais" },
            { "anp", "angika" },
            { "apa", "langue apache" },
            { "arc", "aram\u00e9en" },
            { "arn", "araukan" },
            { "arp", "arapaho" },
            { "art", "langue artificielle" },
            { "arw", "arawak" },
            { "ast", "asturien" },
            { "ath", "langue athapascane" },
            { "aus", "langue australienne" },
            { "awa", "awadhi" },
            { "bad", "banda" },
            { "bai", "langue bamil\u00e9k\u00e9e" },
            { "bal", "baloutchi" },
            { "ban", "balinais" },
            { "bas", "bassa" },
            { "bat", "langue balte" },
            { "bej", "bedja" },
            { "bem", "bemba" },
            { "ber", "berb\u00e8re" },
            { "bho", "bhojpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bla", "siksika" },
            { "bnt", "bantou" },
            { "bra", "braj" },
            { "btk", "batak" },
            { "bua", "bouriate" },
            { "bug", "bugi" },
            { "byn", "blin" },
            { "cad", "caddo" },
            { "cai", "langue am\u00e9rindienne centrale" },
            { "car", "caribe" },
            { "cau", "langue caucasienne" },
            { "cch", "atsam" },
            { "ceb", "cebuano" },
            { "cel", "langue celtique" },
            { "chb", "chibcha" },
            { "chg", "tchaghata\u00ef" },
            { "chk", "chuuk" },
            { "chm", "mari" },
            { "chn", "jargon chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", "cherokee" },
            { "chy", "cheyenne" },
            { "cmc", "langue chame" },
            { "cop", "copte" },
            { "cpe", "cr\u00e9ole ou pidgin anglais" },
            { "cpf", "cr\u00e9ole ou pidgin fran\u00e7ais" },
            { "cpp", "cr\u00e9ole ou pidgin portugais" },
            { "crh", "turc de Crim\u00e9e" },
            { "crp", "cr\u00e9ole ou pidgin" },
            { "csb", "kachoube" },
            { "cus", "langue couchitique" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "day", "dayak" },
            { "del", "delaware" },
            { "den", "slavey" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "doi", "dogri" },
            { "dra", "langue dravidienne" },
            { "dsb", "bas-sorabe" },
            { "dua", "douala" },
            { "dum", "moyen n\u00e9erlandais" },
            { "dyu", "dioula" },
            { "efi", "efik" },
            { "egy", "\u00e9gyptien ancien" },
            { "eka", "ekajuk" },
            { "elx", "\u00e9lamite" },
            { "enm", "moyen anglais" },
            { "ewo", "\u00e9wondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipino" },
            { "fiu", "langue finno-ougrienne" },
            { "fon", "fon" },
            { "frm", "moyen fran\u00e7ais" },
            { "fro", "ancien fran\u00e7ais" },
            { "frr", "frison du Nord" },
            { "frs", "frison oriental" },
            { "fur", "frioulan" },
            { "gaa", "ga" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gem", "langue germanique" },
            { "gez", "gu\u00e8ze" },
            { "gil", "gilbertais" },
            { "gmh", "moyen haut-allemand" },
            { "goh", "ancien haut allemand" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", "gotique" },
            { "grb", "grebo" },
            { "grc", "grec ancien" },
            { "gsw", "al\u00e9manique" },
            { "gwi", "gwich\u02bcin" },
            { "hai", "haida" },
            { "haw", "hawa\u00efen" },
            { "hil", "hiligaynon" },
            { "him", "himachali" },
            { "hit", "hittite" },
            { "hmn", "hmong" },
            { "hsb", "haut-sorabe" },
            { "hup", "hupa" },
            { "iba", "iban" },
            { "ijo", "ijo" },
            { "ilo", "ilokano" },
            { "inc", "langue indo-aryenne" },
            { "ine", "langue indo-europ\u00e9enne" },
            { "inh", "ingouche" },
            { "ira", "langue iranienne" },
            { "iro", "langue iroquoienne" },
            { "jbo", "lojban" },
            { "jpr", "jud\u00e9o-persan" },
            { "jrb", "jud\u00e9o-arabe" },
            { "kaa", "karakalpak" },
            { "kab", "kabyle" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kar", "karen" },
            { "kaw", "kawi" },
            { "kbd", "kabardin" },
            { "kcg", "tyap" },
            { "kfo", "koro" },
            { "kha", "khasi" },
            { "khi", "langue kho\u00efsan" },
            { "kho", "khotanais" },
            { "kmb", "kiMboundou" },
            { "kok", "konkani" },
            { "kos", "kusaien" },
            { "kpe", "kpell\u00e9" },
            { "krc", "karatcha\u00ef balkar" },
            { "krl", "car\u00e9lien" },
            { "kro", "krou" },
            { "kru", "kurukh" },
            { "kum", "koumyk" },
            { "kut", "kutenai" },
            { "lad", "ladino" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezghien" },
            { "lol", "mongo" },
            { "loz", "lozi" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "lushai" },
            { "mad", "madurais" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makassar" },
            { "man", "mandingue" },
            { "map", "malayo-polyn\u00e9sien" },
            { "mas", "masai" },
            { "mdf", "moksa" },
            { "mdr", "mandar" },
            { "men", "mend\u00e9" },
            { "mga", "moyen irlandais" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mis", "langue diverse" },
            { "mkh", "langue mon-khm\u00e8re" },
            { "mnc", "mandchou" },
            { "mni", "manipuri" },
            { "mno", "langue manobo" },
            { "moh", "mohawk" },
            { "mos", "mor\u00e9" },
            { "mul", "multilingue" },
            { "mun", "langue mounda" },
            { "mus", "creek" },
            { "mwl", "mirandais" },
            { "mwr", "marwar\u00ee" },
            { "myn", "langue maya" },
            { "myv", "erzya" },
            { "nah", "nahuatl" },
            { "nai", "langue am\u00e9rindienne du Nord" },
            { "nap", "napolitain" },
            { "nds", "bas-allemand" },
            { "new", "newari" },
            { "nia", "nias" },
            { "nic", "langue nig\u00e9ro-congolaise" },
            { "niu", "niu\u00e9" },
            { "nog", "noga\u00ef" },
            { "non", "vieux norrois" },
            { "nqo", "n\u2019ko" },
            { "nso", "sotho du Nord" },
            { "nub", "langue nubienne" },
            { "nwc", "newar\u00ee classique" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankol\u00e9" },
            { "nyo", "nyoro" },
            { "nzi", "nzema" },
            { "osa", "osage" },
            { "ota", "turc ottoman" },
            { "oto", "langue otomangue" },
            { "paa", "langue papoue" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampangan" },
            { "pap", "papiamento" },
            { "pau", "palau" },
            { "peo", "persan ancien" },
            { "phi", "langue philippine" },
            { "phn", "ph\u00e9nicien" },
            { "pon", "pohnpei" },
            { "pra", "langues pr\u00e2krit" },
            { "pro", "proven\u00e7al ancien" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotongien" },
            { "roa", "langue romane" },
            { "rom", "tzigane" },
            { "rup", "valaque" },
            { "sad", "sandawe" },
            { "sah", "iakoute" },
            { "sai", "langue am\u00e9rindienne du Sud" },
            { "sal", "langue salishenne" },
            { "sam", "aram\u00e9en samaritain" },
            { "sas", "sasak" },
            { "sat", "santal" },
            { "scn", "sicilien" },
            { "sco", "\u00e9cossais" },
            { "sel", "selkoupe" },
            { "sem", "langue s\u00e9mitique" },
            { "sga", "ancien irlandais" },
            { "sgn", "langue des signes" },
            { "shn", "shan" },
            { "sid", "sidamo" },
            { "sio", "langue sioux" },
            { "sit", "langue sino-tib\u00e9taine" },
            { "sla", "langue slave" },
            { "sma", "sami du Sud" },
            { "smi", "langue samie" },
            { "smj", "sami de Lule" },
            { "smn", "sami d\u2019Inari" },
            { "sms", "sami skolt" },
            { "snk", "sonink\u00e9" },
            { "sog", "sogdien" },
            { "son", "songhai" },
            { "srn", "sranan tongo" },
            { "srr", "s\u00e9r\u00e8re" },
            { "ssa", "langue nilo-saharienne" },
            { "suk", "sukuma" },
            { "sus", "soussou" },
            { "sux", "sum\u00e9rien" },
            { "swb", "comorien" },
            { "syc", "syriaque classique" },
            { "syr", "syriaque" },
            { "tai", "langue ta\u00ef" },
            { "tem", "temne" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tig", "tigr\u00e9" },
            { "tiv", "tiv" },
            { "tkl", "tokelau" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tmh", "tamacheq" },
            { "tog", "tonga nyasa" },
            { "tpi", "tok pisin" },
            { "tsi", "tsimshian" },
            { "tum", "tumbuka" },
            { "tup", "langue tupi" },
            { "tut", "langue alta\u00efque" },
            { "tvl", "tuvalu" },
            { "tyv", "touva" },
            { "udm", "oudmourte" },
            { "uga", "ougaritique" },
            { "umb", "umbundu" },
            { "und", "ind\u00e9termin\u00e9" },
            { "vai", "va\u00ef" },
            { "vot", "vote" },
            { "wak", "langues wakashennes" },
            { "wal", "walamo" },
            { "war", "waray" },
            { "was", "washo" },
            { "wen", "langue sorabe" },
            { "xal", "kalmouk" },
            { "yao", "yao" },
            { "yap", "yapois" },
            { "ypk", "langues yupik" },
            { "yue", "cantonais" },
            { "zap", "zapot\u00e8que" },
            { "zbl", "symboles Bliss" },
            { "zen", "zenaga" },
            { "znd", "zand\u00e9" },
            { "zun", "zuni" },
            { "zxx", "sans contenu linguistique" },
            { "zza", "zazaki" },
            { "Arab", "arabe" },
            { "Armi", "aram\u00e9en imp\u00e9rial" },
            { "Armn", "arm\u00e9nien" },
            { "Avst", "avestique" },
            { "Bali", "balinais" },
            { "Batk", "batak" },
            { "Beng", "beng\u00e2gl\u00ee" },
            { "Blis", "symboles Bliss" },
            { "Bopo", "bopomofo" },
            { "Brah", "br\u00e2hm\u00ee" },
            { "Brai", "braille" },
            { "Bugi", "bouguis" },
            { "Buhd", "bouhide" },
            { "Cakm", "chakma" },
            { "Cans", "syllabaire autochtone canadien unifi\u00e9" },
            { "Cari", "carien" },
            { "Cham", "cham" },
            { "Cher", "tch\u00e9rok\u00ee" },
            { "Cirt", "cirth" },
            { "Copt", "copte" },
            { "Cprt", "syllabaire chypriote" },
            { "Cyrl", "cyrillique" },
            { "Cyrs", "cyrillique (variante slavonne)" },
            { "Deva", "d\u00e9van\u00e2gar\u00ee" },
            { "Dsrt", "d\u00e9s\u00e9ret" },
            { "Egyd", "d\u00e9motique \u00e9gyptien" },
            { "Egyh", "hi\u00e9ratique \u00e9gyptien" },
            { "Egyp", "hi\u00e9roglyphes \u00e9gyptiens" },
            { "Ethi", "\u00e9thiopique" },
            { "Geok", "g\u00e9orgien khoutsouri" },
            { "Geor", "g\u00e9orgien" },
            { "Glag", "glagolitique" },
            { "Goth", "gotique" },
            { "Grek", "grec" },
            { "Gujr", "goudjar\u00e2t\u00ee" },
            { "Guru", "gourmoukh\u00ee" },
            { "Hang", "hang\u00fbl" },
            { "Hani", "id\u00e9ogrammes han" },
            { "Hano", "hanoun\u00f3o" },
            { "Hans", "id\u00e9ogrammes han simplifi\u00e9s" },
            { "Hant", "id\u00e9ogrammes han traditionnels" },
            { "Hebr", "h\u00e9breu" },
            { "Hira", "hiragana" },
            { "Hmng", "pahawh hmong" },
            { "Hrkt", "katakana ou hiragana" },
            { "Hung", "ancien hongrois" },
            { "Inds", "indus" },
            { "Ital", "ancien italique" },
            { "Java", "javanais" },
            { "Jpan", "japonais" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharochth\u00ee" },
            { "Khmr", "khmer" },
            { "Knda", "kannara" },
            { "Kore", "cor\u00e9en" },
            { "Kthi", "kaith\u00ee" },
            { "Lana", "lanna" },
            { "Laoo", "lao" },
            { "Latf", "latin (variante bris\u00e9e)" },
            { "Latg", "latin (variante ga\u00e9lique)" },
            { "Latn", "latin" },
            { "Lepc", "lepcha" },
            { "Limb", "limbou" },
            { "Lina", "lin\u00e9aire A" },
            { "Linb", "lin\u00e9aire B" },
            { "Lyci", "lycien" },
            { "Lydi", "lydien" },
            { "Mand", "mand\u00e9en" },
            { "Mani", "manich\u00e9en" },
            { "Maya", "hi\u00e9roglyphes mayas" },
            { "Mero", "m\u00e9ro\u00eftique" },
            { "Mlym", "malay\u00e2lam" },
            { "Mong", "mongol" },
            { "Moon", "moon" },
            { "Mtei", "meitei mayek" },
            { "Mymr", "birman" },
            { "Nkoo", "n\u2019ko" },
            { "Ogam", "ogam" },
            { "Olck", "ol tchiki" },
            { "Orkh", "orkhon" },
            { "Orya", "oriy\u00e2" },
            { "Osma", "osmanais" },
            { "Perm", "ancien permien" },
            { "Phag", "phags pa" },
            { "Phli", "pehlevi des inscriptions" },
            { "Phlp", "pehlevi des psautiers" },
            { "Phlv", "pehlevi des livres" },
            { "Phnx", "ph\u00e9nicien" },
            { "Plrd", "phon\u00e9tique de Pollard" },
            { "Prti", "parthe des inscriptions" },
            { "Rjng", "rejang" },
            { "Roro", "rongorongo" },
            { "Runr", "runique" },
            { "Samr", "samaritain" },
            { "Sara", "sarati" },
            { "Saur", "saurashtra" },
            { "Sgnw", "\u00e9criture des signes" },
            { "Shaw", "shavien" },
            { "Sinh", "singhalais" },
            { "Sund", "sundanais" },
            { "Sylo", "sylot\u00ee n\u00e2gr\u00ee" },
            { "Syrc", "syriaque" },
            { "Syre", "syriaque estrangh\u00e9lo" },
            { "Syrj", "syriaque occidental" },
            { "Syrn", "syriaque oriental" },
            { "Tagb", "tagbanoua" },
            { "Tale", "ta\u00ef-le" },
            { "Talu", "nouveau ta\u00ef-lue" },
            { "Taml", "tamoul" },
            { "Tavt", "ta\u00ef vi\u00eat" },
            { "Telu", "t\u00e9lougou" },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", "tagal" },
            { "Thaa", "th\u00e2na" },
            { "Thai", "tha\u00ef" },
            { "Tibt", "tib\u00e9tain" },
            { "Ugar", "ougaritique" },
            { "Vaii", "va\u00ef" },
            { "Visp", "parole visible" },
            { "Xpeo", "cun\u00e9iforme pers\u00e9politain" },
            { "Xsux", "cun\u00e9iforme sum\u00e9ro-akkadien" },
            { "Yiii", "yi" },
            { "Zinh", "h\u00e9rit\u00e9" },
            { "Zmth", "notation math\u00e9matique" },
            { "Zsym", "symboles" },
            { "Zxxx", "non \u00e9crit" },
            { "Zyyy", "commun" },
            { "Zzzz", "\u00e9criture inconnue ou non valide" },
            { "root", "racine" },
            { "de_AT", "allemand autrichien" },
            { "de_CH", "allemand suisse" },
            { "en_AU", "anglais australien" },
            { "en_CA", "anglais canadien" },
            { "en_GB", "anglais britannique" },
            { "en_US", "anglais am\u00e9ricain" },
            { "es_ES", "espagnol ib\u00e9rique" },
            { "fr_CA", "fran\u00e7ais canadien" },
            { "fr_CH", "fran\u00e7ais suisse" },
            { "nl_BE", "n\u00e9erlandais belge" },
            { "pt_BR", "portugais br\u00e9silien" },
            { "pt_PT", "portugais ib\u00e9rique" },
            { "es_419", "espagnol latino-am\u00e9ricain" },
            { "zh_Hans", "chinois simplifi\u00e9" },
            { "zh_Hant", "chinois traditionnel" },
        };
        return data;
    }
}
