/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.geonames;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import org.fibs.geotag.util.Units;

public class Location
implements Comparable<Location> {
    private String name;
    private String latitude;
    private String longitude;
    private String countryName;
    private String province;
    private double distance;
    private List<String> alternateNames = null;
    private String featureName;
    private String featureClass;

    public String toString() {
        return '[' + this.name + ',' + this.latitude + ',' + this.longitude + ',' + this.province + ',' + this.countryName + ',' + this.distance + ']';
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getDistance(Units.DISTANCE unit) {
        return Units.convert(this.distance, Units.DISTANCE.KILOMETRES, unit);
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public void addAlternateName(String alternateName) {
        if (this.alternateNames == null) {
            this.alternateNames = new ArrayList<String>();
        }
        this.alternateNames.add(alternateName);
    }

    public void setAlternateNames(String names) {
        StringTokenizer tokenizer = new StringTokenizer(names, ",");
        while (tokenizer.hasMoreTokens()) {
            String alternateName = tokenizer.nextToken().trim();
            this.addAlternateName(alternateName);
        }
    }

    public List<String> getAlternateNames() {
        return this.alternateNames;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public String getFeatureClass() {
        return this.featureClass;
    }

    public void setFeatureClass(String featureClass) {
        this.featureClass = featureClass;
    }

    public boolean isPopulatedPlace() {
        return "P".equals(this.featureClass);
    }

    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public int compareTo(Location other) {
        if (this.distance < other.distance) {
            return -1;
        }
        if (this.distance > other.distance) {
            return 1;
        }
        return this.name.compareTo(other.name);
    }
}

