/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import org.testng.IClass;
import org.testng.IConfigurationListener;
import org.testng.IConfigurationListener2;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestNGListenerFactory;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.annotations.IListenersAnnotation;
import org.testng.collections.Lists;
import org.testng.internal.TestNGClassFinder;
import org.testng.internal.annotations.IAnnotationFinder;

public final class TestListenerHelper {
    private TestListenerHelper() {
    }

    static void runPreConfigurationListeners(ITestResult iTestResult, List<IConfigurationListener> list) {
        for (IConfigurationListener iConfigurationListener : list) {
            if (!(iConfigurationListener instanceof IConfigurationListener2)) continue;
            ((IConfigurationListener2)iConfigurationListener).beforeConfiguration(iTestResult);
        }
    }

    static void runPostConfigurationListeners(ITestResult iTestResult, List<IConfigurationListener> list) {
        block5: for (IConfigurationListener iConfigurationListener : list) {
            switch (iTestResult.getStatus()) {
                case 3: {
                    iConfigurationListener.onConfigurationSkip(iTestResult);
                    continue block5;
                }
                case 2: {
                    iConfigurationListener.onConfigurationFailure(iTestResult);
                    continue block5;
                }
                case 1: {
                    iConfigurationListener.onConfigurationSuccess(iTestResult);
                    continue block5;
                }
            }
            throw new AssertionError((Object)("Unexpected value: " + iTestResult.getStatus()));
        }
    }

    public static void runTestListeners(ITestResult iTestResult, List<ITestListener> list) {
        block7: for (ITestListener iTestListener : list) {
            switch (iTestResult.getStatus()) {
                case 3: {
                    iTestListener.onTestSkipped(iTestResult);
                    continue block7;
                }
                case 4: {
                    iTestListener.onTestFailedButWithinSuccessPercentage(iTestResult);
                    continue block7;
                }
                case 2: {
                    iTestListener.onTestFailure(iTestResult);
                    continue block7;
                }
                case 1: {
                    iTestListener.onTestSuccess(iTestResult);
                    continue block7;
                }
                case 16: {
                    iTestListener.onTestStart(iTestResult);
                    continue block7;
                }
            }
            throw new AssertionError((Object)("Unknown status: " + iTestResult.getStatus()));
        }
    }

    public static ListenerHolder findAllListeners(Class<?> clazz, IAnnotationFinder iAnnotationFinder) {
        ListenerHolder listenerHolder = new ListenerHolder();
        listenerHolder.listenerClasses = Lists.newArrayList();
        while (clazz != Object.class) {
            IListenersAnnotation iListenersAnnotation = iAnnotationFinder.findAnnotation(clazz, IListenersAnnotation.class);
            if (iListenersAnnotation != null) {
                Class<? extends ITestNGListener>[] classArray;
                for (Class<? extends ITestNGListener> clazz2 : classArray = iListenersAnnotation.getValue()) {
                    listenerHolder.listenerClasses.add(clazz2);
                    if (!ITestNGListenerFactory.class.isAssignableFrom(clazz2)) continue;
                    if (listenerHolder.listenerFactoryClass == null) {
                        listenerHolder.listenerFactoryClass = clazz2;
                        continue;
                    }
                    throw new TestNGException("Found more than one class implementing ITestNGListenerFactory:" + clazz2 + " and " + listenerHolder.listenerFactoryClass);
                }
            }
            clazz = clazz.getSuperclass();
        }
        return listenerHolder;
    }

    public static ITestNGListenerFactory createListenerFactory(TestNGClassFinder testNGClassFinder, Class<? extends ITestNGListenerFactory> clazz) {
        ITestNGListenerFactory iTestNGListenerFactory = null;
        try {
            IClass iClass;
            if (testNGClassFinder != null && (iClass = testNGClassFinder.getIClass(clazz)) != null) {
                iTestNGListenerFactory = (ITestNGListenerFactory)iClass.getInstances(false)[0];
            }
            if (iTestNGListenerFactory == null) {
                iTestNGListenerFactory = clazz != null ? clazz.newInstance() : null;
            }
            return iTestNGListenerFactory;
        }
        catch (Exception exception) {
            throw new TestNGException("Couldn't instantiate the ITestNGListenerFactory: " + exception);
        }
    }

    public static class ListenerHolder {
        private List<Class<? extends ITestNGListener>> listenerClasses;
        private Class<? extends ITestNGListenerFactory> listenerFactoryClass;

        public List<Class<? extends ITestNGListener>> getListenerClasses() {
            return this.listenerClasses;
        }

        public Class<? extends ITestNGListenerFactory> getListenerFactoryClass() {
            return this.listenerFactoryClass;
        }
    }
}

