/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.events.ChartDataEventListener;
import eu.hansolo.tilesfx.events.TileEvent;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javafx.animation.FadeTransition;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class SmoothAreaChartTileSkin
extends TileSkin {
    private Text titleText;
    private Text valueText;
    private Text upperUnitText;
    private Line fractionLine;
    private Text unitText;
    private VBox unitFlow;
    private HBox valueUnitFlow;
    private int dataSize;
    private double maxValue;
    private List<Point> points;
    private Path fillPath;
    private Path strokePath;
    private Pane dataPointGroup;
    private boolean dataPointsVisible;
    private boolean smoothing;
    private double hStepSize;
    private double vStepSize;
    private Circle selector;
    private Tooltip selectorTooltip;
    private SequentialTransition fadeInFadeOut;
    private Rectangle fillClip;
    private Rectangle strokeClip;
    private ChartDataEventListener chartEventListener;
    private ListChangeListener<ChartData> chartDataListener;
    private EventHandler<MouseEvent> clickHandler;
    private EventHandler<ActionEvent> endOfTransformationHandler;

    public SmoothAreaChartTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.chartEventListener = e -> this.handleData();
        this.chartDataListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(addedItem -> addedItem.addChartDataEventListener(this.chartEventListener));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(removedItem -> removedItem.removeChartDataEventListener(this.chartEventListener));
            }
            this.handleData();
        };
        this.clickHandler = e -> this.select((MouseEvent)e);
        this.endOfTransformationHandler = e -> this.selectorTooltip.hide();
        this.smoothing = this.tile.isSmoothing();
        this.titleText = new Text();
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.fillClip = new Rectangle(0.0, 0.0, 250.0, 250.0);
        this.strokeClip = new Rectangle(0.0, 0.0, 250.0, 250.0);
        this.points = new ArrayList<Point>();
        this.fillPath = new Path();
        this.fillPath.setStroke(null);
        this.fillPath.setClip(this.fillClip);
        this.strokePath = new Path();
        this.strokePath.setFill(null);
        this.strokePath.setStroke(this.tile.getBarColor());
        this.strokePath.setClip(this.strokeClip);
        this.strokePath.setMouseTransparent(true);
        Helper.enableNode(this.fillPath, Tile.ChartType.AREA == this.tile.getChartType());
        this.dataPointGroup = new Pane();
        this.dataPointGroup.setMouseTransparent(true);
        this.dataPointsVisible = this.tile.getDataPointsVisible();
        this.valueText = new Text(String.format(this.locale, this.formatString, (this.tile.getValue() - this.minValue) / this.range * 100.0));
        this.valueText.setFill(this.tile.getValueColor());
        this.valueText.setTextOrigin(VPos.BASELINE);
        Helper.enableNode(this.valueText, this.tile.isValueVisible());
        this.upperUnitText = new Text("");
        this.upperUnitText.setFill(this.tile.getUnitColor());
        Helper.enableNode(this.upperUnitText, !this.tile.getUnit().isEmpty());
        this.fractionLine = new Line();
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setFill(this.tile.getUnitColor());
        Helper.enableNode(this.unitText, !this.tile.getUnit().isEmpty());
        this.unitFlow = new VBox(this.upperUnitText, this.unitText);
        this.unitFlow.setAlignment(Pos.CENTER_RIGHT);
        this.valueUnitFlow = new HBox(this.valueText, this.unitFlow);
        this.valueUnitFlow.setAlignment(Pos.BOTTOM_RIGHT);
        this.valueUnitFlow.setMouseTransparent(true);
        this.selector = new Circle();
        this.selectorTooltip = new Tooltip("");
        this.selectorTooltip.setWidth(60.0);
        this.selectorTooltip.setHeight(48.0);
        Tooltip.install(this.selector, this.selectorTooltip);
        FadeTransition fadeIn = new FadeTransition(Duration.millis(100.0), this.selector);
        fadeIn.setFromValue(0.0);
        fadeIn.setToValue(1.0);
        FadeTransition fadeOut = new FadeTransition(Duration.millis(100.0), this.selector);
        fadeOut.setFromValue(1.0);
        fadeOut.setToValue(0.0);
        this.fadeInFadeOut = new SequentialTransition(fadeIn, new PauseTransition(Duration.millis(3000.0)), fadeOut);
        this.handleData();
        this.getPane().getChildren().addAll((Node[])new Node[]{this.titleText, this.fillPath, this.strokePath, this.dataPointGroup, this.valueUnitFlow, this.fractionLine, this.selector});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.getChartData().forEach(chartData -> chartData.addChartDataEventListener(this.chartEventListener));
        this.tile.getChartData().addListener(this.chartDataListener);
        this.fillPath.addEventHandler(MouseEvent.MOUSE_PRESSED, this.clickHandler);
        this.fadeInFadeOut.setOnFinished(this.endOfTransformationHandler);
    }

    @Override
    public void dispose() {
        this.tile.getChartData().removeListener(this.chartDataListener);
        this.tile.getChartData().forEach(chartData -> chartData.removeChartDataEventListener(this.chartEventListener));
        this.fillPath.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.clickHandler);
        this.endOfTransformationHandler = null;
        this.fadeInFadeOut.setOnFinished(null);
        super.dispose();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (TileEvent.EventType.VISIBILITY.name().equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.valueText, this.tile.isValueVisible());
            Helper.enableNode(this.unitFlow, !this.tile.getUnit().isEmpty());
            Helper.enableNode(this.dataPointGroup, this.tile.getDataPointsVisible());
        } else if (TileEvent.EventType.SERIES.name().equals(EVENT_TYPE)) {
            Helper.enableNode(this.fillPath, Tile.ChartType.AREA == this.tile.getChartType());
        } else if (TileEvent.EventType.CLEAR_DATA.name().equals(EVENT_TYPE)) {
            Platform.runLater(() -> {
                this.tile.clearChartData();
                this.fillPath.setVisible(false);
                this.strokePath.setVisible(false);
                Helper.enableNode(this.dataPointGroup, false);
                if (this.tile.getCustomDecimalFormatEnabled()) {
                    this.valueText.setText(this.decimalFormat.format(this.minValue));
                } else {
                    this.valueText.setText(String.format(this.locale, this.formatString, this.minValue));
                }
            });
            this.handleData();
        }
    }

    private void handleData() {
        Optional lastDataEntry;
        this.selectorTooltip.hide();
        this.selector.setVisible(false);
        ObservableList<ChartData> data = this.tile.getChartData();
        if (null == data || data.isEmpty() || data.size() < 2) {
            return;
        }
        if (!this.strokePath.isVisible() && !this.fillPath.isVisible()) {
            this.fillPath.setVisible(true);
            this.strokePath.setVisible(true);
            Helper.enableNode(this.dataPointGroup, this.tile.getDataPointsVisible());
        }
        if ((lastDataEntry = data.stream().reduce((first, second) -> second)).isPresent()) {
            if (this.tile.getCustomDecimalFormatEnabled()) {
                this.valueText.setText(this.decimalFormat.format(((ChartData)lastDataEntry.get()).getValue()));
            } else {
                this.valueText.setText(String.format(this.locale, this.formatString, ((ChartData)lastDataEntry.get()).getValue()));
            }
            this.tile.setValue(((ChartData)lastDataEntry.get()).getValue());
            this.resizeDynamicText();
        }
        this.dataSize = data.size();
        this.maxValue = data.stream().max(Comparator.comparing(c -> c.getValue())).get().getValue();
        this.hStepSize = this.width / (double)(this.dataSize - 1);
        this.vStepSize = this.height * 0.5 / this.maxValue;
        this.points.clear();
        for (int i = 0; i < this.dataSize; ++i) {
            this.points.add(new Point((double)i * this.hStepSize, this.height - ((ChartData)data.get(i)).getValue() * this.vStepSize));
        }
        this.drawChart(this.points);
    }

    private void drawChart(List<Point> POINTS) {
        Point[] points;
        if (POINTS.isEmpty()) {
            return;
        }
        Point[] pointArray = points = this.smoothing ? Helper.subdividePoints(POINTS.toArray(new Point[0]), 8) : POINTS.toArray(new Point[0]);
        if (0 == points.length || null == points[0]) {
            return;
        }
        this.fillPath.getElements().clear();
        this.fillPath.getElements().add(new MoveTo(0.0, this.height));
        this.strokePath.getElements().clear();
        this.strokePath.getElements().add(new MoveTo(points[0].getX(), points[0].getY()));
        for (Point p : points) {
            this.fillPath.getElements().add(new LineTo(p.getX(), p.getY()));
            this.strokePath.getElements().add(new LineTo(p.getX(), p.getY()));
        }
        this.fillPath.getElements().add(new LineTo(this.width, this.height));
        this.fillPath.getElements().add(new LineTo(0.0, this.height));
        this.fillPath.getElements().add(new ClosePath());
        if (this.dataPointsVisible) {
            this.drawDataPoints(POINTS, this.tile.isFillWithGradient() ? this.tile.getGradientStops().get(0).getColor() : this.tile.getBarColor());
        }
    }

    private void drawDataPoints(List<Point> DATA, Color COLOR) {
        if (DATA.isEmpty()) {
            return;
        }
        double LOWER_BOUND_X = 0.0;
        double LOWER_BOUND_Y = this.minValue;
        this.dataPointGroup.getChildren().clear();
        for (Point point : DATA) {
            double x = point.getX() - 0.0;
            double y = point.getY() - LOWER_BOUND_Y;
            this.drawDataPoint(x, y, COLOR);
        }
    }

    private void drawDataPoint(double X, double Y, Color COLOR) {
        double radius = this.size * 0.02;
        Circle circle = new Circle(X, Y, radius);
        circle.setStroke(this.tile.getBackgroundColor());
        circle.setFill(COLOR);
        circle.setStrokeWidth(this.size * 0.01);
        this.dataPointGroup.getChildren().add(circle);
    }

    private void select(MouseEvent EVT) {
        double EVENT_X = EVT.getX();
        double CHART_X = 0.0;
        double CHART_WIDTH = this.width;
        if (Double.compare(EVENT_X, 0.0) < 0 || Double.compare(EVENT_X, CHART_WIDTH) > 0) {
            return;
        }
        double upperBound = this.tile.getChartData().stream().max(Comparator.comparing(ChartData::getValue)).get().getValue();
        double range = upperBound - this.minValue;
        double factor = range / (this.height * 0.5);
        ObservableList<PathElement> elements = this.strokePath.getElements();
        int noOfElements = elements.size();
        PathElement lastElement = (PathElement)elements.get(0);
        if (this.tile.isSnapToTicks()) {
            double reverseFactor = this.height * 0.5 / range;
            int noOfDataElements = this.tile.getChartData().size();
            double interval = this.width / (double)(noOfDataElements - 1);
            int selectedIndex = Helper.roundDoubleToInt(EVENT_X / interval);
            ChartData selectedData = (ChartData)this.tile.getChartData().get(selectedIndex);
            double selectedValue = selectedData.getValue();
            this.selector.setCenterX(interval * (double)selectedIndex);
            this.selector.setCenterY(this.height - selectedValue * reverseFactor);
            this.selector.setVisible(true);
            this.fadeInFadeOut.playFrom(Duration.millis(0.0));
            String tooltipText = selectedData.getName() + "\n" + String.format(this.locale, this.formatString, selectedValue);
            Point2D popupLocation = this.tile.localToScreen(this.selector.getCenterX() - this.selectorTooltip.getWidth() * 0.5, this.selector.getCenterY() - this.size * 0.025 - this.selectorTooltip.getHeight());
            this.selectorTooltip.setText(tooltipText);
            this.selectorTooltip.setX(popupLocation.getX());
            this.selectorTooltip.setY(popupLocation.getY());
            this.selectorTooltip.show(this.tile.getScene().getWindow());
            this.tile.fireTileEvent(new TileEvent(TileEvent.EventType.SELECTED_CHART_DATA, selectedData));
        } else {
            for (int i = 1; i < noOfElements; ++i) {
                PathElement element = (PathElement)elements.get(i);
                double[] xy = this.getXYFromPathElement(lastElement);
                double[] xy1 = this.getXYFromPathElement(element);
                if (EVENT_X > xy[0] && EVENT_X < xy1[0]) {
                    double deltaX = xy1[0] - xy[0];
                    double deltaY = xy1[1] - xy[1];
                    double m3 = deltaY / deltaX;
                    double y = m3 * (EVT.getX() - xy[0]) + xy[1];
                    double selectedValue = upperBound - (y - this.height * 0.5) * factor;
                    this.selector.setCenterX(EVT.getX());
                    this.selector.setCenterY(y);
                    this.selector.setVisible(true);
                    this.fadeInFadeOut.playFrom(Duration.millis(0.0));
                    Point2D popupLocation = this.tile.localToScreen(EVT.getX() - this.selectorTooltip.getWidth() * 0.5, this.selector.getCenterY() - this.size * 0.025 - this.selectorTooltip.getHeight());
                    this.selectorTooltip.setText(String.format(this.locale, this.formatString, selectedValue));
                    this.selectorTooltip.setX(popupLocation.getX());
                    this.selectorTooltip.setY(popupLocation.getY());
                    this.selectorTooltip.show(this.tile.getScene().getWindow());
                    this.tile.fireTileEvent(new TileEvent(TileEvent.EventType.SELECTED_CHART_DATA, new ChartData(selectedValue)));
                    break;
                }
                lastElement = element;
            }
        }
    }

    private double[] getXYFromPathElement(PathElement ELEMENT) {
        if (ELEMENT instanceof MoveTo) {
            return new double[]{((MoveTo)ELEMENT).getX(), ((MoveTo)ELEMENT).getY()};
        }
        return new double[]{((LineTo)ELEMENT).getX(), ((LineTo)ELEMENT).getY()};
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.unitText.isVisible() ? this.width - this.size * 0.275 : this.width - this.size * 0.1;
        double fontSize = this.size * 0.24;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        maxWidth = this.width - (this.width - this.size * 0.275);
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.12 : this.size * 0.1;
        this.upperUnitText.setFont(Fonts.latoRegular(fontSize));
        if (this.upperUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.upperUnitText, maxWidth, fontSize);
        }
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.12 : this.size * 0.1;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
    }

    @Override
    protected void resize() {
        super.resize();
        this.valueUnitFlow.setPrefWidth(this.width - this.size * 0.1);
        this.valueUnitFlow.relocate(this.size * 0.05, this.contentBounds.getY());
        this.valueUnitFlow.setMaxHeight(this.valueText.getFont().getSize());
        this.fractionLine.setStartX(this.width - 0.17 * this.size);
        this.fractionLine.setStartY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
        this.fractionLine.setEndX(this.width - 0.05 * this.size);
        this.fractionLine.setEndY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
        this.fractionLine.setStroke(this.tile.getUnitColor());
        this.fractionLine.setStrokeWidth(this.size * 0.005);
        this.unitFlow.setTranslateY(-this.size * 0.005);
        this.hStepSize = this.width / (double)this.dataSize;
        this.vStepSize = this.height * 0.5 / this.maxValue;
        this.selector.setRadius(this.size * 0.02);
        this.selector.setStrokeWidth(this.size * 0.01);
        this.handleData();
        this.strokePath.setStrokeWidth(this.size * 0.02);
        this.dataPointGroup.setPrefSize(this.width, this.height);
        double cornerRadius = this.tile.getRoundedCorners() ? this.size * 0.05 : 0.0;
        this.fillClip.setX(0.0);
        this.fillClip.setY(0.0);
        this.fillClip.setWidth(this.tile.getWidth());
        this.fillClip.setHeight(this.tile.getHeight());
        this.fillClip.setArcWidth(cornerRadius);
        this.fillClip.setArcHeight(cornerRadius);
        this.strokeClip.setX(0.0);
        this.strokeClip.setY(0.0);
        this.strokeClip.setWidth(this.tile.getWidth());
        this.strokeClip.setHeight(this.tile.getHeight());
        this.strokeClip.setArcWidth(cornerRadius);
        this.strokeClip.setArcHeight(cornerRadius);
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.smoothing = this.tile.isSmoothing();
        this.titleText.setText(this.tile.getTitle());
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(this.tile.getCurrentValue()));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, this.tile.getCurrentValue()));
        }
        if (this.tile.getUnit().contains("/")) {
            String[] units = this.tile.getUnit().split("/");
            this.upperUnitText.setText(units[0]);
            this.unitText.setText(units[1]);
            Helper.enableNode(this.fractionLine, true);
        } else {
            this.upperUnitText.setText(" ");
            this.unitText.setText(this.tile.getUnit());
            Helper.enableNode(this.fractionLine, false);
        }
        this.resizeDynamicText();
        this.resizeStaticText();
        this.titleText.setFill(this.tile.getTitleColor());
        this.valueText.setFill(this.tile.getValueColor());
        this.upperUnitText.setFill(this.tile.getUnitColor());
        this.fractionLine.setStroke(this.tile.getUnitColor());
        this.unitText.setFill(this.tile.getUnitColor());
        this.selector.setStroke(this.tile.getForegroundColor());
        this.selector.setFill(this.tile.getBackgroundColor());
        Color fillPathColor1 = Helper.getColorWithOpacity(this.tile.getBarColor(), 0.7);
        Color fillPathColor2 = Helper.getColorWithOpacity(this.tile.getBarColor(), 0.1);
        if (this.tile.isFillWithGradient() && !this.tile.getGradientStops().isEmpty()) {
            this.fillPath.setFill(new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, this.tile.getGradientStops()));
            this.strokePath.setStroke(this.tile.getGradientStops().get(0).getColor());
            if (this.dataPointsVisible) {
                this.drawDataPoints(this.points, this.tile.getGradientStops().get(0).getColor());
            }
        } else {
            this.fillPath.setFill(new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop(0.0, fillPathColor1), new Stop(1.0, fillPathColor2)));
            this.strokePath.setStroke(this.tile.getBarColor());
            if (this.dataPointsVisible) {
                this.drawDataPoints(this.points, this.tile.getBarColor());
            }
        }
        this.drawChart(this.points);
    }
}

