# Change Log
All notable changes to this project will be documented in this file.
This project adheres to [Semantic Versioning](http://semver.org/).

## [Unreleased]

## [0.9.6] - 2016-05-03

### Fixed
- Fix issue where if no terms have images but 'having_images' is false, nothing would be returned (props Matt).

## [0.9.5] - 2016-04-09

### Fixed
- Fix loading of admin stylesheet when editing terms in WordPress 4.5

## [0.9.4] - 2016-02-05

### Fixed
- Fix for taxonomy names that may contain characters other than lowercase and underscores (e.g. uppercase).

## [0.9.3] - 2016-01-21

### Fixed
- Fix post permissions error when using media modal.

## [0.9.2] - 2015-12-15

### Added
- Added CHANGELOG.md

### Changed
- Documentation: Pedantic corrections. Props [Gary Jones](https://profiles.wordpress.org/garyj)

### Fixed
- Fix old and new media modal opening simultaneously in some circumstances.

## [0.9.1] - 2015-11-17

### Changed
- Adhere to WordPress PHP coding standards.

### Fixed
- Fixes media modal not opening on newly created terms.

## [0.9] - 2015-11-10

### Added
- Added screenshots for WordPress.org
- Add Spanish translation.
- Add husobj as a contributor.

### Changed
- Make images retina sized in the admin.
- Re-color admin image and icons to fit with more recent versions of WordPress.
- Stop using deprecated `image_resize()` function.
- Stop using deprecated `screen_icon()` function.
- Move JavaScript and CSS files to subfolders.
- Confirmed minimum WordPress 3.4 required.

### Fixed
- Add support for WordPress 3.5+ media modal.

## [0.8.0] - 2013-08-06

### Added
- Add jamiemchale as a contributor.

### Changed
- Use `jQuery.on()` instead of `jQuery.live()`. Props [jamiemchale](https://profiles.wordpress.org/jamiemchale).
- Pass an empty array as default second parameter of `taxonomy_images_plugin_get_the_terms()` and `taxonomy_images_plugin_list_the_terms()`.
- Give the button on the custom admin screen a class of `button-primary`.
- Store the return value of `get_posts()` in a variable called `$images`. Not sure why, but this should not harm anything.
- Change license to `GPLv2 or later` for maximum flexibility and compatibility.
- Random whitespace fixes.
- Update Documentation.
- CSS coding standards.
- Bump version number.
- Update readme files.

## [0.7.3] - 2011-06-20

### Added
- Introduced `.pot` file and languages directory.

### Changed
- Better escaping.

### Fixed
- Fixed the delete image button on edit-terms.php.

## [0.7.2] - 2011-06-20

### Changed
- Return data for fullsize images in archive views. [See this thread](https://wordpress.org/support/topic/image-size-full).

## [0.7.1] - 2011-06-01

### Removed
- Remove unused link code which is throwing an error when no taxonomies support images.

## [0.7] - 2011-05-31

### Added
- Created a custom filter interface for plugin and theme integration.
- Lots of inline documentation added.
- Added custom notices if plugin is used in an unsupported way.
- Taxonomy modal button now available in search + upload states.
- Image interface has been added to single term edit screen.
- Users can now choose which taxonomys have image support.

### Changed
- All strings are now internationalized.
- Add image to term functionality mimics "Add Featured Image".
- All functions are now private.

### Deprecated
- Shortcode deprecated.
- All global variables and constants have been removed or deprecated.

### Removed
- Deprecated function calls removed.

### Fixed
- No longer breaks display of the [Better Plugin Compatibility Control](https://wordpress.org/plugins/better-plugin-compatibility-control/) plugin.
- No notices generated by PHP or WordPress.

### Security
- Security updates.

## 0.6 - Unreleased

### Changed
-  Completely recoded.

## [0.5] - 2010-11-05

### Added
- Direct link to upload new files from `edit-tag.php` has been introduced.
- Ability to create an image/term association immediately after upload has been introduced.
- Users can now delete image/term associations.

### Changed
- Created standalone javascript files - removed inline scripts.
- Obsessive compulsive syntax modifications.
- Localization for strings - still need to "fine-tooth-comb" this.

### Removed
- Removed all debug functions.

## 0.4.4 - Unreleased

### Fixed
- `get_image_html()` Now populates the image's `alt` attribute with appropriate data. Props to [jaygoldman](https://wordpress.org/support/profile/jaygoldman).

## 0.4.3 - Unreleased

### Added
- Support for WordPress 3.0 has been added.

### Changed
- Removed use of deprecated function `is_taxonomy()` - props to [anointed](https://profiles.wordpress.org/users/anointed).
- Included a definition for `taxonomy_exists()` function for backwards compatibility with 2.9 branch. This function is new in WordPress version 3.0.

### Removed
- Support for all beta versions of 3.0 has been dropped.

## 0.4.2 - Unreleased

### Added
- Support for 2.9 branch has been added again.

### Changed
- Changed button name from "Category" to "Taxonomy".

## 0.4.1 - Unreleased

### Added
- Added support for dynamic taxonomy hooks for `_tag_row()`.

### Removed
- Support for 2.9 branch has been temporarily removed.

## 0.4 - Unreleased

### Added
- Added "taxonomy_images_shortcode".

### Fixed
- `get_thumb()` now returns the fullsize URL if there is no appropriate intermediate image.

## 0.3 - Unreleased

### Added
- Added Version check for PHP5.
- Added argument `$term_tax_id` to both `print_image_html()` and `get_image_html()`.

### Changed
- Changed the firing order of every hook utilizing the `category_rows` method to 15. This allows this plugin to be compatible with [Reveal IDs for WP Admin](https://wordpress.org/plugins/reveal-ids-for-wp-admin-25/). Thanks to [Peter Kahoun](https://profiles.wordpress.org/kahi/)
- `$settings` and `$locale` are now public properties.
- Object name changed to `$taxonomy_images_plugin`.

### Removed
- Deleted the `register_deactivation_hook()` function - sorry to all 8 who downloaded this plugin so far :)

## 0.2 - Unreleased

### Added
- Original Release - Works with WordPress 2.9.1.

[Unreleased]: https://github.com/benhuson/Taxonomy-Images/compare/0.9.6...HEAD
[0.9.6]: https://github.com/benhuson/Taxonomy-Images/compare/0.9.5...0.9.6
[0.9.5]: https://github.com/benhuson/Taxonomy-Images/compare/0.9.4...0.9.5
[0.9.4]: https://github.com/benhuson/Taxonomy-Images/compare/0.9.3...0.9.4
[0.9.3]: https://github.com/benhuson/Taxonomy-Images/compare/0.9.2...0.9.3
[0.9.2]: https://github.com/benhuson/Taxonomy-Images/compare/0.9.1...0.9.2
[0.9.1]: https://github.com/benhuson/Taxonomy-Images/compare/0.9...0.9.1
[0.9]: https://github.com/benhuson/Taxonomy-Images/compare/0.8.0...0.9
[0.8.0]: https://github.com/benhuson/Taxonomy-Images/compare/0.7.3...0.8.0
[0.7.3]: https://github.com/benhuson/Taxonomy-Images/compare/0.7.2...0.7.3
[0.7.2]: https://github.com/benhuson/Taxonomy-Images/compare/0.7.1...0.7.2
[0.7.1]: https://github.com/benhuson/Taxonomy-Images/compare/0.7...0.7.1
[0.7]: https://github.com/benhuson/Taxonomy-Images/compare/v0.5...0.7
[0.5]: https://github.com/benhuson/Taxonomy-Images/tree/v0.5
