/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.browse;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XIntrospectionAccess;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.helper.PropertySet;
import com.sun.star.reflection.InvocationTargetException;
import com.sun.star.script.CannotConvertException;
import com.sun.star.script.XInvocation;
import com.sun.star.script.browse.XBrowseNode;
import com.sun.star.script.framework.browse.DialogFactory;
import com.sun.star.script.framework.browse.ScriptBrowseNode;
import com.sun.star.script.framework.container.Parcel;
import com.sun.star.script.framework.container.ParcelContainer;
import com.sun.star.script.framework.container.ScriptEntry;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.ScriptProvider;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JOptionPane;

public class ParcelBrowseNode
extends PropertySet
implements XBrowseNode,
XInvocation {
    private final ScriptProvider provider;
    private Collection<XBrowseNode> browsenodes;
    private final ParcelContainer container;
    private Parcel parcel;
    public boolean deletable = true;
    public boolean editable = false;
    public boolean creatable = false;
    public boolean renamable = true;

    public ParcelBrowseNode(ScriptProvider provider, ParcelContainer container, String parcelName) throws NoSuchElementException, WrappedTargetException {
        this.provider = provider;
        this.container = container;
        this.parcel = (Parcel)this.container.getByName(parcelName);
        this.registerProperty("Deletable", new Type(Boolean.TYPE), (short)0, "deletable");
        this.registerProperty("Editable", new Type(Boolean.TYPE), (short)0, "editable");
        this.registerProperty("Creatable", new Type(Boolean.TYPE), (short)0, "creatable");
        this.registerProperty("Renamable", new Type(Boolean.TYPE), (short)0, "renamable");
        if (provider.hasScriptEditor()) {
            this.creatable = true;
        }
        String parcelDirUrl = this.parcel.getPathToParcel();
        XComponentContext xCtx = provider.getScriptingContext().getComponentContext();
        XMultiComponentFactory xFac = xCtx.getServiceManager();
        try {
            XSimpleFileAccess xSFA = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xFac.createInstanceWithContext("com.sun.star.ucb.SimpleFileAccess", xCtx));
            if (xSFA != null && (xSFA.isReadOnly(parcelDirUrl) || container.isUnoPkg())) {
                this.deletable = false;
                this.editable = false;
                this.creatable = false;
                this.renamable = false;
            }
        }
        catch (com.sun.star.uno.Exception e) {
            LogUtils.DEBUG("Caught exception creating ParcelBrowseNode " + (Object)((Object)e));
            LogUtils.DEBUG(LogUtils.getTrace((Exception)((Object)e)));
        }
    }

    public String getName() {
        return this.parcel.getName();
    }

    public XBrowseNode[] getChildNodes() {
        block4: {
            try {
                if (this.hasChildNodes()) {
                    String[] names = this.parcel.getElementNames();
                    this.browsenodes = new ArrayList<XBrowseNode>(names.length);
                    for (String name : names) {
                        this.browsenodes.add(new ScriptBrowseNode(this.provider, this.parcel, name));
                    }
                    break block4;
                }
                LogUtils.DEBUG("ParcelBrowseNode.getChildeNodes no children ");
                return new XBrowseNode[0];
            }
            catch (Exception e) {
                LogUtils.DEBUG("Failed to getChildeNodes, exception: " + e);
                LogUtils.DEBUG(LogUtils.getTrace(e));
                return new XBrowseNode[0];
            }
        }
        return this.browsenodes.toArray(new XBrowseNode[this.browsenodes.size()]);
    }

    public boolean hasChildNodes() {
        if (this.container != null && this.parcel != null && this.container.hasByName(this.getName())) {
            return this.parcel.hasElements();
        }
        return false;
    }

    public short getType() {
        return 1;
    }

    public String toString() {
        return this.getName();
    }

    public XIntrospectionAccess getIntrospection() {
        return null;
    }

    public Object invoke(String aFunctionName, Object[] aParams, short[][] aOutParamIndex, Object[][] aOutParam) throws IllegalArgumentException, CannotConvertException, InvocationTargetException {
        Any result;
        block25: {
            LogUtils.DEBUG("ParcelBrowseNode invoke for " + aFunctionName);
            aOutParamIndex[0] = new short[0];
            aOutParam[0] = new Object[0];
            result = new Any(new Type(Boolean.class), (Object)Boolean.TRUE);
            if (aFunctionName.equals("Creatable")) {
                try {
                    String newName;
                    if (aParams == null || aParams.length < 1 || !AnyConverter.isString((Object)aParams[0])) {
                        String prompt = "Enter name for new Script";
                        String title = "Create Script";
                        try {
                            DialogFactory dialogFactory = DialogFactory.getDialogFactory();
                            newName = dialogFactory.showInputDialog(title, prompt);
                        }
                        catch (Exception e) {
                            newName = JOptionPane.showInputDialog(null, prompt, title, 3);
                        }
                    } else {
                        newName = AnyConverter.toString((Object)aParams[0]);
                    }
                    if (newName == null || newName.length() == 0) {
                        result = new Any(new Type(Boolean.class), (Object)Boolean.FALSE);
                        break block25;
                    }
                    String source = this.provider.getScriptEditor().getTemplate();
                    String languageName = newName + "." + this.provider.getScriptEditor().getExtension();
                    String language = this.container.getLanguage();
                    ScriptEntry entry = new ScriptEntry(language, languageName);
                    Parcel parcel = (Parcel)this.container.getByName(this.getName());
                    ScriptMetaData data = new ScriptMetaData(parcel, entry, source);
                    parcel.insertByName(languageName, data);
                    ScriptBrowseNode sbn = new ScriptBrowseNode(this.provider, parcel, languageName);
                    if (this.browsenodes == null) {
                        LogUtils.DEBUG("browsenodes null!!");
                        this.browsenodes = new ArrayList<XBrowseNode>(4);
                    }
                    this.browsenodes.add(sbn);
                    result = new Any(new Type(XBrowseNode.class), (Object)sbn);
                }
                catch (Exception e) {
                    LogUtils.DEBUG("ParcelBrowseNode[create] failed with: " + e);
                    LogUtils.DEBUG(LogUtils.getTrace(e));
                    result = new Any(new Type(Boolean.class), (Object)Boolean.FALSE);
                }
            } else if (aFunctionName.equals("Deletable")) {
                try {
                    if (this.container.deleteParcel(this.getName())) {
                        result = new Any(new Type(Boolean.class), (Object)Boolean.TRUE);
                        break block25;
                    }
                    result = new Any(new Type(Boolean.class), (Object)Boolean.FALSE);
                }
                catch (Exception e) {
                    result = new Any(new Type(Boolean.class), (Object)Boolean.FALSE);
                }
            } else if (aFunctionName.equals("Renamable")) {
                String newName = null;
                try {
                    if (aParams == null || aParams.length < 1 || !AnyConverter.isString((Object)aParams[0])) {
                        String prompt = "Enter new name for Library";
                        String title = "Rename Library";
                        try {
                            DialogFactory dialogFactory = DialogFactory.getDialogFactory();
                            newName = dialogFactory.showInputDialog(title, prompt);
                        }
                        catch (Exception e) {
                            newName = JOptionPane.showInputDialog(null, prompt, title, 3);
                        }
                    } else {
                        newName = AnyConverter.toString((Object)aParams[0]);
                    }
                    this.container.renameParcel(this.getName(), newName);
                    Parcel p = (Parcel)this.container.getByName(newName);
                    if (this.browsenodes == null) {
                        this.getChildNodes();
                    }
                    ScriptBrowseNode[] childNodes = this.browsenodes.toArray(new ScriptBrowseNode[this.browsenodes.size()]);
                    for (int index = 0; index < childNodes.length; ++index) {
                        childNodes[index].updateURI(p);
                    }
                    result = new Any(new Type(XBrowseNode.class), (Object)this);
                }
                catch (Exception e) {
                    result = new Any(new Type(Boolean.class), (Object)Boolean.FALSE);
                }
            } else {
                throw new IllegalArgumentException("Function " + aFunctionName + " not supported.");
            }
        }
        return result;
    }

    public void setValue(String aPropertyName, Object aValue) throws UnknownPropertyException, CannotConvertException, InvocationTargetException {
    }

    public Object getValue(String aPropertyName) throws UnknownPropertyException {
        return null;
    }

    public boolean hasMethod(String aName) {
        return false;
    }

    public boolean hasProperty(String aName) {
        return false;
    }
}

