/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.ActiveChar;
import com.dickimawbooks.texparserlib.AssignedMacro;
import com.dickimawbooks.texparserlib.BgChar;
import com.dickimawbooks.texparserlib.CatCodeChanger;
import com.dickimawbooks.texparserlib.CatCodeList;
import com.dickimawbooks.texparserlib.Comment;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.CountRegister;
import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.DimenRegister;
import com.dickimawbooks.texparserlib.EgChar;
import com.dickimawbooks.texparserlib.EndDeclaration;
import com.dickimawbooks.texparserlib.Eol;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.Par;
import com.dickimawbooks.texparserlib.ParameterToken;
import com.dickimawbooks.texparserlib.Register;
import com.dickimawbooks.texparserlib.SkippedEols;
import com.dickimawbooks.texparserlib.SkippedSpaces;
import com.dickimawbooks.texparserlib.Space;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXReader;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TokenRegister;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.WhiteSpace;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Pattern;

public class TeXParser
extends TeXObjectList {
    private TeXSettings settings;
    private Hashtable<Integer, CountRegister> countAlloc = new Hashtable();
    private Hashtable<Integer, DimenRegister> dimenAlloc = new Hashtable();
    private Hashtable<Integer, TokenRegister> toksAlloc = new Hashtable();
    public static final Integer ALLOC_COUNT = 10;
    public static final Integer ALLOC_DIMEN = 11;
    public static final Integer ALLOC_SKIP = 12;
    public static final Integer ALLOC_MUSKIP = 13;
    public static final Integer ALLOC_BOX = 14;
    public static final Integer ALLOC_TOKS = 15;
    public static final Integer ALLOC_INPUT = 16;
    public static final Integer ALLOC_OUTPUT = 17;
    public static final Integer ALLOC_MATHFAM = 18;
    public static final Integer ALLOC_LANGUAGE = 19;
    public static final Integer INS_COUNT = 20;
    public static final Integer ALLOC_NUMBER = 21;
    public static final Integer MINUS_ONE = 22;
    protected Hashtable<String, ControlSequence> csTable;
    protected Hashtable<Integer, ActiveChar> activeTable;
    private Writer writer;
    private TeXReader reader;
    private TeXParserListener listener;
    public static final int TYPE_ESC = 0;
    public static final int TYPE_BG = 1;
    public static final int TYPE_EG = 2;
    public static final int TYPE_MATH = 3;
    public static final int TYPE_TAB = 4;
    public static final int TYPE_EOL = 5;
    public static final int TYPE_PARAM = 6;
    public static final int TYPE_SP = 7;
    public static final int TYPE_SB = 8;
    public static final int TYPE_IGNORE = 9;
    public static final int TYPE_SPACE = 10;
    public static final int TYPE_LETTER = 11;
    public static final int TYPE_OTHER = 12;
    public static final int TYPE_ACTIVE = 13;
    public static final int TYPE_COMMENT = 14;
    public static final int TYPE_INVALID = 15;
    private CatCodeList[] catcodes;
    private Vector<String> verbatim;
    private String jobname = null;
    public static final String VERSION = "0.9.2.4b";
    public static final String VERSION_DATE = "2020-05-30";

    public TeXParser(TeXParserListener teXParserListener) {
        this.listener = teXParserListener;
        this.reader = null;
        this.activeTable = new Hashtable();
        this.csTable = new Hashtable();
        this.settings = new TeXSettings(this);
        this.verbatim = new Vector();
        this.verbatim.add("verb");
        this.initDefCatCodes();
        this.initRegisters();
        teXParserListener.setParser(this);
    }

    private TeXParser() {
    }

    @Override
    public TeXObjectList createList() {
        return new TeXParser(this.listener);
    }

    private void initRegisters() {
        CountRegister countRegister = new CountRegister("count@");
        this.allocCount(255, countRegister);
        DimenRegister dimenRegister = new DimenRegister("dimen@");
        this.allocDimen(0, dimenRegister);
        dimenRegister = new DimenRegister("dimen@i");
        this.allocDimen(1, dimenRegister);
        dimenRegister = new DimenRegister("dimen@ii");
        this.allocDimen(2, dimenRegister);
        for (int i = 0; i < 10; ++i) {
            countRegister = new CountRegister("count" + i);
            this.settings.putRegister(countRegister);
            this.allocCount(ALLOC_COUNT, countRegister);
        }
        countRegister = new CountRegister("count" + ALLOC_COUNT, 22);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_COUNT, countRegister);
        countRegister = new CountRegister("count" + ALLOC_DIMEN, 9);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_DIMEN, countRegister);
        countRegister = new CountRegister("count" + ALLOC_SKIP, 9);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_SKIP, countRegister);
        countRegister = new CountRegister("count" + ALLOC_MUSKIP, 9);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_MUSKIP, countRegister);
        countRegister = new CountRegister("count" + ALLOC_BOX, 9);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_BOX, countRegister);
        countRegister = new CountRegister("count" + ALLOC_TOKS, 9);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_TOKS, countRegister);
        countRegister = new CountRegister("count" + ALLOC_INPUT, -1);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_INPUT, countRegister);
        countRegister = new CountRegister("count" + ALLOC_OUTPUT, -1);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_OUTPUT, countRegister);
        countRegister = new CountRegister("count" + ALLOC_MATHFAM, 3);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_MATHFAM, countRegister);
        countRegister = new CountRegister("count" + ALLOC_LANGUAGE, 0);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_LANGUAGE, countRegister);
        countRegister = new CountRegister("insc@unt", 255);
        this.settings.putRegister(countRegister);
        this.allocCount(INS_COUNT, countRegister);
        countRegister = new CountRegister("allocationnumber");
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_NUMBER, countRegister);
        countRegister = new CountRegister("m@ne", -1);
        this.settings.putRegister(countRegister);
        this.allocCount(MINUS_ONE, countRegister);
    }

    private void initDefCatCodes() {
        int n;
        this.catcodes = new CatCodeList[16];
        for (n = 0; n < this.catcodes.length; ++n) {
            this.catcodes[n] = n == 12 ? null : new CatCodeList();
        }
        this.catcodes[0].add('\\');
        this.catcodes[1].add('{');
        this.catcodes[2].add('}');
        this.catcodes[3].add('$');
        this.catcodes[4].add('&');
        this.catcodes[5].add('\n');
        this.catcodes[5].add('\r');
        this.catcodes[6].add('#');
        this.catcodes[7].add('^');
        this.catcodes[8].add('_');
        this.catcodes[10].add(' ');
        this.catcodes[10].add('\t');
        for (n = 65; n <= 90; ++n) {
            this.catcodes[11].add(n);
        }
        for (n = 97; n <= 122; ++n) {
            this.catcodes[11].add(n);
        }
        this.catcodes[13].add('~');
        this.catcodes[14].add('%');
    }

    public boolean isActive(int n) {
        ActiveChar activeChar = this.getActiveChar(n);
        return activeChar != null;
    }

    public boolean isCatCode(int n, int n2) {
        if (n == 13 && this.isActive(n2)) {
            return true;
        }
        int n3 = this.getCatCode(n2);
        return n == n3;
    }

    public void setCatCode(boolean bl, int n, int n2) {
        if (bl) {
            this.settings.setCatCode(n, n2);
        } else {
            this.setCatCode(n, n2);
        }
    }

    public void setCatCode(int n, int n2) {
        Integer n3 = n;
        for (int i = 0; !(i >= this.catcodes.length || this.catcodes[i] != null && this.catcodes[i].remove(n3)); ++i) {
        }
        if (this.catcodes[n2] != null) {
            this.catcodes[n2].add(n3);
        }
    }

    public int getRootCatCode(int n) {
        Integer n2 = n;
        for (int i = 0; i < this.catcodes.length; ++i) {
            if (this.catcodes[i] == null || !this.catcodes[i].contains(n2)) continue;
            return i;
        }
        return 12;
    }

    public int getCatCode(int n) {
        return this.settings.getCatCode(n);
    }

    public int getLineNumber() {
        return this.reader == null ? -1 : this.reader.getLineNumber() + 1;
    }

    public boolean isLetter(int n) {
        return this.isCatCode(11, n) || Character.isAlphabetic(n) && this.isCatCode(12, n);
    }

    private int read() throws IOException {
        int n = this.reader.read();
        if (n == -1) {
            TeXReader teXReader = this.reader.getParent();
            if (teXReader == null) {
                return -1;
            }
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                this.listener.getTeXApp().error(iOException);
            }
            this.reader = teXReader;
            TeXObjectList teXObjectList = this.reader.getPending();
            if (teXObjectList != null) {
                while (teXObjectList.size() > 0) {
                    this.add((TeXObject)teXObjectList.remove(0));
                }
                this.reader.setPending(null);
            }
            return this.read();
        }
        return n;
    }

    private void mark(int n) throws IOException {
        this.reader.mark(n);
    }

    private void reset() throws IOException {
        this.reader.reset();
    }

    public void scan(String string, TeXObjectList teXObjectList) throws IOException {
        TeXReader teXReader;
        this.reader = teXReader = new TeXReader(this.reader, string);
        while (this.reader == teXReader && this.fetchNext(teXObjectList)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TeXObjectList readLine(TeXReader teXReader, boolean bl) throws IOException {
        if (teXReader.isEnded()) {
            return null;
        }
        TeXReader teXReader2 = this.reader;
        TeXReader teXReader3 = teXReader.getParent();
        TeXObjectList teXObjectList = new TeXObjectList();
        TeXObjectList teXObjectList2 = null;
        try {
            if (this.size() > 0) {
                teXObjectList2 = new TeXObjectList();
                teXObjectList2.addAll(this);
                this.clear();
            }
            teXReader.setParent(this.reader);
            this.reader = teXReader;
            TeXObject teXObject = this.pop();
            while (!(teXObject instanceof Eol) && teXObject != null && !teXReader.isEnded()) {
                teXObjectList.add(teXObject);
                teXObject = this.pop();
            }
            if (bl && teXObject instanceof Eol) {
                teXObjectList.add(teXObject);
            }
            if (teXObjectList.size() > 0 && teXObjectList.lastElement() instanceof Par) {
                teXObjectList.remove(teXObjectList.size() - 1);
            }
        }
        catch (EOFException eOFException) {
            if (teXObjectList.size() == 0) {
                TeXObjectList teXObjectList3 = null;
                return teXObjectList3;
            }
        }
        finally {
            this.reader = teXReader2;
            teXReader.setParent(teXReader3);
            if (teXObjectList2 != null) {
                this.addAll(0, teXObjectList2);
            }
        }
        return teXObjectList;
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return this.string();
    }

    public TeXObjectList string() throws IOException {
        String string;
        if (this.size() == 0) {
            int n = this.read();
            while (this.isCatCode(10, n)) {
                n = this.read();
            }
            if (this.isCatCode(5, n)) {
                this.parseEOL(n, this);
                string = this.pop().toString(this);
            } else if (this.isCatCode(0, n)) {
                this.readControlSequence(this, true);
                string = this.pop().toString(this);
            } else {
                string = "" + n;
            }
        } else {
            return this.pop().string(this);
        }
        return this.string(string);
    }

    public TeXObjectList string(String string) {
        int n;
        TeXObjectList teXObjectList = new TeXObjectList();
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            teXObjectList.add(this.isLetter(n) ? this.listener.getLetter(n) : this.listener.getOther(n));
        }
        return teXObjectList;
    }

    public void addVerbCommand(String string) {
        this.verbatim.add(string);
    }

    public boolean isVerbCommand(String string) {
        return this.verbatim.contains(string);
    }

    private boolean parseEOL(int n, TeXObjectList teXObjectList) throws IOException {
        return this.parseEOL(n, teXObjectList, false);
    }

    private boolean parseEOL(int n, TeXObjectList teXObjectList, boolean bl) throws IOException {
        boolean bl2 = true;
        if (n == 10) {
            this.mark(1);
            n = this.read();
            if (n == 10) {
                bl2 = this.skipNextEols(teXObjectList);
                this.parFound(teXObjectList);
            } else if (n == 13) {
                this.mark(1);
                n = this.read();
                if (this.isCatCode(5, n)) {
                    bl2 = this.skipNextEols(teXObjectList);
                    this.parFound(teXObjectList);
                } else {
                    this.reset();
                    this.eolFound(teXObjectList, bl);
                }
            } else if (this.isCatCode(5, n)) {
                bl2 = this.skipNextEols(teXObjectList);
                this.parFound(teXObjectList);
            } else {
                try {
                    this.reset();
                }
                catch (IOException iOException) {
                    throw new EOFException();
                }
                this.eolFound(teXObjectList, bl);
            }
        } else if (n == 13) {
            this.mark(1);
            n = this.read();
            if (n == 13) {
                bl2 = this.skipNextEols(teXObjectList);
                this.parFound(teXObjectList);
            } else if (n == 10) {
                this.mark(1);
                n = this.read();
                if (this.isCatCode(5, n)) {
                    bl2 = this.skipNextEols(teXObjectList);
                    this.parFound(teXObjectList);
                } else {
                    this.reset();
                    this.eolFound(teXObjectList, bl);
                }
            } else if (this.isCatCode(5, n)) {
                bl2 = this.skipNextEols(teXObjectList);
                this.parFound(teXObjectList);
            } else {
                this.reset();
                this.eolFound(teXObjectList, bl);
            }
        } else {
            this.mark(1);
            n = this.read();
            if (this.isCatCode(5, n)) {
                bl2 = this.skipNextEols(teXObjectList);
                this.parFound(teXObjectList);
            } else {
                this.reset();
                this.eolFound(teXObjectList, bl);
            }
        }
        if (!bl2) {
            return bl2;
        }
        return this.skipNextSpaces(teXObjectList);
    }

    private boolean skipNextEols(TeXObjectList teXObjectList) throws IOException {
        int n = -1;
        this.mark(1);
        SkippedEols skippedEols = null;
        while ((n = this.read()) != -1) {
            if (!this.isCatCode(5, n)) {
                this.reset();
                break;
            }
            if (skippedEols == null) {
                skippedEols = this.listener.createSkippedEols();
            }
            Eol eol = this.listener.getEol();
            eol.setEol(new String(Character.toChars(n)));
            skippedEols.add(eol);
            this.mark(1);
        }
        if (skippedEols != null) {
            teXObjectList.add(skippedEols);
        }
        return n != -1;
    }

    private boolean skipNextSpaces(TeXObjectList teXObjectList) throws IOException {
        int n = -1;
        this.mark(1);
        SkippedSpaces skippedSpaces = null;
        while ((n = this.read()) != -1) {
            if (!this.isCatCode(10, n)) {
                this.reset();
                break;
            }
            if (skippedSpaces == null) {
                skippedSpaces = this.listener.createSkippedSpaces();
            }
            Space space = this.listener.getSpace();
            space.setSpace(n);
            skippedSpaces.add(space);
            this.mark(1);
        }
        if (n == -1) {
            this.reset();
        }
        if (skippedSpaces != null) {
            teXObjectList.add(skippedSpaces);
        }
        return n != -1;
    }

    private void eolFound(TeXObjectList teXObjectList, boolean bl) throws IOException {
        if (bl) {
            SkippedEols skippedEols = this.listener.createSkippedEols();
            skippedEols.add(this.listener.getEol());
            teXObjectList.add(skippedEols);
        } else {
            teXObjectList.add(this.listener.getEol());
        }
    }

    private void parFound(TeXObjectList teXObjectList) throws IOException {
        teXObjectList.add(this.listener.getPar());
    }

    public static boolean isPar(TeXObject teXObject) {
        return teXObject != null && teXObject.isPar();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean readComment(TeXObjectList teXObjectList) throws IOException {
        Comment comment = this.listener.createComment();
        int n = -1;
        while ((n = this.read()) != -1) {
            if (this.isCatCode(5, n)) {
                if (n == 10) {
                    this.mark(1);
                    n = this.read();
                    if (n == 13) {
                        this.mark(1);
                        n = this.read();
                        if (this.isCatCode(5, n)) {
                            teXObjectList.add(comment);
                            teXObjectList.add(this.listener.getPar());
                            return this.skipNextEols(teXObjectList);
                        }
                        teXObjectList.add(comment);
                        return true;
                    }
                    if (n == 10) {
                        teXObjectList.add(comment);
                        teXObjectList.add(this.listener.getPar());
                        return this.skipNextEols(teXObjectList);
                    }
                    if (this.isCatCode(5, n)) {
                        teXObjectList.add(comment);
                        teXObjectList.add(this.listener.getPar());
                        return this.skipNextEols(teXObjectList);
                    }
                    if (n == -1) {
                        teXObjectList.add(comment);
                        return false;
                    }
                    teXObjectList.add(comment);
                    this.reset();
                    return this.skipNextSpaces(teXObjectList);
                }
                if (n == 13) {
                    this.mark(1);
                    n = this.read();
                    if (n == 10) {
                        this.mark(1);
                        n = this.read();
                        if (this.isCatCode(5, n)) {
                            teXObjectList.add(comment);
                            teXObjectList.add(this.listener.getPar());
                            return this.skipNextEols(teXObjectList);
                        }
                        teXObjectList.add(comment);
                        return true;
                    }
                    if (n == 13) {
                        teXObjectList.add(comment);
                        teXObjectList.add(this.listener.getPar());
                        return this.skipNextEols(teXObjectList);
                    }
                    if (this.isCatCode(5, n)) {
                        teXObjectList.add(comment);
                        teXObjectList.add(this.listener.getPar());
                        return this.skipNextEols(teXObjectList);
                    }
                    if (n == -1) {
                        teXObjectList.add(comment);
                        return false;
                    }
                    teXObjectList.add(comment);
                    this.reset();
                    return this.skipNextSpaces(teXObjectList);
                }
                this.mark(1);
                n = this.read();
                if (this.isCatCode(5, n)) {
                    teXObjectList.add(comment);
                    teXObjectList.add(this.listener.getPar());
                    return this.skipNextEols(teXObjectList);
                }
                if (n == -1) {
                    teXObjectList.add(comment);
                    return false;
                }
                teXObjectList.add(comment);
                this.reset();
                return this.skipNextSpaces(teXObjectList);
            }
            comment.appendCodePoint(n);
        }
        teXObjectList.add(comment);
        if (n == -1) return false;
        return true;
    }

    private boolean readParam(TeXObjectList teXObjectList, ParameterToken parameterToken) throws IOException {
        this.mark(1);
        int n = this.read();
        if (n == -1) {
            parameterToken.tail().setDigit(0);
            return false;
        }
        if (this.isCatCode(6, n)) {
            this.readParam(teXObjectList, this.listener.getDoubleParam(parameterToken));
        } else if (n > 48 && n <= 57) {
            parameterToken.tail().setDigit(n - 48);
            teXObjectList.add(parameterToken);
        } else if (this.isCatCode(1, n)) {
            parameterToken.tail().setDigit(-1);
            teXObjectList.add(parameterToken);
            this.reset();
        } else {
            parameterToken.tail().setDigit(0);
            teXObjectList.add(parameterToken);
            this.reset();
        }
        return true;
    }

    private boolean readParam(TeXObjectList teXObjectList) throws IOException {
        this.mark(1);
        int n = this.read();
        if (n == -1) {
            teXObjectList.add(this.listener.getParam(0));
            return false;
        }
        if (this.isCatCode(6, n)) {
            return this.readParam(teXObjectList, this.listener.getParam(0));
        }
        if (n > 48 && n <= 57) {
            teXObjectList.add(this.listener.getParam(n - 48));
        } else if (this.isCatCode(1, n)) {
            teXObjectList.add(this.listener.getParam(-1));
            this.reset();
        } else {
            teXObjectList.add(this.listener.getParam(0));
            this.reset();
        }
        return true;
    }

    public CatCodeChanger isCatCodeChanger(TeXObject teXObject) {
        if (teXObject instanceof CatCodeChanger) {
            return (CatCodeChanger)((Object)teXObject);
        }
        if (teXObject instanceof TeXCsRef) {
            return this.isCatCodeChanger(this.getControlSequence(((TeXCsRef)teXObject).getName()));
        }
        if (teXObject instanceof AssignedMacro) {
            return this.isCatCodeChanger(((AssignedMacro)teXObject).getUnderlying());
        }
        return null;
    }

    public EgChar isEndGroup(TeXObject teXObject) {
        if (teXObject instanceof EgChar) {
            return (EgChar)teXObject;
        }
        if (teXObject instanceof AssignedMacro) {
            return this.isEndGroup(((AssignedMacro)teXObject).getUnderlying());
        }
        if (teXObject instanceof TeXCsRef) {
            return this.isEndGroup(this.getControlSequence(((TeXCsRef)teXObject).getName()));
        }
        return null;
    }

    public BgChar isBeginGroup(TeXObject teXObject) {
        if (teXObject instanceof BgChar) {
            return (BgChar)teXObject;
        }
        if (teXObject instanceof AssignedMacro) {
            return this.isBeginGroup(((AssignedMacro)teXObject).getUnderlying());
        }
        if (teXObject instanceof TeXCsRef) {
            return this.isBeginGroup(this.getControlSequence(((TeXCsRef)teXObject).getName()));
        }
        return null;
    }

    @Override
    public boolean popRemainingGroup(TeXParser teXParser, Group group, byte by, BgChar bgChar) throws IOException {
        return this.popRemainingGroup(group, by, bgChar);
    }

    public boolean popRemainingGroup(Group group, byte by, BgChar bgChar) throws IOException {
        this.startGroup();
        try {
            while (true) {
                EgChar egChar;
                if (this.isEmpty() && !this.fetchNext(TeXParser.isShort(by))) {
                    boolean bl = false;
                    return bl;
                }
                TeXObject teXObject = (TeXObject)this.remove(0);
                CatCodeChanger catCodeChanger = this.isCatCodeChanger(teXObject);
                if (catCodeChanger != null) {
                    catCodeChanger.applyCatCodeChange(this);
                }
                if ((egChar = this.isEndGroup(teXObject)) != null) {
                    if (!egChar.matches(bgChar)) {
                        throw new TeXSyntaxException(this, "tex.error.extra_or_forgotten", egChar.toString(this), bgChar.toString(this));
                    }
                    boolean bl = true;
                    return bl;
                }
                bgChar = this.isBeginGroup(teXObject);
                if (TeXParser.isShort(by) && teXObject.isPar()) {
                    throw new TeXSyntaxException(this, "tex.error.par_before_eg", new Object[0]);
                }
                if (bgChar != null) {
                    Group group2 = bgChar.createGroup(this);
                    if (!this.popRemainingGroup(group2, by, bgChar)) {
                        group.add(group2);
                        boolean bl = false;
                        return bl;
                    }
                    group.add(group2);
                    continue;
                }
                group.add(teXObject);
            }
        }
        finally {
            this.endGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readGroup(Group group, boolean bl) throws IOException {
        int n;
        this.mark(1);
        this.startGroup();
        try {
            while ((n = this.read()) != -1) {
                EgChar egChar;
                TeXObject teXObject;
                if (this.isCatCode(2, n)) {
                    boolean bl2 = true;
                    return bl2;
                }
                if (this.isCatCode(1, n)) {
                    teXObject = this.listener.createGroup();
                    boolean bl3 = this.readGroup((Group)teXObject, bl);
                    group.add(teXObject);
                    if (bl3) continue;
                    boolean bl4 = false;
                    return bl4;
                }
                this.reset();
                this.fetchNext(group, bl);
                teXObject = (TeXObject)group.lastElement();
                CatCodeChanger catCodeChanger = this.isCatCodeChanger(teXObject);
                if (catCodeChanger != null) {
                    catCodeChanger.applyCatCodeChange(this);
                }
                if ((egChar = this.isEndGroup(teXObject)) != null) {
                    group.remove(group.size() - 1);
                }
                if (bl && TeXParser.isPar(teXObject)) {
                    throw new TeXSyntaxException(this, "tex.error.par_before_eg", new Object[0]);
                }
                this.mark(1);
            }
            if (n == -1) {
                throw new TeXSyntaxException(this, "tex.error.no_eg", new Object[0]);
            }
        }
        finally {
            this.endGroup();
        }
        return n != -1;
    }

    private void readMath(MathGroup mathGroup) throws IOException {
        this.mark(1);
        int n = this.read();
        if (n == -1) {
            throw new TeXSyntaxException(this, "tex.error.missing_endmath", new Object[0]);
        }
        if (this.isCatCode(3, n)) {
            mathGroup.setInLine(false);
            this.readDisplayMath(mathGroup);
        } else {
            this.reset();
            mathGroup.setInLine(true);
            this.readInLineMath(mathGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readInLineMath(MathGroup mathGroup) throws IOException {
        this.mark(1);
        this.startGroup();
        try {
            int n;
            while ((n = this.read()) != -1) {
                if (this.isCatCode(3, n)) {
                    return;
                }
                this.reset();
                this.fetchNext(mathGroup, true);
                TeXObject teXObject = (TeXObject)mathGroup.lastElement();
                CatCodeChanger catCodeChanger = this.isCatCodeChanger(teXObject);
                if (catCodeChanger != null) {
                    catCodeChanger.applyCatCodeChange(this);
                }
                this.mark(1);
            }
        }
        finally {
            this.endGroup();
        }
        throw new EOFException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDisplayMath(MathGroup mathGroup) throws IOException {
        this.mark(1);
        this.startGroup();
        try {
            int n;
            while ((n = this.read()) != -1) {
                if (this.isCatCode(3, n)) {
                    this.mark(1);
                    n = this.read();
                    if (n == -1) {
                        throw new TeXSyntaxException(this, "tex.error.missing_endmath", new Object[0]);
                    }
                    if (!this.isCatCode(3, n)) {
                        this.reset();
                        throw new TeXSyntaxException(this, "tex.error.dollar2_ended_with_dollar", new Object[0]);
                    }
                    return;
                }
                this.reset();
                this.fetchNext(mathGroup, true);
                TeXObject teXObject = (TeXObject)mathGroup.lastElement();
                CatCodeChanger catCodeChanger = this.isCatCodeChanger(teXObject);
                if (catCodeChanger != null) {
                    catCodeChanger.applyCatCodeChange(this);
                }
                this.mark(1);
            }
        }
        finally {
            this.endGroup();
        }
        throw new EOFException();
    }

    public void readTo(String string, TeXObjectList teXObjectList) throws IOException {
        int n = string.length();
        this.mark(n);
        this.readTo(string, teXObjectList, n, 0);
    }

    private void readTo(String string, TeXObjectList teXObjectList, int n, int n2) throws IOException {
        int n3 = this.read();
        if (n3 == -1) {
            throw new TeXSyntaxException(this, "tex.error.not_found", string);
        }
        if (n3 == string.charAt(n2)) {
            if (++n2 == n) {
                return;
            }
            this.readTo(string, teXObjectList, n, n2);
        } else {
            this.reset();
            if (!this.fetchNext(teXObjectList)) {
                throw new TeXSyntaxException(this, "tex.error.not_found", string);
            }
            this.mark(n);
            this.readTo(string, teXObjectList, n, 0);
        }
    }

    public TeXObjectList popRemainingVerb(int n) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        while (this.size() > 0) {
            int n2;
            TeXObject teXObject = (TeXObject)this.remove(0);
            String string = teXObject.toString(this);
            int n3 = string.length();
            for (int i = 0; i < n3; i += Character.charCount(n2)) {
                n2 = string.codePointAt(i);
                if (n2 == n) {
                    this.addAll(0, this.listener.createString(string.substring(i)));
                    return teXObjectList;
                }
                teXObjectList.add(this.listener.getOther(n2));
            }
        }
        if (this.readVerb(n, teXObjectList) == -1) {
            throw new EOFException();
        }
        return teXObjectList;
    }

    private int readVerb(int n, TeXObjectList teXObjectList) throws IOException {
        int n2;
        while ((n2 = this.read()) != -1) {
            if (n2 == n) {
                return n2;
            }
            teXObjectList.add(this.listener.getOther(n2));
        }
        return -1;
    }

    private boolean readControlSequence(TeXObjectList teXObjectList) throws IOException {
        return this.readControlSequence(teXObjectList, false);
    }

    private boolean readControlSequence(TeXObjectList teXObjectList, boolean bl) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        this.mark(1);
        while ((n = this.read()) != -1) {
            if (!this.isLetter(n)) {
                TeXCsRef teXCsRef;
                if (this.isCatCode(5, n)) {
                    teXCsRef = stringBuilder.length() == 0 ? new TeXCsRef(" ") : new TeXCsRef(stringBuilder.toString());
                    teXObjectList.add(teXCsRef);
                    this.parseEOL(n, teXObjectList, true);
                } else if (stringBuilder.length() == 0) {
                    teXCsRef = new TeXCsRef(new String(Character.toChars(n)));
                    teXObjectList.add(teXCsRef);
                } else if (this.isCatCode(10, n)) {
                    teXCsRef = new TeXCsRef(stringBuilder.toString());
                    teXObjectList.add(teXCsRef);
                    this.reset();
                    if (!this.skipNextSpaces(teXObjectList)) {
                        return false;
                    }
                } else {
                    this.reset();
                    teXCsRef = new TeXCsRef(stringBuilder.toString());
                    teXObjectList.add(teXCsRef);
                }
                if (bl) {
                    return true;
                }
                if (this.isVerbCommand(teXCsRef.getName())) {
                    n = this.read();
                    if (n == 42) {
                        teXObjectList.add(this.listener.getOther(n));
                        n = this.read();
                    }
                    int n2 = n;
                    TeXObjectList teXObjectList2 = new TeXObjectList();
                    teXObjectList.add(teXObjectList2);
                    teXObjectList2.add(this.listener.getOther(n));
                    n = this.readVerb(n2, teXObjectList2);
                    teXObjectList2.add(this.listener.getOther(n));
                } else if (teXCsRef.getName().equals("detokenize")) {
                    n = this.read();
                    if (this.isCatCode(1, n)) {
                        n = this.read();
                        while (!this.isCatCode(2, n) && n != -1) {
                            teXObjectList.add(this.listener.getOther(n));
                            n = this.read();
                        }
                    } else {
                        teXObjectList.add(this.listener.getOther(n));
                    }
                } else if (teXCsRef.getName().equals("string")) {
                    this.mark(1);
                    n = this.read();
                    while (this.isCatCode(10, n)) {
                        this.mark(1);
                        n = this.read();
                    }
                    if (this.isCatCode(0, n)) {
                        this.reset();
                    } else if (this.isCatCode(11, n)) {
                        teXObjectList.add(this.listener.getLetter(n));
                    } else {
                        teXObjectList.add(this.listener.getOther(n));
                    }
                }
                return true;
            }
            this.mark(1);
            stringBuilder.appendCodePoint(n);
        }
        if (n == -1) {
            teXObjectList.add(new TeXCsRef(" "));
            return false;
        }
        return true;
    }

    public boolean fetchNext() throws IOException {
        return this.fetchNext(this, false);
    }

    public boolean fetchNext(boolean bl) throws IOException {
        return this.fetchNext(this, bl);
    }

    public boolean fetchNext(TeXObjectList teXObjectList) throws IOException {
        return this.fetchNext(teXObjectList, false);
    }

    public boolean fetchNext(TeXObjectList teXObjectList, boolean bl) throws IOException {
        if (this.reader == null) {
            return false;
        }
        int n = this.read();
        if (n == -1) {
            return false;
        }
        if (this.isCatCode(5, n)) {
            this.parseEOL(n, teXObjectList);
        } else {
            if (this.isCatCode(0, n)) {
                return this.readControlSequence(teXObjectList);
            }
            if (this.isCatCode(14, n)) {
                return this.readComment(teXObjectList);
            }
            if (this.isCatCode(6, n)) {
                return this.readParam(teXObjectList);
            }
            if (this.isCatCode(13, n)) {
                ActiveChar activeChar = this.listener.getActiveChar(n);
                if (activeChar == null) {
                    throw new TeXSyntaxException(this, "tex.error.undefined_char", new String(Character.toChars(n)));
                }
                teXObjectList.add(activeChar);
            } else if (this.isCatCode(7, n)) {
                teXObjectList.add(this.listener.createSpChar());
            } else if (this.isCatCode(8, n)) {
                teXObjectList.add(this.listener.createSbChar());
            } else if (this.isCatCode(4, n)) {
                teXObjectList.add(this.listener.getTab());
            } else if (this.isCatCode(3, n)) {
                MathGroup mathGroup = this.listener.createMathGroup();
                teXObjectList.add(mathGroup);
                this.readMath(mathGroup);
            } else if (this.isCatCode(1, n)) {
                teXObjectList.add(this.listener.getBgChar(n));
            } else if (this.isCatCode(2, n)) {
                teXObjectList.add(this.listener.getEgChar(n));
            } else {
                if (this.isCatCode(10, n)) {
                    Space space = this.listener.getSpace();
                    space.setSpace(n);
                    teXObjectList.add(space);
                    return this.skipNextSpaces(teXObjectList);
                }
                if (this.isLetter(n)) {
                    teXObjectList.add(this.listener.getLetter(n));
                } else {
                    teXObjectList.add(this.listener.getOther(n));
                }
            }
        }
        try {
            this.mark(1);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void parse(TeXReader teXReader) throws IOException {
        this.parse(teXReader, -1);
    }

    public void parse(TeXReader teXReader, int n) throws IOException {
        block10: {
            TeXObject teXObject;
            if (teXReader != this.reader) {
                teXObject = null;
                if (this.size() > 0) {
                    teXObject = new TeXObjectList(this.size());
                    while (this.size() > 0) {
                        ((TeXObjectList)teXObject).add((TeXObject)this.remove(0));
                    }
                    this.reader.setPending((TeXObjectList)teXObject);
                    teXObject = null;
                }
                teXReader.setParent(this.reader);
                this.reader = teXReader;
            }
            this.settings.setMode(n);
            try {
                block6: while (this.fetchNext() && this.size() != 0) {
                    while (this.size() > 0) {
                        teXObject = this.pop();
                        try {
                            teXObject.process(this);
                        }
                        catch (EOFException eOFException) {
                            if (this.reader != teXReader) continue block6;
                            this.reader = teXReader.getParent();
                        }
                        catch (TeXSyntaxException teXSyntaxException) {
                            this.listener.getTeXApp().error(teXSyntaxException);
                        }
                    }
                }
            }
            catch (EOFException eOFException) {
                if (this.reader != teXReader) break block10;
                this.reader = teXReader.getParent();
            }
        }
    }

    public void parse(File file) throws IOException {
        this.parse(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(File file, Charset charset) throws IOException {
        if (!this.getListener().getTeXApp().isReadAccessAllowed(file)) {
            this.getListener().getTeXApp().warning(this, this.getListener().getTeXApp().getMessage("message.no.read", file));
            return;
        }
        if (this.jobname == null) {
            this.jobname = file.getName();
            int n = this.jobname.lastIndexOf(".");
            if (n > 0) {
                this.jobname = this.jobname.substring(0, n);
            }
        }
        try {
            this.listener.beginParse(file, charset);
            this.parse(new TeXReader(this.reader, file, charset));
        }
        catch (EOFException eOFException) {
        }
        finally {
            this.listener.endParse(file);
            if (this.reader != null) {
                this.reader.close();
                this.reader = this.reader.getParent();
            }
        }
    }

    public void parse(TeXPath teXPath) throws IOException {
        this.parse(teXPath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(TeXPath teXPath, Charset charset) throws IOException {
        if (!this.getListener().getTeXApp().isReadAccessAllowed(teXPath)) {
            this.getListener().getTeXApp().warning(this, this.getListener().getTeXApp().getMessage("message.no.read", teXPath));
            return;
        }
        File file = teXPath.getFile();
        if (this.jobname == null) {
            this.jobname = file.getName();
            int n = this.jobname.lastIndexOf(".");
            if (n > 0) {
                this.jobname = this.jobname.substring(0, n);
            }
        }
        try {
            this.listener.beginParse(file, charset);
            this.parse(new TeXReader(this.reader, file, charset));
        }
        catch (EOFException eOFException) {
        }
        finally {
            this.listener.endParse(file);
            if (this.reader != null) {
                this.reader.close();
                this.reader = this.reader.getParent();
            }
        }
    }

    @Override
    public TeXObject pop() throws IOException {
        if (this.size() == 0) {
            this.fetchNext();
            if (this.size() == 0) {
                throw new EOFException();
            }
        }
        return (TeXObject)this.remove(0);
    }

    public TeXObject popNextArg() throws IOException {
        return this.popNextArg(POP_IGNORE_LEADING_SPACE);
    }

    public TeXObject popNextArg(byte by) throws IOException {
        boolean bl = !TeXParser.isRetainIgnoreables(by);
        boolean bl2 = TeXParser.isIgnoreLeadingSpace(by);
        if (bl && bl2) {
            while (this.size() == 0) {
                if (!this.fetchNext(TeXParser.isShort(by))) {
                    throw new EOFException();
                }
                TeXObject teXObject = (TeXObject)this.get(0);
                if (teXObject instanceof Ignoreable || teXObject instanceof WhiteSpace) {
                    this.pop();
                    continue;
                }
                break;
            }
        } else if (bl) {
            while (this.size() == 0) {
                if (!this.fetchNext(TeXParser.isShort(by))) {
                    throw new EOFException();
                }
                if (this.get(0) instanceof Ignoreable) {
                    this.pop();
                    continue;
                }
                break;
            }
        } else if (bl2) {
            while (this.size() == 0) {
                if (!this.fetchNext(TeXParser.isShort(by))) {
                    throw new EOFException();
                }
                if (this.get(0) instanceof WhiteSpace) {
                    this.pop();
                    continue;
                }
                break;
            }
        } else if (this.size() == 0 && !this.fetchNext(TeXParser.isShort(by))) {
            throw new EOFException();
        }
        return this.popArg(by);
    }

    public TeXObject popNextArg(int n, int n2) throws IOException {
        return this.popNextArg(POP_IGNORE_LEADING_SPACE, n, n2);
    }

    public TeXObject popNextArg(byte by, int n, int n2) throws IOException {
        if (this.size() == 0) {
            this.fetchNext(TeXParser.isShort(by));
        }
        return this.popArg(by, n, n2);
    }

    public Numerical popNumericalArg(int n, int n2) throws IOException {
        TeXObjectList teXObjectList;
        TeXObject teXObject = this.popNextArg(POP_SHORT, n, n2);
        if (teXObject == null) {
            return null;
        }
        if (teXObject instanceof Numerical) {
            return (Numerical)teXObject;
        }
        if (teXObject instanceof Expandable && (teXObjectList = ((Expandable)((Object)teXObject)).expandfully(this)) != null) {
            teXObject = teXObjectList;
        }
        if (teXObject instanceof TeXObjectList) {
            return ((TeXObjectList)teXObject).popNumerical(this);
        }
        return new UserNumber(this, teXObject.toString(this));
    }

    public Numerical popNumericalArg() throws IOException {
        TeXObjectList teXObjectList;
        TeXObject teXObject = this.popNextArg(POP_SHORT);
        if (teXObject == null) {
            return null;
        }
        if (teXObject instanceof Numerical) {
            return (Numerical)teXObject;
        }
        if (teXObject instanceof Expandable && (teXObjectList = ((Expandable)((Object)teXObject)).expandfully(this)) != null) {
            teXObject = teXObjectList;
        }
        if (teXObject instanceof TeXObjectList) {
            return ((TeXObjectList)teXObject).popNumerical(this);
        }
        return new UserNumber(this, teXObject.toString(this));
    }

    public TeXObject popArg() throws IOException {
        return super.popArg(this);
    }

    public TeXObject popArg(byte by) throws IOException {
        return super.popArg(this, by);
    }

    public TeXObject popArg(byte by, int n, int n2) throws IOException {
        return super.popArg(this, by, n, n2);
    }

    @Override
    public TeXObject expandedPopStack(TeXParser teXParser) throws IOException {
        return teXParser.expandedPopStack();
    }

    @Override
    public TeXObject expandedPopStack(TeXParser teXParser, byte by) throws IOException {
        return teXParser.expandedPopStack(by);
    }

    public TeXObject expandedPopStack() throws IOException {
        return this.expandedPopStack((byte)0);
    }

    public TeXObject expandedPopStack(byte by) throws IOException {
        BgChar bgChar;
        TeXObject teXObject = this.popStack(by);
        if (teXObject instanceof TeXCsRef) {
            teXObject = this.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
        }
        if ((bgChar = this.isBeginGroup(teXObject)) != null) {
            Group group = bgChar.createGroup(this);
            this.popRemainingGroup(group, by, bgChar);
            return group;
        }
        if (!(teXObject instanceof Expandable)) {
            return teXObject;
        }
        TeXObjectList teXObjectList = ((Expandable)((Object)teXObject)).expandfully(this);
        if (teXObjectList != null) {
            if (teXObjectList.size() == 0) {
                return teXObjectList;
            }
            teXObject = (TeXObject)teXObjectList.remove(0);
            bgChar = this.isBeginGroup(teXObject);
            if (bgChar != null) {
                Group group = bgChar.createGroup(this);
                teXObjectList.popRemainingGroup(this, group, by, bgChar);
                this.addAll(0, teXObjectList);
                return group;
            }
            this.addAll(0, teXObjectList);
            return teXObject;
        }
        return teXObject;
    }

    @Override
    public TeXObject popStack(TeXParser teXParser) throws IOException {
        return this.popStack();
    }

    @Override
    public TeXObject popStack(TeXParser teXParser, byte by) throws IOException {
        return this.popStack(by);
    }

    public TeXObject popStack() throws IOException {
        return this.popStack((byte)0);
    }

    public TeXObject popStack(byte by) throws IOException {
        if (this.size() == 0) {
            this.fetchNext(TeXParser.isShort(by));
        }
        if (this.size() == 0) {
            throw new EOFException();
        }
        TeXObject teXObject = (TeXObject)this.remove(0);
        if (teXObject instanceof Ignoreable && !TeXParser.isRetainIgnoreables(by)) {
            this.listener.skipping((Ignoreable)teXObject);
            return this.popStack(by);
        }
        BgChar bgChar = this.isBeginGroup(teXObject);
        if (bgChar != null) {
            Group group = bgChar.createGroup(this);
            this.popRemainingGroup(group, by, bgChar);
            return group;
        }
        return teXObject;
    }

    @Override
    public TeXObject popToken() throws IOException {
        return this.popToken((byte)0);
    }

    @Override
    public TeXObject popToken(byte by) throws IOException {
        if (this.size() == 0) {
            this.fetchNext(TeXParser.isShort(by));
        }
        if (this.size() == 0) {
            throw new EOFException();
        }
        TeXObject teXObject = (TeXObject)this.remove(0);
        if (teXObject instanceof WhiteSpace && TeXParser.isIgnoreLeadingSpace(by)) {
            return this.popToken(by);
        }
        if (teXObject instanceof Ignoreable && !TeXParser.isRetainIgnoreables(by)) {
            this.listener.skipping((Ignoreable)teXObject);
            return this.popToken(by);
        }
        return teXObject;
    }

    public TeXObjectList popToGroup(byte by) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        while (true) {
            if (this.size() == 0) {
                this.fetchNext(TeXParser.isShort(by));
            }
            if (this.size() == 0) {
                throw new EOFException();
            }
            TeXObject teXObject = (TeXObject)this.firstElement();
            BgChar bgChar = this.isBeginGroup(teXObject);
            if (teXObject instanceof Group || bgChar != null) break;
            teXObject = (TeXObject)this.remove(0);
            if (teXObject instanceof Ignoreable && !TeXParser.isRetainIgnoreables(by)) {
                this.listener.skipping((Ignoreable)teXObject);
                continue;
            }
            teXObjectList.add(teXObject);
        }
        return teXObjectList;
    }

    public TeXNumber popNumber() throws IOException {
        return this.popNumber(this);
    }

    public TeXDimension popDimension() throws IOException {
        return this.popDimension(this);
    }

    public Numerical popNumerical() throws IOException {
        return this.popNumerical(this);
    }

    public Register popRegister() throws IOException {
        return this.popRegister(this);
    }

    @Override
    public TeXObject peekStack(byte by) throws IOException {
        int n = 0;
        if (this.size() == 0) {
            this.fetchNext();
        }
        TeXObject teXObject = (TeXObject)this.firstElement();
        if (TeXParser.isIgnoreLeadingSpace(by)) {
            while (teXObject instanceof Ignoreable || teXObject instanceof WhiteSpace) {
                if (this.size() == ++n) {
                    this.fetchNext();
                }
                teXObject = (TeXObject)this.get(n);
            }
        } else {
            while (teXObject instanceof Ignoreable) {
                if (this.size() == ++n) {
                    this.fetchNext();
                }
                teXObject = (TeXObject)this.get(n);
            }
        }
        return teXObject;
    }

    public TeXObject peekStack(int n) {
        return this.size() <= n ? null : (TeXObject)this.get(n);
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public TeXReader getReader() {
        return this.reader;
    }

    public File getCurrentParentFile() {
        if (this.reader == null) {
            return null;
        }
        Object object = this.reader.getSource();
        if (object != null && object instanceof File) {
            return ((File)object).getParentFile();
        }
        return null;
    }

    public void setReader(TeXReader teXReader) {
        this.reader = teXReader;
    }

    public TeXParserListener getListener() {
        return this.listener;
    }

    public File getCurrentFile() {
        if (this.reader == null) {
            return null;
        }
        Object object = this.reader.getSource();
        return object instanceof File ? (File)object : null;
    }

    public boolean isMathMode() {
        return this.settings.getMode() != 0;
    }

    public void putControlSequence(ControlSequence controlSequence) {
        this.csTable.put(controlSequence.getName(), controlSequence);
        if (controlSequence instanceof Declaration && this.isLetter(controlSequence.getName().charAt(0))) {
            EndDeclaration endDeclaration = new EndDeclaration(controlSequence.getName());
            this.csTable.put(endDeclaration.getName(), endDeclaration);
        }
    }

    public void putControlSequence(boolean bl, ControlSequence controlSequence) {
        if (bl) {
            this.settings.putControlSequence(controlSequence);
            if (controlSequence instanceof Declaration) {
                EndDeclaration endDeclaration = new EndDeclaration(controlSequence.getName());
                this.settings.putControlSequence(endDeclaration);
            }
        } else {
            this.putControlSequence(controlSequence);
        }
    }

    public ControlSequence getControlSequence(String string) {
        ControlSequence controlSequence = this.settings.getControlSequence(string);
        if (controlSequence != null) {
            return controlSequence;
        }
        return this.csTable.get(string);
    }

    public ControlSequence removeControlSequence(boolean bl, String string) {
        ControlSequence controlSequence;
        if (bl && (controlSequence = this.settings.removeLocalControlSequence(string)) != null) {
            return controlSequence;
        }
        return this.csTable.remove(string);
    }

    public ActiveChar removeActiveChar(int n) {
        return this.activeTable.remove(n);
    }

    public ActiveChar removeActiveChar(boolean bl, int n) {
        if (bl) {
            return this.settings.removeActiveChar(n);
        }
        return this.removeActiveChar(n);
    }

    public void putActiveChar(ActiveChar activeChar) {
        this.activeTable.put(activeChar.getCharCode(), activeChar);
    }

    public void putActiveChar(boolean bl, ActiveChar activeChar) {
        if (bl) {
            this.settings.putActiveChar(activeChar);
        } else {
            this.putActiveChar(activeChar);
        }
    }

    public ActiveChar getActiveChar(int n) {
        Integer n2 = n;
        ActiveChar activeChar = this.settings.getActiveChar(n2);
        if (activeChar != null) {
            return activeChar;
        }
        return this.activeTable.get(n2);
    }

    public void startGroup() {
        this.settings = new TeXSettings(this.settings, this);
    }

    public void endGroup() {
        TeXObjectList teXObjectList = this.settings.getAfterGroup();
        this.settings = this.settings.getParent();
        if (teXObjectList != null) {
            this.addAll(0, teXObjectList);
        }
    }

    public TeXSettings getSettings() {
        return this.settings;
    }

    public int getSpecialChar(int n, int n2) {
        if (this.catcodes[n].size() == 0) {
            return n2;
        }
        return (Integer)this.catcodes[n].firstElement();
    }

    public int getEscChar() {
        return this.getSpecialChar(0, 92);
    }

    public int getMathChar() {
        return this.getSpecialChar(3, 36);
    }

    public String getMathDelim(boolean bl) {
        int n = this.getSpecialChar(3, 36);
        String string = new String(Character.toChars(n));
        return bl ? string : String.format("%s%s", string, string);
    }

    public int getCommentChar() {
        return this.getSpecialChar(14, 37);
    }

    public int getBgChar() {
        return this.getSpecialChar(1, 123);
    }

    public int getEgChar() {
        return this.getSpecialChar(2, 125);
    }

    public int getParamChar() {
        return this.getSpecialChar(6, 35);
    }

    public int getSpChar() {
        return this.getSpecialChar(7, 94);
    }

    public int getSbChar() {
        return this.getSpecialChar(8, 95);
    }

    public int getTabChar() {
        return this.getSpecialChar(4, 9);
    }

    public String getJobname() {
        return this.jobname;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TeXObject teXObject : this) {
            stringBuilder.append(teXObject.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString(TeXParser teXParser) {
        StringBuilder stringBuilder = new StringBuilder();
        for (TeXObject teXObject : this) {
            stringBuilder.append(teXObject.toString(teXParser));
        }
        return stringBuilder.toString();
    }

    public void allocCount(int n, CountRegister countRegister) {
        this.allocCount((Integer)n, countRegister);
    }

    public void allocCount(Integer n, CountRegister countRegister) {
        this.countAlloc.put(n, countRegister);
        countRegister.setAllocation(n);
    }

    public void allocCount(CountRegister countRegister) {
        CountRegister countRegister2 = this.countAlloc.get(ALLOC_COUNT);
        int n = countRegister2.getValue() + 1;
        while (this.countAlloc.containsKey(n)) {
            ++n;
        }
        this.allocCount(n, countRegister);
        countRegister2.setValue(n);
        this.countAlloc.get(ALLOC_NUMBER).setValue(n);
    }

    public void allocDimen(int n, DimenRegister dimenRegister) {
        this.allocDimen((Integer)n, dimenRegister);
    }

    public void allocDimen(Integer n, DimenRegister dimenRegister) {
        this.dimenAlloc.put(n, dimenRegister);
        dimenRegister.setAllocation(n);
    }

    public void allocDimen(DimenRegister dimenRegister) {
        CountRegister countRegister = this.countAlloc.get(ALLOC_DIMEN);
        int n = countRegister.getValue() + 1;
        while (this.countAlloc.containsKey(n)) {
            ++n;
        }
        this.allocDimen(n, dimenRegister);
        countRegister.setValue(n);
        this.countAlloc.get(ALLOC_NUMBER).setValue(n);
    }

    public void allocToken(int n, TokenRegister tokenRegister) {
        this.allocToken((Integer)n, tokenRegister);
    }

    public void allocToken(Integer n, TokenRegister tokenRegister) {
        this.toksAlloc.put(n, tokenRegister);
        tokenRegister.setAllocation(n);
    }

    public void allocToken(TokenRegister tokenRegister) {
        CountRegister countRegister = this.countAlloc.get(ALLOC_TOKS);
        int n = countRegister.getValue() + 1;
        while (this.countAlloc.containsKey(n)) {
            ++n;
        }
        this.allocToken(n, tokenRegister);
        countRegister.setValue(n);
        this.countAlloc.get(ALLOC_NUMBER).setValue(n);
    }

    public TokenRegister getTokenRegister(Pattern pattern) {
        for (Integer n : this.toksAlloc.keySet()) {
            TokenRegister tokenRegister = this.toksAlloc.get(n);
            if (!pattern.matcher(tokenRegister.getName()).matches()) continue;
            return tokenRegister;
        }
        return null;
    }

    public DimenRegister getDimenRegister(String string) {
        for (Integer n : this.dimenAlloc.keySet()) {
            DimenRegister dimenRegister = this.dimenAlloc.get(n);
            if (!string.equals(dimenRegister.getName())) continue;
            return dimenRegister;
        }
        return null;
    }

    public DimenRegister getDimenRegister(Pattern pattern) {
        for (Integer n : this.dimenAlloc.keySet()) {
            DimenRegister dimenRegister = this.dimenAlloc.get(n);
            if (!pattern.matcher(dimenRegister.getName()).matches()) continue;
            return dimenRegister;
        }
        return null;
    }

    public CountRegister getCountRegister(Pattern pattern) {
        for (Integer n : this.countAlloc.keySet()) {
            CountRegister countRegister = this.countAlloc.get(n);
            if (!pattern.matcher(countRegister.getName()).matches()) continue;
            return countRegister;
        }
        return null;
    }
}

