/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.loaders;

import java.util.Map;
import java.util.WeakHashMap;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.RequestProcessor;

public final class DataNodeUtils {
    private static final RequestProcessor RP = new RequestProcessor("Data System Nodes");
    private static final Map<FileSystem, RequestProcessor> FS_TO_RP = new WeakHashMap<FileSystem, RequestProcessor>();

    private DataNodeUtils() {
    }

    public static RequestProcessor reqProcessor() {
        return RP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestProcessor reqProcessor(FileObject fileObject) {
        if (fileObject == null) {
            return RP;
        }
        try {
            FileSystem fileSystem = fileObject.getFileSystem();
            Map<FileSystem, RequestProcessor> map = FS_TO_RP;
            synchronized (map) {
                RequestProcessor requestProcessor = FS_TO_RP.get(fileSystem);
                if (requestProcessor == null) {
                    requestProcessor = new RequestProcessor("Data System Nodes for " + fileSystem.getDisplayName());
                    FS_TO_RP.put(fileSystem, requestProcessor);
                }
                return requestProcessor;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return RP;
        }
    }
}

