/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SessionData;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.UpdateCheck;
import org.eclipse.aether.impl.UpdateCheckManager;
import org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import org.eclipse.aether.internal.impl.DefaultUpdatePolicyAnalyzer;
import org.eclipse.aether.internal.impl.TrackingFileManager;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.AuthenticationDigest;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.MetadataTransferException;
import org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultUpdateCheckManager
implements UpdateCheckManager,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUpdatePolicyAnalyzer.class);
    private UpdatePolicyAnalyzer updatePolicyAnalyzer;
    private static final String UPDATED_KEY_SUFFIX = ".lastUpdated";
    private static final String ERROR_KEY_SUFFIX = ".error";
    private static final String NOT_FOUND = "";
    private static final String SESSION_CHECKS = "updateCheckManager.checks";
    static final String CONFIG_PROP_SESSION_STATE = "aether.updateCheckManager.sessionState";
    private static final int STATE_ENABLED = 0;
    private static final int STATE_BYPASS = 1;
    private static final int STATE_DISABLED = 2;

    public DefaultUpdateCheckManager() {
    }

    @Inject
    DefaultUpdateCheckManager(UpdatePolicyAnalyzer updatePolicyAnalyzer) {
        this.setUpdatePolicyAnalyzer(updatePolicyAnalyzer);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setUpdatePolicyAnalyzer(locator.getService(UpdatePolicyAnalyzer.class));
    }

    public DefaultUpdateCheckManager setUpdatePolicyAnalyzer(UpdatePolicyAnalyzer updatePolicyAnalyzer) {
        this.updatePolicyAnalyzer = Objects.requireNonNull(updatePolicyAnalyzer, "update policy analyzer cannot be null");
        return this;
    }

    @Override
    public void checkArtifact(RepositorySystemSession session, UpdateCheck<Artifact, ArtifactTransferException> check2) {
        long lastUpdated;
        if (check2.getLocalLastUpdated() != 0L && !this.isUpdatedRequired(session, check2.getLocalLastUpdated(), check2.getPolicy())) {
            LOGGER.debug("Skipped remote request for {}, locally installed artifact up-to-date", (Object)check2.getItem());
            check2.setRequired(false);
            return;
        }
        Artifact artifact = check2.getItem();
        RemoteRepository repository = check2.getRepository();
        File artifactFile = Objects.requireNonNull(check2.getFile(), String.format("The artifact '%s' has no file attached", artifact));
        boolean fileExists = check2.isFileValid() && artifactFile.exists();
        File touchFile = this.getTouchFile(artifact, artifactFile);
        Properties props = this.read(touchFile);
        String updateKey = this.getUpdateKey(session, artifactFile, repository);
        String dataKey = this.getDataKey(artifact, artifactFile, repository);
        String error = this.getError(props, dataKey);
        if (error == null) {
            lastUpdated = fileExists ? artifactFile.lastModified() : 0L;
        } else if (error.length() <= 0) {
            lastUpdated = this.getLastUpdated(props, dataKey);
        } else {
            String transferKey = this.getTransferKey(session, artifact, artifactFile, repository);
            lastUpdated = this.getLastUpdated(props, transferKey);
        }
        if (lastUpdated == 0L) {
            check2.setRequired(true);
        } else if (this.isAlreadyUpdated(session, updateKey)) {
            LOGGER.debug("Skipped remote request for {}, already updated during this session", (Object)check2.getItem());
            check2.setRequired(false);
            if (error != null) {
                check2.setException(this.newException(error, artifact, repository));
            }
        } else if (this.isUpdatedRequired(session, lastUpdated, check2.getPolicy())) {
            check2.setRequired(true);
        } else if (fileExists) {
            LOGGER.debug("Skipped remote request for {}, locally cached artifact up-to-date", (Object)check2.getItem());
            check2.setRequired(false);
        } else {
            int cacheFlag;
            int errorPolicy = Utils.getPolicy(session, artifact, repository);
            if ((errorPolicy & (cacheFlag = DefaultUpdateCheckManager.getCacheFlag(error))) != 0) {
                check2.setRequired(false);
                check2.setException(this.newException(error, artifact, repository));
            } else {
                check2.setRequired(true);
            }
        }
    }

    private static int getCacheFlag(String error) {
        if (error == null || error.length() <= 0) {
            return 1;
        }
        return 2;
    }

    private ArtifactTransferException newException(String error, Artifact artifact, RemoteRepository repository) {
        if (error == null || error.length() <= 0) {
            return new ArtifactNotFoundException(artifact, repository, artifact + " was not found in " + repository.getUrl() + " during a previous attempt. This failure was cached in the local repository and resolution is not reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced", true);
        }
        return new ArtifactTransferException(artifact, repository, artifact + " failed to transfer from " + repository.getUrl() + " during a previous attempt. This failure was cached in the local repository and resolution is not reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced. Original error: " + error, true);
    }

    @Override
    public void checkMetadata(RepositorySystemSession session, UpdateCheck<Metadata, MetadataTransferException> check2) {
        long lastUpdated;
        if (check2.getLocalLastUpdated() != 0L && !this.isUpdatedRequired(session, check2.getLocalLastUpdated(), check2.getPolicy())) {
            LOGGER.debug("Skipped remote request for {} locally installed metadata up-to-date", (Object)check2.getItem());
            check2.setRequired(false);
            return;
        }
        Metadata metadata = check2.getItem();
        RemoteRepository repository = check2.getRepository();
        File metadataFile = Objects.requireNonNull(check2.getFile(), String.format("The metadata '%s' has no file attached", metadata));
        boolean fileExists = check2.isFileValid() && metadataFile.exists();
        File touchFile = this.getTouchFile(metadata, metadataFile);
        Properties props = this.read(touchFile);
        String updateKey = this.getUpdateKey(session, metadataFile, repository);
        String dataKey = this.getDataKey(metadata, metadataFile, check2.getAuthoritativeRepository());
        String error = this.getError(props, dataKey);
        if (error == null) {
            lastUpdated = fileExists ? this.getLastUpdated(props, dataKey) : 0L;
        } else if (error.length() <= 0) {
            lastUpdated = this.getLastUpdated(props, dataKey);
        } else {
            String transferKey = this.getTransferKey(session, metadata, metadataFile, repository);
            lastUpdated = this.getLastUpdated(props, transferKey);
        }
        if (lastUpdated == 0L) {
            check2.setRequired(true);
        } else if (this.isAlreadyUpdated(session, updateKey)) {
            LOGGER.debug("Skipped remote request for {}, already updated during this session", (Object)check2.getItem());
            check2.setRequired(false);
            if (error != null) {
                check2.setException(this.newException(error, metadata, repository));
            }
        } else if (this.isUpdatedRequired(session, lastUpdated, check2.getPolicy())) {
            check2.setRequired(true);
        } else if (fileExists) {
            LOGGER.debug("Skipped remote request for {}, locally cached metadata up-to-date", (Object)check2.getItem());
            check2.setRequired(false);
        } else {
            int cacheFlag;
            int errorPolicy = Utils.getPolicy(session, metadata, repository);
            if ((errorPolicy & (cacheFlag = DefaultUpdateCheckManager.getCacheFlag(error))) != 0) {
                check2.setRequired(false);
                check2.setException(this.newException(error, metadata, repository));
            } else {
                check2.setRequired(true);
            }
        }
    }

    private MetadataTransferException newException(String error, Metadata metadata, RemoteRepository repository) {
        if (error == null || error.length() <= 0) {
            return new MetadataNotFoundException(metadata, repository, metadata + " was not found in " + repository.getUrl() + " during a previous attempt. This failure was cached in the local repository and resolution is not be reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced", true);
        }
        return new MetadataTransferException(metadata, repository, metadata + "failed to transfer from " + repository.getUrl() + " during a previous attempt. This failure was cached in the local repository and resolution will not be reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced. Original error: " + error, true);
    }

    private long getLastUpdated(Properties props, String key2) {
        String value = props.getProperty(key2 + UPDATED_KEY_SUFFIX, NOT_FOUND);
        try {
            return value.length() > 0 ? Long.parseLong(value) : 1L;
        }
        catch (NumberFormatException e2) {
            LOGGER.debug("Cannot parse last updated date {}, ignoring it", (Object)value, (Object)e2);
            return 1L;
        }
    }

    private String getError(Properties props, String key2) {
        return props.getProperty(key2 + ERROR_KEY_SUFFIX);
    }

    private File getTouchFile(Artifact artifact, File artifactFile) {
        return new File(artifactFile.getPath() + UPDATED_KEY_SUFFIX);
    }

    private File getTouchFile(Metadata metadata, File metadataFile) {
        return new File(metadataFile.getParent(), "resolver-status.properties");
    }

    private String getDataKey(Artifact artifact, File artifactFile, RemoteRepository repository) {
        Set<String> mirroredUrls = Collections.emptySet();
        if (repository.isRepositoryManager()) {
            mirroredUrls = new TreeSet<String>();
            for (RemoteRepository mirroredRepository : repository.getMirroredRepositories()) {
                mirroredUrls.add(this.normalizeRepoUrl(mirroredRepository.getUrl()));
            }
        }
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append(this.normalizeRepoUrl(repository.getUrl()));
        for (String mirroredUrl : mirroredUrls) {
            buffer.append('+').append(mirroredUrl);
        }
        return buffer.toString();
    }

    private String getTransferKey(RepositorySystemSession session, Artifact artifact, File artifactFile, RemoteRepository repository) {
        return this.getRepoKey(session, repository);
    }

    private String getDataKey(Metadata metadata, File metadataFile, RemoteRepository repository) {
        return metadataFile.getName();
    }

    private String getTransferKey(RepositorySystemSession session, Metadata metadata, File metadataFile, RemoteRepository repository) {
        return metadataFile.getName() + '/' + this.getRepoKey(session, repository);
    }

    private String getRepoKey(RepositorySystemSession session, RemoteRepository repository) {
        StringBuilder buffer = new StringBuilder(128);
        Proxy proxy2 = repository.getProxy();
        if (proxy2 != null) {
            buffer.append(AuthenticationDigest.forProxy(session, repository)).append('@');
            buffer.append(proxy2.getHost()).append(':').append(proxy2.getPort()).append('>');
        }
        buffer.append(AuthenticationDigest.forRepository(session, repository)).append('@');
        buffer.append(repository.getContentType()).append('-');
        buffer.append(repository.getId()).append('-');
        buffer.append(this.normalizeRepoUrl(repository.getUrl()));
        return buffer.toString();
    }

    private String normalizeRepoUrl(String url) {
        String result = url;
        if (url != null && url.length() > 0 && !url.endsWith("/")) {
            result = url + '/';
        }
        return result;
    }

    private String getUpdateKey(RepositorySystemSession session, File file2, RemoteRepository repository) {
        return file2.getAbsolutePath() + '|' + this.getRepoKey(session, repository);
    }

    private int getSessionState(RepositorySystemSession session) {
        String mode = ConfigUtils.getString(session, "enabled", CONFIG_PROP_SESSION_STATE);
        if (Boolean.parseBoolean(mode) || "enabled".equalsIgnoreCase(mode)) {
            return 0;
        }
        if ("bypass".equalsIgnoreCase(mode)) {
            return 1;
        }
        return 2;
    }

    private boolean isAlreadyUpdated(RepositorySystemSession session, Object updateKey) {
        if (this.getSessionState(session) >= 1) {
            return false;
        }
        SessionData data2 = session.getData();
        Object checkedFiles = data2.get(SESSION_CHECKS);
        if (!(checkedFiles instanceof Map)) {
            return false;
        }
        return ((Map)checkedFiles).containsKey(updateKey);
    }

    private void setUpdated(RepositorySystemSession session, Object updateKey) {
        ConcurrentHashMap old;
        if (this.getSessionState(session) >= 2) {
            return;
        }
        SessionData data2 = session.getData();
        Object checkedFiles = data2.get(SESSION_CHECKS);
        while (!(checkedFiles instanceof Map) && !data2.set(SESSION_CHECKS, old = checkedFiles, checkedFiles = new ConcurrentHashMap(256))) {
            checkedFiles = data2.get(SESSION_CHECKS);
        }
        ((Map)checkedFiles).put(updateKey, Boolean.TRUE);
    }

    private boolean isUpdatedRequired(RepositorySystemSession session, long lastModified, String policy) {
        return this.updatePolicyAnalyzer.isUpdatedRequired(session, lastModified, policy);
    }

    private Properties read(File touchFile) {
        Properties props = new TrackingFileManager().read(touchFile);
        return props != null ? props : new Properties();
    }

    @Override
    public void touchArtifact(RepositorySystemSession session, UpdateCheck<Artifact, ArtifactTransferException> check2) {
        Artifact artifact = check2.getItem();
        File artifactFile = check2.getFile();
        File touchFile = this.getTouchFile(artifact, artifactFile);
        String updateKey = this.getUpdateKey(session, artifactFile, check2.getRepository());
        String dataKey = this.getDataKey(artifact, artifactFile, check2.getAuthoritativeRepository());
        String transferKey = this.getTransferKey(session, artifact, artifactFile, check2.getRepository());
        this.setUpdated(session, updateKey);
        Properties props = this.write(touchFile, dataKey, transferKey, check2.getException());
        if (artifactFile.exists() && !this.hasErrors(props)) {
            touchFile.delete();
        }
    }

    private boolean hasErrors(Properties props) {
        for (Object key2 : props.keySet()) {
            if (!key2.toString().endsWith(ERROR_KEY_SUFFIX)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void touchMetadata(RepositorySystemSession session, UpdateCheck<Metadata, MetadataTransferException> check2) {
        Metadata metadata = check2.getItem();
        File metadataFile = check2.getFile();
        File touchFile = this.getTouchFile(metadata, metadataFile);
        String updateKey = this.getUpdateKey(session, metadataFile, check2.getRepository());
        String dataKey = this.getDataKey(metadata, metadataFile, check2.getAuthoritativeRepository());
        String transferKey = this.getTransferKey(session, metadata, metadataFile, check2.getRepository());
        this.setUpdated(session, updateKey);
        this.write(touchFile, dataKey, transferKey, check2.getException());
    }

    private Properties write(File touchFile, String dataKey, String transferKey, Exception error) {
        HashMap<String, String> updates = new HashMap<String, String>();
        String timestamp = Long.toString(System.currentTimeMillis());
        if (error == null) {
            updates.put(dataKey + ERROR_KEY_SUFFIX, null);
            updates.put(dataKey + UPDATED_KEY_SUFFIX, timestamp);
            updates.put(transferKey + UPDATED_KEY_SUFFIX, null);
        } else if (error instanceof ArtifactNotFoundException || error instanceof MetadataNotFoundException) {
            updates.put(dataKey + ERROR_KEY_SUFFIX, NOT_FOUND);
            updates.put(dataKey + UPDATED_KEY_SUFFIX, timestamp);
            updates.put(transferKey + UPDATED_KEY_SUFFIX, null);
        } else {
            String msg = error.getMessage();
            if (msg == null || msg.length() <= 0) {
                msg = error.getClass().getSimpleName();
            }
            updates.put(dataKey + ERROR_KEY_SUFFIX, msg);
            updates.put(dataKey + UPDATED_KEY_SUFFIX, null);
            updates.put(transferKey + UPDATED_KEY_SUFFIX, timestamp);
        }
        return new TrackingFileManager().update(touchFile, updates);
    }
}

