from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TopoDS import *
from OCC.Core.gp import *
from OCC.Core.TCollection import *
from OCC.Core.TColStd import *
from OCC.Core.TDocStd import *


class XCAFDimTolObjects_DatumModifiersSequence:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> XCAFDimTolObjects_DatumSingleModif: ...
    def Last(self) -> XCAFDimTolObjects_DatumSingleModif: ...
    def Length(self) -> int: ...
    def Append(self, theItem: XCAFDimTolObjects_DatumSingleModif) -> XCAFDimTolObjects_DatumSingleModif: ...
    def Prepend(self, theItem: XCAFDimTolObjects_DatumSingleModif) -> XCAFDimTolObjects_DatumSingleModif: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> XCAFDimTolObjects_DatumSingleModif: ...
    def SetValue(self, theIndex: int, theValue: XCAFDimTolObjects_DatumSingleModif) -> None: ...

class XCAFDimTolObjects_DatumObjectSequence:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class XCAFDimTolObjects_DimensionModifiersSequence:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> XCAFDimTolObjects_DimensionModif: ...
    def Last(self) -> XCAFDimTolObjects_DimensionModif: ...
    def Length(self) -> int: ...
    def Append(self, theItem: XCAFDimTolObjects_DimensionModif) -> XCAFDimTolObjects_DimensionModif: ...
    def Prepend(self, theItem: XCAFDimTolObjects_DimensionModif) -> XCAFDimTolObjects_DimensionModif: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> XCAFDimTolObjects_DimensionModif: ...
    def SetValue(self, theIndex: int, theValue: XCAFDimTolObjects_DimensionModif) -> None: ...

class XCAFDimTolObjects_DimensionObjectSequence:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class XCAFDimTolObjects_GeomToleranceModifiersSequence:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> XCAFDimTolObjects_GeomToleranceModif: ...
    def Last(self) -> XCAFDimTolObjects_GeomToleranceModif: ...
    def Length(self) -> int: ...
    def Append(self, theItem: XCAFDimTolObjects_GeomToleranceModif) -> XCAFDimTolObjects_GeomToleranceModif: ...
    def Prepend(self, theItem: XCAFDimTolObjects_GeomToleranceModif) -> XCAFDimTolObjects_GeomToleranceModif: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> XCAFDimTolObjects_GeomToleranceModif: ...
    def SetValue(self, theIndex: int, theValue: XCAFDimTolObjects_GeomToleranceModif) -> None: ...

class XCAFDimTolObjects_GeomToleranceObjectSequence:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class XCAFDimTolObjects_GeomToleranceType(IntEnum):
	XCAFDimTolObjects_GeomToleranceType_None: int = ...
	XCAFDimTolObjects_GeomToleranceType_Angularity: int = ...
	XCAFDimTolObjects_GeomToleranceType_CircularRunout: int = ...
	XCAFDimTolObjects_GeomToleranceType_CircularityOrRoundness: int = ...
	XCAFDimTolObjects_GeomToleranceType_Coaxiality: int = ...
	XCAFDimTolObjects_GeomToleranceType_Concentricity: int = ...
	XCAFDimTolObjects_GeomToleranceType_Cylindricity: int = ...
	XCAFDimTolObjects_GeomToleranceType_Flatness: int = ...
	XCAFDimTolObjects_GeomToleranceType_Parallelism: int = ...
	XCAFDimTolObjects_GeomToleranceType_Perpendicularity: int = ...
	XCAFDimTolObjects_GeomToleranceType_Position: int = ...
	XCAFDimTolObjects_GeomToleranceType_ProfileOfLine: int = ...
	XCAFDimTolObjects_GeomToleranceType_ProfileOfSurface: int = ...
	XCAFDimTolObjects_GeomToleranceType_Straightness: int = ...
	XCAFDimTolObjects_GeomToleranceType_Symmetry: int = ...
	XCAFDimTolObjects_GeomToleranceType_TotalRunout: int = ...
XCAFDimTolObjects_GeomToleranceType_None = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_None
XCAFDimTolObjects_GeomToleranceType_Angularity = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Angularity
XCAFDimTolObjects_GeomToleranceType_CircularRunout = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_CircularRunout
XCAFDimTolObjects_GeomToleranceType_CircularityOrRoundness = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_CircularityOrRoundness
XCAFDimTolObjects_GeomToleranceType_Coaxiality = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Coaxiality
XCAFDimTolObjects_GeomToleranceType_Concentricity = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Concentricity
XCAFDimTolObjects_GeomToleranceType_Cylindricity = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Cylindricity
XCAFDimTolObjects_GeomToleranceType_Flatness = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Flatness
XCAFDimTolObjects_GeomToleranceType_Parallelism = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Parallelism
XCAFDimTolObjects_GeomToleranceType_Perpendicularity = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Perpendicularity
XCAFDimTolObjects_GeomToleranceType_Position = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Position
XCAFDimTolObjects_GeomToleranceType_ProfileOfLine = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_ProfileOfLine
XCAFDimTolObjects_GeomToleranceType_ProfileOfSurface = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_ProfileOfSurface
XCAFDimTolObjects_GeomToleranceType_Straightness = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Straightness
XCAFDimTolObjects_GeomToleranceType_Symmetry = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Symmetry
XCAFDimTolObjects_GeomToleranceType_TotalRunout = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_TotalRunout

class XCAFDimTolObjects_GeomToleranceModif(IntEnum):
	XCAFDimTolObjects_GeomToleranceModif_Any_Cross_Section: int = ...
	XCAFDimTolObjects_GeomToleranceModif_Common_Zone: int = ...
	XCAFDimTolObjects_GeomToleranceModif_Each_Radial_Element: int = ...
	XCAFDimTolObjects_GeomToleranceModif_Free_State: int = ...
	XCAFDimTolObjects_GeomToleranceModif_Least_Material_Requirement: int = ...
	XCAFDimTolObjects_GeomToleranceModif_Line_Element: int = ...
	XCAFDimTolObjects_GeomToleranceModif_Major_Diameter: int = ...
	XCAFDimTolObjects_GeomToleranceModif_Maximum_Material_Requirement: int = ...
	XCAFDimTolObjects_GeomToleranceModif_Minor_Diameter: int = ...
	XCAFDimTolObjects_GeomToleranceModif_Not_Convex: int = ...
	XCAFDimTolObjects_GeomToleranceModif_Pitch_Diameter: int = ...
	XCAFDimTolObjects_GeomToleranceModif_Reciprocity_Requirement: int = ...
	XCAFDimTolObjects_GeomToleranceModif_Separate_Requirement: int = ...
	XCAFDimTolObjects_GeomToleranceModif_Statistical_Tolerance: int = ...
	XCAFDimTolObjects_GeomToleranceModif_Tangent_Plane: int = ...
	XCAFDimTolObjects_GeomToleranceModif_All_Around: int = ...
	XCAFDimTolObjects_GeomToleranceModif_All_Over: int = ...
XCAFDimTolObjects_GeomToleranceModif_Any_Cross_Section = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Any_Cross_Section
XCAFDimTolObjects_GeomToleranceModif_Common_Zone = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Common_Zone
XCAFDimTolObjects_GeomToleranceModif_Each_Radial_Element = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Each_Radial_Element
XCAFDimTolObjects_GeomToleranceModif_Free_State = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Free_State
XCAFDimTolObjects_GeomToleranceModif_Least_Material_Requirement = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Least_Material_Requirement
XCAFDimTolObjects_GeomToleranceModif_Line_Element = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Line_Element
XCAFDimTolObjects_GeomToleranceModif_Major_Diameter = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Major_Diameter
XCAFDimTolObjects_GeomToleranceModif_Maximum_Material_Requirement = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Maximum_Material_Requirement
XCAFDimTolObjects_GeomToleranceModif_Minor_Diameter = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Minor_Diameter
XCAFDimTolObjects_GeomToleranceModif_Not_Convex = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Not_Convex
XCAFDimTolObjects_GeomToleranceModif_Pitch_Diameter = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Pitch_Diameter
XCAFDimTolObjects_GeomToleranceModif_Reciprocity_Requirement = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Reciprocity_Requirement
XCAFDimTolObjects_GeomToleranceModif_Separate_Requirement = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Separate_Requirement
XCAFDimTolObjects_GeomToleranceModif_Statistical_Tolerance = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Statistical_Tolerance
XCAFDimTolObjects_GeomToleranceModif_Tangent_Plane = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Tangent_Plane
XCAFDimTolObjects_GeomToleranceModif_All_Around = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_All_Around
XCAFDimTolObjects_GeomToleranceModif_All_Over = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_All_Over

class XCAFDimTolObjects_DimensionModif(IntEnum):
	XCAFDimTolObjects_DimensionModif_ControlledRadius: int = ...
	XCAFDimTolObjects_DimensionModif_Square: int = ...
	XCAFDimTolObjects_DimensionModif_StatisticalTolerance: int = ...
	XCAFDimTolObjects_DimensionModif_ContinuousFeature: int = ...
	XCAFDimTolObjects_DimensionModif_TwoPointSize: int = ...
	XCAFDimTolObjects_DimensionModif_LocalSizeDefinedBySphere: int = ...
	XCAFDimTolObjects_DimensionModif_LeastSquaresAssociationCriterion: int = ...
	XCAFDimTolObjects_DimensionModif_MaximumInscribedAssociation: int = ...
	XCAFDimTolObjects_DimensionModif_MinimumCircumscribedAssociation: int = ...
	XCAFDimTolObjects_DimensionModif_CircumferenceDiameter: int = ...
	XCAFDimTolObjects_DimensionModif_AreaDiameter: int = ...
	XCAFDimTolObjects_DimensionModif_VolumeDiameter: int = ...
	XCAFDimTolObjects_DimensionModif_MaximumSize: int = ...
	XCAFDimTolObjects_DimensionModif_MinimumSize: int = ...
	XCAFDimTolObjects_DimensionModif_AverageSize: int = ...
	XCAFDimTolObjects_DimensionModif_MedianSize: int = ...
	XCAFDimTolObjects_DimensionModif_MidRangeSize: int = ...
	XCAFDimTolObjects_DimensionModif_RangeOfSizes: int = ...
	XCAFDimTolObjects_DimensionModif_AnyRestrictedPortionOfFeature: int = ...
	XCAFDimTolObjects_DimensionModif_AnyCrossSection: int = ...
	XCAFDimTolObjects_DimensionModif_SpecificFixedCrossSection: int = ...
	XCAFDimTolObjects_DimensionModif_CommonTolerance: int = ...
	XCAFDimTolObjects_DimensionModif_FreeStateCondition: int = ...
	XCAFDimTolObjects_DimensionModif_Between: int = ...
XCAFDimTolObjects_DimensionModif_ControlledRadius = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_ControlledRadius
XCAFDimTolObjects_DimensionModif_Square = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_Square
XCAFDimTolObjects_DimensionModif_StatisticalTolerance = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_StatisticalTolerance
XCAFDimTolObjects_DimensionModif_ContinuousFeature = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_ContinuousFeature
XCAFDimTolObjects_DimensionModif_TwoPointSize = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_TwoPointSize
XCAFDimTolObjects_DimensionModif_LocalSizeDefinedBySphere = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_LocalSizeDefinedBySphere
XCAFDimTolObjects_DimensionModif_LeastSquaresAssociationCriterion = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_LeastSquaresAssociationCriterion
XCAFDimTolObjects_DimensionModif_MaximumInscribedAssociation = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_MaximumInscribedAssociation
XCAFDimTolObjects_DimensionModif_MinimumCircumscribedAssociation = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_MinimumCircumscribedAssociation
XCAFDimTolObjects_DimensionModif_CircumferenceDiameter = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_CircumferenceDiameter
XCAFDimTolObjects_DimensionModif_AreaDiameter = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_AreaDiameter
XCAFDimTolObjects_DimensionModif_VolumeDiameter = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_VolumeDiameter
XCAFDimTolObjects_DimensionModif_MaximumSize = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_MaximumSize
XCAFDimTolObjects_DimensionModif_MinimumSize = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_MinimumSize
XCAFDimTolObjects_DimensionModif_AverageSize = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_AverageSize
XCAFDimTolObjects_DimensionModif_MedianSize = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_MedianSize
XCAFDimTolObjects_DimensionModif_MidRangeSize = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_MidRangeSize
XCAFDimTolObjects_DimensionModif_RangeOfSizes = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_RangeOfSizes
XCAFDimTolObjects_DimensionModif_AnyRestrictedPortionOfFeature = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_AnyRestrictedPortionOfFeature
XCAFDimTolObjects_DimensionModif_AnyCrossSection = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_AnyCrossSection
XCAFDimTolObjects_DimensionModif_SpecificFixedCrossSection = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_SpecificFixedCrossSection
XCAFDimTolObjects_DimensionModif_CommonTolerance = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_CommonTolerance
XCAFDimTolObjects_DimensionModif_FreeStateCondition = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_FreeStateCondition
XCAFDimTolObjects_DimensionModif_Between = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_Between

class XCAFDimTolObjects_DatumModifWithValue(IntEnum):
	XCAFDimTolObjects_DatumModifWithValue_None: int = ...
	XCAFDimTolObjects_DatumModifWithValue_CircularOrCylindrical: int = ...
	XCAFDimTolObjects_DatumModifWithValue_Distance: int = ...
	XCAFDimTolObjects_DatumModifWithValue_Projected: int = ...
	XCAFDimTolObjects_DatumModifWithValue_Spherical: int = ...
XCAFDimTolObjects_DatumModifWithValue_None = XCAFDimTolObjects_DatumModifWithValue.XCAFDimTolObjects_DatumModifWithValue_None
XCAFDimTolObjects_DatumModifWithValue_CircularOrCylindrical = XCAFDimTolObjects_DatumModifWithValue.XCAFDimTolObjects_DatumModifWithValue_CircularOrCylindrical
XCAFDimTolObjects_DatumModifWithValue_Distance = XCAFDimTolObjects_DatumModifWithValue.XCAFDimTolObjects_DatumModifWithValue_Distance
XCAFDimTolObjects_DatumModifWithValue_Projected = XCAFDimTolObjects_DatumModifWithValue.XCAFDimTolObjects_DatumModifWithValue_Projected
XCAFDimTolObjects_DatumModifWithValue_Spherical = XCAFDimTolObjects_DatumModifWithValue.XCAFDimTolObjects_DatumModifWithValue_Spherical

class XCAFDimTolObjects_DimensionFormVariance(IntEnum):
	XCAFDimTolObjects_DimensionFormVariance_None: int = ...
	XCAFDimTolObjects_DimensionFormVariance_A: int = ...
	XCAFDimTolObjects_DimensionFormVariance_B: int = ...
	XCAFDimTolObjects_DimensionFormVariance_C: int = ...
	XCAFDimTolObjects_DimensionFormVariance_CD: int = ...
	XCAFDimTolObjects_DimensionFormVariance_D: int = ...
	XCAFDimTolObjects_DimensionFormVariance_E: int = ...
	XCAFDimTolObjects_DimensionFormVariance_EF: int = ...
	XCAFDimTolObjects_DimensionFormVariance_F: int = ...
	XCAFDimTolObjects_DimensionFormVariance_FG: int = ...
	XCAFDimTolObjects_DimensionFormVariance_G: int = ...
	XCAFDimTolObjects_DimensionFormVariance_H: int = ...
	XCAFDimTolObjects_DimensionFormVariance_JS: int = ...
	XCAFDimTolObjects_DimensionFormVariance_J: int = ...
	XCAFDimTolObjects_DimensionFormVariance_K: int = ...
	XCAFDimTolObjects_DimensionFormVariance_M: int = ...
	XCAFDimTolObjects_DimensionFormVariance_N: int = ...
	XCAFDimTolObjects_DimensionFormVariance_P: int = ...
	XCAFDimTolObjects_DimensionFormVariance_R: int = ...
	XCAFDimTolObjects_DimensionFormVariance_S: int = ...
	XCAFDimTolObjects_DimensionFormVariance_T: int = ...
	XCAFDimTolObjects_DimensionFormVariance_U: int = ...
	XCAFDimTolObjects_DimensionFormVariance_V: int = ...
	XCAFDimTolObjects_DimensionFormVariance_X: int = ...
	XCAFDimTolObjects_DimensionFormVariance_Y: int = ...
	XCAFDimTolObjects_DimensionFormVariance_Z: int = ...
	XCAFDimTolObjects_DimensionFormVariance_ZA: int = ...
	XCAFDimTolObjects_DimensionFormVariance_ZB: int = ...
	XCAFDimTolObjects_DimensionFormVariance_ZC: int = ...
XCAFDimTolObjects_DimensionFormVariance_None = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_None
XCAFDimTolObjects_DimensionFormVariance_A = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_A
XCAFDimTolObjects_DimensionFormVariance_B = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_B
XCAFDimTolObjects_DimensionFormVariance_C = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_C
XCAFDimTolObjects_DimensionFormVariance_CD = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_CD
XCAFDimTolObjects_DimensionFormVariance_D = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_D
XCAFDimTolObjects_DimensionFormVariance_E = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_E
XCAFDimTolObjects_DimensionFormVariance_EF = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_EF
XCAFDimTolObjects_DimensionFormVariance_F = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_F
XCAFDimTolObjects_DimensionFormVariance_FG = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_FG
XCAFDimTolObjects_DimensionFormVariance_G = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_G
XCAFDimTolObjects_DimensionFormVariance_H = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_H
XCAFDimTolObjects_DimensionFormVariance_JS = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_JS
XCAFDimTolObjects_DimensionFormVariance_J = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_J
XCAFDimTolObjects_DimensionFormVariance_K = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_K
XCAFDimTolObjects_DimensionFormVariance_M = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_M
XCAFDimTolObjects_DimensionFormVariance_N = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_N
XCAFDimTolObjects_DimensionFormVariance_P = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_P
XCAFDimTolObjects_DimensionFormVariance_R = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_R
XCAFDimTolObjects_DimensionFormVariance_S = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_S
XCAFDimTolObjects_DimensionFormVariance_T = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_T
XCAFDimTolObjects_DimensionFormVariance_U = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_U
XCAFDimTolObjects_DimensionFormVariance_V = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_V
XCAFDimTolObjects_DimensionFormVariance_X = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_X
XCAFDimTolObjects_DimensionFormVariance_Y = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_Y
XCAFDimTolObjects_DimensionFormVariance_Z = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_Z
XCAFDimTolObjects_DimensionFormVariance_ZA = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_ZA
XCAFDimTolObjects_DimensionFormVariance_ZB = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_ZB
XCAFDimTolObjects_DimensionFormVariance_ZC = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_ZC

class XCAFDimTolObjects_GeomToleranceZoneModif(IntEnum):
	XCAFDimTolObjects_GeomToleranceZoneModif_None: int = ...
	XCAFDimTolObjects_GeomToleranceZoneModif_Projected: int = ...
	XCAFDimTolObjects_GeomToleranceZoneModif_Runout: int = ...
	XCAFDimTolObjects_GeomToleranceZoneModif_NonUniform: int = ...
XCAFDimTolObjects_GeomToleranceZoneModif_None = XCAFDimTolObjects_GeomToleranceZoneModif.XCAFDimTolObjects_GeomToleranceZoneModif_None
XCAFDimTolObjects_GeomToleranceZoneModif_Projected = XCAFDimTolObjects_GeomToleranceZoneModif.XCAFDimTolObjects_GeomToleranceZoneModif_Projected
XCAFDimTolObjects_GeomToleranceZoneModif_Runout = XCAFDimTolObjects_GeomToleranceZoneModif.XCAFDimTolObjects_GeomToleranceZoneModif_Runout
XCAFDimTolObjects_GeomToleranceZoneModif_NonUniform = XCAFDimTolObjects_GeomToleranceZoneModif.XCAFDimTolObjects_GeomToleranceZoneModif_NonUniform

class XCAFDimTolObjects_DatumTargetType(IntEnum):
	XCAFDimTolObjects_DatumTargetType_Point: int = ...
	XCAFDimTolObjects_DatumTargetType_Line: int = ...
	XCAFDimTolObjects_DatumTargetType_Rectangle: int = ...
	XCAFDimTolObjects_DatumTargetType_Circle: int = ...
	XCAFDimTolObjects_DatumTargetType_Area: int = ...
XCAFDimTolObjects_DatumTargetType_Point = XCAFDimTolObjects_DatumTargetType.XCAFDimTolObjects_DatumTargetType_Point
XCAFDimTolObjects_DatumTargetType_Line = XCAFDimTolObjects_DatumTargetType.XCAFDimTolObjects_DatumTargetType_Line
XCAFDimTolObjects_DatumTargetType_Rectangle = XCAFDimTolObjects_DatumTargetType.XCAFDimTolObjects_DatumTargetType_Rectangle
XCAFDimTolObjects_DatumTargetType_Circle = XCAFDimTolObjects_DatumTargetType.XCAFDimTolObjects_DatumTargetType_Circle
XCAFDimTolObjects_DatumTargetType_Area = XCAFDimTolObjects_DatumTargetType.XCAFDimTolObjects_DatumTargetType_Area

class XCAFDimTolObjects_DatumSingleModif(IntEnum):
	XCAFDimTolObjects_DatumSingleModif_AnyCrossSection: int = ...
	XCAFDimTolObjects_DatumSingleModif_Any_LongitudinalSection: int = ...
	XCAFDimTolObjects_DatumSingleModif_Basic: int = ...
	XCAFDimTolObjects_DatumSingleModif_ContactingFeature: int = ...
	XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintU: int = ...
	XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintV: int = ...
	XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintW: int = ...
	XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintX: int = ...
	XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintY: int = ...
	XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintZ: int = ...
	XCAFDimTolObjects_DatumSingleModif_DistanceVariable: int = ...
	XCAFDimTolObjects_DatumSingleModif_FreeState: int = ...
	XCAFDimTolObjects_DatumSingleModif_LeastMaterialRequirement: int = ...
	XCAFDimTolObjects_DatumSingleModif_Line: int = ...
	XCAFDimTolObjects_DatumSingleModif_MajorDiameter: int = ...
	XCAFDimTolObjects_DatumSingleModif_MaximumMaterialRequirement: int = ...
	XCAFDimTolObjects_DatumSingleModif_MinorDiameter: int = ...
	XCAFDimTolObjects_DatumSingleModif_Orientation: int = ...
	XCAFDimTolObjects_DatumSingleModif_PitchDiameter: int = ...
	XCAFDimTolObjects_DatumSingleModif_Plane: int = ...
	XCAFDimTolObjects_DatumSingleModif_Point: int = ...
	XCAFDimTolObjects_DatumSingleModif_Translation: int = ...
XCAFDimTolObjects_DatumSingleModif_AnyCrossSection = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_AnyCrossSection
XCAFDimTolObjects_DatumSingleModif_Any_LongitudinalSection = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_Any_LongitudinalSection
XCAFDimTolObjects_DatumSingleModif_Basic = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_Basic
XCAFDimTolObjects_DatumSingleModif_ContactingFeature = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_ContactingFeature
XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintU = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintU
XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintV = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintV
XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintW = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintW
XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintX = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintX
XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintY = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintY
XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintZ = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintZ
XCAFDimTolObjects_DatumSingleModif_DistanceVariable = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_DistanceVariable
XCAFDimTolObjects_DatumSingleModif_FreeState = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_FreeState
XCAFDimTolObjects_DatumSingleModif_LeastMaterialRequirement = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_LeastMaterialRequirement
XCAFDimTolObjects_DatumSingleModif_Line = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_Line
XCAFDimTolObjects_DatumSingleModif_MajorDiameter = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_MajorDiameter
XCAFDimTolObjects_DatumSingleModif_MaximumMaterialRequirement = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_MaximumMaterialRequirement
XCAFDimTolObjects_DatumSingleModif_MinorDiameter = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_MinorDiameter
XCAFDimTolObjects_DatumSingleModif_Orientation = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_Orientation
XCAFDimTolObjects_DatumSingleModif_PitchDiameter = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_PitchDiameter
XCAFDimTolObjects_DatumSingleModif_Plane = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_Plane
XCAFDimTolObjects_DatumSingleModif_Point = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_Point
XCAFDimTolObjects_DatumSingleModif_Translation = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_Translation

class XCAFDimTolObjects_DimensionQualifier(IntEnum):
	XCAFDimTolObjects_DimensionQualifier_None: int = ...
	XCAFDimTolObjects_DimensionQualifier_Min: int = ...
	XCAFDimTolObjects_DimensionQualifier_Max: int = ...
	XCAFDimTolObjects_DimensionQualifier_Avg: int = ...
XCAFDimTolObjects_DimensionQualifier_None = XCAFDimTolObjects_DimensionQualifier.XCAFDimTolObjects_DimensionQualifier_None
XCAFDimTolObjects_DimensionQualifier_Min = XCAFDimTolObjects_DimensionQualifier.XCAFDimTolObjects_DimensionQualifier_Min
XCAFDimTolObjects_DimensionQualifier_Max = XCAFDimTolObjects_DimensionQualifier.XCAFDimTolObjects_DimensionQualifier_Max
XCAFDimTolObjects_DimensionQualifier_Avg = XCAFDimTolObjects_DimensionQualifier.XCAFDimTolObjects_DimensionQualifier_Avg

class XCAFDimTolObjects_GeomToleranceTypeValue(IntEnum):
	XCAFDimTolObjects_GeomToleranceTypeValue_None: int = ...
	XCAFDimTolObjects_GeomToleranceTypeValue_Diameter: int = ...
	XCAFDimTolObjects_GeomToleranceTypeValue_SphericalDiameter: int = ...
XCAFDimTolObjects_GeomToleranceTypeValue_None = XCAFDimTolObjects_GeomToleranceTypeValue.XCAFDimTolObjects_GeomToleranceTypeValue_None
XCAFDimTolObjects_GeomToleranceTypeValue_Diameter = XCAFDimTolObjects_GeomToleranceTypeValue.XCAFDimTolObjects_GeomToleranceTypeValue_Diameter
XCAFDimTolObjects_GeomToleranceTypeValue_SphericalDiameter = XCAFDimTolObjects_GeomToleranceTypeValue.XCAFDimTolObjects_GeomToleranceTypeValue_SphericalDiameter

class XCAFDimTolObjects_ToleranceZoneAffectedPlane(IntEnum):
	XCAFDimTolObjects_ToleranceZoneAffectedPlane_None: int = ...
	XCAFDimTolObjects_ToleranceZoneAffectedPlane_Intersection: int = ...
	XCAFDimTolObjects_ToleranceZoneAffectedPlane_Orientation: int = ...
XCAFDimTolObjects_ToleranceZoneAffectedPlane_None = XCAFDimTolObjects_ToleranceZoneAffectedPlane.XCAFDimTolObjects_ToleranceZoneAffectedPlane_None
XCAFDimTolObjects_ToleranceZoneAffectedPlane_Intersection = XCAFDimTolObjects_ToleranceZoneAffectedPlane.XCAFDimTolObjects_ToleranceZoneAffectedPlane_Intersection
XCAFDimTolObjects_ToleranceZoneAffectedPlane_Orientation = XCAFDimTolObjects_ToleranceZoneAffectedPlane.XCAFDimTolObjects_ToleranceZoneAffectedPlane_Orientation

class XCAFDimTolObjects_DimensionType(IntEnum):
	XCAFDimTolObjects_DimensionType_Location_None: int = ...
	XCAFDimTolObjects_DimensionType_Location_CurvedDistance: int = ...
	XCAFDimTolObjects_DimensionType_Location_LinearDistance: int = ...
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromCenterToOuter: int = ...
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromCenterToInner: int = ...
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToCenter: int = ...
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToOuter: int = ...
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToInner: int = ...
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToCenter: int = ...
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToOuter: int = ...
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToInner: int = ...
	XCAFDimTolObjects_DimensionType_Location_Angular: int = ...
	XCAFDimTolObjects_DimensionType_Location_Oriented: int = ...
	XCAFDimTolObjects_DimensionType_Location_WithPath: int = ...
	XCAFDimTolObjects_DimensionType_Size_CurveLength: int = ...
	XCAFDimTolObjects_DimensionType_Size_Diameter: int = ...
	XCAFDimTolObjects_DimensionType_Size_SphericalDiameter: int = ...
	XCAFDimTolObjects_DimensionType_Size_Radius: int = ...
	XCAFDimTolObjects_DimensionType_Size_SphericalRadius: int = ...
	XCAFDimTolObjects_DimensionType_Size_ToroidalMinorDiameter: int = ...
	XCAFDimTolObjects_DimensionType_Size_ToroidalMajorDiameter: int = ...
	XCAFDimTolObjects_DimensionType_Size_ToroidalMinorRadius: int = ...
	XCAFDimTolObjects_DimensionType_Size_ToroidalMajorRadius: int = ...
	XCAFDimTolObjects_DimensionType_Size_ToroidalHighMajorDiameter: int = ...
	XCAFDimTolObjects_DimensionType_Size_ToroidalLowMajorDiameter: int = ...
	XCAFDimTolObjects_DimensionType_Size_ToroidalHighMajorRadius: int = ...
	XCAFDimTolObjects_DimensionType_Size_ToroidalLowMajorRadius: int = ...
	XCAFDimTolObjects_DimensionType_Size_Thickness: int = ...
	XCAFDimTolObjects_DimensionType_Size_Angular: int = ...
	XCAFDimTolObjects_DimensionType_Size_WithPath: int = ...
	XCAFDimTolObjects_DimensionType_CommonLabel: int = ...
	XCAFDimTolObjects_DimensionType_DimensionPresentation: int = ...
XCAFDimTolObjects_DimensionType_Location_None = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_None
XCAFDimTolObjects_DimensionType_Location_CurvedDistance = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_CurvedDistance
XCAFDimTolObjects_DimensionType_Location_LinearDistance = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_LinearDistance
XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromCenterToOuter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromCenterToOuter
XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromCenterToInner = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromCenterToInner
XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToCenter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToCenter
XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToOuter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToOuter
XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToInner = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToInner
XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToCenter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToCenter
XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToOuter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToOuter
XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToInner = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToInner
XCAFDimTolObjects_DimensionType_Location_Angular = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_Angular
XCAFDimTolObjects_DimensionType_Location_Oriented = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_Oriented
XCAFDimTolObjects_DimensionType_Location_WithPath = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_WithPath
XCAFDimTolObjects_DimensionType_Size_CurveLength = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_CurveLength
XCAFDimTolObjects_DimensionType_Size_Diameter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_Diameter
XCAFDimTolObjects_DimensionType_Size_SphericalDiameter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_SphericalDiameter
XCAFDimTolObjects_DimensionType_Size_Radius = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_Radius
XCAFDimTolObjects_DimensionType_Size_SphericalRadius = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_SphericalRadius
XCAFDimTolObjects_DimensionType_Size_ToroidalMinorDiameter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_ToroidalMinorDiameter
XCAFDimTolObjects_DimensionType_Size_ToroidalMajorDiameter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_ToroidalMajorDiameter
XCAFDimTolObjects_DimensionType_Size_ToroidalMinorRadius = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_ToroidalMinorRadius
XCAFDimTolObjects_DimensionType_Size_ToroidalMajorRadius = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_ToroidalMajorRadius
XCAFDimTolObjects_DimensionType_Size_ToroidalHighMajorDiameter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_ToroidalHighMajorDiameter
XCAFDimTolObjects_DimensionType_Size_ToroidalLowMajorDiameter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_ToroidalLowMajorDiameter
XCAFDimTolObjects_DimensionType_Size_ToroidalHighMajorRadius = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_ToroidalHighMajorRadius
XCAFDimTolObjects_DimensionType_Size_ToroidalLowMajorRadius = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_ToroidalLowMajorRadius
XCAFDimTolObjects_DimensionType_Size_Thickness = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_Thickness
XCAFDimTolObjects_DimensionType_Size_Angular = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_Angular
XCAFDimTolObjects_DimensionType_Size_WithPath = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_WithPath
XCAFDimTolObjects_DimensionType_CommonLabel = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_CommonLabel
XCAFDimTolObjects_DimensionType_DimensionPresentation = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_DimensionPresentation

class XCAFDimTolObjects_GeomToleranceMatReqModif(IntEnum):
	XCAFDimTolObjects_GeomToleranceMatReqModif_None: int = ...
	XCAFDimTolObjects_GeomToleranceMatReqModif_M: int = ...
	XCAFDimTolObjects_GeomToleranceMatReqModif_L: int = ...
XCAFDimTolObjects_GeomToleranceMatReqModif_None = XCAFDimTolObjects_GeomToleranceMatReqModif.XCAFDimTolObjects_GeomToleranceMatReqModif_None
XCAFDimTolObjects_GeomToleranceMatReqModif_M = XCAFDimTolObjects_GeomToleranceMatReqModif.XCAFDimTolObjects_GeomToleranceMatReqModif_M
XCAFDimTolObjects_GeomToleranceMatReqModif_L = XCAFDimTolObjects_GeomToleranceMatReqModif.XCAFDimTolObjects_GeomToleranceMatReqModif_L

class XCAFDimTolObjects_DimensionGrade(IntEnum):
	XCAFDimTolObjects_DimensionGrade_IT01: int = ...
	XCAFDimTolObjects_DimensionGrade_IT0: int = ...
	XCAFDimTolObjects_DimensionGrade_IT1: int = ...
	XCAFDimTolObjects_DimensionGrade_IT2: int = ...
	XCAFDimTolObjects_DimensionGrade_IT3: int = ...
	XCAFDimTolObjects_DimensionGrade_IT4: int = ...
	XCAFDimTolObjects_DimensionGrade_IT5: int = ...
	XCAFDimTolObjects_DimensionGrade_IT6: int = ...
	XCAFDimTolObjects_DimensionGrade_IT7: int = ...
	XCAFDimTolObjects_DimensionGrade_IT8: int = ...
	XCAFDimTolObjects_DimensionGrade_IT9: int = ...
	XCAFDimTolObjects_DimensionGrade_IT10: int = ...
	XCAFDimTolObjects_DimensionGrade_IT11: int = ...
	XCAFDimTolObjects_DimensionGrade_IT12: int = ...
	XCAFDimTolObjects_DimensionGrade_IT13: int = ...
	XCAFDimTolObjects_DimensionGrade_IT14: int = ...
	XCAFDimTolObjects_DimensionGrade_IT15: int = ...
	XCAFDimTolObjects_DimensionGrade_IT16: int = ...
	XCAFDimTolObjects_DimensionGrade_IT17: int = ...
	XCAFDimTolObjects_DimensionGrade_IT18: int = ...
XCAFDimTolObjects_DimensionGrade_IT01 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT01
XCAFDimTolObjects_DimensionGrade_IT0 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT0
XCAFDimTolObjects_DimensionGrade_IT1 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT1
XCAFDimTolObjects_DimensionGrade_IT2 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT2
XCAFDimTolObjects_DimensionGrade_IT3 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT3
XCAFDimTolObjects_DimensionGrade_IT4 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT4
XCAFDimTolObjects_DimensionGrade_IT5 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT5
XCAFDimTolObjects_DimensionGrade_IT6 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT6
XCAFDimTolObjects_DimensionGrade_IT7 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT7
XCAFDimTolObjects_DimensionGrade_IT8 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT8
XCAFDimTolObjects_DimensionGrade_IT9 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT9
XCAFDimTolObjects_DimensionGrade_IT10 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT10
XCAFDimTolObjects_DimensionGrade_IT11 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT11
XCAFDimTolObjects_DimensionGrade_IT12 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT12
XCAFDimTolObjects_DimensionGrade_IT13 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT13
XCAFDimTolObjects_DimensionGrade_IT14 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT14
XCAFDimTolObjects_DimensionGrade_IT15 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT15
XCAFDimTolObjects_DimensionGrade_IT16 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT16
XCAFDimTolObjects_DimensionGrade_IT17 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT17
XCAFDimTolObjects_DimensionGrade_IT18 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT18

class XCAFDimTolObjects_DatumObject(Standard_Transient):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, theObj: XCAFDimTolObjects_DatumObject) -> None: ...
	def AddModifier(self, theModifier: XCAFDimTolObjects_DatumSingleModif) -> None: ...
	def GetDatumTarget(self) -> TopoDS_Shape: ...
	def GetDatumTargetAxis(self) -> gp_Ax2: ...
	def GetDatumTargetLength(self) -> float: ...
	def GetDatumTargetNumber(self) -> int: ...
	def GetDatumTargetType(self) -> XCAFDimTolObjects_DatumTargetType: ...
	def GetDatumTargetWidth(self) -> float: ...
	def GetModifierWithValue(self, theModifier: XCAFDimTolObjects_DatumModifWithValue) -> float: ...
	def GetModifiers(self) -> XCAFDimTolObjects_DatumModifiersSequence: ...
	def GetName(self) -> TCollection_HAsciiString: ...
	def GetPlane(self) -> gp_Ax2: ...
	def GetPoint(self) -> gp_Pnt: ...
	def GetPointTextAttach(self) -> gp_Pnt: ...
	def GetPosition(self) -> int: ...
	def GetPresentation(self) -> TopoDS_Shape: ...
	def GetPresentationName(self) -> TCollection_HAsciiString: ...
	def GetSemanticName(self) -> TCollection_HAsciiString: ...
	def HasDatumTargetParams(self) -> bool: ...
	def HasPlane(self) -> bool: ...
	def HasPoint(self) -> bool: ...
	def HasPointText(self) -> bool: ...
	@overload
	def IsDatumTarget(self) -> bool: ...
	@overload
	def IsDatumTarget(self, theIsDT: bool) -> None: ...
	def SetDatumTarget(self, theShape: TopoDS_Shape) -> None: ...
	def SetDatumTargetAxis(self, theAxis: gp_Ax2) -> None: ...
	def SetDatumTargetLength(self, theLength: float) -> None: ...
	def SetDatumTargetNumber(self, theNumber: int) -> None: ...
	def SetDatumTargetType(self, theType: XCAFDimTolObjects_DatumTargetType) -> None: ...
	def SetDatumTargetWidth(self, theWidth: float) -> None: ...
	def SetModifierWithValue(self, theModifier: XCAFDimTolObjects_DatumModifWithValue, theValue: float) -> None: ...
	def SetModifiers(self, theModifiers: XCAFDimTolObjects_DatumModifiersSequence) -> None: ...
	def SetName(self, theTag: TCollection_HAsciiString) -> None: ...
	def SetPlane(self, thePlane: gp_Ax2) -> None: ...
	def SetPoint(self, thePnt: gp_Pnt) -> None: ...
	def SetPointTextAttach(self, thePntText: gp_Pnt) -> None: ...
	def SetPosition(self, thePosition: int) -> None: ...
	def SetPresentation(self, thePresentation: TopoDS_Shape, thePresentationName: TCollection_HAsciiString) -> None: ...
	def SetSemanticName(self, theName: TCollection_HAsciiString) -> None: ...

class XCAFDimTolObjects_DimensionObject(Standard_Transient):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, theObj: XCAFDimTolObjects_DimensionObject) -> None: ...
	def AddDescription(self, theDescription: TCollection_HAsciiString, theName: TCollection_HAsciiString) -> None: ...
	def AddModifier(self, theModifier: XCAFDimTolObjects_DimensionModif) -> None: ...
	def GetClassOfTolerance(self, theFormVariance: XCAFDimTolObjects_DimensionFormVariance, theGrade: XCAFDimTolObjects_DimensionGrade) -> Tuple[bool, bool]: ...
	def GetDescription(self, theNumber: int) -> TCollection_HAsciiString: ...
	def GetDescriptionName(self, theNumber: int) -> TCollection_HAsciiString: ...
	def GetDirection(self, theDir: gp_Dir) -> bool: ...
	def GetLowerBound(self) -> float: ...
	def GetLowerTolValue(self) -> float: ...
	def GetModifiers(self) -> XCAFDimTolObjects_DimensionModifiersSequence: ...
	def GetNbOfDecimalPlaces(self) -> Tuple[int, int]: ...
	def GetPath(self) -> TopoDS_Edge: ...
	def GetPlane(self) -> gp_Ax2: ...
	def GetPoint(self) -> gp_Pnt: ...
	def GetPoint2(self) -> gp_Pnt: ...
	def GetPointTextAttach(self) -> gp_Pnt: ...
	def GetPresentation(self) -> TopoDS_Shape: ...
	def GetPresentationName(self) -> TCollection_HAsciiString: ...
	def GetQualifier(self) -> XCAFDimTolObjects_DimensionQualifier: ...
	def GetSemanticName(self) -> TCollection_HAsciiString: ...
	def GetType(self) -> XCAFDimTolObjects_DimensionType: ...
	def GetUpperBound(self) -> float: ...
	def GetUpperTolValue(self) -> float: ...
	def GetValue(self) -> float: ...
	def GetValues(self) -> TColStd_HArray1OfReal: ...
	def HasDescriptions(self) -> bool: ...
	def HasPlane(self) -> bool: ...
	def HasPoint(self) -> bool: ...
	def HasPoint2(self) -> bool: ...
	def HasQualifier(self) -> bool: ...
	def HasTextPoint(self) -> bool: ...
	def IsDimWithClassOfTolerance(self) -> bool: ...
	def IsDimWithPlusMinusTolerance(self) -> bool: ...
	def IsDimWithRange(self) -> bool: ...
	def NbDescriptions(self) -> int: ...
	def RemoveDescription(self, theNumber: int) -> None: ...
	def SetClassOfTolerance(self, theHole: bool, theFormVariance: XCAFDimTolObjects_DimensionFormVariance, theGrade: XCAFDimTolObjects_DimensionGrade) -> None: ...
	def SetDirection(self, theDir: gp_Dir) -> bool: ...
	def SetLowerBound(self, theLowerBound: float) -> None: ...
	def SetLowerTolValue(self, theLowerTolValue: float) -> bool: ...
	def SetModifiers(self, theModifiers: XCAFDimTolObjects_DimensionModifiersSequence) -> None: ...
	def SetNbOfDecimalPlaces(self, theL: int, theR: int) -> None: ...
	def SetPath(self, thePath: TopoDS_Edge) -> None: ...
	def SetPlane(self, thePlane: gp_Ax2) -> None: ...
	def SetPoint(self, thePnt: gp_Pnt) -> None: ...
	def SetPoint2(self, thePnt: gp_Pnt) -> None: ...
	def SetPointTextAttach(self, thePntText: gp_Pnt) -> None: ...
	def SetPresentation(self, thePresentation: TopoDS_Shape, thePresentationName: TCollection_HAsciiString) -> None: ...
	def SetQualifier(self, theQualifier: XCAFDimTolObjects_DimensionQualifier) -> None: ...
	def SetSemanticName(self, theName: TCollection_HAsciiString) -> None: ...
	def SetType(self, theTyupe: XCAFDimTolObjects_DimensionType) -> None: ...
	def SetUpperBound(self, theUpperBound: float) -> None: ...
	def SetUpperTolValue(self, theUperTolValue: float) -> bool: ...
	def SetValue(self, theValue: float) -> None: ...
	def SetValues(self, theValue: TColStd_HArray1OfReal) -> None: ...

class XCAFDimTolObjects_GeomToleranceObject(Standard_Transient):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, theObj: XCAFDimTolObjects_GeomToleranceObject) -> None: ...
	def AddModifier(self, theModifier: XCAFDimTolObjects_GeomToleranceModif) -> None: ...
	def GetAffectedPlane(self) -> gp_Pln: ...
	def GetAffectedPlaneType(self) -> XCAFDimTolObjects_ToleranceZoneAffectedPlane: ...
	def GetAxis(self) -> gp_Ax2: ...
	def GetMaterialRequirementModifier(self) -> XCAFDimTolObjects_GeomToleranceMatReqModif: ...
	def GetMaxValueModifier(self) -> float: ...
	def GetModifiers(self) -> XCAFDimTolObjects_GeomToleranceModifiersSequence: ...
	def GetPlane(self) -> gp_Ax2: ...
	def GetPoint(self) -> gp_Pnt: ...
	def GetPointTextAttach(self) -> gp_Pnt: ...
	def GetPresentation(self) -> TopoDS_Shape: ...
	def GetPresentationName(self) -> TCollection_HAsciiString: ...
	def GetSemanticName(self) -> TCollection_HAsciiString: ...
	def GetType(self) -> XCAFDimTolObjects_GeomToleranceType: ...
	def GetTypeOfValue(self) -> XCAFDimTolObjects_GeomToleranceTypeValue: ...
	def GetValue(self) -> float: ...
	def GetValueOfZoneModifier(self) -> float: ...
	def GetZoneModifier(self) -> XCAFDimTolObjects_GeomToleranceZoneModif: ...
	def HasAffectedPlane(self) -> False: ...
	def HasAxis(self) -> bool: ...
	def HasPlane(self) -> bool: ...
	def HasPoint(self) -> bool: ...
	def HasPointText(self) -> bool: ...
	@overload
	def SetAffectedPlane(self, thePlane: gp_Pln) -> None: ...
	@overload
	def SetAffectedPlane(self, thePlane: gp_Pln, theType: XCAFDimTolObjects_ToleranceZoneAffectedPlane) -> None: ...
	def SetAffectedPlaneType(self, theType: XCAFDimTolObjects_ToleranceZoneAffectedPlane) -> None: ...
	def SetAxis(self, theAxis: gp_Ax2) -> None: ...
	def SetMaterialRequirementModifier(self, theMatReqModif: XCAFDimTolObjects_GeomToleranceMatReqModif) -> None: ...
	def SetMaxValueModifier(self, theModifier: float) -> None: ...
	def SetModifiers(self, theModifiers: XCAFDimTolObjects_GeomToleranceModifiersSequence) -> None: ...
	def SetPlane(self, thePlane: gp_Ax2) -> None: ...
	def SetPoint(self, thePnt: gp_Pnt) -> None: ...
	def SetPointTextAttach(self, thePntText: gp_Pnt) -> None: ...
	def SetPresentation(self, thePresentation: TopoDS_Shape, thePresentationName: TCollection_HAsciiString) -> None: ...
	def SetSemanticName(self, theName: TCollection_HAsciiString) -> None: ...
	def SetType(self, theType: XCAFDimTolObjects_GeomToleranceType) -> None: ...
	def SetTypeOfValue(self, theTypeOfValue: XCAFDimTolObjects_GeomToleranceTypeValue) -> None: ...
	def SetValue(self, theValue: float) -> None: ...
	def SetValueOfZoneModifier(self, theValue: float) -> None: ...
	def SetZoneModifier(self, theZoneModif: XCAFDimTolObjects_GeomToleranceZoneModif) -> None: ...

class XCAFDimTolObjects_Tool:
	def __init__(self, theDoc: TDocStd_Document) -> None: ...
	def GetDimensions(self, theDimensionObjectSequence: XCAFDimTolObjects_DimensionObjectSequence) -> None: ...
	def GetGeomTolerances(self, theGeomToleranceObjectSequence: XCAFDimTolObjects_GeomToleranceObjectSequence, theDatumObjectSequence: XCAFDimTolObjects_DatumObjectSequence, theMap: XCAFDimTolObjects_DataMapOfToleranceDatum) -> None: ...
	def GetRefDatum(self, theShape: TopoDS_Shape, theDatum: XCAFDimTolObjects_DatumObject) -> bool: ...
	def GetRefDimensions(self, theShape: TopoDS_Shape, theDimensions: XCAFDimTolObjects_DimensionObjectSequence) -> bool: ...
	def GetRefGeomTolerances(self, theShape: TopoDS_Shape, theGeomToleranceObjectSequence: XCAFDimTolObjects_GeomToleranceObjectSequence, theDatumObjectSequence: XCAFDimTolObjects_DatumObjectSequence, theMap: XCAFDimTolObjects_DataMapOfToleranceDatum) -> bool: ...

# harray1 classes
# harray2 classes
# hsequence classes

