/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.filters;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.desktop.filters.FilterPanelPanel;
import org.gephi.desktop.filters.FilterUIModel;
import org.gephi.desktop.filters.library.FiltersExplorer;
import org.gephi.desktop.filters.query.QueryExplorer;
import org.gephi.filters.api.FilterController;
import org.gephi.filters.api.FilterModel;
import org.gephi.filters.api.Query;
import org.gephi.ui.utils.UIUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FiltersPanel
extends JPanel
implements ExplorerManager.Provider,
ChangeListener {
    private final ExplorerManager manager = new ExplorerManager();
    private FilterModel filterModel;
    private FilterUIModel uiModel;
    private final FilterPanelPanel filterPanelPanel;
    private QueryExplorer queriesExplorer;
    private final QueriesPanel queriesPanel;
    private JPanel buttonsPanel;
    private JButton exportColumnButton;
    private JButton exportLabelVisible;
    private JButton exportWorkspaceButton;
    private JToggleButton filterButton;
    private JPanel filtersUIPanel;
    private JScrollPane libraryTree;
    private JButton resetButton;
    private JToggleButton selectButton;
    private JToolBar.Separator separator;
    private JPanel southPanel;
    private JToolBar southToolbar;
    private JSplitPane splitPane;
    private JToggleButton stopButton;
    private JToolBar toolbar;

    public FiltersPanel() {
        this.initComponents();
        Border b = (Border)UIManager.get("Nb.Editor.Toolbar.border");
        this.toolbar.setBorder(b);
        if (UIUtils.isAquaLookAndFeel()) {
            this.toolbar.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.queriesPanel = new QueriesPanel();
        this.southPanel.add((Component)this.queriesPanel, "Center");
        this.filterPanelPanel = new FilterPanelPanel();
        this.filtersUIPanel.add(this.filterPanelPanel);
        this.initEvents();
    }

    private void initEvents() {
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterController controller = (FilterController)Lookup.getDefault().lookup(FilterController.class);
                for (Query query : FiltersPanel.this.filterModel.getQueries()) {
                    controller.remove(query);
                }
                controller.selectVisible(null);
                controller.filterVisible(null);
                ((FiltersExplorer)((Object)FiltersPanel.this.libraryTree)).setup(FiltersPanel.this.manager, FiltersPanel.this.filterModel, FiltersPanel.this.uiModel);
                FiltersPanel.this.stopButton.setVisible(false);
                FiltersPanel.this.filterButton.setVisible(true);
            }
        });
        this.filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FiltersPanel.this.uiModel.getSelectedQuery() != null) {
                    FilterController controller = (FilterController)Lookup.getDefault().lookup(FilterController.class);
                    controller.filterVisible(FiltersPanel.this.uiModel.getSelectedRoot());
                    FiltersPanel.this.stopButton.setSelected(false);
                    FiltersPanel.this.stopButton.setVisible(true);
                    FiltersPanel.this.filterButton.setVisible(false);
                }
            }
        });
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterController controller = (FilterController)Lookup.getDefault().lookup(FilterController.class);
                controller.filterVisible(null);
                controller.selectVisible(null);
                FiltersPanel.this.stopButton.setVisible(false);
                FiltersPanel.this.filterButton.setSelected(true);
                FiltersPanel.this.filterButton.setVisible(true);
            }
        });
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterController controller = (FilterController)Lookup.getDefault().lookup(FilterController.class);
                if (controller.getModel().isSelecting()) {
                    controller.selectVisible(null);
                } else if (FiltersPanel.this.uiModel.getSelectedQuery() != null) {
                    controller.selectVisible(FiltersPanel.this.uiModel.getSelectedRoot());
                }
            }
        });
        this.exportColumnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FiltersPanel.this.uiModel.getSelectedQuery() != null) {
                    String input;
                    FilterController controller = (FilterController)Lookup.getDefault().lookup(FilterController.class);
                    NotifyDescriptor.InputLine question = new NotifyDescriptor.InputLine(NbBundle.getMessage(FiltersPanel.class, (String)"FiltersPanel.exportColumn.input"), NbBundle.getMessage(FiltersPanel.class, (String)"FiltersPanel.exportColumn.input.title"));
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)question) == NotifyDescriptor.OK_OPTION && (input = question.getInputText()) != null && !input.isEmpty()) {
                        controller.exportToColumn(input, FiltersPanel.this.uiModel.getSelectedRoot());
                    }
                }
            }
        });
        this.exportWorkspaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FiltersPanel.this.uiModel.getSelectedQuery() != null) {
                    FilterController controller = (FilterController)Lookup.getDefault().lookup(FilterController.class);
                    controller.exportToNewWorkspace(FiltersPanel.this.uiModel.getSelectedRoot());
                }
            }
        });
        this.exportLabelVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FiltersPanel.this.uiModel.getSelectedQuery() != null) {
                    FilterController controller = (FilterController)Lookup.getDefault().lookup(FilterController.class);
                    controller.exportToLabelVisible(FiltersPanel.this.uiModel.getSelectedRoot());
                }
            }
        });
        this.updateEnabled(false);
    }

    public void refreshModel(FilterModel filterModel, FilterUIModel uiModel) {
        this.filterModel = filterModel;
        this.uiModel = uiModel;
        this.unsetup();
        this.filterPanelPanel.unsetup();
        this.queriesExplorer.unsetup();
        this.setup();
        ((FiltersExplorer)((Object)this.libraryTree)).setup(this.manager, filterModel, uiModel);
        this.queriesExplorer.setup(this.queriesPanel.manager, filterModel, uiModel);
        this.filterPanelPanel.setup(uiModel);
        this.updateEnabled(filterModel != null);
        this.updateControls();
    }

    private void updateEnabled(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FiltersPanel.this.resetButton.setEnabled(enabled);
                FiltersPanel.this.selectButton.setEnabled(enabled && FiltersPanel.this.uiModel.getSelectedQuery() != null);
                FiltersPanel.this.filterButton.setEnabled(enabled && FiltersPanel.this.uiModel.getSelectedQuery() != null);
                FiltersPanel.this.exportColumnButton.setEnabled(enabled && FiltersPanel.this.uiModel.getSelectedQuery() != null && FiltersPanel.this.filterModel.getCurrentQuery() != null);
                FiltersPanel.this.exportWorkspaceButton.setEnabled(enabled && FiltersPanel.this.uiModel.getSelectedQuery() != null && FiltersPanel.this.filterModel.getCurrentQuery() != null);
                FiltersPanel.this.exportLabelVisible.setEnabled(enabled && FiltersPanel.this.uiModel.getSelectedQuery() != null && FiltersPanel.this.filterModel.getCurrentQuery() != null);
            }
        });
    }

    private void updateControls() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FiltersPanel.this.filterModel != null) {
                    if (FiltersPanel.this.filterModel.isFiltering()) {
                        FiltersPanel.this.stopButton.setVisible(true);
                        FiltersPanel.this.stopButton.setSelected(false);
                        FiltersPanel.this.filterButton.setVisible(false);
                    } else {
                        FiltersPanel.this.stopButton.setVisible(false);
                        FiltersPanel.this.filterButton.setSelected(false);
                        FiltersPanel.this.filterButton.setVisible(true);
                    }
                    FiltersPanel.this.selectButton.setSelected(FiltersPanel.this.filterModel.isSelecting());
                } else {
                    FiltersPanel.this.stopButton.setVisible(false);
                    FiltersPanel.this.filterButton.setVisible(true);
                    FiltersPanel.this.filterButton.setSelected(false);
                    FiltersPanel.this.selectButton.setSelected(false);
                }
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof FilterUIModel) {
            if (this.uiModel.getSelectedQuery() != null && this.stopButton.isVisible()) {
                FilterController controller = (FilterController)Lookup.getDefault().lookup(FilterController.class);
                controller.filterVisible(this.uiModel.getSelectedRoot());
            } else if (this.uiModel.getSelectedQuery() != null && this.selectButton.isSelected()) {
                FilterController controller = (FilterController)Lookup.getDefault().lookup(FilterController.class);
                controller.selectVisible(this.uiModel.getSelectedRoot());
            }
        } else if (e.getSource() instanceof FilterModel) {
            if (this.uiModel.getSelectedQuery() != null && this.filterModel.getCurrentQuery() == null) {
                if (!Arrays.asList(this.filterModel.getQueries()).contains(this.uiModel.getSelectedRoot())) {
                    this.uiModel.setSelectedQuery(null);
                }
            } else if (this.filterModel.getCurrentQuery() != null && this.filterModel.getCurrentQuery() != this.uiModel.getSelectedQuery() && this.filterModel.getCurrentQuery() != this.uiModel.getSelectedRoot()) {
                this.uiModel.setSelectedQuery(this.filterModel.getCurrentQuery());
            }
        }
        this.updateControls();
        this.updateEnabled(true);
    }

    private void unsetup() {
        if (this.filterModel != null) {
            this.filterModel.removeChangeListener((ChangeListener)this);
        }
        if (this.uiModel != null) {
            this.uiModel.removeChangeListener(this);
        }
    }

    private void setup() {
        if (this.filterModel != null) {
            this.filterModel.addChangeListener((ChangeListener)this);
        }
        if (this.uiModel != null) {
            this.uiModel.addChangeListener(this);
        }
    }

    private void initComponents() {
        this.toolbar = new JToolBar();
        this.resetButton = new JButton();
        this.separator = new JToolBar.Separator();
        this.exportColumnButton = new JButton();
        this.exportWorkspaceButton = new JButton();
        this.exportLabelVisible = new JButton();
        this.splitPane = new JSplitPane();
        this.libraryTree = new FiltersExplorer();
        this.southPanel = new JPanel();
        this.filtersUIPanel = new JPanel();
        this.southToolbar = new JToolBar();
        this.buttonsPanel = new JPanel();
        this.selectButton = new JToggleButton();
        this.filterButton = new JToggleButton();
        this.stopButton = new JToggleButton();
        this.setLayout(new GridBagLayout());
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.resetButton.setText(NbBundle.getMessage(FiltersPanel.class, (String)"FiltersPanel.resetButton.text"));
        this.resetButton.setFocusable(false);
        this.resetButton.setHorizontalTextPosition(0);
        this.resetButton.setVerticalTextPosition(3);
        this.toolbar.add(this.resetButton);
        this.toolbar.add(this.separator);
        this.exportColumnButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/filters/resources/table_export.png")));
        this.exportColumnButton.setText(NbBundle.getMessage(FiltersPanel.class, (String)"FiltersPanel.exportColumnButton.text"));
        this.exportColumnButton.setToolTipText(NbBundle.getMessage(FiltersPanel.class, (String)"FiltersPanel.exportColumnButton.toolTipText"));
        this.exportColumnButton.setFocusable(false);
        this.exportColumnButton.setHorizontalTextPosition(0);
        this.exportColumnButton.setVerticalTextPosition(3);
        this.toolbar.add(this.exportColumnButton);
        this.exportWorkspaceButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/filters/resources/workspace_export.png")));
        this.exportWorkspaceButton.setText(NbBundle.getMessage(FiltersPanel.class, (String)"FiltersPanel.exportWorkspaceButton.text"));
        this.exportWorkspaceButton.setToolTipText(NbBundle.getMessage(FiltersPanel.class, (String)"FiltersPanel.exportWorkspaceButton.toolTipText"));
        this.exportWorkspaceButton.setFocusable(false);
        this.exportWorkspaceButton.setHorizontalTextPosition(0);
        this.exportWorkspaceButton.setVerticalTextPosition(3);
        this.toolbar.add(this.exportWorkspaceButton);
        this.exportLabelVisible.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/filters/resources/labelvisible_export.png")));
        this.exportLabelVisible.setToolTipText(NbBundle.getMessage(FiltersPanel.class, (String)"FiltersPanel.exportLabelVisible.toolTipText"));
        this.exportLabelVisible.setFocusable(false);
        this.exportLabelVisible.setHorizontalTextPosition(0);
        this.exportLabelVisible.setVerticalTextPosition(3);
        this.toolbar.add(this.exportLabelVisible);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.toolbar, gridBagConstraints);
        this.splitPane.setBorder(null);
        this.splitPane.setDividerLocation(260);
        this.splitPane.setDividerSize(3);
        this.splitPane.setOrientation(0);
        this.libraryTree.setBorder(null);
        this.splitPane.setLeftComponent(this.libraryTree);
        this.southPanel.setLayout(new BorderLayout());
        this.splitPane.setRightComponent(this.southPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.splitPane, gridBagConstraints);
        this.filtersUIPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 1, 5);
        this.add((Component)this.filtersUIPanel, gridBagConstraints);
        this.southToolbar.setFloatable(false);
        this.southToolbar.setRollover(true);
        this.southToolbar.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 5, 0, 0);
        this.add((Component)this.southToolbar, gridBagConstraints);
        this.buttonsPanel.setOpaque(false);
        this.buttonsPanel.setLayout(new FlowLayout(1, 4, 4));
        this.selectButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/filters/resources/select.png")));
        this.selectButton.setText(NbBundle.getMessage(FiltersPanel.class, (String)"FiltersPanel.selectButton.text"));
        this.selectButton.setMargin(new Insets(2, 7, 2, 14));
        this.buttonsPanel.add(this.selectButton);
        this.filterButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/filters/resources/filter.png")));
        this.filterButton.setText(NbBundle.getMessage(FiltersPanel.class, (String)"FiltersPanel.filterButton.text"));
        this.filterButton.setFocusable(false);
        this.filterButton.setMargin(new Insets(2, 7, 2, 14));
        this.buttonsPanel.add(this.filterButton);
        this.stopButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/filters/resources/stop.png")));
        this.stopButton.setText(NbBundle.getMessage(FiltersPanel.class, (String)"FiltersPanel.stopButton.text"));
        this.stopButton.setMargin(new Insets(2, 7, 2, 14));
        this.buttonsPanel.add(this.stopButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.add((Component)this.buttonsPanel, gridBagConstraints);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private class QueriesPanel
    extends JPanel
    implements ExplorerManager.Provider {
        private ExplorerManager manager;

        public QueriesPanel() {
            super(new BorderLayout());
            this.manager = new ExplorerManager();
            FiltersPanel.this.queriesExplorer = new QueryExplorer();
            this.add((Component)((Object)FiltersPanel.this.queriesExplorer), "Center");
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }
    }
}

